package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.JasperReportLog;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoJasperReportLogDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class JasperReportLog.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.JasperReportLog
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoJasperReportLogDAOImpl implements IAutoJasperReportLogDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the JasperReportLog entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<JasperReportLog> getJasperReportLogDataSet()
    {
        return new HibernateDataSet<JasperReportLog>(JasperReportLog.class, this, JasperReportLog.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoJasperReportLogDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a JasperReportLog object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(JasperReportLog transientInstance) {
        logger.debug("persisting JasperReportLog instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified JasperReportLog in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(JasperReportLog instance) {
        logger.debug("attaching dirty JasperReportLog instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified JasperReportLog instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(JasperReportLog instance) {
        logger.debug("attaching clean JasperReportLog instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a JasperReportLog instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(JasperReportLog persistentInstance) {
        logger.debug("deleting JasperReportLog instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a JasperReportLog instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public JasperReportLog merge(JasperReportLog detachedInstance) {
        logger.debug("merging JasperReportLog instance");
        JasperReportLog result = (JasperReportLog) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a JasperReportLog instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public JasperReportLog findById( java.lang.Long id) {
        logger.debug("getting JasperReportLog instance with id: " + id);
        JasperReportLog instance = (JasperReportLog) getSession()
                .get(JasperReportLog.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all JasperReportLog instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<JasperReportLog> findAll() {

 		List<JasperReportLog> instances = new ArrayList<JasperReportLog>();
		logger.debug("getting all JasperReportLog instances");
        instances = getSession().createCriteria(JasperReportLog.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<JasperReportLog>) instances;
    }


	/**
	 * Gets a {@link List} of all JasperReportLog instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<JasperReportLog> findByExample(JasperReportLog instance) {
        logger.debug("finding JasperReportLog instance by example");
        List<JasperReportLog> results = (List<JasperReportLog>) getSession()
                .createCriteria(JasperReportLog.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all JasperReportLog instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<JasperReportLog> findByFieldParcial(JasperReportLog.Fields field, String value) {
        logger.debug("finding JasperReportLog instance by parcial value: "+field+" like "+value);
        List<JasperReportLog> results = (List<JasperReportLog>) getSession()
                .createCriteria(JasperReportLog.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all JasperReportLog instances
	 * in the persistence layer than match the businessId attribute with the given value
	 *
	 * @param businessId to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportLog> findByBusinessId(String businessId) {
        JasperReportLog instance = new JasperReportLog();

        instance.setBusinessId(businessId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportLog instances
	 * in the persistence layer than match the parametersValues attribute with the given value
	 *
	 * @param parametersValues to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportLog> findByParametersValues(String parametersValues) {
        JasperReportLog instance = new JasperReportLog();

        instance.setParametersValues(parametersValues);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportLog instances
	 * in the persistence layer than match the userId attribute with the given value
	 *
	 * @param userId to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportLog> findByUserId(String userId) {
        JasperReportLog instance = new JasperReportLog();

        instance.setUserId(userId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportLog instances
	 * in the persistence layer than match the logDate attribute with the given value
	 *
	 * @param logDate to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportLog> findByLogDate(Date logDate) {
        JasperReportLog instance = new JasperReportLog();

        instance.setLogDate(logDate);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportLog instances
	 * in the persistence layer than match the executionTime attribute with the given value
	 *
	 * @param executionTime to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportLog> findByExecutionTime(Long executionTime) {
        JasperReportLog instance = new JasperReportLog();

        instance.setExecutionTime(executionTime);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportLog instances
	 * in the persistence layer than match the documentId attribute with the given value
	 *
	 * @param documentId to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportLog> findByDocumentId(Long documentId) {
        JasperReportLog instance = new JasperReportLog();

        instance.setDocumentId(documentId);

        return findByExample(instance);
    }

}

