package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.sql.Blob;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.PersistentAction;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoPersistentActionDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class PersistentAction.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.PersistentAction
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoPersistentActionDAOImpl implements IAutoPersistentActionDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the PersistentAction entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<PersistentAction> getPersistentActionDataSet()
    {
        return new HibernateDataSet<PersistentAction>(PersistentAction.class, this, PersistentAction.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoPersistentActionDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a PersistentAction object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(PersistentAction transientInstance) {
        logger.debug("persisting PersistentAction instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified PersistentAction in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(PersistentAction instance) {
        logger.debug("attaching dirty PersistentAction instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified PersistentAction instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(PersistentAction instance) {
        logger.debug("attaching clean PersistentAction instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a PersistentAction instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(PersistentAction persistentInstance) {
        logger.debug("deleting PersistentAction instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a PersistentAction instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public PersistentAction merge(PersistentAction detachedInstance) {
        logger.debug("merging PersistentAction instance");
        PersistentAction result = (PersistentAction) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a PersistentAction instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public PersistentAction findById( java.lang.Long id) {
        logger.debug("getting PersistentAction instance with id: " + id);
        PersistentAction instance = (PersistentAction) getSession()
                .get(PersistentAction.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all PersistentAction instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<PersistentAction> findAll() {

 		List<PersistentAction> instances = new ArrayList<PersistentAction>();
		logger.debug("getting all PersistentAction instances");
        instances = getSession().createCriteria(PersistentAction.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<PersistentAction>) instances;
    }


	/**
	 * Gets a {@link List} of all PersistentAction instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<PersistentAction> findByExample(PersistentAction instance) {
        logger.debug("finding PersistentAction instance by example");
        List<PersistentAction> results = (List<PersistentAction>) getSession()
                .createCriteria(PersistentAction.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all PersistentAction instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<PersistentAction> findByFieldParcial(PersistentAction.Fields field, String value) {
        logger.debug("finding PersistentAction instance by parcial value: "+field+" like "+value);
        List<PersistentAction> results = (List<PersistentAction>) getSession()
                .createCriteria(PersistentAction.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all PersistentAction instances
	 * in the persistence layer than match the objectAction attribute with the given value
	 *
	 * @param objectAction to match
	 * @return the {@link List} of instances
	 */
    public List<PersistentAction> findByObjectAction(Blob objectAction) {
        PersistentAction instance = new PersistentAction();

        instance.setObjectAction(objectAction);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all PersistentAction instances
	 * in the persistence layer than match the poolName attribute with the given value
	 *
	 * @param poolName to match
	 * @return the {@link List} of instances
	 */
    public List<PersistentAction> findByPoolName(String poolName) {
        PersistentAction instance = new PersistentAction();

        instance.setPoolName(poolName);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all PersistentAction instances
	 * in the persistence layer than match the actionId attribute with the given value
	 *
	 * @param actionId to match
	 * @return the {@link List} of instances
	 */
    public List<PersistentAction> findByActionId(Long actionId) {
        PersistentAction instance = new PersistentAction();

        instance.setActionId(actionId);

        return findByExample(instance);
    }

}

