package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.UserDataConsent;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoUserDataConsentDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class UserDataConsent.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.UserDataConsent
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoUserDataConsentDAOImpl implements IAutoUserDataConsentDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the UserDataConsent entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<UserDataConsent> getUserDataConsentDataSet()
    {
        return new HibernateDataSet<UserDataConsent>(UserDataConsent.class, this, UserDataConsent.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoUserDataConsentDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a UserDataConsent object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(UserDataConsent transientInstance) {
        logger.debug("persisting UserDataConsent instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified UserDataConsent in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(UserDataConsent instance) {
        logger.debug("attaching dirty UserDataConsent instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified UserDataConsent instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(UserDataConsent instance) {
        logger.debug("attaching clean UserDataConsent instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a UserDataConsent instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(UserDataConsent persistentInstance) {
        logger.debug("deleting UserDataConsent instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a UserDataConsent instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public UserDataConsent merge(UserDataConsent detachedInstance) {
        logger.debug("merging UserDataConsent instance");
        UserDataConsent result = (UserDataConsent) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a UserDataConsent instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public UserDataConsent findById( java.lang.Long id) {
        logger.debug("getting UserDataConsent instance with id: " + id);
        UserDataConsent instance = (UserDataConsent) getSession()
                .get(UserDataConsent.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all UserDataConsent instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<UserDataConsent> findAll() {

 		List<UserDataConsent> instances = new ArrayList<UserDataConsent>();
		logger.debug("getting all UserDataConsent instances");
        instances = getSession().createCriteria(UserDataConsent.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<UserDataConsent>) instances;
    }


	/**
	 * Gets a {@link List} of all UserDataConsent instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<UserDataConsent> findByExample(UserDataConsent instance) {
        logger.debug("finding UserDataConsent instance by example");
        List<UserDataConsent> results = (List<UserDataConsent>) getSession()
                .createCriteria(UserDataConsent.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all UserDataConsent instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<UserDataConsent> findByFieldParcial(UserDataConsent.Fields field, String value) {
        logger.debug("finding UserDataConsent instance by parcial value: "+field+" like "+value);
        List<UserDataConsent> results = (List<UserDataConsent>) getSession()
                .createCriteria(UserDataConsent.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all UserDataConsent instances
	 * in the persistence layer than match the dateGiven attribute with the given value
	 *
	 * @param dateGiven to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataConsent> findByDateGiven(Timestamp dateGiven) {
        UserDataConsent instance = new UserDataConsent();

        instance.setDateGiven(dateGiven);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all UserDataConsent instances
	 * in the persistence layer than match the dateConfirmed attribute with the given value
	 *
	 * @param dateConfirmed to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataConsent> findByDateConfirmed(Timestamp dateConfirmed) {
        UserDataConsent instance = new UserDataConsent();

        instance.setDateConfirmed(dateConfirmed);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all UserDataConsent instances
	 * in the persistence layer than match the dateRevoked attribute with the given value
	 *
	 * @param dateRevoked to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataConsent> findByDateRevoked(Timestamp dateRevoked) {
        UserDataConsent instance = new UserDataConsent();

        instance.setDateRevoked(dateRevoked);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all UserDataConsent instances
	 * in the persistence layer than match the proofDocumentId attribute with the given value
	 *
	 * @param proofDocumentId to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataConsent> findByProofDocumentId(Long proofDocumentId) {
        UserDataConsent instance = new UserDataConsent();

        instance.setProofDocumentId(proofDocumentId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all UserDataConsent instances
	 * in the persistence layer than match the state attribute with the given value
	 *
	 * @param state to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataConsent> findByState(String state) {
        UserDataConsent instance = new UserDataConsent();

        instance.setState(state);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all UserDataConsent instances
	 * in the persistence layer than match the details attribute with the given value
	 *
	 * @param details to match
	 * @return the {@link List} of instances
	 */
    public List<UserDataConsent> findByDetails(String details) {
        UserDataConsent instance = new UserDataConsent();

        instance.setDetails(details);

        return findByExample(instance);
    }

}

