package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.IRGPDService;
import pt.digitalis.dif.dem.managers.impl.model.dao.IDataConsentDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.DataConsentDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.DataConsent;
import pt.digitalis.dif.dem.managers.impl.model.dao.IDataConsentUserDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.DataConsentUserDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.DataConsentUser;
import pt.digitalis.dif.dem.managers.impl.model.dao.IDataConsentReviewDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.DataConsentReviewDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.DataConsentReview;
import pt.digitalis.dif.dem.managers.impl.model.dao.IDataConsentTransDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.DataConsentTransDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.DataConsentTrans;
import pt.digitalis.dif.dem.managers.impl.model.dao.IUserDataConsentDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.UserDataConsentDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.UserDataConsent;
import pt.digitalis.dif.dem.managers.impl.model.dao.IUserDataRequestDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.UserDataRequestDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.UserDataRequest;
import pt.digitalis.dif.dem.managers.impl.model.dao.IUserDataRequestCommentDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.UserDataRequestCommentDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.UserDataRequestComment;

/**
 * NOTE: This file is auto generated and will be overwrite in a future file generation.
 */
public class RGPDServiceImpl implements IRGPDService {

	/**
	 * Obtains a new DataConsent DAO
	 *
	 * @return A new IDataConsentDAO
	 */
    public IDataConsentDAO getDataConsentDAO() {
    	return new DataConsentDAOImpl();
    }

    /**
     * Obtains a new DataSet for the DataConsent entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<DataConsent> getDataConsentDataSet() {
        return new HibernateDataSet<DataConsent>(DataConsent.class, new DataConsentDAOImpl(),
                DataConsent.getPKFieldListAsString());
    }

	/**
	 * Obtains a new DataConsentUser DAO
	 *
	 * @return A new IDataConsentUserDAO
	 */
    public IDataConsentUserDAO getDataConsentUserDAO() {
    	return new DataConsentUserDAOImpl();
    }

    /**
     * Obtains a new DataSet for the DataConsentUser entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<DataConsentUser> getDataConsentUserDataSet() {
        return new HibernateDataSet<DataConsentUser>(DataConsentUser.class, new DataConsentUserDAOImpl(),
                DataConsentUser.getPKFieldListAsString());
    }

	/**
	 * Obtains a new DataConsentReview DAO
	 *
	 * @return A new IDataConsentReviewDAO
	 */
    public IDataConsentReviewDAO getDataConsentReviewDAO() {
    	return new DataConsentReviewDAOImpl();
    }

    /**
     * Obtains a new DataSet for the DataConsentReview entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<DataConsentReview> getDataConsentReviewDataSet() {
        return new HibernateDataSet<DataConsentReview>(DataConsentReview.class, new DataConsentReviewDAOImpl(),
                DataConsentReview.getPKFieldListAsString());
    }

	/**
	 * Obtains a new DataConsentTrans DAO
	 *
	 * @return A new IDataConsentTransDAO
	 */
    public IDataConsentTransDAO getDataConsentTransDAO() {
    	return new DataConsentTransDAOImpl();
    }

    /**
     * Obtains a new DataSet for the DataConsentTrans entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<DataConsentTrans> getDataConsentTransDataSet() {
        return new HibernateDataSet<DataConsentTrans>(DataConsentTrans.class, new DataConsentTransDAOImpl(),
                DataConsentTrans.getPKFieldListAsString());
    }

	/**
	 * Obtains a new UserDataConsent DAO
	 *
	 * @return A new IUserDataConsentDAO
	 */
    public IUserDataConsentDAO getUserDataConsentDAO() {
    	return new UserDataConsentDAOImpl();
    }

    /**
     * Obtains a new DataSet for the UserDataConsent entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<UserDataConsent> getUserDataConsentDataSet() {
        return new HibernateDataSet<UserDataConsent>(UserDataConsent.class, new UserDataConsentDAOImpl(),
                UserDataConsent.getPKFieldListAsString());
    }

	/**
	 * Obtains a new UserDataRequest DAO
	 *
	 * @return A new IUserDataRequestDAO
	 */
    public IUserDataRequestDAO getUserDataRequestDAO() {
    	return new UserDataRequestDAOImpl();
    }

    /**
     * Obtains a new DataSet for the UserDataRequest entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<UserDataRequest> getUserDataRequestDataSet() {
        return new HibernateDataSet<UserDataRequest>(UserDataRequest.class, new UserDataRequestDAOImpl(),
                UserDataRequest.getPKFieldListAsString());
    }

	/**
	 * Obtains a new UserDataRequestComment DAO
	 *
	 * @return A new IUserDataRequestCommentDAO
	 */
    public IUserDataRequestCommentDAO getUserDataRequestCommentDAO() {
    	return new UserDataRequestCommentDAOImpl();
    }

    /**
     * Obtains a new DataSet for the UserDataRequestComment entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<UserDataRequestComment> getUserDataRequestCommentDataSet() {
        return new HibernateDataSet<UserDataRequestComment>(UserDataRequestComment.class, new UserDataRequestCommentDAOImpl(),
                UserDataRequestComment.getPKFieldListAsString());
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == DataConsent.class)
            return getDataConsentDataSet();

        if (clazz == DataConsentUser.class)
            return getDataConsentUserDataSet();

        if (clazz == DataConsentReview.class)
            return getDataConsentReviewDataSet();

        if (clazz == DataConsentTrans.class)
            return getDataConsentTransDataSet();

        if (clazz == UserDataConsent.class)
            return getUserDataConsentDataSet();

        if (clazz == UserDataRequest.class)
            return getUserDataRequestDataSet();

        if (clazz == UserDataRequestComment.class)
            return getUserDataRequestCommentDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(DataConsent.class.getSimpleName()))
            return getDataConsentDataSet();

        if (entityName.equalsIgnoreCase(DataConsentUser.class.getSimpleName()))
            return getDataConsentUserDataSet();

        if (entityName.equalsIgnoreCase(DataConsentReview.class.getSimpleName()))
            return getDataConsentReviewDataSet();

        if (entityName.equalsIgnoreCase(DataConsentTrans.class.getSimpleName()))
            return getDataConsentTransDataSet();

        if (entityName.equalsIgnoreCase(UserDataConsent.class.getSimpleName()))
            return getUserDataConsentDataSet();

        if (entityName.equalsIgnoreCase(UserDataRequest.class.getSimpleName()))
            return getUserDataRequestDataSet();

        if (entityName.equalsIgnoreCase(UserDataRequestComment.class.getSimpleName()))
            return getUserDataRequestCommentDataSet();

        return null;
    }
}