DELIMITER $$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
	DECLARE TOTAL INT;

    SELECT CHARACTER_MAXIMUM_LENGTH
    INTO TOTAL
	FROM information_schema.COLUMNS 
	WHERE TABLE_SCHEMA = 'DIF' 
	AND TABLE_NAME = 'ERROR_LOG' 
	AND COLUMN_NAME = 'PROCESS_NAME';
	
	IF TOTAL < 500 THEN
		ALTER TABLE `DIF`.`ERROR_LOG` CHANGE COLUMN `PROCESS_NAME` `PROCESS_NAME` VARCHAR(500) NULL DEFAULT NULL COMMENT 'THE PROCESS NAME';
    END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$