-----------------------------------------------------------------------------------------------------------------------
--- USER_PREFERENCES table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'USER_PREFERENCES';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.USER_PREFERENCES( '||
      '  ID              NUMBER(10) NOT NULL, '||
      '  CONFIG_ID       VARCHAR2(255) NOT NULL, '||
      '  USER_ID         VARCHAR2(255) NOT NULL, '||
      '  ATTRIBUTE_KEY   VARCHAR2(200) NOT NULL, '||
      '  ATTRIBUTE_VALUE VARCHAR2(2000) '||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.USER_PREFERENCES.ID IS 'ID';
COMMENT ON COLUMN dif.USER_PREFERENCES.CONFIG_ID IS 'Configuration ID (each application can have a diferent set of consents)';
COMMENT ON COLUMN dif.USER_PREFERENCES.USER_ID IS 'User ID';
COMMENT ON COLUMN dif.USER_PREFERENCES.ATTRIBUTE_KEY IS 'User Attribute Key';
COMMENT ON COLUMN dif.USER_PREFERENCES.ATTRIBUTE_VALUE IS 'User Attribute Value';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'USER_PREFERENCES'
  AND    CONSTRAINT_NAME = 'USER_PREFERENCES_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_PREFERENCES ADD CONSTRAINT USER_PREFERENCES_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'USER_PREFERENCES'
  AND    CONSTRAINT_NAME = 'USER_PREFERENCES_UK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.USER_PREFERENCES ADD CONSTRAINT USER_PREFERENCES_UK UNIQUE (CONFIG_ID, USER_ID, ATTRIBUTE_KEY)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'USER_PREFERENCES_ID';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.USER_PREFERENCES_ID MINVALUE 1 MAXVALUE 999999999999999999999999999 START WITH 1 INCREMENT BY 1 NOCACHE';
  END IF;
END;
/