/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.servermanager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.servermanager.ServerApplicationNodeInstance;
import pt.digitalis.dif.servermanager.ServerManagerUtils;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.LogLevel;
import pt.digitalis.utils.HttpRequestResult;
import pt.digitalis.utils.common.HttpUtils;
import pt.digitalis.utils.crypto.exeption.CryptoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifyServersOfNewMessagesToProcess
extends Thread {
    private List<ServerApplicationNodeInstance> servers = new ArrayList<ServerApplicationNodeInstance>();

    public NotifyServersOfNewMessagesToProcess(List<ServerApplicationNodeInstance> servers) {
        this.servers = servers;
    }

    private boolean notifyServer(ServerApplicationNodeInstance server, int timeOut) throws CryptoException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverURL", ServerManagerUtils.encryptValue((String)server.getServerBaseURL()));
        DIFLogger.getLogger().debug((Object)("Notifying server \"" + server.getServerBaseURL() + "\" of new messages..."));
        try {
            HttpRequestResult response = HttpUtils.makeHttpRequest((String)(server.getServerBaseURL() + "/ajax/servermanagerproxy/messagesavailable"), (String)"GET", parameters, (Integer)timeOut);
            DIFLogger.getLogger().log(response.getStatus() == 200 ? LogLevel.INFO : LogLevel.WARN, (Object)("Messages available trigger sent to " + server.getServerBaseURL() + " (response [" + response.getStatus() + "] - " + response.getResponse() + ")"));
            return true;
        }
        catch (IOException e) {
            new BusinessException("Cannot notify server", (Exception)e).addToExceptionContext("server", (Object)server).log(LogLevel.WARN);
            return false;
        }
    }

    @Override
    public void run() {
        ArrayList<ServerApplicationNodeInstance> failedServers = new ArrayList<ServerApplicationNodeInstance>();
        for (ServerApplicationNodeInstance server : this.servers) {
            try {
                boolean result = this.notifyServer(server, 15000);
                if (result) continue;
                failedServers.add(server);
            }
            catch (CryptoException e) {
                e.printStackTrace();
            }
        }
        for (ServerApplicationNodeInstance server : failedServers) {
            try {
                this.notifyServer(server, 600000);
            }
            catch (CryptoException e) {
                e.printStackTrace();
            }
        }
    }
}

