/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAccessLogDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.AccessLog;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

public class AccessLogDAOImpl
implements IAccessLogDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<AccessLog> getAccessLogDataSet() {
        return new HibernateDataSet(AccessLog.class, (IHibernateDAO)this, AccessLog.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(AccessLog transientInstance) {
        this.logger.debug((Object)"persisting AccessLog instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(AccessLog instance) {
        this.logger.debug((Object)"attaching dirty AccessLog instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(AccessLog instance) {
        this.logger.debug((Object)"attaching clean AccessLog instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(AccessLog persistentInstance) {
        this.logger.debug((Object)"deleting AccessLog instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public AccessLog merge(AccessLog detachedInstance) {
        this.logger.debug((Object)"merging AccessLog instance");
        AccessLog result = (AccessLog)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public AccessLog findById(Long id) {
        this.logger.debug((Object)("getting AccessLog instance with id: " + id));
        AccessLog instance = (AccessLog)this.getSession().get(AccessLog.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<AccessLog> findAll() {
        List<AccessLog> instances = new ArrayList();
        this.logger.debug((Object)"getting all AccessLog instances");
        instances = this.getSession().createCriteria(AccessLog.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<AccessLog> findByExample(AccessLog instance) {
        this.logger.debug((Object)"finding AccessLog instance by example");
        List results = this.getSession().createCriteria(AccessLog.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<AccessLog> findByFieldParcial(AccessLog.Fields field, String value) {
        this.logger.debug((Object)("finding AccessLog instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(AccessLog.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }
}

