DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.EVENT
(
    ID                           INT(10)      NOT NULL AUTO_INCREMENT,
    CONFIG_ID                    VARCHAR(255) NOT NULL,
    APPLICATION_ID               VARCHAR(100) NOT NULL,
    CATEGORY_ID                  VARCHAR(255) NOT NULL,
    BUSINESS_ID                  VARCHAR(255) NOT NULL,
    EVENT_DATE                   DATE,
    STATE                        VARCHAR(1),
    PUBLISHER_ID                 VARCHAR(255) NOT NULL,
    USER_ID_THAT_TRIGGERED_EVENT VARCHAR(100),
    PRIMARY KEY (`ID`)
) ENGINE = INNODB
  DEFAULT CHARSET = UTF8
  COLLATE = UTF8_BIN$$


DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.EVENT_SUBSCRIPTION
(
    ID            INT(10)       NOT NULL AUTO_INCREMENT,
    CONFIG_ID     VARCHAR(255)  NOT NULL,
    PUBLISHER_ID  VARCHAR(255)  NOT NULL,
    CATEGORY_ID   VARCHAR(255)  NOT NULL,
    SUBSCRIBER_ID VARCHAR(255)  NOT NULL,
    CONFIGURATION VARCHAR(4000) NOT NULL,
    IS_ENABLED    TINYINT(1)    NOT NULL,
    PRIMARY KEY (`ID`)
) ENGINE = INNODB
  DEFAULT CHARSET = UTF8
  COLLATE = UTF8_BIN$$


DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.EVENT_LOG_PROCESS
(
    ID                    INT(10)      NOT NULL AUTO_INCREMENT,
    CONFIG_ID             VARCHAR(255) NOT NULL,
    EVENT_ID              INT(10),
    EVENT_SUBSCRIPTION_ID INT(10)      NOT NULL,
    DATE_PROCESS          DATE         NOT NULL,
    STATE                 VARCHAR(1)   NOT NULL,
    RESULT                TEXT         NOT NULL,
    EXTERNAL_ID           TEXT,
    PRIMARY KEY (`ID`)
) ENGINE = INNODB
  DEFAULT CHARSET = UTF8
  COLLATE = UTF8_BIN$$


ALTER TABLE `DIF.EVENT_LOG_PROCESS`
    ADD CONSTRAINT `FK_EVENT` FOREIGN KEY (`EVENT_ID`) REFERENCES `DIF.EVENT` (`ID`);
ALTER TABLE `DIF.EVENT_LOG_PROCESS`
    ADD CONSTRAINT `FK_SUBSCRIPTION` FOREIGN KEY (`SUBSCRIPTION_ID`) REFERENCES `DIF.EVENT_SUBSCRIPTION` (`ID`);