/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IReportInstanceDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportInstance;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

public class ReportInstanceDAOImpl
implements IReportInstanceDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<ReportInstance> getReportInstanceDataSet() {
        return new HibernateDataSet(ReportInstance.class, (IHibernateDAO)this, ReportInstance.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(ReportInstance transientInstance) {
        this.logger.debug((Object)"persisting ReportInstance instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(ReportInstance instance) {
        this.logger.debug((Object)"attaching dirty ReportInstance instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(ReportInstance instance) {
        this.logger.debug((Object)"attaching clean ReportInstance instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(ReportInstance persistentInstance) {
        this.logger.debug((Object)"deleting ReportInstance instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public ReportInstance merge(ReportInstance detachedInstance) {
        this.logger.debug((Object)"merging ReportInstance instance");
        ReportInstance result = (ReportInstance)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public ReportInstance findById(Long id) {
        this.logger.debug((Object)("getting ReportInstance instance with id: " + id));
        ReportInstance instance = (ReportInstance)this.getSession().get(ReportInstance.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<ReportInstance> findAll() {
        List<ReportInstance> instances = new ArrayList();
        this.logger.debug((Object)"getting all ReportInstance instances");
        instances = this.getSession().createCriteria(ReportInstance.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<ReportInstance> findByExample(ReportInstance instance) {
        this.logger.debug((Object)"finding ReportInstance instance by example");
        List results = this.getSession().createCriteria(ReportInstance.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<ReportInstance> findByFieldParcial(ReportInstance.Fields field, String value) {
        this.logger.debug((Object)("finding ReportInstance instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(ReportInstance.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }
}

