----DIF.EVENT
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'EVENT';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.EVENT( ' ||
                '  ID                            NUMBER(10) NOT NULL, ' ||
                '  CONFIG_ID                     VARCHAR2(255) NOT NULL, ' ||
                '  APPLICATION_ID                VARCHAR2(100), ' ||
                '  CATEGORY_ID                   VARCHAR2(255), ' ||
                '  BUSINESS_ID                   VARCHAR2(255), ' ||
                '  EVENT_DATE                    DATE, ' ||
                '  STATE                         VARCHAR2(1), ' ||
                '  PUBLISHER_ID                  VARCHAR2(255), ' ||
                '  USER_ID_THAT_TRIGGERED_EVENT  VARCHAR2(100) ' ||
                ') ';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'EVENT'
      AND CONSTRAINT_NAME = 'EVENT_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.EVENT
            ADD CONSTRAINT EVENT_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_EVENT';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_EVENT MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

----DIF.SUBSCRIPTION
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'EVENT_SUBSCRIPTION';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.EVENT_SUBSCRIPTION( ' ||
                '  ID                  NUMBER(10) NOT NULL, ' ||
                '  CONFIG_ID           VARCHAR2(255) NOT NULL, ' ||
                '  PUBLISHER_ID        VARCHAR2(255), ' ||
                '  CATEGORY_ID         VARCHAR2(255), ' ||
                '  SUBSCRIBER_ID       VARCHAR2(255), ' ||
                '  CONFIGURATION       VARCHAR2(4000), ' ||
                '  IS_ENABLED          NUMBER(1) NOT NULL' ||
                ') ';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'EVENT_SUBSCRIPTION'
      AND CONSTRAINT_NAME = 'EVENT_SUBSCRIPTION_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.EVENT_SUBSCRIPTION
            ADD CONSTRAINT EVENT_SUBSCRIPTION_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_EVENT_SUBSCRIPTION';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_EVENT_SUBSCRIPTION MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

----DIF.EVENT_LOG_PROCESS
DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TABLES
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'EVENT_LOG_PROCESS';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE
                'CREATE TABLE DIF.EVENT_LOG_PROCESS( ' ||
                '  ID                     NUMBER(10) NOT NULL, ' ||
                '  CONFIG_ID              VARCHAR2(255) NOT NULL, ' ||
                '  EVENT_ID               NUMBER(10), ' ||
                '  EVENT_SUBSCRIPTION_ID  NUMBER(10) NOT NULL, ' ||
                '  DATE_EVENT_PROCESS     DATE NOT NULL, ' ||
                '  STATE                  VARCHAR2(1) NOT NULL, ' ||
                '  RESULT                 VARCHAR2(4000) NOT NULL, ' ||
                '  EXTERNAL_ID            VARCHAR2(4000) ' ||
                ') ';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'EVENT_LOG_PROCESS'
      AND CONSTRAINT_NAME = 'EVENT_LOG_PROCESS_PK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.EVENT_LOG_PROCESS
            ADD CONSTRAINT EVENT_LOG_PROCESS_PK PRIMARY KEY (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_SEQUENCES
    WHERE SEQUENCE_OWNER = 'DIF'
      AND SEQUENCE_NAME = 'SEQ_ID_EVENT_LOG_PROCESS';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_EVENT_LOG_PROCESS MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'EVENT_LOG_PROCESS'
      AND CONSTRAINT_NAME = 'EVENT_ID_FK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.EVENT_LOG_PROCESS
            ADD CONSTRAINT EVENT_ID_FK FOREIGN KEY (EVENT_ID) REFERENCES DIF.EVENT (ID)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'EVENT_LOG_PROCESS'
      AND CONSTRAINT_NAME = 'EVENT_SUBSCRIPTION_ID_FK';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.EVENT_LOG_PROCESS
            ADD CONSTRAINT EVENT_SUBSCRIPTION_ID_FK FOREIGN KEY (EVENT_SUBSCRIPTION_ID) REFERENCES DIF.EVENT_SUBSCRIPTION (ID)';
    END IF;
END;