DELIMITER $$

-- inicio migração do script oracle - dif_V2.7.1__workflow_files_and_conversations.sql
-- -----------------------------------------------------
-- updateColumn `DIF`.`CONVERSATION`.`BUSINESS_PROCESS_TYPE_ID`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'CONVERSATION'
      AND COLUMN_NAME = 'BUSINESS_PROCESS_TYPE_ID'
      AND IS_NULLABLE = 'NO';

    IF TOTAL > 0 THEN
        ALTER TABLE DIF.CONVERSATION
            MODIFY COLUMN BUSINESS_PROCESS_TYPE_ID varchar(100) NULL;
    END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

-- -----------------------------------------------------
-- updateColumn `DIF`.`CONVERSATION`.`BUSINESS_PROCESS_INSTANCE_ID`
-- -----------------------------------------------------

CREATE PROCEDURE updateColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'CONVERSATION'
      AND COLUMN_NAME = 'BUSINESS_PROCESS_INSTANCE_ID'
      AND IS_NULLABLE = 'NO';

    IF TOTAL > 0 THEN
        ALTER TABLE DIF.CONVERSATION
            MODIFY COLUMN BUSINESS_PROCESS_INSTANCE_ID varchar(100) NULL;
    END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

-- -----------------------------------------------------
-- dropColumn `DIF`.`CONVERSATION_MESSAGE`.`FILE_TYPE`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS dropColumn;
$$
CREATE PROCEDURE dropColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'CONVERSATION_MESSAGE'
      AND COLUMN_NAME = 'FILE_TYPE';

    IF TOTAL > 0 THEN
        ALTER TABLE `DIF`.`CONVERSATION_MESSAGE`
            DROP COLUMN `FILE_TYPE`;
    END IF;
END
$$
CALL dropColumn();
$$
DROP PROCEDURE IF EXISTS dropColumn;
$$

-- -----------------------------------------------------
-- createColumn `DIF`.`CONVERSATION_MESSAGE`.`MESSAGE_TYPE`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
    DECLARE TOTAL INT;
    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'CONVERSATION_MESSAGE'
      AND COLUMN_NAME = 'MESSAGE_TYPE';
    IF TOTAL = 0 THEN
        ALTER TABLE `DIF`.`CONVERSATION_MESSAGE`
            ADD COLUMN `MESSAGE_TYPE` VARCHAR(1);
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

-- -----------------------------------------------------
-- createColumn `DIF`.`CONVERSATION_MESSAGE`.`IS_SYSTEM_MESSAGE`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
    DECLARE TOTAL INT;
    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'CONVERSATION_MESSAGE'
      AND COLUMN_NAME = 'IS_SYSTEM_MESSAGE';
    IF TOTAL = 0 THEN
        ALTER TABLE `DIF`.`CONVERSATION_MESSAGE`
            ADD COLUMN `IS_SYSTEM_MESSAGE` TINYINT(1) DEFAULT 0 NOT NULL;
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

-- -----------------------------------------------------
-- createColumn `DIF`.`CONVERSATION_MESSAGE`.`TEMPLATE_DOCUMENT_ID`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
    DECLARE TOTAL INT;
    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'CONVERSATION_MESSAGE'
      AND COLUMN_NAME = 'TEMPLATE_DOCUMENT_ID';
    IF TOTAL = 0 THEN
        ALTER TABLE `DIF`.`CONVERSATION_MESSAGE`
            ADD COLUMN `TEMPLATE_DOCUMENT_ID` int(11);
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

-- -----------------------------------------------------
-- CREATE TABLE  `DIF`.`FILE_TYPE_GEN_PARAMETERS`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `DIF`.`FILE_TYPE_GEN_PARAMETERS`
(
    `ID`                 int(11)      NOT NULL AUTO_INCREMENT,
    `FILE_TYPE_ID`       int(11)      NOT NULL,
    `NAME`               varchar(500) NOT NULL,
    `TYPE`               varchar(30)  NOT NULL,
    `OPTIONS`            varchar(4000),
    `OPTIONS_AJAX_EVENT` varchar(500),
    `IS_MANDATORY`       TINYINT(1) DEFAULT 1,
    `HINT`               varchar(1000),
    `HELP`               varchar(4000),
    PRIMARY KEY (`ID`),
    CONSTRAINT `FILE_TYPE_GEN_PARAMETERS` FOREIGN KEY (`FILE_TYPE_ID`) REFERENCES DIF.FILE_TYPE (ID) ON DELETE CASCADE
) ENGINE = InnoDB;
$$

-- -----------------------------------------------------
-- CREATE TABLE  `DIF`.`WORKFLOW`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `DIF`.`WORKFLOW`
(
    `ID`                int(11)      NOT NULL AUTO_INCREMENT,
    `APPLICATION_ID`    VARCHAR(50)  NOT NULL,
    `NAME`              VARCHAR(500) NOT NULL,
    `DESCRIPTION`       VARCHAR(4000),
    `BUSINESS_CLASS_ID` VARCHAR(250) NOT NULL,
    `VERSION`           INT(11)      NOT NULL,
    `BUSINESS_VERSION`  INT(11)      NOT NULL,
    `FILE_BUNDLE_ID`    int(11),
    `IS_CUSTOMIZED`     TINYINT DEFAULT 0,
    `IS_ACTIVE`         TINYINT DEFAULT 0,
    CONSTRAINT `WORKFLOW_PK` PRIMARY KEY (`ID`),
    CONSTRAINT `IDX_WF_BUSINESS_CLASS_ID` UNIQUE (`BUSINESS_CLASS_ID`, `BUSINESS_VERSION`, `VERSION`),
    CONSTRAINT `FK_WORKFLOW_FILE_BUNDLE` FOREIGN KEY (FILE_BUNDLE_ID) REFERENCES DIF.FILE_BUNDLE (ID) ON DELETE CASCADE
) ENGINE = InnoDB;
$$

-- -----------------------------------------------------
-- CREATE TABLE  `DIF`.`WORKFLOW_ACTION_LIST`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `DIF`.`WORKFLOW_ACTION_LIST`
(
    `ID`          int(11)      NOT NULL AUTO_INCREMENT,
    `WORKFLOW_ID` int(11)      NOT NULL,
    `NAME`        VARCHAR(200) NOT NULL,
    CONSTRAINT `WORKFLOW_ACTION_LIST_PK` PRIMARY KEY (`ID`),
    CONSTRAINT `FK_WF_ACTION_LIST_WF` FOREIGN KEY (`WORKFLOW_ID`) REFERENCES `DIF`.`WORKFLOW` (`ID`) ON DELETE CASCADE
) ENGINE = InnoDB;
$$
-- -----------------------------------------------------
-- CREATE TABLE  `DIF`.`WORKFLOW_CUSTOM_FORM`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `DIF`.`WORKFLOW_CUSTOM_FORM`
(
    `ID`          int(11)      NOT NULL AUTO_INCREMENT,
    `STAGE_ID`    VARCHAR(500) NOT NULL,
    `FORM_NAME`   VARCHAR(500) NOT NULL,
    `NAME`        VARCHAR(500) NOT NULL,
    `WORKFLOW_ID` int(11)      NOT NULL,
    CONSTRAINT `WORKFLOW_CUST_FORM_PK` PRIMARY KEY (`ID`),
    CONSTRAINT `FK_WF_CUSTOM_FORMS_WF` FOREIGN KEY (`WORKFLOW_ID`) REFERENCES `DIF`.`WORKFLOW` (`ID`) ON DELETE CASCADE
) ENGINE = InnoDB;
$$
-- -----------------------------------------------------
-- CREATE TABLE  `DIF`.`WORKFLOW_STATE`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `DIF`.`WORKFLOW_STATE`
(
    `ID`                      int(11)           NOT NULL AUTO_INCREMENT,
    `WORKFLOW_ID`             int(11)           NOT NULL,
    `NAME`                    VARCHAR(200)      NOT NULL,
    `KEYWORD`                 VARCHAR(40)       NOT NULL,
    `ICON_IMAGE_PATH`         VARCHAR(1000),
    `DESCRIPTION`             VARCHAR(4000),
    `STATE_BUSINESS_ID`       VARCHAR(500),
    `IS_INITIAL`              TINYINT DEFAULT 0 NOT NULL,
    `IS_FINAL`                TINYINT DEFAULT 0,
    `ON_ENTER_ACTION_LIST_ID` int(11),
    `ON_EXIT_ACTION_LIST_ID`  int(11),
    CONSTRAINT `WORKFLOW_STATE_PK` PRIMARY KEY (`ID`),
    CONSTRAINT `FK_WORKFLOW_STATE_WORKFLOW` FOREIGN KEY (`WORKFLOW_ID`)
        REFERENCES `DIF`.`WORKFLOW` (`ID`) ON DELETE CASCADE,
    CONSTRAINT `FK_WF_STATE_ENTER_AL` FOREIGN KEY (`ON_ENTER_ACTION_LIST_ID`)
        REFERENCES `DIF`.`WORKFLOW_ACTION_LIST` (`ID`) ON DELETE CASCADE,
    CONSTRAINT `FK_WF_STATE_EXIT_AL` FOREIGN KEY (`ON_EXIT_ACTION_LIST_ID`)
        REFERENCES `DIF`.`WORKFLOW_ACTION_LIST` (`ID`) ON DELETE CASCADE
) ENGINE = InnoDB;
$$
-- -----------------------------------------------------
-- CREATE TABLE  `DIF`.`WORKFLOW_STATE_ACTION`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `DIF`.`WORKFLOW_STATE_ACTION`
(
    `ID`                         int(11)           NOT NULL AUTO_INCREMENT,
    `WORKFLOW_STATE_ID`          int(11)           NOT NULL,
    `NAME`                       VARCHAR(500)      NOT NULL,
    `DESCRIPTION`                VARCHAR(4000),
    `ICON_IMAGE_PATH`            VARCHAR(1000),
    `ACTION_BUSINESS_ID`         VARCHAR(500),
    `ACTION_LIST_ID`             int(11)           NOT NULL,
    `BUSINESS_RULE_CONDITION_ID` VARCHAR(1000),
    `MUST_COMMENT`               TINYINT DEFAULT 0 NOT NULL,
    `SHOW_IF_CONDITION_FAILS`    TINYINT DEFAULT 0,
    CONSTRAINT `WORKFLOW_STATE_ACTION_PK` PRIMARY KEY (`ID`),
    CONSTRAINT `FK_WK_STATE_ACTION_WF_STATE` FOREIGN KEY (`WORKFLOW_STATE_ID`)
        REFERENCES `DIF`.`WORKFLOW_STATE` (`ID`) ON DELETE CASCADE,
    CONSTRAINT `FK_WF_STATE_ACTION_WAL` FOREIGN KEY (`ACTION_LIST_ID`)
        REFERENCES `DIF`.`WORKFLOW_ACTION_LIST` (`ID`) ON DELETE CASCADE
) ENGINE = InnoDB;
$$
-- -----------------------------------------------------
-- CREATE TABLE  `DIF`.`WORKFLOW_USER_PROFILE`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `DIF`.`WORKFLOW_USER_PROFILE`
(
    `ID`                         int(11)      NOT NULL AUTO_INCREMENT,
    `WORKFLOW_ID`                int(11)      NOT NULL,
    `NAME`                       VARCHAR(200) NOT NULL,
    `GROUP_ID`                   VARCHAR(500),
    `PROFILE_BUSINESS_ID`        VARCHAR(200),
    `PROFILE_BUSINESS_ID_PARAMS` VARCHAR(1000),
    CONSTRAINT `WORKFLOW_USER_PROFILE_PK` PRIMARY KEY (`ID`),
    CONSTRAINT `FK_WF_USER_PROFILE_WF` FOREIGN KEY (`WORKFLOW_ID`)
        REFERENCES `DIF`.`WORKFLOW` (`ID`) ON DELETE CASCADE
) ENGINE = InnoDB;
$$
-- -----------------------------------------------------
-- CREATE TABLE  `DIF`.`WORKFLOW_USER_PROFILE`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `DIF`.`WORKFLOW_ACTION_LIST_ITEM`
(
    `ID`                         int(11)      NOT NULL AUTO_INCREMENT,
    `ACTION_LIST_ID`             int(11)      NOT NULL,
    `ACTION_TYPE`                VARCHAR(100) NOT NULL,
    `ACTION_ITEM_BUSINESS_ID`    VARCHAR(500),
    `PARAMETERS`                 VARCHAR(1000),
    `BUSINESS_FLOW_ACTION_ID`    VARCHAR(1000),
    `BUSINESS_RULE_EXECUTION_ID` VARCHAR(1000),
    `NEW_STATE_ID`               int(11),
    `EXECUTION_ORDER`            int(11)      NOT NULL,
    `FAIL_ACTION_LIST_ON_ERROR`  TINYINT DEFAULT 1,
    `BUSINESS_ALERT_ID`          VARCHAR(2000),
    CONSTRAINT `WORKFLOW_ACT_LST_PK` PRIMARY KEY (`ID`),
    CONSTRAINT `FK_WF_ACTION_LIST_ITEM_AL` FOREIGN KEY (`ACTION_LIST_ID`)
        REFERENCES `DIF`.`WORKFLOW_ACTION_LIST` (`ID`) ON DELETE CASCADE,
    CONSTRAINT `FK_WF_ACTION_LIST_ITEM_WS` FOREIGN KEY (`NEW_STATE_ID`)
        REFERENCES `DIF`.`WORKFLOW_STATE` (`ID`)
) ENGINE = InnoDB;
$$
-- -----------------------------------------------------
-- CREATE TABLE  `DIF`.`WORKFLOW_ALI_TARGET`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `DIF`.`WORKFLOW_ALI_TARGET`
(
    `ID`                  int(11) NOT NULL AUTO_INCREMENT,
    `ACTION_LIST_ITEM_ID` int(11) NOT NULL,
    `USER_ID`             VARCHAR(1000),
    `USER_PROFILE_ID`     int(11),
    CONSTRAINT `WORKFLOW_ALI_TARGET_PK` PRIMARY KEY (`ID`),
    CONSTRAINT `FK_WF_ALI_TARGET_ALI` FOREIGN KEY (`ACTION_LIST_ITEM_ID`)
        REFERENCES `DIF`.`WORKFLOW_ACTION_LIST_ITEM` (`ID`) ON DELETE CASCADE,
    CONSTRAINT `FK_WORKFLOW_ALI_TARGET` FOREIGN KEY (`USER_PROFILE_ID`)
        REFERENCES `DIF`.`WORKFLOW_USER_PROFILE` (`ID`) ON DELETE CASCADE
) ENGINE = InnoDB;
$$
-- -----------------------------------------------------
-- CREATE TABLE  `DIF`.`WORKFLOW_CUSTOM_FORM_CONFIG`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `DIF`.`WORKFLOW_CUSTOM_FORM_CONFIG`
(
    `ID`                      int(11) NOT NULL AUTO_INCREMENT,
    `WORKFLOW_CUSTOM_FORM_ID` int(11) NOT NULL,
    `STATE_ID`                int(11),
    `USER_PROFILE_ID`         int(11),
    CONSTRAINT `WORKFLOW_CUST_FORM_CFG_PK` PRIMARY KEY (`ID`),
    CONSTRAINT `FK_WF_CUSTOM_FORM_CONFIG_WCF` FOREIGN KEY (`WORKFLOW_CUSTOM_FORM_ID`)
        REFERENCES `DIF`.`WORKFLOW_CUSTOM_FORM` (`ID`) ON DELETE CASCADE,
    CONSTRAINT `FK_WF_CUSTOM_FORM_CONFIG_WS` FOREIGN KEY (`STATE_ID`)
        REFERENCES `DIF`.`WORKFLOW_STATE` (`ID`) ON DELETE CASCADE,
    CONSTRAINT `FK_WF_CUSTOM_FORM_CONFIG_WUP` FOREIGN KEY (`USER_PROFILE_ID`)
        REFERENCES `DIF`.`WORKFLOW_USER_PROFILE` (`ID`) ON DELETE CASCADE
) ENGINE = InnoDB;
$$
-- -----------------------------------------------------
-- CREATE TABLE  `DIF`.`WORKFLOW_FILE_ACL`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `DIF`.`WORKFLOW_FILE_ACL`
(
    `ID`                  int(11)           NOT NULL AUTO_INCREMENT,
    `WORKFLOW_ID`         int(11)           NOT NULL,
    `FILE_BUNDLE_FILE_ID` int(11)           NOT NULL,
    `STATE_ID`            int(11),
    `USER_ID`             VARCHAR(1000),
    `USER_PROFILE_ID`     int(11),
    `CAN_UPLOAD`          TINYINT DEFAULT 1 NOT NULL,
    `CAN_VALIDATE`        TINYINT DEFAULT 1 NOT NULL,
    `CAN_INVALIDATE`      TINYINT DEFAULT 1 NOT NULL,
    `CAN_VIEW_VALID`      TINYINT DEFAULT 1 NOT NULL,
    `CAN_VIEW_NOT_VALID`  TINYINT DEFAULT 1 NOT NULL,
    `CAN_VIEW_PRIVATE`    TINYINT DEFAULT 0 NOT NULL,
    CONSTRAINT `WORKFLOW_FILE_ACL_PK` PRIMARY KEY (`ID`),
    CONSTRAINT `FK_WORKFLOW_FILE_WORKFLOW` FOREIGN KEY (`WORKFLOW_ID`)
        REFERENCES `DIF`.`WORKFLOW` (`ID`) ON DELETE CASCADE,
    CONSTRAINT `FK_WORKFLOW_FILE_ACL_FILE` FOREIGN KEY (`FILE_BUNDLE_FILE_ID`)
        REFERENCES `DIF`.`FILE_BUNDLE_FILE` (`ID`),
    CONSTRAINT `FK_WORKFLOW_FILE_ACL_STATE` FOREIGN KEY (`STATE_ID`)
        REFERENCES `DIF`.`WORKFLOW_STATE` (`ID`) ON DELETE CASCADE,
    CONSTRAINT `FK_WORKFLOW_FILE_ACL_PROFILE` FOREIGN KEY (`USER_PROFILE_ID`)
        REFERENCES `DIF`.`WORKFLOW_USER_PROFILE` (`ID`) ON DELETE CASCADE
) ENGINE = InnoDB;
$$
-- -----------------------------------------------------
-- CREATE TABLE  `DIF`.`WORKFLOW_INSTANCE`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `DIF`.`WORKFLOW_INSTANCE`
(
    `ID`                    int(11)      NOT NULL AUTO_INCREMENT,
    `WORKFLOW_ID`           int(11)      NOT NULL,
    `STATE_ID`              int(11)      NOT NULL,
    `BUSINESS_ID`           VARCHAR(250) NOT NULL,
    `CREATOR_USER_ID`       VARCHAR(1000),
    `CURRENT_OWNER_USER_ID` VARCHAR(1000),
    `CONVERSATION_ID`       int(11)      NOT NULL,
    CONSTRAINT `WORKFLOW_INSTANCE_PK` PRIMARY KEY (`ID`),
    CONSTRAINT `IDX_WORKFLOW_BUSINESS_ID` UNIQUE (`WORKFLOW_ID`, `BUSINESS_ID`),
    CONSTRAINT `FK_WORKFLOW_INSTANCE_WORKFLOW` FOREIGN KEY (`WORKFLOW_ID`)
        REFERENCES `DIF`.`WORKFLOW` (`ID`),
    CONSTRAINT `FK_WORKFLOW_INSTANCE` FOREIGN KEY (`STATE_ID`)
        REFERENCES `DIF`.`WORKFLOW_STATE` (`ID`),
    CONSTRAINT `FK_WORKFLOW_INST_CONVERS` FOREIGN KEY (`CONVERSATION_ID`)
        REFERENCES `DIF`.`CONVERSATION` (`ID`)
) ENGINE = InnoDB;
$$
-- -----------------------------------------------------
-- CREATE TABLE  `DIF`.`WORKFLOW_STATE_ACTION_ACL`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `DIF`.`WORKFLOW_STATE_ACTION_ACL`
(
    `ID`              int(11) NOT NULL AUTO_INCREMENT,
    `STATE_ACTION_ID` int(11) NOT NULL,
    `USER_ID`         VARCHAR(1000),
    `USER_PROFILE_ID` int(11),
    CONSTRAINT `WORKFLOW_STATE_ACT_ACL_PK` PRIMARY KEY (`ID`),
    CONSTRAINT `FK_WF_STATE_ACTION_ACL_SA` FOREIGN KEY (`STATE_ACTION_ID`)
        REFERENCES `DIF`.`WORKFLOW_STATE_ACTION` (`ID`) ON DELETE CASCADE,
    CONSTRAINT `FK_WF_STATE_ACTION_ACL_WUP` FOREIGN KEY (`USER_PROFILE_ID`)
        REFERENCES `DIF`.`WORKFLOW_USER_PROFILE` (`ID`) ON DELETE CASCADE
) ENGINE = InnoDB;
$$
-- -----------------------------------------------------
-- dropColumn `DIF`.`FILE_BUNDLE`.`BUSINESS_PROCESS_INSTANCE_ID`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS dropColumn;
$$
CREATE PROCEDURE dropColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'BUSINESS_PROCESS_INSTANCE_ID';

    IF TOTAL > 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE`
            DROP COLUMN `BUSINESS_PROCESS_INSTANCE_ID`;
    END IF;
END
$$
CALL dropColumn();
$$
DROP PROCEDURE IF EXISTS dropColumn;
$$

-- -----------------------------------------------------
-- dropColumn `DIF`.`FILE_BUNDLE`.`CREATION_DATE`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS dropColumn;
$$
CREATE PROCEDURE dropColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'CREATION_DATE';

    IF TOTAL > 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE`
            DROP COLUMN `CREATION_DATE`;
    END IF;
END
$$
CALL dropColumn();
$$
DROP PROCEDURE IF EXISTS dropColumn;
$$

-- -----------------------------------------------------
-- dropColumn `DIF`.`FILE_BUNDLE`.`IS_OPEN`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS dropColumn;
$$
CREATE PROCEDURE dropColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'IS_OPEN';

    IF TOTAL > 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE`
            DROP COLUMN `IS_OPEN`;
    END IF;
END
$$
CALL dropColumn();
$$
DROP PROCEDURE IF EXISTS dropColumn;
$$

-- -----------------------------------------------------
-- dropColumn `DIF`.`FILE_BUNDLE`.`CLOSE_DATE`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS dropColumn;
$$
CREATE PROCEDURE dropColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'CLOSE_DATE';

    IF TOTAL > 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE`
            DROP COLUMN `CLOSE_DATE`;
    END IF;
END
$$
CALL dropColumn();
$$
DROP PROCEDURE IF EXISTS dropColumn;
$$

-- -----------------------------------------------------
-- dropColumn `DIF`.`FILE_BUNDLE`.`DOCUMENT_ID`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS dropColumn;
$$
CREATE PROCEDURE dropColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'DOCUMENT_ID';

    IF TOTAL > 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE`
            DROP COLUMN `DOCUMENT_ID`;
    END IF;
END
$$
CALL dropColumn();
$$
DROP PROCEDURE IF EXISTS dropColumn;
$$

-- -----------------------------------------------------
-- dropColumn `DIF`.`FILE_BUNDLE`.`IS_PRIVATE`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS dropColumn;
$$
CREATE PROCEDURE dropColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'IS_PRIVATE';

    IF TOTAL > 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE`
            DROP COLUMN `IS_PRIVATE`;
    END IF;
END
$$
CALL dropColumn();
$$
DROP PROCEDURE IF EXISTS dropColumn;
$$

-- -----------------------------------------------------
-- dropColumn `DIF`.`FILE_BUNDLE`.`IS_VALID`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS dropColumn;
$$
CREATE PROCEDURE dropColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'IS_VALID';

    IF TOTAL > 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE`
            DROP COLUMN `IS_VALID`;
    END IF;
END
$$
CALL dropColumn();
$$
DROP PROCEDURE IF EXISTS dropColumn;
$$

-- -----------------------------------------------------
-- dropColumn `DIF`.`FILE_BUNDLE`.`UPLOAD_USER_ID`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS dropColumn;
$$
CREATE PROCEDURE dropColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'UPLOAD_USER_ID';

    IF TOTAL > 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE`
            DROP COLUMN `UPLOAD_USER_ID`;
    END IF;
END
$$
CALL dropColumn();
$$
DROP PROCEDURE IF EXISTS dropColumn;
$$

-- -----------------------------------------------------
-- dropColumn `DIF`.`FILE_BUNDLE`.`UPLOAD_DATE`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS dropColumn;
$$
CREATE PROCEDURE dropColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'UPLOAD_DATE';

    IF TOTAL > 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE`
            DROP COLUMN `UPLOAD_DATE`;
    END IF;
END
$$
CALL dropColumn();
$$
DROP PROCEDURE IF EXISTS dropColumn;
$$

-- -----------------------------------------------------
-- dropColumn `DIF`.`FILE_BUNDLE`.`UPLOAD_USER_BUSINESS_ID`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS dropColumn;
$$
CREATE PROCEDURE dropColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'UPLOAD_USER_BUSINESS_ID';

    IF TOTAL > 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE`
            DROP COLUMN `UPLOAD_USER_BUSINESS_ID`;
    END IF;
END
$$
CALL dropColumn();
$$
DROP PROCEDURE IF EXISTS dropColumn;
$$

-- -----------------------------------------------------
-- dropColumn `DIF`.`FILE_BUNDLE`.`VALIDATE_USER_ID`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS dropColumn;
$$
CREATE PROCEDURE dropColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'VALIDATE_USER_ID';

    IF TOTAL > 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE`
            DROP COLUMN `VALIDATE_USER_ID`;
    END IF;
END
$$
CALL dropColumn();
$$
DROP PROCEDURE IF EXISTS dropColumn;
$$

-- -----------------------------------------------------
-- dropColumn `DIF`.`FILE_BUNDLE`.`VALIDATE_DATE`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS dropColumn;
$$
CREATE PROCEDURE dropColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'VALIDATE_DATE';

    IF TOTAL > 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE`
            DROP COLUMN `VALIDATE_DATE`;
    END IF;
END
$$
CALL dropColumn();
$$
DROP PROCEDURE IF EXISTS dropColumn;
$$

-- -----------------------------------------------------
-- dropColumn `DIF`.`FILE_BUNDLE`.`VALIDATE_USER_BUSINESS_ID`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS dropColumn;
$$
CREATE PROCEDURE dropColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'VALIDATE_USER_BUSINESS_ID';

    IF TOTAL > 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE`
            DROP COLUMN `VALIDATE_USER_BUSINESS_ID`;
    END IF;
END
$$
CALL dropColumn();
$$
DROP PROCEDURE IF EXISTS dropColumn;
$$

-- -----------------------------------------------------
-- createColumn `DIF`.`FILE_BUNDLE_FILE`.`IS_MANDATORY`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
    DECLARE TOTAL INT;
    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND COLUMN_NAME = 'IS_MANDATORY';
    IF TOTAL = 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE_FILE`
            ADD COLUMN `IS_MANDATORY` tinyint DEFAULT 0 NOT NULL;
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

-- -----------------------------------------------------
-- createColumn `DIF`.`FILE_BUNDLE_FILE`.`IS_VERSIONED`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
    DECLARE TOTAL INT;
    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND COLUMN_NAME = 'IS_VERSIONED';
    IF TOTAL = 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE_FILE`
            ADD COLUMN `IS_VERSIONED` tinyint DEFAULT 0 NOT NULL;
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

-- -----------------------------------------------------
-- createColumn `DIF`.`FILE_BUNDLE_FILE`.`HAS_VALIDATION`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
    DECLARE TOTAL INT;
    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_FILE'
      AND COLUMN_NAME = 'HAS_VALIDATION';
    IF TOTAL = 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE_FILE`
            ADD COLUMN `HAS_VALIDATION` tinyint DEFAULT 0 NOT NULL;
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

-- -----------------------------------------------------
-- createColumn `DIF`.`WORKFLOW_FILE_ACL`.`CAN_VIEW_PRIVATE`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
    DECLARE TOTAL INT;
    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_FILE_ACL'
      AND COLUMN_NAME = 'CAN_VIEW_PRIVATE';
    IF TOTAL = 0 THEN
        ALTER TABLE `DIF`.`WORKFLOW_FILE_ACL`
            ADD COLUMN `CAN_VIEW_PRIVATE` tinyint DEFAULT 0 NOT NULL;
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

-- -----------------------------------------------------
-- CREATE TABLE  `DIF`.`FILE_BUNDLE_INSTANCE`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `DIF`.`FILE_BUNDLE_INSTANCE`
(
    `ID`                           INT(11)           NOT NULL,
    `FILE_BUNDLE_ID`               INT(11)           NOT NULL,
    `BUSINESS_PROCESS_INSTANCE_ID` VARCHAR(200),
    `CREATION_DATE`                DATETIME          NOT NULL,
    `IS_OPEN`                      TINYINT DEFAULT 1 NOT NULL,
    `CLOSE_DATE`                   DATETIME,
    CONSTRAINT `PK_FILE_BUNDLE_INSTANCE_ID` PRIMARY KEY (`ID`),
    CONSTRAINT `FK_FILE_BUNDLE_INSTANCE_FB` FOREIGN KEY (`FILE_BUNDLE_ID`)
        REFERENCES `DIF`.`FILE_BUNDLE` (`ID`)
) ENGINE = InnoDB;
$$
-- -----------------------------------------------------
-- createIndex `DIF`.`FILE_BUNDLE_INSTANCE`.`IDX_FILE_BUNDLE_INST_F`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS createIndex;
$$

CREATE PROCEDURE createIndex()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM INFORMATION_SCHEMA.STATISTICS
    WHERE TABLE_CATALOG = 'def'
      AND TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_INSTANCE'
      AND INDEX_NAME = 'IDX_FILE_BUNDLE_INST_F';

    IF TOTAL = 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE_INSTANCE`
            ADD INDEX `IDX_FILE_BUNDLE_INST_F` (`FILE_BUNDLE_ID`);
    END IF;
END
$$

CALL createIndex();
$$

DROP PROCEDURE IF EXISTS createIndex;
$$

-- -----------------------------------------------------
-- CREATE TABLE  `DIF`.`FILE_BUNDLE_INSTANCE_FILE`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `DIF`.`FILE_BUNDLE_INSTANCE_FILE`
(
    `ID`                        INT(11)           NOT NULL,
    `FILE_BUNDLE_INSTANCE_ID`   INT(11)           NOT NULL,
    `FILE_BUNDLE_FILE_ID`       INT(11)           NOT NULL,
    `DOCUMENT_ID`               DOUBLE,
    `IS_PRIVATE`                TINYINT DEFAULT 0 NOT NULL,
    `IS_VALID`                  TINYINT DEFAULT 0 NOT NULL,
    `UPLOAD_USER_ID`            VARCHAR(300),
    `UPLOAD_DATE`               DATETIME,
    `UPLOAD_USER_BUSINESS_ID`   VARCHAR(300),
    `VALIDATE_USER_ID`          VARCHAR(300),
    `VALIDATE_DATE`             DATETIME,
    `VALIDATE_USER_BUSINESS_ID` VARCHAR(300),
    `VERSION`                   INT     DEFAULT 1,
    `IS_INVALID`                TINYINT DEFAULT 0 NOT NULL,
    CONSTRAINT `FILE_BUNDLE_INSTANCE_FILE_PK` PRIMARY KEY (`ID`),
    CONSTRAINT `FK_FILE_BUNDLE_INST_FILE_FBF` FOREIGN KEY (`FILE_BUNDLE_FILE_ID`)
        REFERENCES `DIF`.`FILE_BUNDLE_FILE` (`ID`),
    CONSTRAINT `FK_FILE_BUNDLE_INST_FILE_FBI` FOREIGN KEY (`FILE_BUNDLE_INSTANCE_ID`)
        REFERENCES `DIF`.`FILE_BUNDLE_INSTANCE` (`ID`) ON DELETE CASCADE
) ENGINE = InnoDB;
$$

-- -----------------------------------------------------
-- createIndex `DIF`.`FILE_BUNDLE_INSTANCE`.`IDX_FILE_BUNDLE_INST_FB`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS createIndex;
$$

CREATE PROCEDURE createIndex()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM INFORMATION_SCHEMA.STATISTICS
    WHERE TABLE_CATALOG = 'def'
      AND TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_INSTANCE_FILE'
      AND INDEX_NAME = 'IDX_FILE_BUNDLE_INST_FB';

    IF TOTAL = 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE_INSTANCE_FILE`
            ADD INDEX `IDX_FILE_BUNDLE_INST_FB` (`FILE_BUNDLE_INSTANCE_ID`);
    END IF;
END
$$

CALL createIndex();
$$

DROP PROCEDURE IF EXISTS createIndex;
$$
-- -----------------------------------------------------
-- CREATE TABLE  `DIF`.`FILE_BUNDLE_HISTORY`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `DIF`.`FILE_BUNDLE_HISTORY`
(
    `ID`               INT(11)      NOT NULL,
    `INSTANCE_FILE_ID` INT(11)      NOT NULL,
    `DOCUMENT_ID`      INT(11)      NOT NULL,
    `VERSION`          INT          NOT NULL,
    `UPLOAD_DATE`      DATETIME     NOT NULL,
    `DEPRECATION_DATE` DATETIME     NOT NULL,
    `UPLOAD_USER_ID`   VARCHAR(300) NOT NULL,
    CONSTRAINT `PK_FILE_BUNDLE_HISTORY_ID` PRIMARY KEY (`ID`),
    CONSTRAINT `FK_FILE_BUNDLE_IF_VERSION_FBIF` FOREIGN KEY (`INSTANCE_FILE_ID`)
        REFERENCES `DIF`.`FILE_BUNDLE_INSTANCE_FILE` (`ID`) ON DELETE CASCADE
);
$$
-- -----------------------------------------------------
-- createIndex `DIF`.`FILE_BUNDLE_HISTORY`.`IDX_FILE_BUNDLE_HIST_INST_FIL`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS createIndex;
$$

CREATE PROCEDURE createIndex()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM INFORMATION_SCHEMA.STATISTICS
    WHERE TABLE_CATALOG = 'def'
      AND TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE_HISTORY'
      AND INDEX_NAME = 'IDX_FILE_BUNDLE_HIST_INST_FIL';

    IF TOTAL = 0 THEN
        ALTER TABLE `DIF`.`FILE_BUNDLE_HISTORY`
            ADD INDEX `IDX_FILE_BUNDLE_HIST_INST_FIL` (`INSTANCE_FILE_ID`);
    END IF;
END
$$

CALL createIndex();
$$

DROP PROCEDURE IF EXISTS createIndex;
$$

-- -----------------------------------------------------
-- updateColumn `DIF`.`FILE_BUNDLE`.`DESCRIPTION`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'DESCRIPTION'
      AND IS_NULLABLE = 'NO';

    IF TOTAL > 0 THEN
        ALTER TABLE DIF.FILE_BUNDLE
            CHANGE DESCRIPTION NAME VARCHAR(300);
    END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$


-- -----------------------------------------------------
-- updateColumn `DIF`.`FILE_BUNDLE`.`BUSINESS_PROCESS_TYPE_ID`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'FILE_BUNDLE'
      AND COLUMN_NAME = 'BUSINESS_PROCESS_TYPE_ID'
      AND IS_NULLABLE = 'NO';

    IF TOTAL > 0 THEN
        ALTER TABLE DIF.FILE_BUNDLE
            MODIFY COLUMN BUSINESS_PROCESS_TYPE_ID varchar(300) NULL;
    END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$


-- -----------------------------------------------------
-- createColumn `DIF`.`WORKFLOW_INSTANCE`.`FILE_BUNDLE_INSTANCE_ID`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
    DECLARE TOTAL INT;
    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_INSTANCE'
      AND COLUMN_NAME = 'FILE_BUNDLE_INSTANCE_ID';
    IF TOTAL = 0 THEN
        ALTER TABLE `DIF`.`WORKFLOW_INSTANCE`
            ADD COLUMN `FILE_BUNDLE_INSTANCE_ID` int(11),
            ADD CONSTRAINT `FK_WORKFLOW_INSTANCE_FBI`
                FOREIGN KEY (`FILE_BUNDLE_INSTANCE_ID`)
                    REFERENCES `DIF`.`FILE_BUNDLE_INSTANCE` (`id`)
                    ON DELETE CASCADE
                    ON UPDATE NO ACTION;

    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

-- -----------------------------------------------------
-- createIndex `DIF`.`WORKFLOW_INSTANCE`.`IDX_WORKFLOW_INS_FILE_BUNDLE`
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS createIndex;
$$

CREATE PROCEDURE createIndex()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM INFORMATION_SCHEMA.STATISTICS
    WHERE TABLE_CATALOG = 'def'
      AND TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_INSTANCE'
      AND INDEX_NAME = 'IDX_WORKFLOW_INS_FILE_BUNDLE';

    IF TOTAL = 0 THEN
        ALTER TABLE `DIF`.`WORKFLOW_INSTANCE`
            ADD INDEX `IDX_WORKFLOW_INS_FILE_BUNDLE` (`FILE_BUNDLE_INSTANCE_ID`);
    END IF;
END
$$

CALL createIndex();
$$

-- fim migração do script oracle - dif_V2.7.1__workflow_files_and_conversations.sql

-- inicio migração do script oracle - dif_V2.7.1_1__campos_files.sql
-- As alterações deste script foram feitas diretamente na criação da tabela FILE_BUNDLE_INSTANCE_FILE, visto que é criada neste script
-- fim migração do script oracle - dif_V2.7.1_1__campos_files.sql

CREATE PROCEDURE dropUniqueIndex()
BEGIN
    DECLARE total INT;
    SELECT count(*)
    INTO total
    FROM INFORMATION_SCHEMA.STATISTICS
    WHERE `TABLE_CATALOG` = 'def'
      AND `TABLE_SCHEMA` = 'DIF'
      AND `TABLE_NAME` = 'WORKFLOW'
      AND `INDEX_NAME` = 'IDX_WORKFLOW_BUSINESS_CLASS_ID';
    IF total = 1 THEN
        ALTER TABLE `DIF`.`WORKFLOW`
            DROP KEY IDX_WF_BUSINESS_CLASS_ID;
    END IF;
END
$$

CALL dropUniqueIndex();
$$

DROP PROCEDURE IF EXISTS dropUniqueIndex;
$$

CREATE PROCEDURE createUniqueIndex()
BEGIN
    DECLARE total INT;
    SELECT count(*)
    INTO total
    FROM INFORMATION_SCHEMA.STATISTICS
    WHERE `TABLE_CATALOG` = 'def'
      AND `TABLE_SCHEMA` = 'DIF'
      AND `TABLE_NAME` = 'WORKFLOW'
      AND `INDEX_NAME` = 'IDX_WORKFLOW_BUSINESS_CLASS_ID';
    IF total = 0 THEN
        ALTER TABLE `DIF`.`WORKFLOW`
            ADD UNIQUE INDEX `IDX_WORKFLOW_BUSINESS_CLASS_ID` (`BUSINESS_CLASS_ID` ASC, `BUSINESS_VERSION` ASC, `VERSION` ASC);
    END IF;
END
$$

CALL createUniqueIndex();
$$

DROP PROCEDURE IF EXISTS createUniqueIndex;
$$

DELIMITER $$
CREATE PROCEDURE createColumn()
BEGIN
    DECLARE TOTAL INT;
    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_ACTION_LIST_ITEM'
      AND COLUMN_NAME = 'BUSINESS_ALERT_ID';
    IF TOTAL = 0 THEN
        ALTER TABLE `DIF`.`WORKFLOW_ACTION_LIST_ITEM`
            ADD COLUMN `BUSINESS_ALERT_ID` VARCHAR(2000);
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'WORKFLOW'
      AND COLUMN_NAME = 'BUSINESS_CLASS_ID'
      AND IS_NULLABLE = 'NO';

    IF TOTAL > 0 THEN
        ALTER TABLE `DIF`.`WORKFLOW`
            CHANGE COLUMN `BUSINESS_CLASS_ID` `BUSINESS_CLASS_ID` VARCHAR(250) NOT NULL;
    END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'WORKFLOW'
      AND COLUMN_NAME = 'BUSINESS_VERSION'
      AND IS_NULLABLE = 'NO';

    IF TOTAL > 0 THEN
        ALTER TABLE `DIF`.`WORKFLOW`
            CHANGE COLUMN `BUSINESS_VERSION` `BUSINESS_VERSION` NUMERIC;
    END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'WORKFLOW'
      AND COLUMN_NAME = 'BUSINESS_VERSION'
      AND IS_NULLABLE = 'NO';

    IF TOTAL > 0 THEN
        ALTER TABLE `DIF`.`WORKFLOW`
            CHANGE COLUMN `VERSION` `VERSION` NUMERIC;
    END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT COUNT(*)
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_ACTION_LIST_ITEM'
      AND COLUMN_NAME = 'ACTION_TYPE'
      AND IS_NULLABLE = 'NO';

    IF TOTAL > 0 THEN
        ALTER TABLE `DIF`.`WORKFLOW_ACTION_LIST_ITEM`
            CHANGE COLUMN `ACTION_TYPE` `ACTION_TYPE` VARCHAR(100);
    END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
    DECLARE TOTAL INT;

    SELECT CHARACTER_MAXIMUM_LENGTH
    INTO TOTAL
    FROM information_schema.COLUMNS
    WHERE TABLE_SCHEMA = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_STATE'
      AND COLUMN_NAME = 'KEYWORD';

    IF TOTAL < 300 THEN
        ALTER TABLE `DIF`.`WORKFLOW_STATE`
            CHANGE COLUMN `KEYWORD` `KEYWORD` VARCHAR(40);
    END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

/* Remove the foreing key cascade */
ALTER TABLE `DIF`.`WORKFLOW_INSTANCE`
    DROP FOREIGN KEY `FK_WORKFLOW_INST_CONVERS`;
$$

ALTER TABLE `DIF`.`WORKFLOW_INSTANCE`
    ADD CONSTRAINT `FK_WORKFLOW_INST_CONVERS`
        FOREIGN KEY (`CONVERSATION_ID`)
            REFERENCES `DIF`.`CONVERSATION` (`ID`)
            ON DELETE NO ACTION
            ON UPDATE NO ACTION;
$$
