DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
    INTO   TOTAL
    FROM   ALL_TAB_COLUMNS 
    WHERE  OWNER      = 'DIF'
    AND    TABLE_NAME = 'INDICATOR'
    AND    COLUMN_NAME = 'IS_VISIBLE';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE   'ALTER TABLE DIF.INDICATOR ADD IS_VISIBLE NUMBER(1)';
  END IF;
END;
/

COMMENT ON COLUMN dif.INDICATOR.IS_VISIBLE IS 'If the indicator is visible.';

UPDATE DIF.INDICATOR SET IS_VISIBLE = 1 WHERE IS_VISIBLE IS NULL;

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TAB_COLUMNS 
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'INDICATOR'
  AND    COLUMN_NAME = 'IS_VISIBLE'
  AND    NULLABLE    = 'N';
      
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.INDICATOR MODIFY IS_VISIBLE NOT NULL';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
    INTO   TOTAL
    FROM   ALL_TAB_COLUMNS 
    WHERE  OWNER      = 'DIF'
    AND    TABLE_NAME = 'INDICATOR'
    AND    COLUMN_NAME = 'CHART_MODE';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE   'ALTER TABLE DIF.INDICATOR ADD CHART_MODE NUMBER(1)';
  END IF;
END;
/

COMMENT ON COLUMN dif.INDICATOR.CHART_MODE IS 'If the indicator is a chart.';

UPDATE DIF.INDICATOR SET CHART_MODE = 1 WHERE CHART_MODE IS NULL;

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TAB_COLUMNS 
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'INDICATOR'
  AND    COLUMN_NAME = 'CHART_MODE'
  AND    NULLABLE    = 'N';
      
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.INDICATOR MODIFY CHART_MODE NOT NULL';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
    INTO   TOTAL
    FROM   ALL_TAB_COLUMNS 
    WHERE  OWNER      = 'DIF'
    AND    TABLE_NAME = 'INDICATOR'
    AND    COLUMN_NAME = 'GROUP_POSITION';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE   'ALTER TABLE DIF.INDICATOR ADD GROUP_POSITION NUMBER(3)';
  END IF;
END;
/

COMMENT ON COLUMN dif.INDICATOR.GROUP_POSITION IS 'The custom position of the group.';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
    INTO   TOTAL
    FROM   ALL_TAB_COLUMNS 
    WHERE  OWNER      = 'DIF'
    AND    TABLE_NAME = 'INDICATOR'
    AND    COLUMN_NAME = 'POSITION';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE   'ALTER TABLE DIF.INDICATOR ADD POSITION NUMBER(3)';
  END IF;
END;
/

COMMENT ON COLUMN dif.INDICATOR.POSITION IS 'The custom position inside it''s group.';


DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
    INTO   TOTAL
    FROM   ALL_TAB_COLUMNS 
    WHERE  OWNER      = 'DIF'
    AND    TABLE_NAME = 'INDICATOR'
    AND    COLUMN_NAME = 'GRID_COLUMNS';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE   'ALTER TABLE DIF.INDICATOR ADD GRID_COLUMNS VARCHAR2(4000)';
  END IF;
END;
/

COMMENT ON COLUMN dif.INDICATOR.GRID_COLUMNS IS 'The grid columns configuration.';
