/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.ecommerce;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.hibernate.exception.ConstraintViolationException;
import pt.digitalis.dif.dem.managers.impl.model.IECommerceService;
import pt.digitalis.dif.dem.managers.impl.model.data.EcommercePayments;
import pt.digitalis.dif.ecommerce.BusinessProcessResult;
import pt.digitalis.dif.ecommerce.IECommerce;
import pt.digitalis.dif.ecommerce.IECommerceBusiness;
import pt.digitalis.dif.ecommerce.PaymentException;
import pt.digitalis.dif.ecommerce.PaymentExecutionResult;
import pt.digitalis.dif.ecommerce.PaymentRequest;
import pt.digitalis.dif.ecommerce.PaymentStatus;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.Filter;
import pt.digitalis.dif.model.dataset.FilterType;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.dif.utils.logging.DIFLoggerInterceptorImpl;
import pt.digitalis.dif.utils.logging.IErrorLogManager;
import pt.digitalis.log.LogLevel;
import pt.digitalis.utils.common.CollectionUtils;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.ConfigurationException;

public abstract class AbstractECommerce<T>
implements IECommerce<T> {
    public static final String UNIQUE_ID_SEPARATOR = "-";
    protected static final String PAYMENT_AMOUNT_CHANGED_MSG = "The payment amount received is different from the original request.";
    protected static final String PAYMENT_BUSINESS_PROCESSOR_FAILED = "The payment business proccess [\"#1\"] failed.";
    protected static final String PAYMENT_BUSINESS_PROCESSOR_WARNING = "The payment business proccess [\"#1\"] has warnings.";
    protected static final String PAYMENT_INIT_ERROR = "The payment was not initialized. Process aborted.";
    protected static final String PAYMENT_TOKEN_CHANGED_MSG = "The payment token received is different from the original request.";
    public static String MESSAGE_SEPARATOR = "#SEP#";
    private static IECommerceService eCommerceService = (IECommerceService)DIFIoCRegistry.getRegistry().getImplementation(IECommerceService.class);
    private IErrorLogManager errorLogManager = (IErrorLogManager)DIFIoCRegistry.getRegistry().getImplementation(IErrorLogManager.class);

    public static String verifyMessage(String newMessage, String statusMessage) {
        String result = statusMessage;
        if (result != null) {
            if (result.contains(newMessage)) {
                result = result.replace(newMessage, "");
            }
            if ((result = result + newMessage).length() >= 3999) {
                result = StringUtils.right((String)result, (int)3990);
            }
        }
        return result;
    }

    private static synchronized EcommercePayments getInsertWitNextID(String partialBusinessId, EcommercePayments ePaymentRecord) throws DataSetException {
        Object result = null;
        Query query = eCommerceService.getEcommercePaymentsDataSet().query();
        query.addFilter(new Filter("businessId", FilterType.LIKE, partialBusinessId));
        Long seq = query.count();
        String id = partialBusinessId + UNIQUE_ID_SEPARATOR + (seq + 1L);
        ePaymentRecord.setBusinessId(id);
        ePaymentRecord = (EcommercePayments)eCommerceService.getEcommercePaymentsDataSet().insert((IBeanAttributes)ePaymentRecord);
        ePaymentRecord = (EcommercePayments)eCommerceService.getEcommercePaymentsDataSet().get((Serializable)ePaymentRecord.getId());
        return ePaymentRecord;
    }

    @Override
    public boolean allowReprocessFailedPayments() {
        return false;
    }

    @Override
    public boolean canCancelPayments() {
        return true;
    }

    public abstract PaymentExecutionResult<T> doInit(PaymentRequest var1, String var2, String var3) throws ConfigurationException;

    public abstract PaymentExecutionResult<T> doProcess(String var1, String var2, String var3, T var4) throws ConfigurationException;

    private EcommercePayments getPaymentRecord(String businessId) throws DataSetException {
        Query query = eCommerceService.getEcommercePaymentsDataSet().query();
        query.addFilter(new Filter("businessId".toString(), FilterType.EQUALS, businessId));
        return (EcommercePayments)query.singleValue();
    }

    @Override
    public final EcommercePayments initWebPayment(PaymentRequest payment, String partialBusinessId) throws PaymentException, ConfigurationException {
        return this.initWebPayment(payment, partialBusinessId, null);
    }

    @Override
    public EcommercePayments initWebPayment(PaymentRequest payment, String partialBusinessId, String configurationId) throws PaymentException, ConfigurationException {
        EcommercePayments ePaymentRecord = null;
        ePaymentRecord = new EcommercePayments();
        ePaymentRecord.setBusinessContext(payment.getBusinessContext());
        ePaymentRecord.setCreator(payment.getCreator());
        ePaymentRecord.setDateCreation(new Timestamp(new Date().getTime()));
        ePaymentRecord.setEcommerceProcessor(this.getIdentifier());
        ePaymentRecord.setPaymentValue(payment.getAmount());
        ePaymentRecord.setConfigurationId(configurationId);
        try {
            InetAddress ip = InetAddress.getLocalHost();
            ePaymentRecord.setStatusMessage(" Host Address:  " + ip.getHostAddress() + " Host Name: " + ip.getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (payment.getFee() != null) {
            ePaymentRecord.setPaymentFee(payment.getFee());
            BigDecimal amount = payment.getAmount();
            amount = amount.add(payment.getFee());
            ePaymentRecord.setPaymentValue(amount);
            payment.setAmount(amount);
        }
        ePaymentRecord.setStatus(PaymentStatus.F.name());
        ePaymentRecord.setPaymentContext(CollectionUtils.keyValueMapToString(payment.getPaymentContext()));
        boolean inserted = false;
        while (!inserted) {
            try {
                ePaymentRecord = AbstractECommerce.getInsertWitNextID(partialBusinessId, ePaymentRecord);
                inserted = ePaymentRecord != null && ePaymentRecord.getId() != null;
            }
            catch (Exception e) {
                boolean uniqueKeyException = false;
                if (e instanceof ConstraintViolationException) {
                    ConstraintViolationException constraintViolation = (ConstraintViolationException)e.getCause();
                    uniqueKeyException = constraintViolation.getConstraintName().toUpperCase().endsWith(".EPAYMENTRECORD_BUSINESS_ID_UK");
                }
                if (uniqueKeyException) continue;
                throw new PaymentException(e);
            }
        }
        PaymentExecutionResult<T> paymentResult = this.doInit(payment, ePaymentRecord.getBusinessId(), configurationId);
        if (paymentResult.isSuccess()) {
            ePaymentRecord.setSecurityToken(paymentResult.getSecurityToken());
            ePaymentRecord.setRedirectUrl(paymentResult.getRedirectURL());
            ePaymentRecord.setTransactionId(paymentResult.getTransactionId());
            ePaymentRecord.setPaymentContext(CollectionUtils.keyValueMapToString(payment.getPaymentContext()));
            String message = "doInit: Payment '" + ePaymentRecord.getBusinessId() + "' initialized.";
            if (paymentResult.getMessage() != null) {
                message = message + " Message:" + paymentResult.getMessage();
            }
            ePaymentRecord.setStatusMessage(message);
            ePaymentRecord.setStatus(PaymentStatus.W.name());
            try {
                ePaymentRecord = (EcommercePayments)eCommerceService.getEcommercePaymentsDataSet().update((IBeanAttributes)ePaymentRecord);
            }
            catch (DataSetException e) {
                throw new PaymentException((Exception)((Object)e));
            }
        }
        String errorMessage = paymentResult.getMessage() == null ? PAYMENT_INIT_ERROR : "The payment was not initialized. Process aborted.\n   Reason: " + paymentResult.getMessage();
        try {
            ePaymentRecord.setStatusMessage(errorMessage);
            ePaymentRecord = (EcommercePayments)eCommerceService.getEcommercePaymentsDataSet().update((IBeanAttributes)ePaymentRecord);
        }
        catch (DataSetException e) {
            throw new PaymentException((Exception)((Object)e));
        }
        throw new PaymentException(errorMessage);
        return ePaymentRecord;
    }

    @Override
    public final EcommercePayments processBusinessPayment(EcommercePayments ePaymentRecord) throws PaymentException {
        try {
            IECommerceBusiness business;
            String statusMessage = StringUtils.nvl((String)ePaymentRecord.getStatusMessage(), (String)"");
            List list = DIFIoCRegistry.getRegistry().getImplementations(IECommerceBusiness.class);
            Boolean markAsProcessed = true;
            Boolean updateRecord = false;
            try {
                InetAddress ip = InetAddress.getLocalHost();
                ePaymentRecord.setStatusMessage(statusMessage + " Host Address:  " + ip.getHostAddress() + " Host Name: " + ip.getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            if (!list.isEmpty() && (business = (IECommerceBusiness)list.get(0)) != null) {
                String businessMessage = "";
                try {
                    BusinessProcessResult processResult = business.processPayment(ePaymentRecord);
                    if (!processResult.isSuccess().booleanValue()) {
                        markAsProcessed = false;
                    }
                    businessMessage = processResult.getMessage();
                }
                catch (Exception e) {
                    businessMessage = " " + e.getMessage();
                    markAsProcessed = false;
                }
                if (!markAsProcessed.booleanValue()) {
                    String newMessage = MESSAGE_SEPARATOR + PAYMENT_BUSINESS_PROCESSOR_FAILED.replace("#1", business.getFullIdentifier()) + ": " + businessMessage;
                    statusMessage = AbstractECommerce.verifyMessage(newMessage, statusMessage);
                    ePaymentRecord.setStatusMessage(statusMessage.trim());
                    updateRecord = true;
                } else if (businessMessage != null && !"".equals(businessMessage)) {
                    statusMessage = statusMessage + MESSAGE_SEPARATOR + PAYMENT_BUSINESS_PROCESSOR_WARNING.replace("#1", business.getFullIdentifier()) + ": " + businessMessage;
                    updateRecord = true;
                    ePaymentRecord.setStatusMessage(statusMessage.trim());
                }
            }
            if (markAsProcessed.booleanValue()) {
                ePaymentRecord.setStatus(PaymentStatus.P.name());
                ePaymentRecord.setDateProcessed(new Timestamp(new Date().getTime()));
                updateRecord = true;
            }
            if (updateRecord.booleanValue()) {
                String message = ePaymentRecord.getStatusMessage();
                if (DIFLoggerInterceptorImpl.isMonitoredClass((String)this.getClass().getCanonicalName())) {
                    BusinessException difException = new BusinessException("processBusinessPayment:" + message);
                    difException.log(LogLevel.DEBUG, false);
                }
                if (StringUtils.isNotBlank((String)message)) {
                    message = StringUtils.right((String)message, (int)3999).trim();
                    ePaymentRecord.setStatusMessage(message);
                }
                ePaymentRecord = (EcommercePayments)eCommerceService.getEcommercePaymentsDataSet().update((IBeanAttributes)ePaymentRecord);
            }
        }
        catch (DataSetException e) {
            throw new PaymentException((Exception)((Object)e));
        }
        return ePaymentRecord;
    }

    @Override
    public EcommercePayments processWebPayment(String businessID) throws PaymentException, ConfigurationException {
        return this.processWebPayment(businessID, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final EcommercePayments processWebPayment(String businessID, String securityToken, T providerResponse) throws PaymentException, ConfigurationException {
        AbstractECommerce abstractECommerce = this;
        synchronized (abstractECommerce) {
            EcommercePayments ePaymentRecord = null;
            try {
                ePaymentRecord = this.getPaymentRecord(businessID);
                if (ePaymentRecord == null) {
                    throw new PaymentException("The requested payment wasn't found. The payment ID is \"" + businessID + "\"");
                }
                if (ePaymentRecord.getEcommerceProcessor() == null || !this.getIdentifier().equals(ePaymentRecord.getEcommerceProcessor())) {
                    String message = (ePaymentRecord.getStatusMessage() != null ? ePaymentRecord.getStatusMessage() : "") + " - " + "Error: " + "The processor identifier for this instance (" + this.getIdentifier() + ") is different from the one in record (" + ePaymentRecord.getEcommerceProcessor() + "). Please see error log and search for the business id(" + ePaymentRecord.getBusinessId() + ").";
                    ePaymentRecord.setStatusMessage(message);
                    PaymentException e = new PaymentException(message);
                    message = message + " - " + ExceptionUtils.getStackTrace((Throwable)e);
                    this.errorLogManager.logError("EcommercePayments", this.getClass().getName(), (Exception)new PaymentException(message));
                } else {
                    String statusMessage = StringUtils.nvl((String)ePaymentRecord.getStatusMessage(), (String)"");
                    if (!PaymentStatus.W.name().equals(ePaymentRecord.getStatus())) {
                        throw new PaymentException("The requested payment has already been processed. The payment ID is \"" + businessID + "\"");
                    }
                    PaymentExecutionResult paymentExecutionResult = new PaymentExecutionResult();
                    if (ePaymentRecord.getSecurityToken() == null || ePaymentRecord.getSecurityToken().equals(securityToken) || securityToken == null) {
                        if (securityToken == null) {
                            securityToken = ePaymentRecord.getSecurityToken();
                        }
                        paymentExecutionResult = this.doProcess(businessID, securityToken, ePaymentRecord.getConfigurationId(), providerResponse);
                        statusMessage = statusMessage + MESSAGE_SEPARATOR + " doProcess ";
                    } else {
                        statusMessage = statusMessage + " The payment token received is different from the original request.";
                    }
                    if (ePaymentRecord.getSecurityToken() == null && paymentExecutionResult.getSecurityToken() != null) {
                        ePaymentRecord.setSecurityToken(paymentExecutionResult.getSecurityToken());
                    }
                    if (paymentExecutionResult.isSuccess()) {
                        statusMessage = statusMessage + " Success ";
                        if (paymentExecutionResult.getMessage() != null) {
                            statusMessage = statusMessage + paymentExecutionResult.getMessage();
                        }
                        paymentExecutionResult.setBusinessContext(ePaymentRecord.getBusinessContext());
                        if (paymentExecutionResult.getAmmount().compareTo(ePaymentRecord.getPaymentValue()) != 0) {
                            statusMessage = statusMessage + MESSAGE_SEPARATOR + PAYMENT_AMOUNT_CHANGED_MSG;
                        }
                        String message = StringUtils.right((String)statusMessage, (int)3999);
                        ePaymentRecord.setStatusMessage(StringUtils.nvl((String)message, (String)"").trim());
                        ePaymentRecord.setStatus(PaymentStatus.R.name());
                        ePaymentRecord.setTransactionId(paymentExecutionResult.getTransactionId());
                        ePaymentRecord.setTransactionDate(new Timestamp(paymentExecutionResult.getTransactionDate().getTime()));
                        ePaymentRecord.setDateReceived(new Timestamp(new Date().getTime()));
                        ePaymentRecord.setPaymentValue(paymentExecutionResult.getAmmount());
                        ePaymentRecord.setAuthorizationId(paymentExecutionResult.getAuthorizationId());
                        ePaymentRecord = (EcommercePayments)eCommerceService.getEcommercePaymentsDataSet().update((IBeanAttributes)ePaymentRecord);
                        ePaymentRecord = this.processBusinessPayment(ePaymentRecord);
                    } else {
                        if (paymentExecutionResult.getMessage() != null) {
                            String newMessage = MESSAGE_SEPARATOR + paymentExecutionResult.getMessage();
                            statusMessage = AbstractECommerce.verifyMessage(newMessage, statusMessage);
                        }
                        if (StringUtils.isNotEmpty((String)paymentExecutionResult.getMessageForUser())) {
                            String errorFriendlyMessage = paymentExecutionResult.getMessageForUser();
                            errorFriendlyMessage = StringUtils.right((String)errorFriendlyMessage, (int)3990);
                            ePaymentRecord.setErrorFriendlyUserMessage(errorFriendlyMessage.trim());
                        }
                        statusMessage = StringUtils.right((String)statusMessage, (int)3990);
                        ePaymentRecord.setStatusMessage(statusMessage.trim());
                        if (paymentExecutionResult.isPaymentFailed()) {
                            ePaymentRecord.setStatus(PaymentStatus.F.name());
                            ePaymentRecord.setDateReceived(new Timestamp(new Date().getTime()));
                        }
                        ePaymentRecord = (EcommercePayments)eCommerceService.getEcommercePaymentsDataSet().update((IBeanAttributes)ePaymentRecord);
                    }
                }
            }
            catch (DataSetException e) {
                throw new PaymentException(e.getMessage());
            }
            return ePaymentRecord;
        }
    }
}

