/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.utils.logging.performance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StatelessSession;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.data.AccessLog;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.utils.logging.performance.LogRequestData;
import pt.digitalis.dif.utils.logging.performance.PerformanceLogger;
import pt.digitalis.dif.utils.logging.performance.PerformanceLoggerConfiguration;
import pt.digitalis.log.LogLevel;
import pt.digitalis.utils.common.Chronometer;

public class PerformanceLoggerDBImplementation
extends PerformanceLogger {
    private static final long MAX_RECORDS_BEFORE_FLUSH = 200L;
    private static final long MAX_SECONDS_BEFORE_FLUSH = 30L;
    private Calendar lastBatchInsert = Calendar.getInstance();
    private List<AccessLog> logBuffer = new ArrayList<AccessLog>();

    protected synchronized void auditRequest(LogRequestData logData, Long timeSpent, String errorDescription) {
        AccessLog access = this.createLogRecord(logData, timeSpent, errorDescription);
        if (StringUtils.isNotBlank((String)access.getApplicationId()) && StringUtils.isNotBlank((String)access.getServiceId()) && StringUtils.isNotBlank((String)access.getStageId()) && access.getRequestType() != null && access.getAccessDate() != null && access.getExecutionTime() != null && StringUtils.isNotBlank((String)access.getClientIp())) {
            this.logBuffer.add(access);
        } else {
            DIFLogger.getLogger().warn((Object)("Performance Access logs: The request could not be Logged. Insuficient data!\n" + access.toString()));
        }
        long secondsSinceLastBatchInsert = (Calendar.getInstance().getTimeInMillis() - this.lastBatchInsert.getTimeInMillis()) / 1000L;
        if ((long)this.logBuffer.size() > 200L || secondsSinceLastBatchInsert > 30L) {
            FlushLogbufferToDB writer = new FlushLogbufferToDB(new ArrayList<AccessLog>(this.logBuffer));
            this.logBuffer.clear();
            this.lastBatchInsert = Calendar.getInstance();
            writer.start();
        }
    }

    protected AccessLog createLogRecord(LogRequestData logData, Long timeSpent, String errorDescription) {
        String eventID = logData.getEventID();
        String userID = logData.getUserID();
        AccessLog access = new AccessLog();
        access.setUserId(userID);
        access.setClientIp(logData.getClientRemoteAddress());
        access.setAccessDate(new Timestamp(new Date().getTime()));
        access.setApplicationId(logData.getApplicationID());
        access.setServiceId(logData.getServiceID());
        access.setStageId(logData.getStageID());
        access.setEventId(eventID);
        access.setRequestType(logData.getRequestType());
        access.setExecutionTime(timeSpent);
        access.setErrorReport(errorDescription);
        if (StringUtils.isNotBlank((String)errorDescription) || PerformanceLoggerConfiguration.getInstance().getAuditRequestsDebugMode().booleanValue()) {
            access.setRequestDump(logData.getRequestDump());
        }
        return access;
    }

    private class FlushLogbufferToDB
    extends Thread {
        private List<AccessLog> logsToWrite = new ArrayList<AccessLog>();

        public FlushLogbufferToDB(List<AccessLog> logsToWrite) {
            this.logsToWrite = logsToWrite;
        }

        @Override
        public void run() {
            Chronometer crono = new Chronometer();
            crono.start();
            StatelessSession session = HibernateUtil.getSessionFactory((String)DIFRepositoryFactory.SESSION_FACTORY_NAME).openStatelessSession();
            session.beginTransaction();
            Connection c = session.connection();
            try {
                PreparedStatement ps = c.prepareStatement("INSERT INTO DIF.ACCESS_LOG(application_id,service_id,stage_id,event_id,request_type,user_id,access_date,execution_time,client_ip,error_report,request_dump) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                long inserted = 0L;
                for (AccessLog log : this.logsToWrite) {
                    ++inserted;
                    ps.setString(1, log.getApplicationId());
                    ps.setString(2, log.getServiceId());
                    ps.setString(3, log.getStageId());
                    ps.setString(4, StringUtils.left((String)log.getEventId(), (int)100));
                    ps.setString(5, log.getRequestType().toString());
                    ps.setString(6, log.getUserId());
                    ps.setTimestamp(7, log.getAccessDate());
                    ps.setLong(8, log.getExecutionTime());
                    ps.setString(9, log.getClientIp());
                    if (StringUtils.isNotBlank((String)log.getErrorReport())) {
                        String errorReport = log.getErrorReport();
                        if (errorReport.length() > 3999) {
                            errorReport = errorReport.substring(0, 3999);
                        }
                        ps.setString(10, errorReport);
                    } else {
                        ps.setString(10, null);
                    }
                    ps.setString(11, log.getRequestDump());
                    ps.addBatch();
                    ps.clearParameters();
                }
                ps.executeBatch();
                session.getTransaction().commit();
                session.close();
                crono.end();
                DIFLogger.getLogger().info((Object)("Performance Access logs: " + inserted + " logs flushed in " + crono.getTimePassedAsFormattedString()));
            }
            catch (Exception e) {
                new BusinessException("Error saving performance log buffer to the database", e).addToExceptionContext("LogsToWrite", this.logsToWrite).log(LogLevel.ERROR);
                session.getTransaction().rollback();
                session.close();
            }
        }
    }
}

