DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW'
      AND CONSTRAINT_NAME = 'IDX_WORKFLOW_BUSINESS_CLASS_ID';

    IF TOTAL = 1 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW DROP CONSTRAINT IDX_WORKFLOW_BUSINESS_CLASS_ID';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW'
      AND CONSTRAINT_NAME = 'IDX_WORKFLOW_BUSINESS_CLASS_ID';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW ADD CONSTRAINT IDX_WORKFLOW_BUSINESS_CLASS_ID UNIQUE (BUSINESS_CLASS_ID, BUSINESS_VERSION, VERSION)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN

    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_ACTION_LIST_ITEM'
      AND COLUMN_NAME = 'BUSINESS_ALERT_ID';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_ACTION_LIST_ITEM ADD BUSINESS_ALERT_ID varchar2(2000)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW'
      AND COLUMN_NAME = 'BUSINESS_CLASS_ID'
      AND NULLABLE = 'N';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW MODIFY ( BUSINESS_CLASS_ID NOT NULL)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW'
      AND COLUMN_NAME = 'BUSINESS_VERSION'
      AND NULLABLE = 'N';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW MODIFY ( BUSINESS_VERSION NOT NULL)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW'
      AND COLUMN_NAME = 'VERSION'
      AND NULLABLE = 'N';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW MODIFY ( VERSION NOT NULL)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_ACTION_LIST_ITEM'
      AND COLUMN_NAME = 'ACTION_TYPE'
      AND NULLABLE = 'N';

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_ACTION_LIST_ITEM MODIFY ( ACTION_TYPE NOT NULL)';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_TAB_COLUMNS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_STATE'
      AND COLUMN_NAME = 'KEYWORD'
      AND DATA_LENGTH < 40;

    IF TOTAL = 0 THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DIF.WORKFLOW_STATE MODIFY ( KEYWORD varchar2(40))';
    END IF;
END;
/

DECLARE
    TOTAL NUMBER;
BEGIN
    SELECT COUNT(*)
    INTO TOTAL
    FROM ALL_CONSTRAINTS
    WHERE OWNER = 'DIF'
      AND TABLE_NAME = 'WORKFLOW_INSTANCE'
      AND CONSTRAINT_NAME = 'FK_WORKFLOW_INST_CONVERS';

    IF TOTAL > 0 THEN
        EXECUTE IMMEDIATE 'alter table DIF.WORKFLOW_INSTANCE drop constraint FK_WORKFLOW_INST_CONVERS';
    END IF;
END;
/

alter table DIF.WORKFLOW_INSTANCE
    add constraint FK_WORKFLOW_INST_CONVERS foreign key (CONVERSATION_ID) references DIF.CONVERSATION (ID);
