/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.ldap;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import pt.digitalis.log.ILogWrapper;
import pt.digitalis.utils.ldap.LDAPConfigurations;
import pt.digitalis.utils.ldap.LDAPGroup;
import pt.digitalis.utils.ldap.LDAPUser;
import pt.digitalis.utils.ldap.exception.LDAPOperationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ILDAPUtils {
    public void addGroup(LDAPGroup var1) throws LDAPOperationException;

    public void addGroupAttribute(String var1, String var2, Object var3) throws LDAPOperationException;

    public void addUser(LDAPUser var1) throws LDAPOperationException;

    public void addUserAttribute(String var1, String var2, Object var3) throws LDAPOperationException;

    public void addUserToGroup(String var1, String var2) throws LDAPOperationException;

    public void changePassword(String var1, String var2) throws LDAPOperationException;

    public int countAllGroups() throws NamingException, LDAPOperationException;

    public int countAllGroups(boolean var1) throws NamingException, LDAPOperationException;

    public int countAllGroupsOfUser(String var1) throws NamingException, LDAPOperationException;

    public int countAllUsers() throws NamingException, LDAPOperationException;

    public int countAllUsers(String var1) throws LDAPOperationException;

    public int countUsers(Map<String, String> var1) throws LDAPOperationException;

    public Set<LDAPGroup> findAllGroups() throws LDAPOperationException;

    public Set<LDAPUser> findAllUsers() throws LDAPOperationException;

    public LDAPGroup findGroupByCommonName(String var1) throws LDAPOperationException;

    public LDAPGroup findGroupByDistinguishedName(String var1) throws LDAPOperationException;

    public Set<LDAPGroup> findGroups(int var1, int var2) throws LDAPOperationException;

    public Set<LDAPGroup> findGroupsOfUser(String var1) throws LDAPOperationException;

    public Set<LDAPGroup> findGroupsOfUserPagination(String var1, Integer var2, Integer var3) throws LDAPOperationException;

    public LDAPUser findUserByDistinguishedName(String var1) throws LDAPOperationException;

    public LDAPUser findUserByLogin(String var1) throws LDAPOperationException;

    public Set<LDAPUser> findUsers(int var1, int var2) throws LDAPOperationException;

    public Set<LDAPUser> findUsersByAnyAttribute(Map<String, String> var1) throws LDAPOperationException;

    public Set<LDAPUser> findUsersByAttribute(String var1, String var2) throws LDAPOperationException;

    public Set<LDAPUser> findUsersByAttributes(Map<String, String> var1) throws LDAPOperationException;

    public Set<LDAPUser> findUsersByAttributes(Map<String, String> var1, Integer var2, Integer var3) throws LDAPOperationException;

    public Set<LDAPUser> findUsersByEmail(String var1) throws LDAPOperationException;

    public Map<String, LDAPUser> findUsersInGroup(String var1) throws LDAPOperationException;

    public Set<LDAPGroup> getChildGroupsByCN(String var1) throws LDAPOperationException;

    public Set<LDAPGroup> getChildGroupsByDN(String var1) throws LDAPOperationException;

    public LDAPConfigurations getConfigurations();

    public Object getGroupAttribute(String var1, String var2) throws LDAPOperationException;

    public String getGroupAttributeName();

    public Map<String, Object> getGroupAttributes(String var1) throws LDAPOperationException;

    public String getMailAttributeName();

    public String getNameAttributeName();

    public String getNonAvailableValue();

    public List<String> getUnchangeableLDAPAttributes();

    public Object getUserAttribute(String var1, String var2) throws LDAPOperationException;

    public Map<String, Object> getUserAttributes(String var1) throws LDAPOperationException;

    public String getUserLoginAttributeName();

    public String getUserParentGroupAttributeName();

    public boolean groupContainsAttribute(String var1, String var2) throws LDAPOperationException;

    public boolean groupExists(String var1) throws LDAPOperationException;

    public boolean isIdentityValid(String var1, String var2) throws LDAPOperationException;

    public boolean isReadOnly();

    public boolean isUserInGroup(String var1, String var2) throws LDAPOperationException;

    public void removeGroup(String var1) throws LDAPOperationException;

    public void removeGroupAttribute(String var1, String var2) throws LDAPOperationException;

    public void removeUser(String var1) throws LDAPOperationException;

    public void removeUserAttribute(String var1, String var2) throws LDAPOperationException;

    public void removeUserFromGroup(String var1, String var2) throws LDAPOperationException;

    public void resetConfigurations();

    public void setGroupAttribute(String var1, String var2, Object var3) throws LDAPOperationException;

    public void setLogger(ILogWrapper var1);

    public void setUserAttribute(String var1, String var2, Object var3) throws LDAPOperationException;

    public void updateGroup(LDAPGroup var1, String var2) throws LDAPOperationException;

    public void updateUser(LDAPUser var1, String var2) throws LDAPOperationException;

    public boolean userContainsAttribute(String var1, String var2) throws LDAPOperationException;

    public boolean userExists(String var1) throws LDAPOperationException;
}

