/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.ldap;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;
import pt.digitalis.utils.config.ConfigurationsPreferencesImpl;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigSectionID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigID(value="dif2")
@ConfigSectionID(value="LDAPConfigurations")
public class LDAPConfigurations {
    private static String LDAP_CONFIGURATIONS_PATH = "dif2/LDAPConfigurations";
    private static Map<String, String> revertGroupMappings;
    private boolean allowDistinguishedNameModifications;
    private CaseInsensitiveHashMap<String> attributesMappings;
    private String baseSearchDN;
    private String baseUserDN;
    private String bulkParametersAttributeName;
    private String defaultGroupDN;
    private String defaultProfileDN;
    private String exclusionCharaters;
    private Boolean forceSecureConnection;
    private Map<String, String> groupMappings;
    private String hostName;
    private String loginAttribute;
    private String password;
    private String port;
    private int querysPageSizeLimit;
    private boolean readOnly;
    private String sslPort;
    private String userDN;

    @ConfigDefault(value="false")
    public boolean getAllowDistinguishedNameModifications() {
        return this.allowDistinguishedNameModifications;
    }

    @ConfigIgnore
    public Map<String, String> getAttributesMapping() {
        if (this.attributesMappings == null) {
            this.attributesMappings = new CaseInsensitiveHashMap();
            Properties properties = new ConfigurationsPreferencesImpl().readConfiguration(LDAP_CONFIGURATIONS_PATH, "Mappings");
            for (Object object : properties.keySet()) {
                this.attributesMappings.put(object.toString(), (Object)properties.getProperty(object.toString()));
            }
        }
        return this.attributesMappings;
    }

    @ConfigDefault(value="DC=ldap-server,DC=com")
    public String getBaseSearchDN() {
        return this.baseSearchDN;
    }

    @ConfigDefault(value="CN=Users,DC=ldap-server,DC=com")
    public String getBaseUserDN() {
        return this.baseUserDN;
    }

    @ConfigDefault(value="carLicense")
    public String getBulkParametersAttributeName() {
        return this.bulkParametersAttributeName;
    }

    @ConfigDefault(value="CN=Groups,DC=ldap-server,DC=com")
    public String getDefaultGroupDN() {
        return this.defaultGroupDN;
    }

    @ConfigDefault(value="CN=Users,DC=ldap-server,DC=com")
    public String getDefaultProfileDN() {
        return this.defaultProfileDN;
    }

    @ConfigDefault(value=",=")
    public String getExclusionCharaters() {
        return this.exclusionCharaters;
    }

    @ConfigDefault(value="false")
    public Boolean getForceSecureConnection() {
        return this.forceSecureConnection;
    }

    @ConfigIgnore
    public String getGroupMapping(String groupName) {
        if (revertGroupMappings == null) {
            revertGroupMappings = new HashMap<String, String>();
            for (Map.Entry<String, String> entrie : this.getGroupMappings().entrySet()) {
                revertGroupMappings.put(entrie.getValue(), entrie.getKey());
            }
        }
        return revertGroupMappings.get(groupName);
    }

    @ConfigIgnore
    public Map<String, String> getGroupMappings() {
        if (this.groupMappings == null) {
            this.groupMappings = new HashMap<String, String>();
            this.groupMappings = new ConfigurationsPreferencesImpl().readConfigurationAsMap(LDAP_CONFIGURATIONS_PATH, "GroupMappings");
        }
        return this.groupMappings;
    }

    @ConfigDefault(value="ldap-server.com")
    public String getHostName() {
        return this.hostName;
    }

    @ConfigDefault(value="cn")
    public String getLoginAttribute() {
        return this.loginAttribute;
    }

    @ConfigDefault(value="password")
    public String getPassword() {
        return this.password;
    }

    @ConfigDefault(value="389")
    public String getPort() {
        return this.port;
    }

    @ConfigDefault(value="500")
    public int getQuerysPageSizeLimit() {
        return this.querysPageSizeLimit;
    }

    @ConfigDefault(value="false")
    public boolean getReadOnly() {
        return this.readOnly;
    }

    @ConfigDefault(value="636")
    public String getSSLPort() {
        return this.sslPort;
    }

    @ConfigDefault(value="CN=Admin,CN=Users,DC=ldap-server,DC=com")
    public String getUserDN() {
        return this.userDN;
    }

    public void setAllowDistinguishedNameModifications(boolean allowDistinguishedNameModifications) {
        this.allowDistinguishedNameModifications = allowDistinguishedNameModifications;
    }

    @ConfigIgnore
    public void setAttributeMappings(Map<String, String> attributeMappings) {
        if (this.attributesMappings == null) {
            this.attributesMappings = new CaseInsensitiveHashMap();
        } else {
            this.attributesMappings.clear();
            this.attributesMappings.putAll(attributeMappings);
        }
    }

    public void setBaseSearchDN(String baseSearchDN) {
        this.baseSearchDN = baseSearchDN;
    }

    public void setBaseUserDN(String baseUserDN) {
        this.baseUserDN = baseUserDN;
    }

    public void setBulkParametersAttributeName(String newBulkParametersAttributeName) {
        this.bulkParametersAttributeName = newBulkParametersAttributeName;
    }

    public void setDefaultGroupDN(String newDefaultGroupDN) {
        this.defaultGroupDN = newDefaultGroupDN;
    }

    public void setDefaultProfileDN(String defaultProfileDN) {
        this.defaultProfileDN = defaultProfileDN;
    }

    public void setExclusionCharaters(String exclusionCharaters) {
        this.exclusionCharaters = exclusionCharaters;
    }

    public void setForceSecureConnection(Boolean forceSecureConnection) {
        this.forceSecureConnection = forceSecureConnection;
    }

    @ConfigIgnore
    public void setGroupMappings(Map<String, String> groupMappings) {
        this.groupMappings = groupMappings;
        Properties properties = new Properties();
        properties.putAll(this.groupMappings);
        new ConfigurationsPreferencesImpl().writeConfiguration(LDAP_CONFIGURATIONS_PATH, "GroupMappings", properties);
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setLoginAttribute(String loginAttribute) {
        this.loginAttribute = loginAttribute;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setQuerysPageSizeLimit(int querysPageSizeLimit) {
        this.querysPageSizeLimit = querysPageSizeLimit;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setSSLPort(String sslPort) {
        this.sslPort = sslPort;
    }

    public void setUserDN(String userDN) {
        this.userDN = userDN;
    }
}

