/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.ldap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;
import pt.digitalis.utils.ldap.LDAPEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPUser
extends LDAPEntity {
    public static final String DISPLAY_NAME = "displayName";
    public static final String GIVEN_NAME = "givenName";
    private String displayName;
    private String eMail;
    private String givenName;
    private String loginName;
    private final CaseInsensitiveHashMap<String> parameters = new CaseInsensitiveHashMap();
    private final List<String> parametersToRemove = new ArrayList<String>();
    private String password;
    private String userName;

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmail() {
        return this.eMail;
    }

    public boolean getEnabled() {
        return false;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public String getParameter(String attributeName) {
        return (String)this.parameters.get((Object)attributeName);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public List<String> getParametersToRemove() {
        return this.parametersToRemove;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void removeParameter(String attributeName) {
        this.parameters.remove((Object)attributeName);
        this.parametersToRemove.add(attributeName);
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setEmail(String eMail) {
        this.eMail = eMail;
    }

    public void setEnabled(boolean enabled) {
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public void setParameter(String attributeName, String value) {
        this.parameters.put(attributeName, (Object)value);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String toString() {
        String N_A = "  N/A";
        String NEW_LINE = "\n";
        String EQUALS = "=";
        String DISPLAY_NAME = "displayName=";
        String GIVEN_NAME = "givenName=";
        String LOGIN_NAME = "loginName=";
        String NAME = "name=";
        String USER_NAME = "userName=";
        String PARENT_GROUP_DN = "parentGroupDN=";
        StringBuffer ldapUser = new StringBuffer();
        if (this.displayName == null) {
            ldapUser.append("displayName=  N/A\n");
        } else {
            ldapUser.append("displayName=" + this.displayName + "\n");
        }
        if (this.givenName == null) {
            ldapUser.append("givenName=  N/A\n");
        } else {
            ldapUser.append("givenName=" + this.givenName + "\n");
        }
        if (this.loginName == null) {
            ldapUser.append("loginName=  N/A\n");
        } else {
            ldapUser.append("loginName=" + this.loginName + "\n");
        }
        if (this.getName() == null) {
            ldapUser.append("name=  N/A\n");
        } else {
            ldapUser.append("name=" + this.getName() + "\n");
        }
        if (this.userName == null) {
            ldapUser.append("userName=  N/A\n");
        } else {
            ldapUser.append("userName=" + this.userName + "\n");
        }
        if (this.getParentGroupDN() == null) {
            ldapUser.append("parentGroupDN=  N/A\n");
        } else {
            ldapUser.append("parentGroupDN=" + this.getParentGroupDN() + "\n");
        }
        if (this.parameters.size() > 0) {
            for (String attributeName : this.parameters.keySet()) {
                ldapUser.append(attributeName + "=" + (String)this.parameters.get((Object)attributeName) + "\n");
            }
        }
        return super.toString() + ldapUser.toString();
    }
}

