/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.ldap.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import pt.digitalis.log.ILogWrapper;
import pt.digitalis.log.LogLevel;
import pt.digitalis.log.Logger;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;
import pt.digitalis.utils.config.ConfigurationsPreferencesImpl;
import pt.digitalis.utils.ldap.ILDAPUtils;
import pt.digitalis.utils.ldap.LDAPConfigurations;
import pt.digitalis.utils.ldap.LDAPGroup;
import pt.digitalis.utils.ldap.LDAPUser;
import pt.digitalis.utils.ldap.exception.LDAPOperationException;
import pt.digitalis.utils.ldap.exception.LDAPOperationReadOnlyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLDAPUtils
implements ILDAPUtils {
    protected static final String CN_TAG = "cn=";
    private static List<String> groupMappingsFound = new ArrayList<String>();
    private static ILogWrapper logger = null;
    protected static final String NON_AVAILABLE = "N/A";
    protected LDAPConfigurations ldapConfigurations = null;

    protected static final String getCNFromDN(String distinguishedName) {
        return distinguishedName.split(",")[0].split("=")[1];
    }

    protected static ILogWrapper getLogger() {
        if (logger == null) {
            logger = Logger.getLogger((String)"LDAP Utils ", (LogLevel)LogLevel.INFO);
        }
        return logger;
    }

    public static byte[] parseControls(Control[] controls) throws NamingException {
        byte[] cookie = null;
        if (controls != null) {
            for (int i = 0; i < controls.length; ++i) {
                if (!(controls[i] instanceof PagedResultsResponseControl)) continue;
                PagedResultsResponseControl prrc = (PagedResultsResponseControl)controls[i];
                cookie = prrc.getCookie();
            }
        }
        return cookie == null ? new byte[]{} : cookie;
    }

    private final void addAttribute(String distinguishedName, String attributeName, String value) throws LDAPOperationException {
        if (this.isReadOnly()) {
            throw new LDAPOperationReadOnlyException();
        }
        String attributeRealName = this.getConfigurations().getAttributesMapping().get(attributeName);
        if (attributeRealName == null) {
            attributeRealName = attributeName;
        }
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, new BasicAttribute(attributeRealName, value.toString()))};
        this.modifyAttributes(distinguishedName, mods, false);
    }

    @Override
    public void addGroup(LDAPGroup newGroup) throws LDAPOperationException {
        if (this.isReadOnly()) {
            throw new LDAPOperationReadOnlyException();
        }
        String groupDN = null;
        String newEntityDN = null;
        String groupMapping = this.getConfigurations().getGroupMappings().get(newGroup.getCommonName());
        if (groupMapping != null) {
            newGroup.setCommonName(groupMapping);
        }
        if (newGroup.getParentGroupDN() != null) {
            groupDN = newGroup.getParentGroupDN();
            newEntityDN = this.calculateDistinguishedName(newGroup.getCommonName(), groupDN);
        } else if (this.getConfigurations().getDefaultGroupDN() != null) {
            groupDN = this.getConfigurations().getDefaultGroupDN();
            newEntityDN = this.calculateDistinguishedName(newGroup.getCommonName(), groupDN);
        } else {
            newEntityDN = CN_TAG + newGroup.getCommonName() + "," + this.getConfigurations().getBaseSearchDN();
        }
        newGroup.setDistinguishedName(newEntityDN);
        this.createSubcontext(newGroup.getDistinguishedName(), this.getAttributesForGroupAddition(newGroup));
    }

    @Override
    public void addGroupAttribute(String commonName, String attributeName, Object value) throws LDAPOperationException {
        if (this.isReadOnly()) {
            throw new LDAPOperationReadOnlyException();
        }
        this.addAttribute(this.findGroupByCommonName(commonName).getDistinguishedName(), attributeName, value.toString());
    }

    @Override
    public void addUser(LDAPUser newUser) throws LDAPOperationException {
        String userParentGroupDN;
        if (this.isReadOnly()) {
            throw new LDAPOperationReadOnlyException();
        }
        String exclusionCharaters = this.getConfigurations().getExclusionCharaters();
        if (exclusionCharaters != null && !"".equals(exclusionCharaters)) {
            for (int i = 0; i < exclusionCharaters.length(); ++i) {
                if (newUser.getLoginName() == null || newUser.getLoginName().indexOf(exclusionCharaters.charAt(i)) <= -1) continue;
                throw new LDAPOperationException("Your login name cannot contain the characters " + exclusionCharaters);
            }
        }
        if ((userParentGroupDN = newUser.getParentGroupDN()) == null) {
            if (this.getConfigurations().getDefaultProfileDN() != null) {
                userParentGroupDN = this.getConfigurations().getDefaultProfileDN();
            } else if (this.getConfigurations().getBaseSearchDN() != null) {
                userParentGroupDN = this.getConfigurations().getBaseSearchDN();
            }
            newUser.setParentGroupDN(userParentGroupDN);
        }
        newUser.setDistinguishedName(this.calculateDistinguishedName(newUser.getLoginName(), userParentGroupDN));
        this.createSubcontext(newUser.getDistinguishedName(), this.getAttributesForUserAddition(newUser));
        this.changePassword(newUser.getLoginName(), newUser.getPassword());
    }

    @Override
    public void addUserAttribute(String loginName, String attributeName, Object value) throws LDAPOperationException {
        if (this.isReadOnly()) {
            throw new LDAPOperationReadOnlyException();
        }
        this.addAttribute(this.findUserByLogin(loginName).getDistinguishedName(), attributeName, value.toString());
    }

    @Override
    public void addUserToGroup(String groupCN, String userLogin) throws LDAPOperationException {
        if (this.isReadOnly()) {
            throw new LDAPOperationReadOnlyException();
        }
        this.setGroupAttribute(groupCN, "member", this.findUserByLogin(userLogin).getDistinguishedName());
    }

    private String buildAttributesString(Map<String, String> attributes, boolean allFields) throws LDAPOperationException {
        StringBuffer query = new StringBuffer();
        for (String attributeKey : attributes.keySet()) {
            boolean isBulkParam = false;
            String attributeValue = "";
            String attributeBulkKey = "";
            if (this.getUserParentGroupAttributeName().equals(attributeKey)) {
                attributeValue = this.findGroupByCommonName(attributes.get(attributeKey)).getDistinguishedName();
            } else if (this.getNameAttributeName().equals(attributeKey) || this.getUserLoginAttributeName().equals(attributeKey) || this.getMailAttributeName().equals(attributeKey) || this.getDisplayNameAttributeName().equals(attributeKey)) {
                attributeValue = attributes.get(attributeKey);
            } else if (this.ldapConfigurations.getAttributesMapping().get(attributeKey.toUpperCase()) != null) {
                attributeValue = attributes.get(attributeKey);
                attributeKey = this.ldapConfigurations.getAttributesMapping().get(attributeKey.toUpperCase());
            } else if (this.ldapConfigurations.getBulkParametersAttributeName() != null) {
                isBulkParam = true;
                attributeValue = attributes.get(attributeKey);
                attributeBulkKey = attributeKey;
                attributeKey = this.ldapConfigurations.getBulkParametersAttributeName();
            } else {
                attributeValue = attributes.get(attributeKey);
            }
            if (attributeKey.equalsIgnoreCase(this.getNameAttributeName())) {
                query.append("(|");
                if (StringUtils.isNotBlank((String)this.getGivenNameAttributeName())) {
                    query.append("(" + this.getGivenNameAttributeName() + "=" + (isBulkParam ? "*" + attributeBulkKey + "=" : "") + attributeValue + (isBulkParam ? ";*" : "") + ")");
                }
                if (StringUtils.isNotBlank((String)this.getDisplayNameAttributeName())) {
                    query.append("(" + this.getDisplayNameAttributeName() + "=" + (isBulkParam ? "*" + attributeBulkKey + "=" : "") + attributeValue + (isBulkParam ? ";*" : "") + ")");
                }
                if (StringUtils.isNotBlank((String)this.getNameAttributeName())) {
                    query.append("(" + this.getNameAttributeName() + "=" + (isBulkParam ? "*" + attributeBulkKey + "=" : "") + attributeValue + (isBulkParam ? ";*" : "") + ")");
                }
                query.append(")");
                continue;
            }
            query.append("(" + attributeKey + "=" + (isBulkParam ? "*" + attributeBulkKey + "=" : "") + attributeValue + (isBulkParam ? ";*" : "") + ")");
        }
        return "(" + (allFields ? "&" : "|") + query.toString() + ")";
    }

    protected abstract String calculateDistinguishedName(String var1, String var2) throws LDAPOperationException;

    @Override
    public abstract void changePassword(String var1, String var2) throws LDAPOperationException;

    protected LDAPGroup convertFromAttributesToLDAPGroup(Attributes attributes, String distinguishedName) {
        LDAPGroup ldapGroup = new LDAPGroup();
        ldapGroup.setDistinguishedName(distinguishedName);
        try {
            if (attributes.get("cn") != null) {
                String groupMappingValue = this.ldapConfigurations.getGroupMapping(attributes.get("cn").get().toString());
                if (groupMappingValue != null && !"".equals(groupMappingValue)) {
                    ldapGroup.setCommonName(groupMappingValue);
                } else {
                    ldapGroup.setCommonName(attributes.get("cn").get().toString());
                }
            } else {
                ldapGroup.setCommonName(NON_AVAILABLE);
            }
            if (attributes.get(this.getNameAttributeName()) != null) {
                ldapGroup.setName(attributes.get(this.getNameAttributeName()).get().toString());
            } else {
                ldapGroup.setName(NON_AVAILABLE);
            }
            if (attributes.get("description") != null) {
                ldapGroup.setDescription(attributes.get("description").get().toString());
            } else {
                ldapGroup.setDescription(NON_AVAILABLE);
            }
            if (attributes.get(this.getGroupParentGroupAttributeName()) != null) {
                ldapGroup.setParentGroupDN(attributes.get(this.getGroupParentGroupAttributeName()).get().toString());
            } else {
                ldapGroup.setParentGroupDN(NON_AVAILABLE);
            }
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
        }
        return ldapGroup;
    }

    protected LDAPUser convertFromAttributesToLDAPUser(Attributes attributes, String distinguishedName) {
        return this.convertFromAttributesToLDAPUser(attributes, distinguishedName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LDAPUser convertFromAttributesToLDAPUser(Attributes attributes, String distinguishedName, boolean convertAttributes) {
        LDAPUser ldapUser;
        block27: {
            ldapUser = new LDAPUser();
            ldapUser.setDistinguishedName(distinguishedName);
            try {
                if (attributes.get("cn") != null) {
                    ldapUser.setCommonName(attributes.get("cn").get().toString());
                } else {
                    ldapUser.setCommonName(NON_AVAILABLE);
                }
                if (attributes.get("name") != null) {
                    ldapUser.setName(attributes.get("name").get().toString());
                } else {
                    ldapUser.setName(NON_AVAILABLE);
                }
                if (attributes.get("displayName") != null) {
                    ldapUser.setDisplayName(attributes.get("displayName").get().toString());
                } else {
                    ldapUser.setDisplayName(NON_AVAILABLE);
                }
                if (attributes.get("givenName") != null) {
                    ldapUser.setGivenName(attributes.get("givenName").get().toString());
                } else {
                    ldapUser.setGivenName(NON_AVAILABLE);
                }
                if (attributes.get(this.getUserLoginAttributeName()) != null) {
                    ldapUser.setLoginName(attributes.get(this.getUserLoginAttributeName()).get().toString());
                } else {
                    ldapUser.setLoginName(NON_AVAILABLE);
                }
                if (attributes.get(this.getMailAttributeName()) != null) {
                    ldapUser.setEmail(attributes.get(this.getMailAttributeName()).get().toString());
                } else {
                    ldapUser.setEmail(NON_AVAILABLE);
                }
                if (attributes.get(this.getUserParentGroupAttributeName()) != null) {
                    ldapUser.setParentGroupDN(attributes.get(this.getUserParentGroupAttributeName()).get().toString());
                } else {
                    ldapUser.setParentGroupDN(NON_AVAILABLE);
                }
                if (convertAttributes) {
                    Map<String, String> bulkParametres = this.getBulkParametersValues(attributes);
                    for (Map.Entry<String, String> entry : bulkParametres.entrySet()) {
                        ldapUser.setParameter(entry.getKey(), entry.getValue());
                    }
                    NamingEnumeration<String> attributeNames = attributes.getIDs();
                    try {
                        while (attributeNames.hasMore()) {
                            String attributeName = attributeNames.next();
                            if ("cn".equals(attributeName) || "name".equals(attributeName) || "displayName".equals(attributeName) || "givenName".equals(attributeName) || this.getUserLoginAttributeName().equals(attributeName) || this.getMailAttributeName().equals(attributeName) || this.getPasswordAttributeName().equals(attributeName) || this.getUserParentGroupAttributeName().equals(attributeName) || this.getConfigurations().getBulkParametersAttributeName().equals(attributeName)) continue;
                            if (this.getConfigurations().getAttributesMapping().containsValue(attributeName)) {
                                ldapUser.setParameter(this.getKey(attributeName), attributes.get(attributeName).get().toString());
                                continue;
                            }
                            ldapUser.setParameter(attributeName, attributes.get(attributeName).get().toString());
                        }
                        break block27;
                    }
                    finally {
                        attributeNames.close();
                    }
                }
                NamingEnumeration<String> attributeNames = attributes.getIDs();
                try {
                    while (attributeNames.hasMore()) {
                        String attributeName = attributeNames.next();
                        ldapUser.setParameter(attributeName, attributes.get(attributeName).get().toString());
                    }
                }
                finally {
                    attributeNames.close();
                }
            }
            catch (NamingException namingException) {
                namingException.printStackTrace();
            }
        }
        return ldapUser;
    }

    protected LDAPGroup convertFromSearchResultToLDAPGroup(SearchResult searchResult) {
        LDAPGroup ldapGroup = null;
        if (searchResult != null) {
            ldapGroup = this.convertFromAttributesToLDAPGroup(searchResult.getAttributes(), searchResult.getNameInNamespace());
        }
        return ldapGroup;
    }

    protected LDAPUser convertFromSearchResultToLDAPUser(SearchResult searchResult) {
        LDAPUser ldapUser = null;
        if (searchResult != null) {
            ldapUser = this.convertFromAttributesToLDAPUser(searchResult.getAttributes(), searchResult.getNameInNamespace(), true);
        }
        return ldapUser;
    }

    protected LDAPUser convertFromSearchResultToLDAPUser(SearchResult searchResult, boolean convertAttributes) {
        LDAPUser ldapUser = null;
        if (searchResult != null) {
            ldapUser = this.convertFromAttributesToLDAPUser(searchResult.getAttributes(), searchResult.getNameInNamespace(), convertAttributes);
        }
        return ldapUser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected final Map<String, Object> convertFromSearchResultToMap(SearchResult searchResult) throws LDAPOperationException {
        CaseInsensitiveHashMap attributeMap = new CaseInsensitiveHashMap();
        if (searchResult == null) return attributeMap;
        Attributes attributes = searchResult.getAttributes();
        NamingEnumeration<? extends Attribute> attrs = attributes.getAll();
        try {
            block9: while (attrs.hasMore()) {
                Attribute attribute = attrs.next();
                if (attribute.getID().equalsIgnoreCase(this.getConfigurations().getBulkParametersAttributeName())) {
                    Map<String, String> bulkParametres = this.getBulkParametersValues(attributes);
                    Iterator<Map.Entry<String, String>> i$ = bulkParametres.entrySet().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block9;
                        Map.Entry<String, String> entry = i$.next();
                        attributeMap.put(entry.getKey(), entry.getValue());
                    }
                }
                String commonName = null;
                if (attribute.getID().equals(this.getCommonName()) && this.getConfigurations().getGroupMapping(attribute.get().toString()) != null) {
                    commonName = this.getConfigurations().getGroupMapping(attribute.get().toString());
                }
                if (this.getConfigurations().getAttributesMapping().containsValue(attribute.getID())) {
                    attributeMap.put(this.getKey(attribute.getID()), commonName != null ? commonName : attribute.get());
                    continue;
                }
                attributeMap.put(attribute.getID(), commonName != null ? commonName : attribute.get());
            }
            return attributeMap;
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not fetch attribute!", namingException);
        }
        finally {
            try {
                attrs.close();
            }
            catch (NamingException e) {
                throw new LDAPOperationException("Error closing NamingEnumeration!", e);
            }
        }
    }

    @Override
    public int countAllGroups() throws NamingException, LDAPOperationException {
        return this.countAllGroups(false);
    }

    @Override
    public int countAllGroups(boolean commonNameDistinct) throws NamingException, LDAPOperationException {
        String search = "(" + this.getObjectClassName() + "=" + this.getGroupClassName() + ")";
        LdapContext context = this.getLDAPContext();
        try {
            List<SearchResult> returnedGroups = this.doLDAPCount(context, this.getConfigurations().getBaseSearchDN(), search);
            if (commonNameDistinct) {
                HashSet<String> groupsCommonName = new HashSet<String>();
                for (SearchResult searchResult : returnedGroups) {
                    LDAPGroup group = this.convertFromSearchResultToLDAPGroup(searchResult);
                    if (searchResult != null && searchResult.getObject() instanceof Context) {
                        ((Context)searchResult.getObject()).close();
                    }
                    groupsCommonName.add(group.getCommonName());
                }
                int n = groupsCommonName.size();
                return n;
            }
            int n = returnedGroups.size();
            return n;
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not count all groups!", namingException);
        }
        catch (IOException e) {
            throw new LDAPOperationException("Could not count all groups!", e);
        }
        finally {
            context.close();
        }
    }

    @Override
    public int countAllGroupsOfUser(String loginName) throws NamingException, LDAPOperationException {
        HashSet<String> result = new HashSet<String>();
        LDAPUser user = this.findUserByLogin(loginName);
        String search = "(&(" + this.getObjectClassName() + "=" + this.getGroupClassName() + ")(" + this.getGroupAttributeName() + "=" + user.getDistinguishedName() + "))";
        LdapContext context = this.getLDAPContext();
        try {
            List<SearchResult> returnedGroups = null;
            returnedGroups = this.doLDAPCount(context, this.getConfigurations().getBaseSearchDN(), search);
            for (SearchResult searchResult : returnedGroups) {
                result.add(searchResult.getNameInNamespace().toLowerCase());
                if (!(searchResult.getObject() instanceof Context)) continue;
                ((Context)searchResult.getObject()).close();
            }
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not get groups of user " + loginName + "!", namingException);
        }
        catch (IOException e) {
            throw new LDAPOperationException("Could not get groups of user " + loginName + "!", e);
        }
        finally {
            context.close();
        }
        return result.size();
    }

    @Override
    public int countAllUsers() throws NamingException, LDAPOperationException {
        String search = "(" + this.getObjectClassName() + "=" + this.getUserClassName() + ")";
        LdapContext context = this.getLDAPContext();
        try {
            List<SearchResult> returnedUsers = this.doLDAPCount(context, this.getConfigurations().getBaseSearchDN(), search);
            int n = returnedUsers.size();
            return n;
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not count all users!", namingException);
        }
        catch (IOException e) {
            throw new LDAPOperationException("Could not count all users!", e);
        }
        finally {
            context.close();
        }
    }

    @Override
    public int countAllUsers(String groupId) throws LDAPOperationException {
        return this.getGroupMembers(groupId).size();
    }

    @Override
    public int countUsers(Map<String, String> attributes) throws LDAPOperationException {
        StringBuffer query = new StringBuffer("(&(" + this.getObjectClassName() + "=" + this.getUserClassName() + ")");
        query.append(this.buildAttributesString(attributes, true));
        query.append(")");
        LdapContext context = this.getLDAPContext();
        try {
            List<SearchResult> returnedUsers = this.doLDAPCount(context, this.getConfigurations().getBaseSearchDN(), query.toString());
            int n = returnedUsers.size();
            return n;
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not count all groups!", namingException);
        }
        catch (IOException e) {
            throw new LDAPOperationException("Could not count all groups!", e);
        }
        finally {
            try {
                context.close();
            }
            catch (NamingException e) {
                throw new LDAPOperationException("Error closing context!", e);
            }
        }
    }

    private final void createSubcontext(String distinguishedName, Attributes attributes) throws LDAPOperationException {
        LdapContext ctx = this.getLDAPContext();
        try {
            ctx.createSubcontext(distinguishedName, attributes).close();
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not create LDAP subcontext!!", namingException);
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException e) {
                throw new LDAPOperationException("Error closing context!", e);
            }
        }
    }

    private final void destroySubcontext(String distinguishedName) throws LDAPOperationException {
        LdapContext ctx = this.getLDAPContext();
        try {
            ctx.destroySubcontext(distinguishedName);
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not remove LDAP subcontext!!", namingException);
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException e) {
                throw new LDAPOperationException("Error closing context!", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchResult> doLDAPCount(LdapContext context, String baseNode, String searchCriteria) throws NamingException, LDAPOperationException, IOException {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        try {
            SearchControls searchConfigurations = new SearchControls();
            searchConfigurations.setReturningObjFlag(false);
            searchConfigurations.setSearchScope(2);
            AbstractLDAPUtils.getLogger().debug((Object)("ldapSearch - baseNode: " + baseNode));
            AbstractLDAPUtils.getLogger().debug((Object)("ldapSearch - searchCriteria: " + searchCriteria));
            byte[] cookie = null;
            context.setRequestControls(new Control[]{new PagedResultsControl(this.getConfigurations().getQuerysPageSizeLimit(), true)});
            do {
                NamingEnumeration<SearchResult> resultsEnumeration = context.search(baseNode, searchCriteria, searchConfigurations);
                results.addAll(Collections.list(resultsEnumeration));
                cookie = AbstractLDAPUtils.parseControls(context.getResponseControls());
                context.setRequestControls(new Control[]{new PagedResultsControl(this.getConfigurations().getQuerysPageSizeLimit(), cookie, true)});
            } while (cookie != null && cookie.length != 0);
        }
        finally {
            context.close();
        }
        return results;
    }

    private SearchResult doLDAPSearchFirstReturn(String search) throws LDAPOperationException {
        SearchResult result = null;
        LdapContext context = this.getLDAPContext();
        try {
            List<SearchResult> ldapResult = this.doLDAPSearchMultipleReturns(context, this.getConfigurations().getBaseSearchDN(), search);
            if (ldapResult.size() > 0) {
                result = ldapResult.get(0);
            }
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException(namingException);
        }
        catch (IOException ioException) {
            throw new LDAPOperationException(ioException);
        }
        finally {
            try {
                context.close();
            }
            catch (NamingException e) {
                throw new LDAPOperationException("Error closing context!", e);
            }
        }
        return result;
    }

    public List<SearchResult> doLDAPSearchMultipleReturns(LdapContext context, String baseNode, String searchCriteria) throws NamingException, LDAPOperationException, IOException {
        return this.doLDAPSearchMultipleReturnsPaging(context, baseNode, searchCriteria, this.getConfigurations().getQuerysPageSizeLimit(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchResult> doLDAPSearchMultipleReturnsPaging(LdapContext context, String baseNode, String searchCriteria, int rowsPerPage, Integer pageToReturn) throws NamingException, LDAPOperationException, IOException {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        try {
            SearchControls searchConfigurations = new SearchControls();
            searchConfigurations.setReturningObjFlag(true);
            searchConfigurations.setSearchScope(2);
            AbstractLDAPUtils.getLogger().debug((Object)("ldapSearch - baseNode: " + baseNode));
            AbstractLDAPUtils.getLogger().debug((Object)("ldapSearch - searchCriteria: " + searchCriteria));
            byte[] cookie = null;
            int pageCount = 0;
            context.setRequestControls(new Control[]{new PagedResultsControl(rowsPerPage, true)});
            do {
                NamingEnumeration<SearchResult> resultsEnumeration = context.search(baseNode, searchCriteria, searchConfigurations);
                if (pageToReturn == null || pageToReturn == ++pageCount) {
                    results.addAll(Collections.list(resultsEnumeration));
                } else {
                    Collections.list(resultsEnumeration);
                }
                cookie = AbstractLDAPUtils.parseControls(context.getResponseControls());
                context.setRequestControls(new Control[]{new PagedResultsControl(rowsPerPage, cookie, true)});
            } while (cookie != null && cookie.length != 0 && (pageToReturn == null || pageCount < pageToReturn));
        }
        finally {
            context.close();
        }
        return results;
    }

    private SearchResult doLDAPSearchSingleReturn(String search) throws LDAPOperationException {
        SearchResult result = null;
        LdapContext context = this.getLDAPContext();
        try {
            boolean entityLoaded = false;
            List<SearchResult> ldapResult = this.doLDAPSearchMultipleReturns(context, this.getConfigurations().getBaseSearchDN(), search);
            for (SearchResult searchResult : ldapResult) {
                if (entityLoaded) {
                    throw new LDAPOperationException("More than one entity exists with the same searched criteria!");
                }
                entityLoaded = true;
                result = searchResult;
            }
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException(namingException);
        }
        catch (IOException e) {
            throw new LDAPOperationException(e);
        }
        finally {
            try {
                context.close();
            }
            catch (NamingException e) {
                throw new LDAPOperationException("Error closing context!", e);
            }
        }
        return result;
    }

    @Override
    public Set<LDAPGroup> findAllGroups() throws LDAPOperationException {
        HashSet<LDAPGroup> groups = new HashSet<LDAPGroup>();
        String search = "(" + this.getObjectClassName() + "=" + this.getGroupClassName() + ")";
        LdapContext context = this.getLDAPContext();
        try {
            List<SearchResult> returnedGroups = this.doLDAPSearchMultipleReturns(context, this.getConfigurations().getBaseSearchDN(), search);
            for (SearchResult searchResult : returnedGroups) {
                LDAPGroup group = this.convertFromSearchResultToLDAPGroup(searchResult);
                if (searchResult != null && searchResult.getObject() instanceof Context) {
                    ((Context)searchResult.getObject()).close();
                }
                groups.add(group);
            }
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not get all groups!", namingException);
        }
        catch (IOException e) {
            throw new LDAPOperationException("Could not get all groups!", e);
        }
        finally {
            try {
                context.close();
            }
            catch (NamingException e) {
                throw new LDAPOperationException("Error closing context!", e);
            }
        }
        return groups;
    }

    @Override
    public Set<LDAPUser> findAllUsers() throws LDAPOperationException {
        HashSet<LDAPUser> users = new HashSet<LDAPUser>();
        String search = "(" + this.getObjectClassName() + "=" + this.getUserClassName() + ")";
        LdapContext context = this.getLDAPContext();
        try {
            List<SearchResult> returnedUsers = this.doLDAPSearchMultipleReturns(context, this.getConfigurations().getBaseSearchDN(), search);
            for (SearchResult searchResult : returnedUsers) {
                LDAPUser user = this.convertFromSearchResultToLDAPUser(searchResult);
                if (searchResult != null && searchResult.getObject() instanceof Context) {
                    ((Context)searchResult.getObject()).close();
                }
                users.add(user);
            }
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not get all users!", namingException);
        }
        catch (IOException e) {
            throw new LDAPOperationException("Could not get all users!", e);
        }
        finally {
            try {
                context.close();
            }
            catch (NamingException e) {
                throw new LDAPOperationException("Error closing context!", e);
            }
        }
        return users;
    }

    @Override
    public LDAPGroup findGroupByCommonName(String cn) throws LDAPOperationException {
        SearchResult searchResult = this.getGroupByCommonName(cn);
        LDAPGroup converted = this.convertFromSearchResultToLDAPGroup(searchResult);
        if (searchResult != null && searchResult.getObject() instanceof Context) {
            try {
                ((Context)searchResult.getObject()).close();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        return converted;
    }

    @Override
    public LDAPGroup findGroupByDistinguishedName(String dn) throws LDAPOperationException {
        return this.getGroupByDistinguishedName(dn);
    }

    @Override
    public Set<LDAPGroup> findGroups(int rowsPerPage, int pageToReturn) throws LDAPOperationException {
        HashSet<LDAPGroup> groups = new HashSet<LDAPGroup>();
        String search = "(" + this.getObjectClassName() + "=" + this.getGroupClassName() + ")";
        LdapContext context = this.getLDAPContext();
        try {
            List<SearchResult> returnedGroups = this.doLDAPSearchMultipleReturnsPaging(context, this.getConfigurations().getBaseSearchDN(), search, rowsPerPage, pageToReturn);
            for (SearchResult searchResult : returnedGroups) {
                LDAPGroup group = this.convertFromSearchResultToLDAPGroup(searchResult);
                if (searchResult != null && searchResult.getObject() instanceof Context) {
                    ((Context)searchResult.getObject()).close();
                }
                groups.add(group);
            }
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not get all groups!", namingException);
        }
        catch (IOException e) {
            throw new LDAPOperationException("Could not get all groups!", e);
        }
        finally {
            try {
                context.close();
            }
            catch (NamingException e) {
                throw new LDAPOperationException("Error closing context!", e);
            }
        }
        return groups;
    }

    @Override
    public Set<LDAPGroup> findGroupsOfUser(String loginName) throws LDAPOperationException {
        return this.findGroupsOfUserPagination(loginName, null, null);
    }

    @Override
    public Set<LDAPGroup> findGroupsOfUserPagination(String loginName, Integer rowsPerPage, Integer pageToReturn) throws LDAPOperationException {
        HashMap<String, LDAPGroup> groups = new HashMap<String, LDAPGroup>();
        LDAPGroup group = null;
        LDAPUser user = this.findUserByLogin(loginName);
        boolean hasPagination = pageToReturn != null && rowsPerPage != null;
        String search = "(&(" + this.getObjectClassName() + "=" + this.getGroupClassName() + ")(" + this.getGroupAttributeName() + "=" + user.getDistinguishedName() + "))";
        LdapContext context = this.getLDAPContext();
        try {
            List<SearchResult> returnedGroups = null;
            returnedGroups = hasPagination ? this.doLDAPSearchMultipleReturnsPaging(context, this.getConfigurations().getBaseSearchDN(), search, rowsPerPage, pageToReturn) : this.doLDAPSearchMultipleReturns(context, this.getConfigurations().getBaseSearchDN(), search);
            for (SearchResult searchResult : returnedGroups) {
                group = this.convertFromSearchResultToLDAPGroup(searchResult);
                if (searchResult != null && searchResult.getObject() instanceof Context) {
                    ((Context)searchResult.getObject()).close();
                }
                groups.put(group.getCommonName(), group);
            }
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not get groups of user " + loginName + "!", namingException);
        }
        catch (IOException e) {
            throw new LDAPOperationException("Could not get groups of user " + loginName + "!", e);
        }
        finally {
            try {
                context.close();
            }
            catch (NamingException e) {
                throw new LDAPOperationException("Error closing context!", e);
            }
        }
        return new HashSet<LDAPGroup>(groups.values());
    }

    @Override
    public LDAPUser findUserByDistinguishedName(String dn) throws LDAPOperationException {
        return this.getUserByDistinguishedName(dn);
    }

    @Override
    public LDAPUser findUserByLogin(String loginName) throws LDAPOperationException {
        return this.findUserByLogin(loginName, true);
    }

    public LDAPUser findUserByLogin(String loginName, boolean convertAttributes) throws LDAPOperationException {
        SearchResult result = this.getByLogin(loginName);
        LDAPUser converted = this.convertFromSearchResultToLDAPUser(result, convertAttributes);
        if (result != null && result.getObject() instanceof Context) {
            try {
                ((Context)result.getObject()).close();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        return converted;
    }

    @Override
    public Set<LDAPUser> findUsers(int rowsPerPage, int pageToReturn) throws LDAPOperationException {
        HashSet<LDAPUser> users = new HashSet<LDAPUser>();
        String search = "(" + this.getObjectClassName() + "=" + this.getUserClassName() + ")";
        LdapContext context = this.getLDAPContext();
        try {
            List<SearchResult> returnedUsers = this.doLDAPSearchMultipleReturnsPaging(context, this.getConfigurations().getBaseSearchDN(), search, rowsPerPage, pageToReturn);
            for (SearchResult searchResult : returnedUsers) {
                LDAPUser user = this.convertFromSearchResultToLDAPUser(searchResult);
                if (searchResult != null && searchResult.getObject() instanceof Context) {
                    ((Context)searchResult.getObject()).close();
                }
                users.add(user);
            }
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not get all users!", namingException);
        }
        catch (IOException e) {
            throw new LDAPOperationException("Could not get all users!", e);
        }
        finally {
            try {
                context.close();
            }
            catch (NamingException e) {
                throw new LDAPOperationException("Error closing context!", e);
            }
        }
        return users;
    }

    @Override
    public Set<LDAPUser> findUsersByAnyAttribute(Map<String, String> attributes) throws LDAPOperationException {
        return this.internalFindUsersByAttributes(attributes, false, null, null);
    }

    @Override
    public Set<LDAPUser> findUsersByAttribute(String attribute, String value) throws LDAPOperationException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(attribute, value);
        return this.findUsersByAttributes(attributes);
    }

    @Override
    public Set<LDAPUser> findUsersByAttributes(Map<String, String> attributes) throws LDAPOperationException {
        return this.internalFindUsersByAttributes(attributes, true, null, null);
    }

    @Override
    public Set<LDAPUser> findUsersByAttributes(Map<String, String> attributes, Integer rowsPerPage, Integer pageToReturn) throws LDAPOperationException {
        return this.internalFindUsersByAttributes(attributes, true, rowsPerPage, pageToReturn);
    }

    @Override
    public Set<LDAPUser> findUsersByEmail(String value) throws LDAPOperationException {
        return this.findUsersByAttribute(this.getMailAttributeName(), value);
    }

    @Override
    public Map<String, LDAPUser> findUsersInGroup(String groupCN) throws LDAPOperationException {
        HashMap<String, LDAPUser> usersFromGroup = new HashMap<String, LDAPUser>();
        Vector<String> members = this.getGroupMembers(groupCN);
        if (members.size() > 0) {
            LDAPUser groupUser = null;
            for (String memberDN : members) {
                try {
                    groupUser = this.findUserByDistinguishedName(memberDN);
                    if (usersFromGroup.containsKey(groupUser.getCommonName())) continue;
                    usersFromGroup.put(groupUser.getCommonName(), groupUser);
                }
                catch (LDAPOperationException ldapOperationException) {
                    if (ldapOperationException.getCause().getClass().equals(NameNotFoundException.class)) continue;
                    throw new LDAPOperationException("Could not find users in group " + groupCN + "!", ldapOperationException);
                }
            }
        }
        return usersFromGroup;
    }

    protected Attributes getAttributesForGroupAddition(LDAPGroup newGroup) throws LDAPOperationException {
        BasicAttributes attrs = new BasicAttributes(true);
        attrs.put(this.getObjectClassName(), this.getGroupClassName());
        if (newGroup.getName() != null) {
            attrs.put(this.getNameAttributeName(), newGroup.getName());
        }
        if (newGroup.getDescription() != null) {
            attrs.put(this.getDescriptionAttributeName(), newGroup.getDescription());
        }
        if (newGroup.getParentGroupDN() != null) {
            attrs.put(this.getGroupParentGroupAttributeName(), newGroup.getParentGroupDN());
        }
        return attrs;
    }

    protected Attributes getAttributesForUserAddition(LDAPUser newUser) throws LDAPOperationException {
        String N_A = NON_AVAILABLE;
        BasicAttributes attrs = new BasicAttributes(true);
        attrs.put(this.getObjectClassName(), this.getUserClassName());
        attrs.put(this.getUserLoginAttributeName(), newUser.getLoginName());
        attrs.put(this.getNameAttributeName(), newUser.getUserName());
        attrs.put(this.getMailAttributeName(), newUser.getEmail() == null ? " " : newUser.getEmail());
        attrs.put(this.getDisplayNameAttributeName(), newUser.getDisplayName());
        attrs.put(this.getGivenNameAttributeName(), newUser.getGivenName());
        if (NON_AVAILABLE.equals(newUser.getParentGroupDN()) || newUser.getParentGroupDN() == null) {
            attrs.put(this.getUserParentGroupAttributeName(), NON_AVAILABLE);
        } else {
            attrs.put(this.getUserParentGroupAttributeName(), this.findGroupByDistinguishedName(newUser.getParentGroupDN()).getDistinguishedName());
        }
        if (newUser.getParameters().size() > 0) {
            StringBuilder attributeValue = new StringBuilder();
            for (String attributeName : newUser.getParameters().keySet()) {
                if (this.getConfigurations().getAttributesMapping().containsKey(attributeName)) {
                    attrs.put(this.getConfigurations().getAttributesMapping().get(attributeName), newUser.getParameter(attributeName));
                    continue;
                }
                attributeValue.append(attributeName + "=" + newUser.getParameter(attributeName) + ";");
            }
            if (attributeValue.length() > 0) {
                attrs.put(this.getConfigurations().getBulkParametersAttributeName(), attributeValue.toString());
            }
        }
        return attrs;
    }

    private Map<String, String> getBulkParametersValues(Attributes attributes) throws NamingException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.getConfigurations().getBulkParametersAttributeName() != null && attributes.get(this.getConfigurations().getBulkParametersAttributeName()) != null) {
            String[] bulkParameters = attributes.get(this.getConfigurations().getBulkParametersAttributeName()).get().toString().split(";");
            String[] bulkParameter = null;
            for (int i = 0; i < bulkParameters.length; ++i) {
                bulkParameter = bulkParameters[i].split("=");
                if (bulkParameter.length != 2) continue;
                result.put(bulkParameter[0], bulkParameter[1]);
            }
        }
        return result;
    }

    protected SearchResult getByDistinguishedName(String distinguishedName) throws LDAPOperationException {
        String search = "(distinguishedName=" + distinguishedName + ")";
        SearchResult result = this.doLDAPSearchSingleReturn(search);
        return result;
    }

    protected SearchResult getByLogin(String loginName) throws LDAPOperationException {
        String search = "(&(" + this.getUserIdentifierName() + ")(" + this.getUserLoginAttributeName() + "=" + loginName + "))";
        SearchResult result = this.doLDAPSearchSingleReturn(search);
        return result;
    }

    @Override
    public Set<LDAPGroup> getChildGroupsByCN(String commonName) throws LDAPOperationException {
        return this.getChildGroupsByDN(this.findGroupByCommonName(commonName).getDistinguishedName());
    }

    @Override
    public Set<LDAPGroup> getChildGroupsByDN(String distinguishedName) throws LDAPOperationException {
        LdapContext context = this.getLDAPContext();
        try {
            HashSet<LDAPGroup> childGroups = new HashSet<LDAPGroup>();
            String search = "(" + this.getGroupParentGroupAttributeName() + "=" + distinguishedName + ")";
            List<SearchResult> groups = this.doLDAPSearchMultipleReturns(context, this.getConfigurations().getBaseSearchDN(), search);
            for (SearchResult searchResult : groups) {
                LDAPGroup group = this.convertFromSearchResultToLDAPGroup(searchResult);
                if (searchResult != null && searchResult.getObject() instanceof Context) {
                    ((LdapContext)searchResult.getObject()).close();
                }
                childGroups.add(group);
            }
            HashSet<LDAPGroup> grandSonsGroups = new HashSet<LDAPGroup>();
            for (LDAPGroup group : childGroups) {
                if (group.getDistinguishedName().equalsIgnoreCase(group.getParentGroupDN())) continue;
                grandSonsGroups.addAll(this.getChildGroupsByDN(group.getDistinguishedName()));
            }
            childGroups.addAll(grandSonsGroups);
            HashSet<LDAPGroup> hashSet = childGroups;
            return hashSet;
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not get child groups of " + distinguishedName + "!", namingException);
        }
        catch (IOException e) {
            throw new LDAPOperationException("Could not get child groups of " + distinguishedName + "!", e);
        }
        finally {
            try {
                context.close();
            }
            catch (NamingException e) {
                throw new LDAPOperationException("Error closing context!", e);
            }
        }
    }

    protected final String getCommonName() {
        return "cn";
    }

    @Override
    public LDAPConfigurations getConfigurations() {
        if (this.ldapConfigurations == null) {
            this.ldapConfigurations = (LDAPConfigurations)new ConfigurationsPreferencesImpl().readConfiguration(LDAPConfigurations.class);
        }
        return this.ldapConfigurations;
    }

    protected String getDescriptionAttributeName() {
        return "description";
    }

    protected String getDisplayNameAttributeName() {
        return "displayName";
    }

    protected String getGivenNameAttributeName() {
        return "givenName";
    }

    @Override
    public Object getGroupAttribute(String attributeName, String commonName) throws LDAPOperationException {
        return this.getGroupAttributes(commonName).get(attributeName);
    }

    @Override
    public String getGroupAttributeName() {
        return "member";
    }

    @Override
    public Map<String, Object> getGroupAttributes(String commonName) throws LDAPOperationException {
        SearchResult searchResult = this.getGroupByCommonName(commonName);
        Map<String, Object> converted = this.convertFromSearchResultToMap(searchResult);
        if (searchResult != null && searchResult.getObject() instanceof Context) {
            try {
                ((Context)searchResult.getObject()).close();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        return converted;
    }

    protected SearchResult getGroupByCommonName(String cn) throws LDAPOperationException {
        if (this.getConfigurations().getGroupMappings().get(cn) != null && !"".equals(this.getConfigurations().getGroupMappings().get(cn))) {
            if (!groupMappingsFound.contains(cn)) {
                AbstractLDAPUtils.getLogger().info((Object)("Group Mapping found: Resolving " + cn + " to " + this.getConfigurations().getGroupMappings().get(cn)));
                groupMappingsFound.add(cn);
            }
            cn = this.getConfigurations().getGroupMappings().get(cn);
        }
        String search = "(&(" + this.getObjectClassName() + "=" + this.getGroupClassName() + ")(" + this.getCommonName() + "=" + cn + "))";
        SearchResult result = this.doLDAPSearchFirstReturn(search);
        return result;
    }

    protected LDAPGroup getGroupByDistinguishedName(String distinguishedName) throws LDAPOperationException {
        LdapContext ctx = this.getLDAPContext();
        try {
            Attributes attrs = ctx.getAttributes(distinguishedName);
            LDAPGroup lDAPGroup = this.convertFromAttributesToLDAPGroup(attrs, distinguishedName);
            return lDAPGroup;
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not LDAP context!!", namingException);
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
    }

    protected abstract String getGroupClassName();

    protected final String getGroupIdentifierName() {
        return this.getObjectClassName() + "=" + this.getGroupClassName();
    }

    private Vector<String> getGroupMembers(String groupCN) throws LDAPOperationException {
        SearchResult group = null;
        Vector<String> members = new Vector<String>();
        try {
            group = this.getGroupByCommonName(groupCN);
            if (group.getAttributes().get(this.getGroupAttributeName()) != null) {
                members = this.processMembers(group.getAttributes().get(this.getGroupAttributeName()));
            }
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not LDAP context!!", namingException);
        }
        finally {
            if (group != null && group.getObject() instanceof Context) {
                try {
                    ((Context)group.getObject()).close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
        return members;
    }

    public abstract String getGroupParentGroupAttributeName();

    private String getKey(String attributeValue) {
        String key = null;
        for (Map.Entry<String, String> entry : this.getConfigurations().getAttributesMapping().entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(attributeValue)) continue;
            key = entry.getKey();
        }
        return key;
    }

    protected final LdapContext getLDAPContext() throws LDAPOperationException {
        try {
            return this.login(this.getConfigurations().getUserDN(), this.getConfigurations().getPassword(), false);
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not get LDAP context!", namingException);
        }
    }

    @Override
    public String getMailAttributeName() {
        return "mail";
    }

    @Override
    public String getNameAttributeName() {
        return "name";
    }

    @Override
    public String getNonAvailableValue() {
        return NON_AVAILABLE;
    }

    protected final String getObjectClassName() {
        return "objectClass";
    }

    protected String getPasswordAttributeName() {
        return "userPassword";
    }

    protected final LdapContext getSecureLDAPContext() throws LDAPOperationException {
        try {
            return this.login(this.getConfigurations().getUserDN(), this.getConfigurations().getPassword(), true);
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not get secure connection to LDAP server!", namingException);
        }
    }

    protected String getSurnameAttributeName() {
        return "sn";
    }

    @Override
    public Object getUserAttribute(String attributeName, String loginName) throws LDAPOperationException {
        return this.getUserAttributes(loginName).get(attributeName);
    }

    @Override
    public Map<String, Object> getUserAttributes(String loginName) throws LDAPOperationException {
        SearchResult searchResult = this.getByLogin(loginName);
        Map<String, Object> converted = this.convertFromSearchResultToMap(searchResult);
        if (searchResult != null && searchResult.getObject() instanceof Context) {
            try {
                ((Context)searchResult.getObject()).close();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        return converted;
    }

    protected LDAPUser getUserByDistinguishedName(String distinguishedName) throws LDAPOperationException {
        try {
            LdapContext ctx = this.getLDAPContext();
            Attributes attrs = ctx.getAttributes(distinguishedName);
            ctx.close();
            return this.convertFromAttributesToLDAPUser(attrs, distinguishedName);
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not get user with DN=" + distinguishedName + "!", namingException);
        }
    }

    protected abstract String getUserClassName();

    protected final String getUserIdentifierName() {
        return this.getObjectClassName() + "=" + this.getUserClassName();
    }

    protected SearchResult getUserInGroup(String userLogin, String groupCN) throws LDAPOperationException {
        LDAPUser user = this.findUserByLogin(userLogin);
        if (user != null) {
            String search = "(&(" + this.getCommonName() + "=" + groupCN + ")(" + "member" + "=" + user.getDistinguishedName() + "))";
            SearchResult result = this.doLDAPSearchFirstReturn(search);
            return result;
        }
        return null;
    }

    @Override
    public String getUserLoginAttributeName() {
        return "cn";
    }

    @Override
    public String getUserParentGroupAttributeName() {
        return "manager";
    }

    @Override
    public boolean groupContainsAttribute(String attributeName, String commonName) throws LDAPOperationException {
        return this.getGroupAttributes(commonName).containsKey(attributeName);
    }

    @Override
    public boolean groupExists(String groupCN) throws LDAPOperationException {
        return this.findGroupByCommonName(groupCN) != null;
    }

    private Set<LDAPUser> internalFindUsersByAttributes(Map<String, String> attributes, boolean allFields, Integer rowsPerPage, Integer pageToReturn) throws LDAPOperationException {
        HashSet<LDAPUser> users = new HashSet<LDAPUser>();
        StringBuffer query = new StringBuffer("(&(" + this.getObjectClassName() + "=" + this.getUserClassName() + ")");
        query.append(this.buildAttributesString(attributes, allFields));
        query.append(")");
        LdapContext context = this.getLDAPContext();
        try {
            List<SearchResult> returnedUsers = null;
            returnedUsers = rowsPerPage != null && pageToReturn != null ? this.doLDAPSearchMultipleReturnsPaging(context, this.getConfigurations().getBaseSearchDN(), query.toString(), rowsPerPage, pageToReturn) : this.doLDAPSearchMultipleReturns(context, this.getConfigurations().getBaseSearchDN(), query.toString());
            for (SearchResult searchResult : returnedUsers) {
                LDAPUser user = this.convertFromSearchResultToLDAPUser(searchResult);
                if (searchResult != null && searchResult.getObject() instanceof Context) {
                    ((Context)searchResult.getObject()).close();
                }
                users.add(user);
            }
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException("Could not get users using query " + query.toString(), namingException);
        }
        catch (IOException e) {
            throw new LDAPOperationException("Could not get users using query " + query.toString(), e);
        }
        finally {
            try {
                context.close();
            }
            catch (NamingException e) {
                throw new LDAPOperationException("Error closing context!", e);
            }
        }
        return users;
    }

    @Override
    public boolean isIdentityValid(String loginName, String suppliedPassword) throws LDAPOperationException {
        Context ctx = null;
        try {
            ctx = this.login(this.findUserByLogin(loginName).getDistinguishedName(), suppliedPassword, false);
        }
        catch (AuthenticationException authenticationException) {
            boolean bl = false;
            return bl;
        }
        catch (NullPointerException nullPointerException) {
            boolean bl = false;
            return bl;
        }
        catch (NamingException namingException) {
            throw new LDAPOperationException(namingException);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    throw new LDAPOperationException("Error closing context!", e);
                }
            }
        }
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.getConfigurations().getReadOnly();
    }

    @Override
    public boolean isUserInGroup(String groupCN, String userLogin) throws LDAPOperationException {
        SearchResult searchResult = this.getUserInGroup(userLogin, groupCN);
        LDAPUser user = this.convertFromSearchResultToLDAPUser(searchResult);
        if (searchResult != null && searchResult.getObject() instanceof Context) {
            try {
                ((Context)searchResult.getObject()).close();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        return user != null;
    }

    private LdapContext login(String loginName, String password, boolean secureConnection) throws NamingException {
        Hashtable<String, String> environmentProperties = new Hashtable<String, String>();
        environmentProperties.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        environmentProperties.put("com.sun.jndi.ldap.connect.pool", "true");
        environmentProperties.put("com.sun.jndi.ldap.connect.pool.maxsize", "100");
        environmentProperties.put("com.sun.jndi.ldap.read.timeout", "0");
        environmentProperties.put("com.sun.jndi.ldap.connect.timeout", "60000");
        environmentProperties.put("java.naming.ldap.version", "3");
        environmentProperties.put("java.naming.security.authentication", "simple");
        environmentProperties.put("java.naming.referral", "ignore");
        environmentProperties.put("java.naming.security.principal", loginName);
        environmentProperties.put("java.naming.security.credentials", password);
        if (this.getConfigurations().getForceSecureConnection().booleanValue()) {
            secureConnection = true;
        }
        if (secureConnection) {
            environmentProperties.put("java.naming.provider.url", "ldaps://" + this.getConfigurations().getHostName() + ":" + this.getConfigurations().getSSLPort());
            environmentProperties.put("java.naming.security.protocol", "ssl");
            environmentProperties.put("java.naming.ldap.factory.socket", "javax.net.ssl.SSLSocketFactory");
            String keystore = System.getProperty("java.home") + "/lib/security/cacerts";
            System.setProperty("javax.net.ssl.trustStore", keystore);
        } else {
            environmentProperties.put("java.naming.security.protocol", "plain");
            environmentProperties.put("java.naming.provider.url", "ldap://" + this.getConfigurations().getHostName() + ":" + this.getConfigurations().getPort());
        }
        InitialLdapContext ctx = new InitialLdapContext(environmentProperties, null);
        return ctx;
    }

    protected final void modifyAttributes(String distinguishedName, ModificationItem[] mods, boolean secure) throws LDAPOperationException {
        if (mods.length > 0) {
            LdapContext context = null;
            try {
                context = secure ? this.getSecureLDAPContext() : this.getLDAPContext();
                context.modifyAttributes(distinguishedName, mods);
                context.close();
            }
            catch (NamingException namingException) {
                throw new LDAPOperationException("Could not modify attributes for LDAP entity with DN: " + distinguishedName + "!", namingException);
            }
            finally {
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (NamingException e) {
                        throw new LDAPOperationException("Error closing context!", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<String> processMembers(Attribute attribute) throws NamingException {
        Vector<String> members = new Vector<String>();
        NamingEnumeration<?> nameEnum = attribute.getAll();
        try {
            while (nameEnum.hasMore()) {
                String nameEnumValue = (String)nameEnum.next();
                if (!StringUtils.isNotBlank((String)nameEnumValue)) continue;
                members.add(nameEnumValue);
            }
        }
        finally {
            nameEnum.close();
        }
        return members;
    }

    private final void removeAttribute(String distinguishedName, String attributeName) throws LDAPOperationException {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(attributeName))};
        this.modifyAttributes(distinguishedName, mods, false);
    }

    private final void removeAttributeWithValue(String distinguishedName, String attributeName, String value) throws LDAPOperationException {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(attributeName, value))};
        try {
            this.modifyAttributes(distinguishedName, mods, false);
        }
        catch (LDAPOperationException ldapOperationException) {
            if (ldapOperationException.getCause().getClass().equals(SchemaViolationException.class)) {
                mods[0] = new ModificationItem(2, new BasicAttribute(attributeName, ""));
                this.modifyAttributes(distinguishedName, mods, false);
            }
            throw new LDAPOperationException("Could not remove attribute " + attributeName + " from entity with DN=" + distinguishedName + "!", ldapOperationException);
        }
    }

    @Override
    public void removeGroup(String groupCN) throws LDAPOperationException {
        if (this.isReadOnly()) {
            throw new LDAPOperationReadOnlyException();
        }
        LDAPGroup groupToRemove = this.findGroupByCommonName(groupCN);
        if (groupToRemove != null) {
            this.destroySubcontext(groupToRemove.getDistinguishedName());
        }
    }

    @Override
    public void removeGroupAttribute(String commonName, String attributeName) throws LDAPOperationException {
        if (this.isReadOnly()) {
            throw new LDAPOperationReadOnlyException();
        }
        this.removeAttribute(this.findGroupByCommonName(commonName).getDistinguishedName(), attributeName);
    }

    @Override
    public void removeUser(String loginName) throws LDAPOperationException {
        if (this.isReadOnly()) {
            throw new LDAPOperationReadOnlyException();
        }
        LDAPUser userToRemove = this.findUserByLogin(loginName);
        if (userToRemove != null) {
            this.destroySubcontext(userToRemove.getDistinguishedName());
        }
    }

    @Override
    public void removeUserAttribute(String loginName, String attributeName) throws LDAPOperationException {
        if (this.isReadOnly()) {
            throw new LDAPOperationReadOnlyException();
        }
        LDAPUser user = this.findUserByLogin(loginName);
        if (user != null) {
            user.removeParameter(attributeName);
            this.updateUser(user, user.getLoginName());
        }
    }

    @Override
    public void removeUserFromGroup(String groupCN, String userLogin) throws LDAPOperationException {
        if (this.isReadOnly()) {
            throw new LDAPOperationReadOnlyException();
        }
        LDAPGroup group = this.findGroupByCommonName(groupCN);
        LDAPUser user = this.findUserByLogin(userLogin);
        if (group != null && user != null) {
            this.removeAttributeWithValue(group.getDistinguishedName(), "member", user.getDistinguishedName());
        }
    }

    private final void replaceAttribute(String distinguishedName, String attributeName, String value) throws LDAPOperationException {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(attributeName, value.toString()))};
        this.modifyAttributes(distinguishedName, mods, false);
    }

    @Override
    public void resetConfigurations() {
        this.ldapConfigurations = null;
    }

    @Override
    public void setGroupAttribute(String commonName, String attributeName, Object value) throws LDAPOperationException {
        if (this.isReadOnly()) {
            throw new LDAPOperationReadOnlyException();
        }
        LDAPGroup group = this.findGroupByCommonName(commonName);
        if (group == null) {
            throw new LDAPOperationException("The group with the common name \"" + commonName + "\" doesn't exists!");
        }
        if ("member".equals(attributeName)) {
            this.addAttribute(group.getDistinguishedName(), attributeName, value.toString());
        } else {
            this.replaceAttribute(group.getDistinguishedName(), attributeName, value.toString());
        }
    }

    @Override
    public void setLogger(ILogWrapper logger) {
        AbstractLDAPUtils.logger = logger;
    }

    @Override
    public void setUserAttribute(String loginName, String attributeName, Object value) throws LDAPOperationException {
        if (this.isReadOnly()) {
            throw new LDAPOperationReadOnlyException();
        }
        LDAPUser user = this.findUserByLogin(loginName);
        if (user == null) {
            throw new LDAPOperationException("Could not store parameter on user attribute for user with login " + loginName + "! User was not found on LDAP server...\nCheck user was created before and exists on server.");
        }
        user.setParameter(attributeName, value.toString());
        this.updateUser(user, user.getLoginName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateGroup(LDAPGroup groupToUpdate, String groupCN) throws LDAPOperationException {
        block14: {
            if (this.isReadOnly()) {
                throw new LDAPOperationReadOnlyException();
            }
            LDAPGroup existingGroup = this.findGroupByCommonName(groupCN);
            ArrayList<ModificationItem> itens = new ArrayList<ModificationItem>();
            if (groupToUpdate.getDescription() != null && !groupToUpdate.getDescription().equals(existingGroup.getDescription())) {
                itens.add(new ModificationItem(2, new BasicAttribute(this.getDescriptionAttributeName(), groupToUpdate.getDescription())));
            }
            if (groupToUpdate.getParentGroupDN() != null && !groupToUpdate.getParentGroupDN().equals(existingGroup.getParentGroupDN())) {
                itens.add(new ModificationItem(2, new BasicAttribute(this.getGroupParentGroupAttributeName(), groupToUpdate.getParentGroupDN())));
            }
            if (itens.size() > 0) {
                ModificationItem[] mods = new ModificationItem[itens.size()];
                for (int i = 0; i < itens.size(); ++i) {
                    mods[i] = (ModificationItem)itens.get(i);
                }
                this.modifyAttributes(existingGroup.getDistinguishedName(), mods, false);
            }
            if (this.ldapConfigurations.getAllowDistinguishedNameModifications() && groupToUpdate.getParentGroupDN() != null && !groupToUpdate.getParentGroupDN().equals(existingGroup.getParentGroupDN()) || groupToUpdate.getCommonName() != null && !groupToUpdate.getCommonName().equals(existingGroup.getCommonName())) {
                String commonName = groupToUpdate.getCommonName();
                String parentGroup = groupToUpdate.getParentGroupDN();
                if (commonName == null) {
                    commonName = existingGroup.getCommonName();
                }
                if (parentGroup == null) {
                    parentGroup = this.getGroupByDistinguishedName(existingGroup.getParentGroupDN()).getDistinguishedName();
                }
                String newDN = this.calculateDistinguishedName(commonName, parentGroup);
                try {
                    if (existingGroup.getDistinguishedName().equals(newDN)) break block14;
                    LdapContext ctx = this.getLDAPContext();
                    try {
                        ctx.rename(existingGroup.getDistinguishedName(), newDN);
                    }
                    finally {
                        ctx.close();
                    }
                }
                catch (LDAPOperationException ldapOperationException) {
                    throw ldapOperationException;
                }
                catch (NamingException namingException) {
                    throw new LDAPOperationException("Could not update group's parent group...", namingException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUser(LDAPUser userToUpdate, String userLogin) throws LDAPOperationException {
        block25: {
            if (this.isReadOnly()) {
                throw new LDAPOperationReadOnlyException();
            }
            LDAPUser existingUser = this.findUserByLogin(userLogin, false);
            if (existingUser != null) {
                ArrayList<ModificationItem> items = new ArrayList<ModificationItem>();
                if (userToUpdate.getDisplayName() != null && !userToUpdate.getDisplayName().equalsIgnoreCase(existingUser.getDisplayName())) {
                    items.add(new ModificationItem(2, new BasicAttribute(this.getDisplayNameAttributeName(), userToUpdate.getDisplayName())));
                }
                if (userToUpdate.getEmail() != null && !userToUpdate.getEmail().equals(existingUser.getEmail())) {
                    items.add(new ModificationItem(2, new BasicAttribute(this.getMailAttributeName(), userToUpdate.getEmail())));
                }
                if (userToUpdate.getGivenName() != null && !userToUpdate.getGivenName().equals(existingUser.getGivenName())) {
                    items.add(new ModificationItem(2, new BasicAttribute(this.getGivenNameAttributeName(), userToUpdate.getGivenName())));
                }
                if (userToUpdate.getPassword() != null) {
                    this.changePassword(userLogin, userToUpdate.getPassword());
                }
                if (userToUpdate.getLoginName() != null && !userToUpdate.getLoginName().equals(existingUser.getLoginName())) {
                    items.add(new ModificationItem(2, new BasicAttribute(this.getUserLoginAttributeName(), userToUpdate.getLoginName())));
                }
                if (userToUpdate.getParentGroupDN() != null && !userToUpdate.getParentGroupDN().equals(existingUser.getParentGroupDN())) {
                    items.add(new ModificationItem(2, new BasicAttribute(this.getUserParentGroupAttributeName(), userToUpdate.getParentGroupDN())));
                }
                HashMap<String, String> bulkParameters = new HashMap<String, String>();
                for (String parameterName : userToUpdate.getParameters().keySet()) {
                    if (this.getConfigurations().getAttributesMapping().containsKey(parameterName)) {
                        items.add(new ModificationItem(2, new BasicAttribute(this.getConfigurations().getAttributesMapping().get(parameterName), userToUpdate.getParameter(parameterName))));
                        continue;
                    }
                    if (existingUser.getParameter(parameterName) != null) {
                        if (this.getUnchangeableLDAPAttributes().contains(parameterName.toUpperCase()) || userToUpdate.getParameter(parameterName).equalsIgnoreCase(existingUser.getParameter(parameterName))) continue;
                        items.add(new ModificationItem(2, new BasicAttribute(parameterName, userToUpdate.getParameter(parameterName))));
                        continue;
                    }
                    bulkParameters.put(parameterName, userToUpdate.getParameter(parameterName));
                }
                for (String parameterName : userToUpdate.getParametersToRemove()) {
                    if (this.getConfigurations().getAttributesMapping().containsKey(parameterName)) {
                        items.add(new ModificationItem(3, new BasicAttribute(this.getConfigurations().getAttributesMapping().get(parameterName))));
                        continue;
                    }
                    bulkParameters.remove(parameterName);
                }
                StringBuilder bulkParameterAttributeValue = new StringBuilder();
                for (Map.Entry entry : bulkParameters.entrySet()) {
                    bulkParameterAttributeValue.append((String)entry.getKey() + "=" + (String)entry.getValue() + ";");
                }
                if (bulkParameterAttributeValue.length() == 0) {
                    bulkParameterAttributeValue.append(" ");
                }
                items.add(new ModificationItem(2, new BasicAttribute(this.getConfigurations().getBulkParametersAttributeName(), bulkParameterAttributeValue.toString())));
                if (items.size() > 0) {
                    ModificationItem[] mods = new ModificationItem[items.size()];
                    for (int i = 0; i < items.size(); ++i) {
                        mods[i] = (ModificationItem)items.get(i);
                    }
                    this.modifyAttributes(existingUser.getDistinguishedName(), mods, false);
                }
                if (this.ldapConfigurations.getAllowDistinguishedNameModifications() && userToUpdate.getParentGroupDN() != null && !userToUpdate.getParentGroupDN().equals(existingUser.getParentGroupDN())) {
                    String loginName = userToUpdate.getLoginName();
                    if (loginName == null) {
                        loginName = existingUser.getLoginName();
                    }
                    String newDN = this.calculateDistinguishedName(loginName, userToUpdate.getParentGroupDN());
                    try {
                        if (existingUser.getDistinguishedName().equals(newDN)) break block25;
                        LdapContext ctx = this.getLDAPContext();
                        try {
                            ctx.rename(existingUser.getDistinguishedName(), newDN);
                        }
                        finally {
                            ctx.close();
                        }
                    }
                    catch (LDAPOperationException ldapOperationException) {
                        throw ldapOperationException;
                    }
                    catch (NamingException namingException) {
                        throw new LDAPOperationException("Could not update user's main group...", namingException);
                    }
                }
            }
        }
    }

    @Override
    public boolean userContainsAttribute(String id, String loginName) throws LDAPOperationException {
        return this.getUserAttributes(loginName).containsKey(id);
    }

    @Override
    public boolean userExists(String loginName) throws LDAPOperationException {
        return this.findUserByLogin(loginName) != null;
    }
}

