/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.ldap.impl.ad;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import pt.digitalis.utils.ldap.LDAPUser;
import pt.digitalis.utils.ldap.exception.LDAPOperationException;
import pt.digitalis.utils.ldap.exception.LDAPOperationReadOnlyException;
import pt.digitalis.utils.ldap.impl.AbstractLDAPUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPUtilsActiveDirectoryImpl
extends AbstractLDAPUtils {
    private static final int UF_ACCOUNTDISABLE = 2;
    private static final int UF_ACCOUNTENABLE = 1;
    private static final int UF_DONT_EXPIRE_PASSWD = 65536;
    private static final int UF_NORMAL_ACCOUNT = 512;
    private static final int UF_PASSWD_CANT_CHANGE = 64;
    private static final int UF_PASSWD_NOTREQD = 32;
    private static final int UF_PASSWORD_EXPIRED = 0x800000;
    static final List<String> unchangeableAttributes = new ArrayList<String>();
    private static final String USER_CONTROL_VALUE = Integer.toString(66081);

    @Override
    protected String calculateDistinguishedName(String commonName, String mainGroupDN) throws LDAPOperationException {
        if (commonName == null) {
            throw new LDAPOperationException("The supplied CN was null! Cannot calculate the entity's DN without a valid CN...");
        }
        if (mainGroupDN == null) {
            throw new LDAPOperationException("The supplied parent group name was null!! Cannot calculate the entity's DN without a valid parent group name...");
        }
        StringBuffer newDistinguishedName = new StringBuffer("cn=" + commonName);
        StringBuffer groupDistinguishedName = new StringBuffer(mainGroupDN);
        groupDistinguishedName.trimToSize();
        groupDistinguishedName.replace(0, groupDistinguishedName.capacity(), groupDistinguishedName.substring(groupDistinguishedName.indexOf(",")));
        newDistinguishedName.append(groupDistinguishedName);
        return newDistinguishedName.toString();
    }

    @Override
    public void changePassword(String loginName, String newPassword) throws LDAPOperationException {
        if (this.isReadOnly()) {
            throw new LDAPOperationReadOnlyException();
        }
        String ENCODING = "UTF-16LE";
        try {
            String newQuotedPassword = "\"" + newPassword + "\"";
            byte[] newUnicodePassword = newQuotedPassword.getBytes("UTF-16LE");
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("unicodePwd", newUnicodePassword))};
            super.modifyAttributes(this.findUserByLogin(loginName).getDistinguishedName(), mods, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new LDAPOperationException("UTF-16LE encoding not suppported!", unsupportedEncodingException);
        }
    }

    @Override
    protected Attributes getAttributesForUserAddition(LDAPUser newUser) throws LDAPOperationException {
        String[] baseDnArray;
        Attributes attrs = super.getAttributesForUserAddition(newUser);
        attrs.put(this.getUserControlAttributeName(), USER_CONTROL_VALUE);
        String result = "";
        String baseDn = this.getConfigurations().getBaseSearchDN();
        for (String content : baseDnArray = baseDn.split(",")) {
            if (!content.toUpperCase().startsWith("DC")) continue;
            result = "".equals(result) ? content.split("=")[1] : result + "." + content.split("=")[1];
        }
        result = "".equals(result) ? newUser.getLoginName() : newUser.getLoginName() + "@" + result;
        attrs.put("userPrincipalName", result);
        return attrs;
    }

    @Override
    protected String getGroupClassName() {
        return "group";
    }

    @Override
    public String getGroupParentGroupAttributeName() {
        return "desktopProfile";
    }

    @Override
    public String getMailAttributeName() {
        return "mail";
    }

    @Override
    public List<String> getUnchangeableLDAPAttributes() {
        return unchangeableAttributes;
    }

    @Override
    protected String getUserClassName() {
        return "user";
    }

    protected String getUserControlAttributeName() {
        return "userAccountControl";
    }

    @Override
    public String getUserLoginAttributeName() {
        return "sAMAccountName";
    }

    static {
        unchangeableAttributes.add("USNCHANGED");
        unchangeableAttributes.add("WHENCHANGED");
    }
}

