/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.utils.ldap.impl.openldap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.ldap.LDAPGroup;
import pt.digitalis.utils.ldap.LDAPUser;
import pt.digitalis.utils.ldap.exception.LDAPOperationException;
import pt.digitalis.utils.ldap.exception.LDAPOperationReadOnlyException;
import pt.digitalis.utils.ldap.impl.AbstractLDAPUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPUtilsOpenLDAPImpl
extends AbstractLDAPUtils {
    static final List<String> unchangeableAttributes = new ArrayList<String>();

    @Override
    protected String calculateDistinguishedName(String commonName, String mainGroupDN) throws LDAPOperationException {
        if (commonName == null) {
            throw new LDAPOperationException("The supplied CN was null! Cannot calculate the entity's DN without a valid CN...");
        }
        if (mainGroupDN == null) {
            throw new LDAPOperationException("The supplied parent group name was null!! Cannot calculate the entity's DN without a valid parent group name...");
        }
        StringBuffer newDistinguishedName = new StringBuffer("cn=" + commonName);
        StringBuffer groupDistinguishedName = new StringBuffer(mainGroupDN);
        groupDistinguishedName.trimToSize();
        groupDistinguishedName.replace(0, groupDistinguishedName.capacity(), groupDistinguishedName.substring(groupDistinguishedName.indexOf(",")));
        newDistinguishedName.append(groupDistinguishedName);
        return newDistinguishedName.toString();
    }

    @Override
    public void changePassword(String loginName, String newPassword) throws LDAPOperationException {
        if (this.isReadOnly()) {
            throw new LDAPOperationReadOnlyException();
        }
        LDAPUser user = this.findUserByLogin(loginName);
        if (user != null) {
            ArrayList<ModificationItem> itens = new ArrayList<ModificationItem>();
            itens.add(new ModificationItem(2, new BasicAttribute(this.getPasswordAttributeName(), newPassword)));
            if (itens.size() > 0) {
                ModificationItem[] mods = new ModificationItem[itens.size()];
                for (int i = 0; i < itens.size(); ++i) {
                    mods[i] = (ModificationItem)itens.get(i);
                }
                LdapContext ctx = this.getLDAPContext();
                try {
                    ctx.modifyAttributes(user.getDistinguishedName(), mods);
                }
                catch (NamingException namingException) {
                    throw new LDAPOperationException("Could not change password for user with DN=" + user.getDistinguishedName() + "!", namingException);
                }
                finally {
                    try {
                        ctx.close();
                    }
                    catch (NamingException e) {
                        throw new LDAPOperationException("Error closing NamingEnumeration!", e);
                    }
                }
            }
        } else {
            throw new LDAPOperationException("User with login=" + loginName + " was not found on the LDAP server! Can't change the password on an nonexistent user...");
        }
    }

    @Override
    protected Attributes getAttributesForGroupAddition(LDAPGroup newGroup) throws LDAPOperationException {
        BasicAttributes attrs = new BasicAttributes(true);
        attrs.put(this.getObjectClassName(), this.getGroupClassName());
        attrs.put(this.getGroupAttributeName(), "");
        if (newGroup.getDescription() != null) {
            attrs.put(this.getDescriptionAttributeName(), newGroup.getDescription());
        }
        if (newGroup.getParentGroupDN() != null) {
            attrs.put(this.getGroupParentGroupAttributeName(), newGroup.getParentGroupDN());
        }
        return attrs;
    }

    @Override
    protected Attributes getAttributesForUserAddition(LDAPUser newUser) throws LDAPOperationException {
        Attributes attributes = super.getAttributesForUserAddition(newUser);
        attributes.put(this.getSurnameAttributeName(), newUser.getGivenName());
        attributes.remove(this.getNameAttributeName());
        return attributes;
    }

    @Override
    protected String getGroupClassName() {
        return "groupOfNames";
    }

    @Override
    public String getGroupParentGroupAttributeName() {
        return "seeAlso";
    }

    @Override
    public String getNameAttributeName() {
        return "cn";
    }

    @Override
    public List<String> getUnchangeableLDAPAttributes() {
        return unchangeableAttributes;
    }

    @Override
    protected String getUserClassName() {
        return "inetOrgPerson";
    }

    @Override
    public String getUserLoginAttributeName() {
        return StringUtils.isEmpty((String)this.getConfigurations().getLoginAttribute()) ? "cn" : this.ldapConfigurations.getLoginAttribute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUser(LDAPUser userToUpdate, String userLogin) throws LDAPOperationException {
        block25: {
            if (this.isReadOnly()) {
                throw new LDAPOperationReadOnlyException();
            }
            LDAPUser existingUser = this.findUserByLogin(userLogin, false);
            if (existingUser != null) {
                ArrayList<ModificationItem> items = new ArrayList<ModificationItem>();
                if (userToUpdate.getDisplayName() != null && !userToUpdate.getDisplayName().equalsIgnoreCase(existingUser.getDisplayName())) {
                    items.add(new ModificationItem(2, new BasicAttribute(this.getDisplayNameAttributeName(), userToUpdate.getDisplayName())));
                }
                if (userToUpdate.getEmail() != null && !userToUpdate.getEmail().equals(existingUser.getEmail())) {
                    items.add(new ModificationItem(2, new BasicAttribute(this.getMailAttributeName(), userToUpdate.getEmail())));
                }
                if (userToUpdate.getGivenName() != null && !userToUpdate.getGivenName().equals(existingUser.getGivenName())) {
                    items.add(new ModificationItem(2, new BasicAttribute(this.getGivenNameAttributeName(), userToUpdate.getGivenName())));
                }
                if (userToUpdate.getPassword() != null) {
                    this.changePassword(userLogin, userToUpdate.getPassword());
                }
                if (userToUpdate.getParentGroupDN() != null && !userToUpdate.getParentGroupDN().equals(existingUser.getParentGroupDN())) {
                    items.add(new ModificationItem(2, new BasicAttribute(this.getUserParentGroupAttributeName(), userToUpdate.getParentGroupDN())));
                }
                HashMap<String, String> bulkParameters = new HashMap<String, String>();
                for (String parameterName : userToUpdate.getParameters().keySet()) {
                    if (this.getConfigurations().getAttributesMapping().containsKey(parameterName)) {
                        items.add(new ModificationItem(2, new BasicAttribute(this.getConfigurations().getAttributesMapping().get(parameterName), userToUpdate.getParameter(parameterName))));
                        continue;
                    }
                    if (existingUser.getParameter(parameterName) != null) {
                        if (this.getUnchangeableLDAPAttributes().contains(parameterName.toUpperCase()) || userToUpdate.getParameter(parameterName).equalsIgnoreCase(existingUser.getParameter(parameterName))) continue;
                        items.add(new ModificationItem(2, new BasicAttribute(parameterName, userToUpdate.getParameter(parameterName))));
                        continue;
                    }
                    bulkParameters.put(parameterName, userToUpdate.getParameter(parameterName));
                }
                for (String parameterName : userToUpdate.getParametersToRemove()) {
                    if (this.getConfigurations().getAttributesMapping().containsKey(parameterName)) {
                        items.add(new ModificationItem(3, new BasicAttribute(this.getConfigurations().getAttributesMapping().get(parameterName))));
                        continue;
                    }
                    bulkParameters.remove(parameterName);
                }
                StringBuilder bulkParameterAttributeValue = new StringBuilder();
                for (Map.Entry entry : bulkParameters.entrySet()) {
                    bulkParameterAttributeValue.append((String)entry.getKey() + "=" + (String)entry.getValue() + ";");
                }
                if (bulkParameterAttributeValue.length() == 0) {
                    bulkParameterAttributeValue.append(" ");
                }
                items.add(new ModificationItem(2, new BasicAttribute(this.getConfigurations().getBulkParametersAttributeName(), bulkParameterAttributeValue.toString())));
                if (items.size() > 0) {
                    ModificationItem[] mods = new ModificationItem[items.size()];
                    for (int i = 0; i < items.size(); ++i) {
                        mods[i] = (ModificationItem)items.get(i);
                    }
                    this.modifyAttributes(existingUser.getDistinguishedName(), mods, false);
                }
                if (this.ldapConfigurations.getAllowDistinguishedNameModifications() && userToUpdate.getParentGroupDN() != null && !userToUpdate.getParentGroupDN().equals(existingUser.getParentGroupDN()) || userToUpdate.getCommonName() != null && !userToUpdate.getCommonName().equals(existingUser.getCommonName()) || userToUpdate.getLoginName() != null && !userToUpdate.getLoginName().equals(existingUser.getLoginName())) {
                    String parentGroupDN;
                    String loginName = userToUpdate.getLoginName();
                    if (loginName == null || "N/A".equals(loginName)) {
                        loginName = existingUser.getLoginName();
                    }
                    if ((parentGroupDN = userToUpdate.getParentGroupDN()) == null || "N/A".equals(parentGroupDN)) {
                        parentGroupDN = existingUser.getParentGroupDN();
                    }
                    String newDN = this.calculateDistinguishedName(loginName, parentGroupDN);
                    try {
                        if (existingUser.getDistinguishedName().equals(newDN)) break block25;
                        LdapContext ctx = this.getLDAPContext();
                        try {
                            ctx.rename(existingUser.getDistinguishedName(), newDN);
                        }
                        finally {
                            ctx.close();
                        }
                    }
                    catch (LDAPOperationException ldapOperationException) {
                        throw ldapOperationException;
                    }
                    catch (NamingException namingException) {
                        throw new LDAPOperationException("Could not update user's main group...", namingException);
                    }
                }
            }
        }
    }
}

