/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.Reply;
import com.atomikos.icatch.imp.Result;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

class TerminationResult
extends Result {
    protected boolean analyzed_ = false;
    protected Hashtable heuristicparticipants_ = new Hashtable();
    protected Hashtable possiblyIndoubts_ = new Hashtable();

    public TerminationResult(int count) {
        super(count);
    }

    public Hashtable getHeuristicParticipants() throws IllegalStateException, InterruptedException {
        this.analyze();
        return this.heuristicparticipants_;
    }

    public Hashtable getPossiblyIndoubts() throws IllegalStateException, InterruptedException {
        this.analyze();
        return this.possiblyIndoubts_;
    }

    protected synchronized void analyze() throws IllegalStateException, InterruptedException {
        if (this.analyzed_) {
            return;
        }
        boolean heurmixed = false;
        boolean heuraborts = false;
        boolean heurcommits = false;
        boolean heurhazards = false;
        boolean allOK = true;
        boolean rolledback = false;
        Stack replies = this.getReplies();
        Enumeration enumm = replies.elements();
        while (enumm.hasMoreElements()) {
            Reply reply = (Reply)enumm.nextElement();
            if (reply.hasFailed()) {
                allOK = false;
                Exception err = reply.getException();
                if (err instanceof RollbackException) {
                    rolledback = true;
                    continue;
                }
                if (err instanceof HeurMixedException) {
                    heurmixed = true;
                    HeurMixedException hm = (HeurMixedException)err;
                    this.addErrorMessages(hm.getHeuristicMessages());
                    this.heuristicparticipants_.put(reply.getParticipant(), TxState.HEUR_MIXED);
                    continue;
                }
                if (err instanceof HeurCommitException) {
                    heurcommits = true;
                    HeurCommitException hc = (HeurCommitException)err;
                    this.addErrorMessages(hc.getHeuristicMessages());
                    heurmixed = heurmixed || heuraborts || heurhazards;
                    this.heuristicparticipants_.put(reply.getParticipant(), TxState.HEUR_COMMITTED);
                    continue;
                }
                if (err instanceof HeurRollbackException) {
                    heuraborts = true;
                    heurmixed = heurmixed || heurcommits || heurhazards;
                    HeurRollbackException hr = (HeurRollbackException)err;
                    this.addErrorMessages(hr.getHeuristicMessages());
                    this.heuristicparticipants_.put(reply.getParticipant(), TxState.HEUR_ABORTED);
                    continue;
                }
                heurhazards = true;
                heurmixed = heurmixed || heuraborts || heurcommits;
                StringHeuristicMessage heurmsg = new StringHeuristicMessage("No commit ACK from participant " + reply.getParticipant());
                this.errmsgvector_.addElement(heurmsg);
                this.heuristicparticipants_.put(reply.getParticipant(), TxState.HEUR_HAZARD);
                this.possiblyIndoubts_.put(reply.getParticipant(), TxState.HEUR_HAZARD);
                continue;
            }
            HeuristicMessage[] msgs = (HeuristicMessage[])reply.getResponse();
            if (msgs == null) continue;
            this.addMessages(msgs);
        }
        if (rolledback) {
            this.result_ = 6;
        } else if (heurmixed || heuraborts && this.heuristicparticipants_.size() != replies.size() || heurcommits && this.heuristicparticipants_.size() != replies.size()) {
            this.result_ = 2;
        } else if (heurhazards) {
            this.result_ = 1;
        } else if (heuraborts) {
            this.result_ = 3;
        } else if (heurcommits) {
            this.result_ = 4;
        } else if (allOK) {
            this.result_ = 0;
        }
        this.analyzed_ = true;
    }
}

