/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.jta.RemoteClientUserTransactionFactory;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.icatch.jta.UserTransactionServer;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.rmi.PortableRemoteObject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public final class RemoteClientUserTransaction
implements UserTransaction,
Externalizable,
Referenceable {
    private static final Logger LOGGER = LoggerFactory.createLogger(RemoteClientUserTransaction.class);
    static final int DEFAULT_TIMEOUT = 30;
    private transient UserTransactionServer txmgrServer_;
    private transient TransactionManager txmgr_;
    private transient Hashtable threadToTidMap_;
    private int timeout_;
    private String name_;
    private String initialContextFactory_;
    private String providerUrl_;
    private boolean imported_;

    public RemoteClientUserTransaction() {
        this.threadToTidMap_ = new Hashtable();
        this.timeout_ = 30;
        this.imported_ = false;
    }

    public RemoteClientUserTransaction(String name, String initialContextFactory, String providerUrl) {
        this.initialContextFactory_ = initialContextFactory;
        this.providerUrl_ = providerUrl;
        this.name_ = name;
        this.threadToTidMap_ = new Hashtable();
        this.timeout_ = 30;
        this.imported_ = false;
    }

    private String getNotFoundMessage() {
        String errorMsg = "Name not found: " + this.name_ + "\n" + "Please check that: \n" + "\t-server property com.atomikos.icatch.client_demarcation is set to true \n" + "   -server property com.atomikos.icatch.rmi_export_class is correct \n" + "\t-server property java.naming.factory.initial is " + this.initialContextFactory_ + "\n" + "\t-server property java.naming.provider.url is " + this.providerUrl_ + "\n" + "\t-the naming service is running on port " + this.providerUrl_ + "\n" + "\t-the transaction server is running";
        return errorMsg;
    }

    private boolean checkSetup() {
        this.txmgr_ = TransactionManagerImp.getTransactionManager();
        if (this.txmgr_ == null) {
            try {
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", this.initialContextFactory_);
                env.put("java.naming.provider.url", this.providerUrl_);
                InitialContext ctx = new InitialContext(env);
                this.txmgrServer_ = (UserTransactionServer)PortableRemoteObject.narrow((Object)ctx.lookup(this.name_), UserTransactionServer.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(this.getNotFoundMessage());
            }
            if (this.txmgrServer_ == null) {
                throw new RuntimeException(this.getNotFoundMessage());
            }
        }
        return this.txmgr_ != null;
    }

    private synchronized void setThreadMapping(String tid) {
        Thread thread = Thread.currentThread();
        this.threadToTidMap_.put(thread, tid);
    }

    private synchronized String removeThreadMapping() {
        Thread thread = Thread.currentThread();
        return (String)this.threadToTidMap_.remove(thread);
    }

    private synchronized String getThreadMapping() {
        Thread thread = Thread.currentThread();
        return (String)this.threadToTidMap_.get(thread);
    }

    public void begin() throws NotSupportedException, SystemException {
        boolean local = this.checkSetup();
        if (local) {
            this.txmgr_.begin();
        } else {
            String tid = this.getThreadMapping();
            if (tid != null) {
                throw new NotSupportedException("Nested transaction not allowed here");
            }
            try {
                tid = this.txmgrServer_.begin(this.timeout_);
            }
            catch (RemoteException re) {
                throw new SystemException(re.getMessage());
            }
            this.setThreadMapping(tid);
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, IllegalStateException, SecurityException {
        boolean local = this.checkSetup();
        if (local) {
            this.txmgr_.commit();
        } else {
            if (this.imported_) {
                throw new SecurityException("Commit not allowed: not creator");
            }
            String tid = this.removeThreadMapping();
            if (tid == null) {
                throw new IllegalStateException("No transaction for thread");
            }
            try {
                this.txmgrServer_.commit(tid);
            }
            catch (RemoteException re) {
                throw new SystemException(re.getMessage());
            }
        }
    }

    public void rollback() throws IllegalStateException, SystemException, SecurityException {
        boolean local = this.checkSetup();
        if (local) {
            this.txmgr_.rollback();
        } else {
            if (this.imported_) {
                throw new SecurityException("Rollback not allowed: not creator");
            }
            String tid = this.removeThreadMapping();
            if (tid == null) {
                throw new IllegalStateException("No transaction for thread");
            }
            try {
                this.txmgrServer_.rollback(tid);
            }
            catch (RemoteException re) {
                throw new SystemException(re.getMessage());
            }
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        boolean local = this.checkSetup();
        if (local) {
            this.txmgr_.setRollbackOnly();
        } else {
            String tid = this.getThreadMapping();
            if (tid == null) {
                throw new IllegalStateException("No transaction for thread");
            }
            try {
                this.txmgrServer_.setRollbackOnly(tid);
            }
            catch (RemoteException re) {
                throw new SystemException(re.getMessage());
            }
        }
    }

    public int getStatus() throws SystemException {
        int ret = 6;
        boolean local = this.checkSetup();
        if (local) {
            ret = this.txmgr_.getStatus();
        } else {
            String tid = this.getThreadMapping();
            if (tid != null) {
                try {
                    ret = this.txmgrServer_.getStatus(tid);
                }
                catch (RemoteException re) {
                    throw new SystemException(re.getMessage());
                }
            }
        }
        return ret;
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.timeout_ = seconds;
    }

    public String toString() {
        String ret = null;
        boolean local = this.checkSetup();
        if (local) {
            Transaction tx = null;
            try {
                tx = this.txmgr_.getTransaction();
            }
            catch (SystemException e) {
                String msg = "Error getting transaction";
                LOGGER.logWarning(msg, e);
            }
            if (tx != null) {
                ret = tx.toString();
            }
        }
        if (ret == null) {
            ret = this.getThreadMapping();
        }
        return ret;
    }

    public Reference getReference() throws NamingException {
        StringRefAddr nameRef = new StringRefAddr("ServerName", this.name_);
        StringRefAddr urlRef = new StringRefAddr("ProviderUrl", this.providerUrl_);
        StringRefAddr factRef = new StringRefAddr("ContextFactory", this.initialContextFactory_);
        StringRefAddr timeoutRef = new StringRefAddr("Timeout", new Integer(this.timeout_).toString());
        Reference ref = new Reference(this.getClass().getName(), new StringRefAddr("name", "RemoteClientUserTransaction"), RemoteClientUserTransactionFactory.class.getName(), null);
        ref.add(nameRef);
        ref.add(urlRef);
        ref.add(factRef);
        ref.add(timeoutRef);
        return ref;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        String tid = this.getThreadMapping();
        out.writeObject(tid);
        out.writeObject(this.name_);
        out.writeObject(this.initialContextFactory_);
        out.writeObject(this.providerUrl_);
        out.writeInt(this.timeout_);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String tid = (String)in.readObject();
        if (tid != null) {
            this.setThreadMapping(tid);
            this.imported_ = true;
        }
        this.name_ = (String)in.readObject();
        this.initialContextFactory_ = (String)in.readObject();
        this.providerUrl_ = (String)in.readObject();
        this.timeout_ = in.readInt();
    }
}

