/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.crypto;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.kernel.crypto.CryptoUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestAlgorithms {
    public static final String SHA1 = "SHA-1";
    public static final String SHA256 = "SHA-256";
    public static final String SHA384 = "SHA-384";
    public static final String SHA512 = "SHA-512";
    public static final String RIPEMD160 = "RIPEMD160";
    public static final String SHA3_256 = "SHA3-256";
    public static final String SHA3_512 = "SHA3-512";
    public static final String SHA3_384 = "SHA3-384";
    public static final String SHAKE256 = "SHAKE256";
    private static final Map<String, String> digestNames = new HashMap<String, String>();
    private static final Map<String, String> fixNames = new HashMap<String, String>();
    private static final Map<String, String> allowedDigests = new HashMap<String, String>();
    private static final Map<String, Integer> bitLengths = new HashMap<String, Integer>();
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private static final Logger LOGGER = LoggerFactory.getLogger(DigestAlgorithms.class);

    public static MessageDigest getMessageDigestFromOid(String digestOid, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return DigestAlgorithms.getMessageDigest(DigestAlgorithms.getDigest(digestOid), provider);
    }

    public static MessageDigest getMessageDigest(String hashAlgorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoUtil.getMessageDigest(hashAlgorithm, provider);
    }

    public static byte[] digest(InputStream data, String hashAlgorithm, String provider) throws GeneralSecurityException, IOException {
        MessageDigest messageDigest = DigestAlgorithms.getMessageDigest(hashAlgorithm, provider);
        return DigestAlgorithms.digest(data, messageDigest);
    }

    public static byte[] digest(InputStream data, MessageDigest messageDigest) throws IOException {
        int n;
        byte[] buf = new byte[8192];
        while ((n = data.read(buf)) > 0) {
            messageDigest.update(buf, 0, n);
        }
        return messageDigest.digest();
    }

    public static String getDigest(String oid) {
        String ret = digestNames.get(oid);
        if (ret == null) {
            try {
                String digest = DigestAlgorithms.getMessageDigest(oid, BOUNCY_CASTLE_FACTORY.getProviderName()).getAlgorithm();
                LOGGER.warn("Requested algorithm might not be supported by the pdf specification.");
                return digest;
            }
            catch (Exception e) {
                return oid;
            }
        }
        return ret;
    }

    public static String normalizeDigestName(String algo) {
        if (fixNames.containsKey(algo)) {
            return fixNames.get(algo);
        }
        return algo;
    }

    public static String getAllowedDigest(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name of the digest algorithm is null.");
        }
        String allowedDigest = allowedDigests.get(StringNormalizer.toUpperCase((String)name));
        if (allowedDigest != null) {
            return allowedDigest;
        }
        allowedDigest = BOUNCY_CASTLE_FACTORY.getDigestAlgorithmOid(StringNormalizer.toUpperCase((String)name));
        if (allowedDigest != null) {
            LOGGER.warn("Requested algorithm might not be supported by the pdf specification.");
        }
        return allowedDigest;
    }

    public static int getOutputBitLength(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name of the digest algorithm is null.");
        }
        return bitLengths.get(name);
    }

    static {
        digestNames.put("1.2.840.113549.2.5", "MD5");
        digestNames.put("1.2.840.113549.2.2", "MD2");
        digestNames.put("1.3.14.3.2.26", "SHA1");
        digestNames.put("2.16.840.1.101.3.4.2.4", "SHA224");
        digestNames.put("2.16.840.1.101.3.4.2.1", "SHA256");
        digestNames.put("2.16.840.1.101.3.4.2.2", "SHA384");
        digestNames.put("2.16.840.1.101.3.4.2.3", "SHA512");
        digestNames.put("1.3.36.3.2.2", "RIPEMD128");
        digestNames.put("1.3.36.3.2.1", RIPEMD160);
        digestNames.put("1.3.36.3.2.3", "RIPEMD256");
        digestNames.put("1.2.840.113549.1.1.4", "MD5");
        digestNames.put("1.2.840.113549.1.1.2", "MD2");
        digestNames.put("1.2.840.113549.1.1.5", "SHA1");
        digestNames.put("1.2.840.113549.1.1.14", "SHA224");
        digestNames.put("1.2.840.113549.1.1.11", "SHA256");
        digestNames.put("1.2.840.113549.1.1.12", "SHA384");
        digestNames.put("1.2.840.113549.1.1.13", "SHA512");
        digestNames.put("1.2.840.10040.4.3", "SHA1");
        digestNames.put("2.16.840.1.101.3.4.3.1", "SHA224");
        digestNames.put("2.16.840.1.101.3.4.3.2", "SHA256");
        digestNames.put("2.16.840.1.101.3.4.3.3", "SHA384");
        digestNames.put("2.16.840.1.101.3.4.3.4", "SHA512");
        digestNames.put("1.3.36.3.3.1.3", "RIPEMD128");
        digestNames.put("1.3.36.3.3.1.2", RIPEMD160);
        digestNames.put("1.3.36.3.3.1.4", "RIPEMD256");
        digestNames.put("1.2.643.2.2.9", "GOST3411");
        digestNames.put("2.16.840.1.101.3.4.2.7", "SHA3-224");
        digestNames.put("2.16.840.1.101.3.4.2.8", SHA3_256);
        digestNames.put("2.16.840.1.101.3.4.2.9", SHA3_384);
        digestNames.put("2.16.840.1.101.3.4.2.10", SHA3_512);
        digestNames.put("2.16.840.1.101.3.4.2.12", SHAKE256);
        fixNames.put("SHA256", SHA256);
        fixNames.put("SHA384", SHA384);
        fixNames.put("SHA512", SHA512);
        allowedDigests.put("MD2", "1.2.840.113549.2.2");
        allowedDigests.put("MD-2", "1.2.840.113549.2.2");
        allowedDigests.put("MD5", "1.2.840.113549.2.5");
        allowedDigests.put("MD-5", "1.2.840.113549.2.5");
        allowedDigests.put("SHA1", "1.3.14.3.2.26");
        allowedDigests.put(SHA1, "1.3.14.3.2.26");
        allowedDigests.put("SHA224", "2.16.840.1.101.3.4.2.4");
        allowedDigests.put("SHA-224", "2.16.840.1.101.3.4.2.4");
        allowedDigests.put("SHA256", "2.16.840.1.101.3.4.2.1");
        allowedDigests.put(SHA256, "2.16.840.1.101.3.4.2.1");
        allowedDigests.put("SHA384", "2.16.840.1.101.3.4.2.2");
        allowedDigests.put(SHA384, "2.16.840.1.101.3.4.2.2");
        allowedDigests.put("SHA512", "2.16.840.1.101.3.4.2.3");
        allowedDigests.put(SHA512, "2.16.840.1.101.3.4.2.3");
        allowedDigests.put("RIPEMD128", "1.3.36.3.2.2");
        allowedDigests.put("RIPEMD-128", "1.3.36.3.2.2");
        allowedDigests.put(RIPEMD160, "1.3.36.3.2.1");
        allowedDigests.put("RIPEMD-160", "1.3.36.3.2.1");
        allowedDigests.put("RIPEMD256", "1.3.36.3.2.3");
        allowedDigests.put("RIPEMD-256", "1.3.36.3.2.3");
        allowedDigests.put("GOST3411", "1.2.643.2.2.9");
        allowedDigests.put("SHA3-224", "2.16.840.1.101.3.4.2.7");
        allowedDigests.put(SHA3_256, "2.16.840.1.101.3.4.2.8");
        allowedDigests.put(SHA3_384, "2.16.840.1.101.3.4.2.9");
        allowedDigests.put(SHA3_512, "2.16.840.1.101.3.4.2.10");
        allowedDigests.put(SHAKE256, "2.16.840.1.101.3.4.2.12");
        bitLengths.put("MD2", 128);
        bitLengths.put("MD-2", 128);
        bitLengths.put("MD5", 128);
        bitLengths.put("MD-5", 128);
        bitLengths.put("SHA1", 160);
        bitLengths.put(SHA1, 160);
        bitLengths.put("SHA224", 224);
        bitLengths.put("SHA-224", 224);
        bitLengths.put("SHA256", 256);
        bitLengths.put(SHA256, 256);
        bitLengths.put("SHA384", 384);
        bitLengths.put(SHA384, 384);
        bitLengths.put("SHA512", 512);
        bitLengths.put(SHA512, 512);
        bitLengths.put("RIPEMD128", 128);
        bitLengths.put("RIPEMD-128", 128);
        bitLengths.put(RIPEMD160, 160);
        bitLengths.put("RIPEMD-160", 160);
        bitLengths.put("RIPEMD256", 256);
        bitLengths.put("RIPEMD-256", 256);
        bitLengths.put("SHA3-224", 224);
        bitLengths.put(SHA3_256, 256);
        bitLengths.put(SHA3_384, 384);
        bitLengths.put(SHA3_512, 512);
        bitLengths.put(SHAKE256, 512);
    }
}

