/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagging;

import com.itextpdf.kernel.pdf.GenericNameTree;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.validation.context.DuplicateIdEntryValidationContext;

public class PdfStructIdTree
extends GenericNameTree {
    PdfStructIdTree(PdfDocument pdfDoc) {
        super(pdfDoc);
    }

    static PdfStructIdTree readFromDictionary(PdfDocument pdfDoc, PdfDictionary dict) {
        PdfStructIdTree structIdTree = new PdfStructIdTree(pdfDoc);
        structIdTree.setItems(GenericNameTree.readTree(dict));
        return structIdTree;
    }

    public PdfStructElem getStructElemById(PdfString id) {
        PdfObject rawObj = this.getItems().get(id);
        if (rawObj instanceof PdfIndirectReference) {
            rawObj = ((PdfIndirectReference)rawObj).getRefersTo();
        }
        if (rawObj instanceof PdfDictionary) {
            return new PdfStructElem((PdfDictionary)rawObj);
        }
        return null;
    }

    public PdfStructElem getStructElemById(byte[] id) {
        return this.getStructElemById(new PdfString(id));
    }

    @Override
    public void addEntry(PdfString key, PdfObject value) {
        super.addEntry(key, value, pdfDoc -> pdfDoc.checkIsoConformance(new DuplicateIdEntryValidationContext(key)));
    }
}

