/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.xobject;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.codec.PngWriter;
import com.itextpdf.io.codec.TiffWriter;
import com.itextpdf.kernel.actions.data.ITextCoreProductData;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.colorspace.PdfDeviceCs;
import com.itextpdf.kernel.pdf.colorspace.PdfSpecialCs;
import com.itextpdf.kernel.pdf.function.BaseInputOutPutConvertors;
import com.itextpdf.kernel.pdf.function.IPdfFunction;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.utils.BitmapImagePixels;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

class ImagePdfBytesInfo {
    private static final String TIFFTAG_SOFTWARE_VALUE = "iText\u00ae " + ITextCoreProductData.getInstance().getVersion() + " \u00a9" + ITextCoreProductData.getInstance().getSinceCopyrightYear() + "-" + ITextCoreProductData.getInstance().getToCopyrightYear() + " Apryse Group NV";
    private final int width;
    private final int height;
    private final List<IPdfFunction> colorTransformations = new ArrayList<IPdfFunction>();
    private final PdfImageXObject imageXObject;
    private final PdfImageXObject.ImageBytesRetrievalProperties properties;
    private double[] decodeArray = null;
    private int channels;
    private boolean alphaChannel;
    private int colorDepth;
    private Palette palette = null;
    private PdfColorSpace sourceColorSpace;
    private PdfColorSpace targetColorSpace;
    private PdfImageXObject transparencyMask;
    private OutputFileType outputFileType;
    private byte[] iccData;

    public ImagePdfBytesInfo(PdfImageXObject imageXObject, PdfImageXObject.ImageBytesRetrievalProperties properties) {
        this.properties = properties;
        this.imageXObject = imageXObject;
        if (properties.isApplyDecodeArray() && ((PdfStream)imageXObject.getPdfObject()).containsKey(PdfName.Decode)) {
            this.decodeArray = ((PdfStream)imageXObject.getPdfObject()).getAsArray(PdfName.Decode).toDoubleArray();
        }
        this.extractColorInfo(imageXObject);
        this.width = (int)imageXObject.getWidth();
        this.height = (int)imageXObject.getHeight();
    }

    public OutputFileType getImageType() {
        return this.outputFileType;
    }

    public byte[] getProcessedImageData(byte[] intialBytes) throws IOException {
        if (this.channels > 1 && this.colorDepth != 8 && this.colorDepth != 16) {
            throw new com.itextpdf.io.exceptions.IOException("The color depth {0} is not supported for color space {1}.").setMessageParams(new Object[]{this.colorDepth, this.sourceColorSpace.getName()});
        }
        byte[] data = PdfReader.decodeBytes(intialBytes, (PdfDictionary)this.imageXObject.getPdfObject());
        if (this.decodeArray != null && !this.isNeutralDecodeArray(this.decodeArray)) {
            data = this.applyDecoding(data);
        }
        for (IPdfFunction fct : this.colorTransformations) {
            data = fct.calculateFromByteArray(data, 0, data.length, 1, 1);
        }
        if (this.transparencyMask != null) {
            data = this.applytransparency(data);
        }
        ImageProcesser proc = this.outputFileType == OutputFileType.PNG ? new PngImageProcessor(data, this.transparencyMask, this.palette, this.iccData, this.targetColorSpace, this.colorDepth, this.width, this.height) : new TiffImageProcessor(data, this.transparencyMask, this.palette, this.iccData, this.targetColorSpace, this.colorDepth, this.width, this.height);
        return proc.processImage();
    }

    int getPngColorType() {
        if (this.outputFileType == OutputFileType.PNG) {
            PngImageProcessor proc = new PngImageProcessor(new byte[0], this.transparencyMask, this.palette, this.iccData, this.targetColorSpace, this.colorDepth, this.width, this.height);
            return proc.getColorTypeFromColorSpace(this.targetColorSpace).ordinal();
        }
        return -1;
    }

    private boolean isNeutralDecodeArray(double[] decodeArray) {
        for (int i = 0; i <= this.channels / 2; ++i) {
            if (!(decodeArray[i * 2] > 0.0) || !(decodeArray[i * 2 + 1] < 1.0)) continue;
            return false;
        }
        return true;
    }

    private void extractColorInfo(PdfImageXObject imageXObject) {
        PdfObject colorSpace;
        this.colorDepth = ((PdfStream)imageXObject.getPdfObject()).containsKey(PdfName.BitsPerComponent) ? ((PdfStream)imageXObject.getPdfObject()).getAsNumber(PdfName.BitsPerComponent).intValue() : 1;
        if (this.properties.isApplyTransparency() && ((PdfStream)imageXObject.getPdfObject()).containsKey(PdfName.SMask)) {
            this.alphaChannel = true;
            this.transparencyMask = new PdfImageXObject(((PdfStream)imageXObject.getPdfObject()).getAsStream(PdfName.SMask));
        }
        if (imageXObject.isMask() || imageXObject.isSoftMask()) {
            this.sourceColorSpace = new PdfDeviceCs.Gray();
            colorSpace = this.sourceColorSpace.getPdfObject();
        } else {
            colorSpace = ((PdfStream)imageXObject.getPdfObject()).get(PdfName.ColorSpace);
            this.sourceColorSpace = PdfColorSpace.makeColorSpace(colorSpace);
        }
        this.targetColorSpace = this.sourceColorSpace;
        this.outputFileType = OutputFileType.PNG;
        if (colorSpace.isName()) {
            switch (((PdfName)colorSpace).getValue()) {
                case "DeviceGray": {
                    this.channels = 1;
                    break;
                }
                case "DeviceRGB": {
                    this.channels = 3;
                    break;
                }
                case "DeviceCMYK": {
                    this.channels = 4;
                    this.outputFileType = OutputFileType.TIFF;
                    break;
                }
                default: {
                    throw new com.itextpdf.io.exceptions.IOException("The color space {0} is not supported.").setMessageParams(new Object[]{((PdfName)colorSpace).getValue()});
                }
            }
        } else if (colorSpace.isArray()) {
            PdfArray csArray = (PdfArray)colorSpace;
            switch (((PdfName)csArray.get(0)).getValue()) {
                case "Indexed": {
                    this.palette = new Palette(csArray, this.colorDepth);
                    long color0 = ImagePdfBytesInfo.isPaletteBlackAndWhite(this.palette);
                    if (this.colorDepth == 1 && color0 >= 0L) {
                        this.targetColorSpace = new PdfDeviceCs.Gray();
                        if (color0 == 1L && this.decodeArray == null) {
                            this.decodeArray = new double[]{1.0, 0.0};
                        }
                        this.palette = null;
                        break;
                    }
                    if ((!this.properties.isApplyTransparency() || !this.alphaChannel) && this.palette.getBaseColorspace().getNumberOfComponents() != 1) break;
                    this.targetColorSpace = this.palette.getBaseColorspace();
                    this.colorTransformations.add(new DeIndexingTransformation(this.palette));
                    this.palette = null;
                    break;
                }
                case "DeviceN": 
                case "NChannel": {
                    throw new com.itextpdf.io.exceptions.IOException("The color space {0} is not supported.").setMessageParams(new Object[]{csArray.get(0).toString()});
                }
                case "Separation": {
                    PdfSpecialCs.Separation separationCs = (PdfSpecialCs.Separation)this.sourceColorSpace;
                    if (this.properties.isApplyTintTransformations()) {
                        this.colorTransformations.add(separationCs.getTintTransformation());
                        this.targetColorSpace = separationCs.getBaseCs();
                        if (this.targetColorSpace.getName() != PdfName.DeviceRGB && this.targetColorSpace.getName() != PdfName.CalRGB) {
                            throw new UnsupportedOperationException("Only RGB alternate color spaces are currently supported for extracting separation color images");
                        }
                        if (this.colorDepth >= 8) break;
                        throw new com.itextpdf.io.exceptions.IOException("The color depth {0} is not supported for separation target color space {1}.").setMessageParams(new Object[]{this.colorDepth, this.targetColorSpace.getName()});
                    }
                    this.targetColorSpace = new PdfDeviceCs.Gray();
                    break;
                }
                case "ICCBased": {
                    int iccComponents;
                    PdfStream iccStream = null;
                    iccStream = csArray.get(1).isIndirectReference() ? (PdfStream)((PdfIndirectReference)csArray.get(1)).getRefersTo() : (PdfStream)csArray.get(1);
                    if (this.targetColorSpace.getNumberOfComponents() > 3) {
                        this.outputFileType = OutputFileType.TIFF;
                    }
                    if ((iccComponents = this.targetColorSpace.getNumberOfComponents()) != 1 && iccComponents != 3 && iccComponents != 4) {
                        throw new com.itextpdf.io.exceptions.IOException("N value {0} is not supported.").setMessageParams(new Object[]{iccComponents});
                    }
                    this.iccData = iccStream.getBytes();
                    break;
                }
                case "CalGray": 
                case "CalRGB": {
                    break;
                }
                default: {
                    throw new com.itextpdf.io.exceptions.IOException("The color space {0} is not supported.").setMessageParams(new Object[]{csArray.get(0)});
                }
            }
            this.channels = this.targetColorSpace.getNumberOfComponents();
        }
    }

    private static long isPaletteBlackAndWhite(Palette palette) {
        if (palette.getHiVal() > 1) {
            return -1L;
        }
        long color0 = -1L;
        for (int c = 0; c < palette.getBaseColorspace().getNumberOfComponents(); ++c) {
            block5: for (int i = 0; i < 2; ++i) {
                switch ((int)palette.getColor(i)[c]) {
                    case 0: {
                        if (i != 0) continue block5;
                        color0 = 0L;
                        continue block5;
                    }
                    case 255: {
                        if (i != 0) continue block5;
                        color0 = 1L;
                        continue block5;
                    }
                    default: {
                        return -1L;
                    }
                }
            }
        }
        return color0;
    }

    private byte[] applytransparency(byte[] imageData) {
        int maskMultiplier = 8 / ((PdfStream)this.transparencyMask.getPdfObject()).getAsNumber(PdfName.BitsPerComponent).intValue();
        byte[] mask = this.transparencyMask.getImageBytes(false);
        mask = PdfReader.decodeBytes(mask, (PdfDictionary)this.transparencyMask.getPdfObject());
        byte[] out = new byte[imageData.length / this.channels * (this.channels + 1)];
        BitmapImagePixels imageInPix = new BitmapImagePixels(this.width, this.height, this.colorDepth, this.channels, imageData);
        BitmapImagePixels imageOutPix = new BitmapImagePixels(this.width, this.height, this.colorDepth, this.channels + 1, out);
        BitmapImagePixels maskPix = new BitmapImagePixels(this.width, this.height, this.colorDepth, 1, mask);
        long[] nPix = new long[this.channels + 1];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                long[] oPix = imageInPix.getPixelAsLongs(x, y);
                System.arraycopy(oPix, 0, nPix, 0, this.channels);
                nPix[this.channels] = maskPix.getPixelAsLongs(x, y)[0] * (long)maskMultiplier;
                imageOutPix.setPixel(x, y, nPix);
            }
        }
        return imageOutPix.getData();
    }

    private byte[] applyDecoding(byte[] imageData) {
        BitmapImagePixels imagePixels = new BitmapImagePixels(this.width, this.height, this.colorDepth, this.sourceColorSpace.getNumberOfComponents(), imageData);
        double[] factors = new double[this.sourceColorSpace.getNumberOfComponents()];
        double[] floor = new double[this.sourceColorSpace.getNumberOfComponents()];
        for (int i = 0; i < this.sourceColorSpace.getNumberOfComponents(); ++i) {
            factors[i] = this.decodeArray[i * 2 + 1] - this.decodeArray[i * 2];
            floor[i] = this.decodeArray[i * 2] * (double)((1 << this.colorDepth) - 1);
        }
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                long[] pix = imagePixels.getPixelAsLongs(x, y);
                for (int c = 0; c < this.sourceColorSpace.getNumberOfComponents(); ++c) {
                    pix[c] = (long)(floor[c] + (double)pix[c] * factors[c]);
                }
                imagePixels.setPixel(x, y, pix);
            }
        }
        return imagePixels.getData();
    }

    private class DeIndexingTransformation
    implements IPdfFunction {
        private final Palette palette;

        public DeIndexingTransformation(Palette palette) {
            this.palette = palette;
        }

        @Override
        public int getFunctionType() {
            return -1;
        }

        @Override
        public boolean checkCompatibilityWithColorSpace(PdfColorSpace alternateSpace) {
            return this.palette.getBaseColorspace().equals(alternateSpace);
        }

        @Override
        public int getInputSize() {
            return 1;
        }

        @Override
        public int getOutputSize() {
            return this.palette.getBaseColorspace().getNumberOfComponents();
        }

        @Override
        public double[] getDomain() {
            return new double[]{0.0, 1.0};
        }

        @Override
        public void setDomain(double[] value) {
        }

        @Override
        public double[] getRange() {
            double[] range = new double[this.palette.getBaseColorspace().getNumberOfComponents() * 2];
            for (int i = 0; i < this.palette.getBaseColorspace().getNumberOfComponents(); ++i) {
                range[i * 2] = 0.0;
                range[i * 2 + 1] = 1.0;
            }
            return range;
        }

        @Override
        public void setRange(double[] value) {
        }

        @Override
        public double[] calculate(double[] input) {
            return new double[0];
        }

        @Override
        public byte[] calculateFromByteArray(byte[] bytes, int offset, int length, int wordSizeInputLength, int wordSizeOutputLength) throws IOException {
            byte[] output = new byte[this.palette.getBaseColorspace().getNumberOfComponents() * length * (9 - this.palette.getIndexBitDepth())];
            BitmapImagePixels indexedPixels = new BitmapImagePixels(ImagePdfBytesInfo.this.width, ImagePdfBytesInfo.this.height, ImagePdfBytesInfo.this.colorDepth, 1, bytes);
            BitmapImagePixels deIndexedPixels = new BitmapImagePixels(ImagePdfBytesInfo.this.width, ImagePdfBytesInfo.this.height, 8, this.palette.getBaseColorspace().getNumberOfComponents(), output);
            for (int y = 0; y < ImagePdfBytesInfo.this.height; ++y) {
                for (int x = 0; x < ImagePdfBytesInfo.this.width; ++x) {
                    long[] color = this.palette.getColor(indexedPixels.getPixelAsLongs(x, y)[0]);
                    deIndexedPixels.setPixel(x, y, color);
                }
            }
            return deIndexedPixels.getData();
        }

        @Override
        public byte[] calculateFromByteArray(byte[] bytes, int offset, int length, int wordSizeInputLength, int wordSizeOutputLength, BaseInputOutPutConvertors.IInputConversionFunction inputConvertor, BaseInputOutPutConvertors.IOutputConversionFunction outputConvertor) throws IOException {
            return new byte[0];
        }

        @Override
        public double[] clipInput(double[] input) {
            return new double[0];
        }

        @Override
        public double[] clipOutput(double[] input) {
            return new double[0];
        }

        @Override
        public PdfObject getAsPdfObject() {
            return null;
        }
    }

    private static class PngImageProcessor
    implements ImageProcesser {
        private final byte[] imageData;
        private final PdfImageXObject transparencyMask;
        private final PdfColorSpace colorSpace;
        private final int width;
        private final int height;
        private final int colorDepth;
        private final byte[] iccProfile;
        private final Palette palette;

        public PngImageProcessor(byte[] imageData, PdfImageXObject transparencyMask, Palette palette, byte[] iccProfile, PdfColorSpace colorSpace, int colorDepth, int width, int height) {
            this.imageData = imageData;
            this.transparencyMask = transparencyMask;
            this.palette = palette;
            this.iccProfile = iccProfile;
            this.colorSpace = colorSpace;
            this.colorDepth = colorDepth;
            this.width = width;
            this.height = height;
        }

        public PngColorType getColorTypeFromColorSpace(PdfColorSpace colorSpace) {
            switch (colorSpace.getNumberOfComponents()) {
                case 1: {
                    if (this.palette == null) {
                        if (this.transparencyMask == null) {
                            return PngColorType.GRAYSCALE;
                        }
                        return PngColorType.GRAYSCALE_ALPHA;
                    }
                    return PngColorType.PALETTE;
                }
                case 3: {
                    if (this.transparencyMask == null) {
                        return PngColorType.RGB;
                    }
                    return PngColorType.RGBA;
                }
            }
            throw new UnsupportedOperationException(MessageFormatUtil.format((String)"PngGeneration does not support {0} color components.", (Object[])new Object[]{colorSpace.getNumberOfComponents()}));
        }

        @Override
        public byte[] processImage() throws IOException {
            ByteArrayOutputStream ms = new ByteArrayOutputStream();
            PngWriter png = new PngWriter((OutputStream)ms);
            PngColorType colorType = this.getColorTypeFromColorSpace(this.colorSpace);
            png.writeHeader(this.width, this.height, this.colorDepth, colorType.ordinal());
            if (this.iccProfile != null) {
                png.writeIccProfile(this.iccProfile);
            }
            if (this.palette != null && this.palette.getPaletteData() != null) {
                png.writePalette(this.palette.getPaletteData());
            }
            int stride = (this.width * this.colorDepth * (this.colorSpace.getNumberOfComponents() + (this.transparencyMask == null ? 0 : 1)) + 7) / 8;
            png.writeData(this.imageData, stride);
            png.writeEnd();
            return ms.toByteArray();
        }
    }

    private static class TiffImageProcessor
    implements ImageProcesser {
        private final byte[] imageData;
        private final PdfImageXObject transparencyMask;
        private final PdfColorSpace colorSpace;
        private final int width;
        private final int height;
        private final int colorDepth;
        private final byte[] iccProfile;

        public TiffImageProcessor(byte[] imageData, PdfImageXObject transparencyMask, Palette palette, byte[] iccProfile, PdfColorSpace colorSpace, int colorDepth, int width, int height) {
            this.imageData = imageData;
            this.transparencyMask = transparencyMask;
            this.iccProfile = iccProfile;
            this.colorSpace = colorSpace;
            this.colorDepth = colorDepth;
            this.width = width;
            this.height = height;
        }

        @Override
        public byte[] processImage() throws IOException {
            ByteArrayOutputStream ms = new ByteArrayOutputStream();
            int samples = this.colorSpace.getNumberOfComponents();
            if (this.transparencyMask != null) {
                ++samples;
            }
            int[] bitsPerSample = new int[samples];
            for (int i = 0; i < samples; ++i) {
                bitsPerSample[i] = this.colorDepth;
            }
            int stride = samples * this.width;
            TiffWriter wr = new TiffWriter();
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldShort(277, this.colorSpace.getNumberOfComponents()));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldShort(258, bitsPerSample));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldShort(262, 5));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldLong(256, this.width));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldLong(257, this.height));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldShort(259, 5));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldShort(317, 2));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldLong(278, this.height));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldRational(282, new int[]{300, 1}));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldRational(283, new int[]{300, 1}));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldShort(296, 2));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldAscii(305, TIFFTAG_SOFTWARE_VALUE));
            ByteArrayOutputStream comp = new ByteArrayOutputStream();
            TiffWriter.compressLZW((OutputStream)comp, (int)2, (byte[])this.imageData, (int)this.height, (int)samples, (int)stride);
            byte[] buf = comp.toByteArray();
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldImage(buf));
            wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldLong(279, buf.length));
            if (this.iccProfile != null) {
                wr.addField((TiffWriter.FieldBase)new TiffWriter.FieldUndefined(34675, this.iccProfile));
            }
            wr.writeFile((OutputStream)ms);
            return ms.toByteArray();
        }
    }

    private static interface ImageProcesser {
        public byte[] processImage() throws IOException;
    }

    private static class Palette {
        private final PdfColorSpace baseColorspace;
        private final int hiVal;
        private final int indexBitDepth;
        private final byte[] paletteData;
        private final int paletteChannels;

        public Palette(PdfArray csArray, int indexBitDepth) {
            if (csArray.size() != 4) {
                throw new PdfException("Indexed color spaces require four array entries.");
            }
            this.indexBitDepth = indexBitDepth;
            this.baseColorspace = PdfColorSpace.makeColorSpace(csArray.get(1));
            this.paletteChannels = this.baseColorspace.getNumberOfComponents();
            this.hiVal = ((PdfNumber)csArray.get(2)).intValue();
            PdfObject data = csArray.get(3);
            this.paletteData = data.isStream() ? ((PdfStream)data).getBytes() : (byte[])(data.isString() ? ((PdfString)data).getValueBytes() : null);
        }

        public int getIndexBitDepth() {
            return this.indexBitDepth;
        }

        public byte[] getPaletteData() {
            return this.paletteData;
        }

        public PdfColorSpace getBaseColorspace() {
            return this.baseColorspace;
        }

        public long[] getColor(long index) {
            long[] result = new long[this.paletteChannels];
            for (int c = 0; c < this.paletteChannels; ++c) {
                result[c] = this.paletteData[(int)index * this.paletteChannels + c] & 0xFF;
            }
            return result;
        }

        public int getHiVal() {
            return this.hiVal;
        }
    }

    public static enum PngColorType {
        GRAYSCALE,
        INVALID_1,
        RGB,
        PALETTE,
        GRAYSCALE_ALPHA,
        INVALID_5,
        RGBA;

    }

    public static enum OutputFileType {
        TIFF,
        PNG;

    }
}

