/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.mappers.CharMapper;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.Range;

public final class MappedSequence
extends BasedSequenceImpl {
    private final CharMapper mapper;
    private final BasedSequence base;

    public CharMapper getCharMapper() {
        return this.mapper;
    }

    private MappedSequence(CharMapper mapper, CharSequence baseSeq) {
        this.base = MappedSequence.of(baseSeq);
        this.mapper = mapper;
    }

    private MappedSequence(CharMapper mapper, CharSequence baseSeq, int start) {
        this.base = MappedSequence.of(baseSeq, start);
        this.mapper = mapper;
    }

    private MappedSequence(CharMapper mapper, CharSequence baseSeq, int start, int end) {
        this.base = MappedSequence.of(baseSeq, start, end);
        this.mapper = mapper;
    }

    public static MappedSequence of(CharMapper mapper, CharSequence baseSeq) {
        return new MappedSequence(mapper, baseSeq);
    }

    public static MappedSequence of(CharMapper mapper, CharSequence baseSeq, int start) {
        return new MappedSequence(mapper, baseSeq, start);
    }

    public static MappedSequence of(CharMapper mapper, CharSequence baseSeq, int start, int end) {
        return new MappedSequence(mapper, baseSeq, start, end);
    }

    @Override
    public char charAt(int index) {
        char c = this.base.charAt(index);
        return this.mapper.map(c);
    }

    @Override
    public BasedSequence subSequence(int start, int end) {
        BasedSequence baseSequence = this.base.subSequence(start, end);
        return baseSequence == this.base ? this : new MappedSequence(this.mapper, baseSequence);
    }

    @Override
    public BasedSequence baseSubSequence(int start, int end) {
        BasedSequence baseSequence = this.base.subSequence(start, end);
        return baseSequence == this.base ? this : new MappedSequence(this.mapper, baseSequence);
    }

    @Override
    public Object getBase() {
        return this.base.getBase();
    }

    @Override
    public BasedSequence getBaseSequence() {
        return this.base.getBaseSequence();
    }

    @Override
    public int getStartOffset() {
        return this.base.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.base.getEndOffset();
    }

    @Override
    public int getIndexOffset(int index) {
        return this.base.getIndexOffset(index);
    }

    @Override
    public Range getSourceRange() {
        return this.base.getSourceRange();
    }

    @Override
    public int length() {
        return this.base.length();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.length());
        sb.append(this);
        return sb.toString();
    }
}

