/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.URIResolver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.XSLTTemplateProcessor;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.axis2.wsdl.util.ConfigPropertyFileLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public abstract class FileWriter {
    private static final Log log = LogFactory.getLog(FileWriter.class);
    protected File outputFileLocation = null;
    protected File outputFile = null;
    protected FileOutputStream stream = null;
    protected InputStream xsltStream = null;
    protected String language = ConfigPropertyFileLoader.getDefaultLanguage();
    protected static final String TEMPLATE_SUFFIX = ".template";
    protected static final String EXTENSION_SUFFIX = ".extension";
    protected static final String SEPARATOR_STRING = ",";
    protected boolean fileExists = false;
    protected boolean isOverride = false;

    public void setLanguage(String language) {
        this.language = language;
    }

    public void loadTemplate() throws CodeGenerationException {
        Class<?> clazz = this.getClass();
        Map languageSpecificPropertyMap = (Map)ConfigPropertyFileLoader.getLanguageSpecificPropertiesMap().get(this.language);
        if (languageSpecificPropertyMap == null) {
            throw new CodeGenerationException(CodegenMessages.getMessage("writer.noLangPropertiesExtension"));
        }
        String templateName = this.findTemplate(languageSpecificPropertyMap);
        if (templateName == null) {
            throw new CodeGenerationException(CodegenMessages.getMessage("writer.templateMissing"));
        }
        this.xsltStream = clazz.getResourceAsStream(templateName);
    }

    protected String findTemplate(Map languageSpecificPropertyMap) {
        String ownClazzName = this.getClass().getName();
        String templateName = null;
        Iterator keys = languageSpecificPropertyMap.keySet().iterator();
        while (keys.hasNext()) {
            String propertyValue;
            String key = keys.next().toString();
            if (!key.endsWith(TEMPLATE_SUFFIX) || !(propertyValue = languageSpecificPropertyMap.get(key).toString()).startsWith(ownClazzName)) continue;
            templateName = propertyValue.substring(propertyValue.indexOf(SEPARATOR_STRING) + 1);
            break;
        }
        return templateName;
    }

    public void createOutFile(String packageName, String fileName) throws Exception {
        this.outputFile = org.apache.axis2.util.FileWriter.createClassFile((File)this.outputFileLocation, (String)packageName, (String)fileName, (String)this.getFileExtensionForLanguage(this.language));
        if (this.isOverride) {
            this.stream = new FileOutputStream(this.outputFile);
        } else {
            this.fileExists = this.outputFile.exists();
            if (!this.fileExists) {
                this.stream = new FileOutputStream(this.outputFile);
            } else {
                log.info((Object)Messages.getMessage((String)"fileExistsNoOverwrite", (String)this.outputFile.toString()));
            }
        }
    }

    protected String getFileExtensionForLanguage(String language) {
        Map languageSpecificPropertyMap = (Map)ConfigPropertyFileLoader.getLanguageSpecificPropertiesMap().get(this.language);
        Iterator keys = languageSpecificPropertyMap.keySet().iterator();
        String extension = null;
        while (keys.hasNext()) {
            String key = keys.next().toString();
            if (!key.endsWith(EXTENSION_SUFFIX)) continue;
            extension = languageSpecificPropertyMap.get(key).toString();
            extension = "." + extension;
        }
        return extension;
    }

    public void parse(Document doc, URIResolver resolver) throws Exception {
        if (!this.fileExists || this.isOverride()) {
            XSLTTemplateProcessor.parse((OutputStream)this.stream, (Document)doc, (InputStream)this.xsltStream, (URIResolver)resolver);
            this.stream.flush();
            this.stream.close();
        }
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    public void setOverride(boolean override) {
        this.isOverride = override;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }
}

