/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.ReportFileDialoger;
import org.apache.jmeter.util.JMeterUtils;

public class ReportFilePanel
extends HorizontalPanel
implements ActionListener {
    private static final long serialVersionUID = 240L;
    private final JTextField filename = new JTextField(20);
    private final JLabel label = new JLabel(JMeterUtils.getResString((String)"file_visualizer_filename"));
    private final JButton browse = new JButton(JMeterUtils.getResString((String)"browse"));
    private final List<ChangeListener> listeners = new LinkedList<ChangeListener>();
    private final String title;
    private final String filetype;

    public ReportFilePanel() {
        this("");
    }

    public ReportFilePanel(String title) {
        this(title, null);
    }

    public ReportFilePanel(String title, String filetype) {
        this.title = title;
        this.filetype = filetype;
        this.init();
    }

    public ReportFilePanel(ChangeListener l, String title) {
        this(title);
        this.listeners.add(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    private void init() {
        this.setBorder(BorderFactory.createTitledBorder(this.title));
        this.add(this.label);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.filename);
        this.add(Box.createHorizontalStrut(5));
        this.filename.addActionListener(this);
        this.add(this.browse);
        this.browse.setActionCommand("browse");
        this.browse.addActionListener(this);
    }

    public void enableFile(boolean enable) {
        this.browse.setEnabled(enable);
        this.filename.setEnabled(enable);
    }

    public String getFilename() {
        return this.filename.getText();
    }

    public void setFilename(String f) {
        this.filename.setText(f);
    }

    private void fireFileChanged() {
        Iterator<ChangeListener> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            iter.next().stateChanged(new ChangeEvent(this));
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("browse")) {
            JFileChooser chooser = ReportFileDialoger.promptToOpenFile(new String[]{this.filetype});
            if (chooser != null && chooser.getSelectedFile() != null) {
                this.filename.setText(chooser.getSelectedFile().getPath());
                this.fireFileChanged();
            }
        } else {
            this.fireFileChanged();
        }
    }
}

