/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.gui.util.ReportMenuFactory;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.report.gui.AbstractReportGui;
import org.apache.jmeter.testelement.Table;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class TableGui
extends AbstractReportGui
implements ChangeListener {
    private static final long serialVersionUID = 240L;
    private JCheckBox meanCheck = new JCheckBox(JMeterUtils.getResString((String)"average"));
    private JCheckBox medianCheck = new JCheckBox(JMeterUtils.getResString((String)"graph_results_median"));
    private JCheckBox maxCheck = new JCheckBox(JMeterUtils.getResString((String)"aggregate_report_max"));
    private JCheckBox minCheck = new JCheckBox(JMeterUtils.getResString((String)"aggregate_report_min"));
    private JCheckBox responseRateCheck = new JCheckBox(JMeterUtils.getResString((String)"aggregate_report_rate"));
    private JCheckBox transferRateCheck = new JCheckBox(JMeterUtils.getResString((String)"aggregate_report_bandwidth"));
    private JCheckBox fiftypercentCheck = new JCheckBox(JMeterUtils.getResString((String)"monitor_label_left_middle"));
    private JCheckBox nintypercentCheck = new JCheckBox(JMeterUtils.getResString((String)"aggregate_report_90"));
    private JCheckBox errorRateCheck = new JCheckBox(JMeterUtils.getResString((String)"aggregate_report_error"));

    public TableGui() {
        this.init();
    }

    public String getLabelResource() {
        return "report_table";
    }

    private void init() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(this.makeBorder());
        this.setBackground(Color.white);
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout(10, 10));
        pane.setBackground(Color.white);
        pane.add((Component)this.getNamePanel(), "North");
        this.meanCheck.addChangeListener(this);
        VerticalPanel options = new VerticalPanel(Color.white);
        this.meanCheck.setBackground(Color.white);
        this.medianCheck.setBackground(Color.white);
        this.maxCheck.setBackground(Color.white);
        this.minCheck.setBackground(Color.white);
        this.responseRateCheck.setBackground(Color.white);
        this.transferRateCheck.setBackground(Color.white);
        this.fiftypercentCheck.setBackground(Color.white);
        this.nintypercentCheck.setBackground(Color.white);
        this.errorRateCheck.setBackground(Color.white);
        options.add((Component)this.meanCheck);
        options.add((Component)this.medianCheck);
        options.add((Component)this.maxCheck);
        options.add((Component)this.minCheck);
        options.add((Component)this.responseRateCheck);
        options.add((Component)this.transferRateCheck);
        options.add((Component)this.fiftypercentCheck);
        options.add((Component)this.nintypercentCheck);
        options.add((Component)this.errorRateCheck);
        this.add(pane, "North");
        this.add((Component)options, "Center");
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu pop = new JPopupMenu();
        ReportMenuFactory.addFileMenu(pop);
        ReportMenuFactory.addEditMenu(pop, true);
        return pop;
    }

    public TestElement createTestElement() {
        Table element = new Table();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        Table tb = (Table)element;
        tb.set50Percent(String.valueOf(this.fiftypercentCheck.isSelected()));
        tb.set90Percent(String.valueOf(this.nintypercentCheck.isSelected()));
        tb.setErrorRate(String.valueOf(this.errorRateCheck.isSelected()));
        tb.setMax(String.valueOf(this.maxCheck.isSelected()));
        tb.setMean(String.valueOf(this.meanCheck.isSelected()));
        tb.setMedian(String.valueOf(this.medianCheck.isSelected()));
        tb.setMin(String.valueOf(this.minCheck.isSelected()));
        tb.setResponseRate(String.valueOf(this.responseRateCheck.isSelected()));
        tb.setTransferRate(String.valueOf(this.transferRateCheck.isSelected()));
    }

    public void configure(TestElement element) {
        super.configure(element);
        Table tb = (Table)element;
        this.meanCheck.setSelected(tb.getMean());
        this.medianCheck.setSelected(tb.getMedian());
        this.maxCheck.setSelected(tb.getMax());
        this.minCheck.setSelected(tb.getMin());
        this.fiftypercentCheck.setSelected(tb.get50Percent());
        this.nintypercentCheck.setSelected(tb.get90Percent());
        this.errorRateCheck.setSelected(tb.getErrorRate());
        this.responseRateCheck.setSelected(tb.getResponseRate());
        this.transferRateCheck.setSelected(tb.getTransferRate());
    }

    public void stateChanged(ChangeEvent e) {
        this.modifyTestElement(ReportGuiPackage.getInstance().getCurrentElement());
    }
}

