/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.jmeter.report.DataSet;
import org.apache.jmeter.testelement.AbstractChart;
import org.apache.jmeter.visualizers.AxisGraph;
import org.apache.jmeter.visualizers.SamplingStatCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarChart
extends AbstractChart {
    private static final long serialVersionUID = 240L;
    public static final String REPORT_BAR_CHART_URL = "ReportChart.bar.chart.url";

    public String getURL() {
        return this.getPropertyAsString(REPORT_BAR_CHART_URL);
    }

    public void setURL(String url) {
        this.setProperty(REPORT_BAR_CHART_URL, url);
    }

    public double[][] convertToDouble(List<SamplingStatCalculator> data) {
        double[][] dataset = new double[1][data.size()];
        for (int idx = 0; idx < data.size(); ++idx) {
            SamplingStatCalculator stat = data.get(idx);
            dataset[0][idx] = this.getValue(stat);
        }
        return dataset;
    }

    @Override
    public JComponent renderChart(List<DataSet> data) {
        ArrayList<SamplingStatCalculator> dset = new ArrayList<SamplingStatCalculator>();
        ArrayList<String> xlabels = new ArrayList<String>();
        for (DataSet item : data) {
            SamplingStatCalculator ss = item.getStatistics(this.getURL());
            if (ss == null) continue;
            dset.add(ss);
            if (this.getXLabel().equals("Filename")) {
                xlabels.add(item.getDataSourceName());
                continue;
            }
            xlabels.add(item.getMonthDayYearDate());
        }
        double[][] dbset = this.convertToDouble(dset);
        return this.renderGraphics(dbset, xlabels.toArray(new String[xlabels.size()]));
    }

    public JComponent renderGraphics(double[][] data, String[] xAxisLabels) {
        AxisGraph panel = new AxisGraph();
        panel.setTitle(this.getTitle());
        panel.setData(data);
        panel.setXAxisLabels(xAxisLabels);
        panel.setYAxisLabels(this.getYLabel());
        panel.setXAxisTitle(this.getFormattedXAxis());
        panel.setYAxisTitle(this.getYAxis());
        int width = this.getWidth();
        int height = this.getHeight();
        panel.setPreferredSize(new Dimension(width, height));
        panel.setSize(new Dimension(width, height));
        panel.setWidth(width);
        panel.setHeight(width);
        this.setBufferedImage(new BufferedImage(width, height, 1));
        panel.paintComponent((Graphics)this.getBufferedImage().createGraphics());
        return panel;
    }
}

