/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.install;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.install.AbstractInstallMojo;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class InstallFileMojo
extends AbstractInstallMojo {
    protected String groupId;
    protected String artifactId;
    protected String version;
    protected String packaging;
    protected String classifier;
    private File file;
    private File pomFile;
    private boolean generatePom;
    private ArtifactFactory artifactFactory;
    private String repositoryLayout;
    private Map repositoryLayouts;
    private File localRepositoryPath;
    private String localRepositoryId;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block19: {
            if (StringUtils.isNotEmpty((String)this.localRepositoryId) && this.localRepositoryPath != null) {
                try {
                    ArtifactRepositoryLayout layout = (ArtifactRepositoryLayout)this.repositoryLayouts.get(this.repositoryLayout);
                    this.getLog().info((CharSequence)("Layout: " + layout.getClass()));
                    this.localRepository = new DefaultArtifactRepository(this.localRepositoryId, this.localRepositoryPath.toURL().toString(), layout);
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("MalformedURLException: " + e.getMessage(), (Exception)e);
                }
            }
            ProjectArtifactMetadata metadata = null;
            Artifact pomArtifact = null;
            File pom = null;
            if (this.pomFile != null && this.pomFile.exists()) {
                this.processModel(this.readPom(this.pomFile));
                pomArtifact = this.artifactFactory.createArtifact(this.groupId, this.artifactId, this.version, null, "pom");
            } else if (this.groupId == null || this.artifactId == null || this.version == null || this.packaging == null) {
                throw new MojoExecutionException("Missing group, artifact, version, or packaging information");
            }
            Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.packaging, this.classifier);
            if (this.generatePom) {
                FileWriter fw = null;
                try {
                    File tempFile = File.createTempFile("mvninstall", ".pom");
                    tempFile.deleteOnExit();
                    Model model = new Model();
                    model.setModelVersion("4.0.0");
                    model.setGroupId(this.groupId);
                    model.setArtifactId(this.artifactId);
                    model.setVersion(this.version);
                    model.setPackaging(this.packaging);
                    model.setDescription("POM was created from install:install-file");
                    fw = new FileWriter(tempFile);
                    tempFile.deleteOnExit();
                    new MavenXpp3Writer().write((Writer)fw, model);
                    metadata = new ProjectArtifactMetadata(artifact, tempFile);
                    artifact.addMetadata((ArtifactMetadata)metadata);
                }
                catch (IOException e) {
                    try {
                        throw new MojoExecutionException("Error writing temporary pom file: " + e.getMessage(), (Exception)e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(fw);
                        throw throwable;
                    }
                }
                IOUtil.close((Writer)fw);
            }
            try {
                String localPath = this.localRepository.pathOf(artifact);
                File destination = new File(this.localRepository.getBasedir(), localPath);
                if (!this.file.getPath().equals(destination.getPath())) {
                    this.installer.install(this.file, artifact, this.localRepository);
                    if (this.createChecksum) {
                        if (this.generatePom) {
                            pom = new File(this.localRepository.getBasedir(), this.localRepository.pathOfLocalRepositoryMetadata(metadata, this.localRepository));
                            this.installCheckSum(pom, true);
                        }
                        this.installCheckSum(this.file, artifact, false);
                    }
                    if (this.pomFile != null && this.pomFile.exists()) {
                        this.installer.install(this.pomFile, pomArtifact, this.localRepository);
                        if (this.createChecksum) {
                            this.installCheckSum(this.pomFile, pomArtifact, false);
                        }
                    }
                    break block19;
                }
                throw new MojoFailureException("Cannot install artifact. Artifact is already in the local repository.\n\nFile in question is: " + this.file + "\n");
            }
            catch (ArtifactInstallationException e) {
                throw new MojoExecutionException("Error installing artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Model readPom(File aFile) throws MojoExecutionException {
        Model model;
        FileReader reader = null;
        try {
            reader = new FileReader(aFile);
            MavenXpp3Reader mavenReader = new MavenXpp3Reader();
            model = mavenReader.read((Reader)reader);
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException("File not found " + aFile, (Exception)e);
                catch (IOException e2) {
                    throw new MojoExecutionException("Error reading pom", (Exception)e2);
                }
                catch (XmlPullParserException e3) {
                    throw new MojoExecutionException("Error reading pom", (Exception)((Object)e3));
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return model;
    }

    private void processModel(Model model) {
        Parent parent = model.getParent();
        if (this.groupId == null) {
            if (parent != null && parent.getGroupId() != null) {
                this.groupId = parent.getGroupId();
            }
            if (model.getGroupId() != null) {
                this.groupId = model.getGroupId();
            }
        }
        if (this.artifactId == null && model.getArtifactId() != null) {
            this.artifactId = model.getArtifactId();
        }
        if (this.version == null && model.getVersion() != null) {
            this.version = model.getVersion();
        }
        if (this.packaging == null && model.getPackaging() != null) {
            this.packaging = model.getPackaging();
        }
    }

    public String getLocalRepositoryId() {
        return this.localRepositoryId;
    }

    public void setLocalRepositoryId(String theLocalRepositoryId) {
        this.localRepositoryId = theLocalRepositoryId;
    }

    public File getLocalRepositoryPath() {
        return this.localRepositoryPath;
    }

    public void setLocalRepositoryPath(File theLocalRepositoryPath) {
        this.localRepositoryPath = theLocalRepositoryPath;
    }
}

