/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.resources;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.resources.MavenBuildTimestamp;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;

@Mojo(name="resources", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class ResourcesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter
    protected String propertiesEncoding;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.resources}", required=true, readonly=true)
    private List<Resource> resources;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.filters}", readonly=true)
    protected List<String> buildFilters;
    @Parameter
    protected List<String> filters;
    @Parameter(defaultValue="true")
    protected boolean useBuildFilters;
    @Inject
    protected MavenResourcesFiltering mavenResourcesFiltering;
    @Inject
    protected Map<String, MavenResourcesFiltering> mavenResourcesFilteringMap;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter
    protected String escapeString;
    @Parameter(defaultValue="false")
    private boolean overwrite;
    @Parameter(defaultValue="false")
    protected boolean includeEmptyDirs;
    @Parameter
    protected List<String> nonFilteredFileExtensions;
    @Parameter(defaultValue="true")
    protected boolean escapeWindowsPaths;
    @Parameter
    protected LinkedHashSet<String> delimiters;
    @Parameter(defaultValue="true")
    protected boolean useDefaultDelimiters;
    @Parameter(defaultValue="true")
    protected boolean addDefaultExcludes;
    @Parameter
    private List<String> mavenFilteringHints;
    private List<MavenResourcesFiltering> mavenFilteringComponents = new ArrayList<MavenResourcesFiltering>();
    @Parameter(defaultValue="false")
    private boolean supportMultiLineFiltering;
    @Parameter(defaultValue="false")
    private boolean fileNameFiltering;
    @Parameter(property="maven.resources.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping the execution.");
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.encoding) && this.isFilteringEnabled(this.getResources())) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + Charset.defaultCharset().displayName() + ". Build is platform dependent!"));
            this.getLog().warn((CharSequence)"See https://maven.apache.org/general.html#encoding-warning");
        }
        try {
            List<String> combinedFilters = this.getCombinedFiltersList();
            MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(this.getResources(), this.getOutputDirectory(), this.project, this.encoding, combinedFilters, Collections.emptyList(), this.session);
            mavenResourcesExecution.setEscapeWindowsPaths(this.escapeWindowsPaths);
            mavenResourcesExecution.setInjectProjectBuildFilters(false);
            mavenResourcesExecution.setEscapeString(this.escapeString);
            mavenResourcesExecution.setOverwrite(this.overwrite);
            mavenResourcesExecution.setIncludeEmptyDirs(this.includeEmptyDirs);
            mavenResourcesExecution.setSupportMultiLineFiltering(this.supportMultiLineFiltering);
            mavenResourcesExecution.setFilterFilenames(this.fileNameFiltering);
            mavenResourcesExecution.setAddDefaultExcludes(this.addDefaultExcludes);
            Properties additionalProperties = this.addSeveralSpecialProperties();
            mavenResourcesExecution.setAdditionalProperties(additionalProperties);
            mavenResourcesExecution.setDelimiters(this.delimiters, this.useDefaultDelimiters);
            mavenResourcesExecution.setPropertiesEncoding(this.propertiesEncoding);
            if (this.nonFilteredFileExtensions != null) {
                mavenResourcesExecution.setNonFilteredFileExtensions(this.nonFilteredFileExtensions);
            }
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
            this.executeUserFilterComponents(mavenResourcesExecution);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Properties addSeveralSpecialProperties() {
        String timeStamp = new MavenBuildTimestamp().formattedTimestamp();
        Properties additionalProperties = new Properties();
        additionalProperties.put("maven.build.timestamp", timeStamp);
        if (this.project.getBasedir() != null) {
            additionalProperties.put("project.baseUri", this.project.getBasedir().getAbsoluteFile().toURI().toString());
        }
        return additionalProperties;
    }

    protected void executeUserFilterComponents(MavenResourcesExecution mavenResourcesExecution) throws MojoExecutionException, MavenFilteringException {
        if (this.mavenFilteringHints != null) {
            for (String hint : this.mavenFilteringHints) {
                MavenResourcesFiltering userFilterComponent = this.mavenResourcesFilteringMap.get(hint);
                if (userFilterComponent != null) {
                    this.getLog().debug((CharSequence)("added user filter component with hint: " + hint));
                    this.mavenFilteringComponents.add(userFilterComponent);
                    continue;
                }
                throw new MojoExecutionException("User filter with hint `" + hint + "` requested, but not present. Discovered filters are: " + this.mavenResourcesFilteringMap.keySet());
            }
        } else {
            this.getLog().debug((CharSequence)"no user filter components");
        }
        if (this.mavenFilteringComponents != null && !this.mavenFilteringComponents.isEmpty()) {
            this.getLog().debug((CharSequence)"execute user filters");
            for (MavenResourcesFiltering filter : this.mavenFilteringComponents) {
                filter.filterResources(mavenResourcesExecution);
            }
        }
    }

    protected List<String> getCombinedFiltersList() {
        if (this.filters == null || this.filters.isEmpty()) {
            return this.useBuildFilters ? this.buildFilters : null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.useBuildFilters && this.buildFilters != null && !this.buildFilters.isEmpty()) {
            result.addAll(this.buildFilters);
        }
        result.addAll(this.filters);
        return result;
    }

    private boolean isFilteringEnabled(Collection<Resource> theResources) {
        if (theResources != null) {
            for (Resource resource : theResources) {
                if (!resource.isFiltering()) continue;
                return true;
            }
        }
        return false;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isIncludeEmptyDirs() {
        return this.includeEmptyDirs;
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }

    public List<String> getFilters() {
        return this.filters;
    }

    public void setFilters(List<String> filters) {
        this.filters = filters;
    }

    public LinkedHashSet<String> getDelimiters() {
        return this.delimiters;
    }

    public void setDelimiters(LinkedHashSet<String> delimiters) {
        this.delimiters = delimiters;
    }

    public boolean isUseDefaultDelimiters() {
        return this.useDefaultDelimiters;
    }

    public void setUseDefaultDelimiters(boolean useDefaultDelimiters) {
        this.useDefaultDelimiters = useDefaultDelimiters;
    }

    public boolean isSkip() {
        return this.skip;
    }
}

