/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeELResolver
extends ELResolver {
    private int size = 0;
    private ELResolver[] resolvers = new ELResolver[2];

    public void add(ELResolver elResolver) {
        if (elResolver == null) {
            throw new NullPointerException();
        }
        if (this.size >= this.resolvers.length) {
            ELResolver[] nr = new ELResolver[this.size * 2];
            System.arraycopy(this.resolvers, 0, nr, 0, this.size);
            this.resolvers = nr;
        }
        this.resolvers[this.size++] = elResolver;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        context.setPropertyResolved(false);
        int sz = this.size;
        Object result = null;
        for (int i = 0; i < sz; ++i) {
            result = this.resolvers[i].getValue(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return result;
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        context.setPropertyResolved(false);
        int sz = this.size;
        for (int i = 0; i < sz; ++i) {
            this.resolvers[i].setValue(context, base, property, value);
            if (!context.isPropertyResolved()) continue;
            return;
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        context.setPropertyResolved(false);
        int sz = this.size;
        boolean readOnly = false;
        for (int i = 0; i < sz; ++i) {
            readOnly = this.resolvers[i].isReadOnly(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return readOnly;
        }
        return false;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return new FeatureIterator(context, base, this.resolvers, this.size);
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        int sz = this.size;
        Class<?> commonType = null;
        Class<?> type = null;
        for (int i = 0; i < sz; ++i) {
            type = this.resolvers[i].getCommonPropertyType(context, base);
            if (type == null || commonType != null && !commonType.isAssignableFrom(type)) continue;
            commonType = type;
        }
        return commonType;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        context.setPropertyResolved(false);
        int sz = this.size;
        for (int i = 0; i < sz; ++i) {
            Class<?> type = this.resolvers[i].getType(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return type;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FeatureIterator
    implements Iterator<FeatureDescriptor> {
        private final ELContext context;
        private final Object base;
        private final ELResolver[] resolvers;
        private final int size;
        private Iterator<FeatureDescriptor> itr;
        private int idx;
        private FeatureDescriptor next;

        public FeatureIterator(ELContext context, Object base, ELResolver[] resolvers, int size) {
            this.context = context;
            this.base = base;
            this.resolvers = resolvers;
            this.size = size;
            this.idx = 0;
            this.guaranteeIterator();
        }

        private void guaranteeIterator() {
            while (this.itr == null && this.idx < this.size) {
                this.itr = this.resolvers[this.idx].getFeatureDescriptors(this.context, this.base);
                ++this.idx;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.itr != null) {
                while (this.next == null && this.itr.hasNext()) {
                    this.next = this.itr.next();
                }
            } else {
                return false;
            }
            if (this.next == null) {
                this.itr = null;
                this.guaranteeIterator();
            }
            return this.hasNext();
        }

        @Override
        public FeatureDescriptor next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            FeatureDescriptor next = this.next;
            this.next = null;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

