/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.adoc.integration;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigLOVValues;
import pt.digitalis.utils.config.annotations.ConfigSectionID;
import pt.digitalis.utils.config.annotations.ConfigVirtualPathForNode;

@ConfigID(value="ADOC")
@ConfigSectionID(value="Config/CSDnet integration")
@ConfigVirtualPathForNode(value="ADOC/CSDnet integration")
public class CSDnetConfigurations {
    private static CSDnetConfigurations configuration = null;
    private String teacherSyncMode;

    @ConfigIgnore
    public static CSDnetConfigurations getInstance() {
        if (configuration == null) {
            try {
                configuration = (CSDnetConfigurations)((IConfigurations)DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class)).readConfiguration(CSDnetConfigurations.class);
            }
            catch (ConfigurationException e) {
                configuration = null;
            }
        }
        return configuration;
    }

    @ConfigDefault(value="singledb")
    @ConfigLOVValues(value="singledb=Single database (ADOC and CSD are in the same database),twodbramcache=Separated databases Optimized (use RAM cache to sync both databases),twodbnocache=Separated databases low RAM (slower method with more IO to sync both databases)")
    public String getTeacherSyncMode() {
        return this.teacherSyncMode;
    }

    public void setTeacherSyncMode(String teacherSyncMode) {
        this.teacherSyncMode = teacherSyncMode;
    }

    @ConfigIgnore
    public boolean isSingleDatabase() {
        return this.getTeacherSyncMode().equals("singledb");
    }

    @ConfigIgnore
    public boolean isTeacherSyncRAMCacheModeEnabled() {
        return this.getTeacherSyncMode().equals("twodbramcache");
    }
}

