/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.adoc.integration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.hibernate.StatelessSession;
import org.hibernate.classic.Session;
import pt.digitalis.adoc.integration.CSDnetConfigurations;
import pt.digitalis.adoc.integration.InexistantTeacherInformationSystemIntegration;
import pt.digitalis.adoc.model.ADOCFactory;
import pt.digitalis.adoc.model.IADOCService;
import pt.digitalis.adoc.model.data.Teacher;
import pt.digitalis.adoc.model.data.TeacherProcess;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.IListProcessor;
import pt.digitalis.dif.model.dataset.ListDataSet;
import pt.digitalis.dif.model.hibernate.HibernateUtil;
import pt.digitalis.dif.model.sql.GenericBeanAttributes;
import pt.digitalis.dif.model.sql.SQLDataSet;
import pt.digitalis.dif.model.sql.SQLDialect;
import pt.digitalis.dif.presentation.views.jsp.objects.ajax.GenericServerProcessWorker;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.fcdnet.model.FCDnetFactory;
import pt.digitalis.log.LogLevel;
import pt.digitalis.utils.common.StringUtils;

public class CSDnetIntegrator
extends InexistantTeacherInformationSystemIntegration {
    @Override
    public boolean allowTeacherSynchonization() {
        return true;
    }

    @Override
    public boolean hasChangedActivities(TeacherProcess teacherProcess) throws DataSetException {
        Session adocSession = HibernateUtil.getSessionFactory((String)ADOCFactory.SESSION_FACTORY_NAME).getCurrentSession();
        adocSession.beginTransaction();
        StringBuffer bufferSQL = new StringBuffer();
        bufferSQL.append("select to_char(max(dt_operacao), 'dd-mm-yyyy hh24:mi:ss') max_date\n");
        bufferSQL.append("   from operacoes\n");
        bufferSQL.append("  where programa = 'FCD'\n");
        bufferSQL.append("    and tablename like 'T_PRODUCAO%'\n");
        bufferSQL.append("    and (\n");
        bufferSQL.append("       register_id in (select register_id from producao where id_docente = " + teacherProcess.getTeacher().getBusinessKey() + ") or\n");
        bufferSQL.append("       register_id in (select pc.register_id\n");
        bufferSQL.append("                         from producao_cientifica pc, producao p\n");
        bufferSQL.append("                        where p.id = pc.id_producao and id_docente = " + teacherProcess.getTeacher().getBusinessKey() + ") or\n");
        bufferSQL.append("       register_id in (select pc.register_id\n");
        bufferSQL.append("                         from producao_artistica pc, producao p\n");
        bufferSQL.append("                        where p.id = pc.id_producao and id_docente = " + teacherProcess.getTeacher().getBusinessKey() + ") or\n");
        bufferSQL.append("       register_id in (select pc.register_id\n");
        bufferSQL.append("                        from producao_tecnica pc, producao p\n");
        bufferSQL.append("                       where p.id = pc.id_producao and id_docente = " + teacherProcess.getTeacher().getBusinessKey() + "))\n");
        SQLDataSet maxDateDataSet = new SQLDataSet(FCDnetFactory.getSession(), bufferSQL.toString(), SQLDialect.ORACLE);
        GenericBeanAttributes maxChange = (GenericBeanAttributes)maxDateDataSet.query().singleValue();
        if (maxChange == null) {
            return false;
        }
        SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        try {
            Date maxChangeDate = df.parse(maxChange.getAttributeAsString("max_date"));
            return maxChangeDate.after(teacherProcess.getLastActivityImportDate());
        }
        catch (ParseException e) {
            return false;
        }
    }

    @Override
    public void syncRemoteTeachers(final GenericServerProcessWorker worker) {
        if (CSDnetConfigurations.getInstance().isSingleDatabase()) {
            StatelessSession adocSession = HibernateUtil.getSessionFactory((String)ADOCFactory.SESSION_FACTORY_NAME).openStatelessSession();
            try {
                adocSession.beginTransaction();
                Connection adocConnection = adocSession.connection();
                StringBuffer bufferMissingSQL = new StringBuffer();
                bufferMissingSQL.append("select cd_docente, nm_completo,\n");
                bufferMissingSQL.append("       nvl(email_inst, email) email,\n");
                bufferMissingSQL.append("       calc.devolve_ds_depart(cd_depart) departamento\n");
                bufferMissingSQL.append("from   vwdocente\n");
                bufferMissingSQL.append("where  activo = 'S'\n");
                bufferMissingSQL.append("and    cd_docente not in (select business_key from adoc.teacher where business_key is not null)\n");
                SQLDataSet sigesMissingTeachers = new SQLDataSet(adocConnection, bufferMissingSQL.toString(), SQLDialect.ORACLE);
                StringBuffer bufferChangedSQL = new StringBuffer();
                bufferChangedSQL.append("select d.cd_docente, d.nm_completo,\n");
                bufferChangedSQL.append("       nvl(d.email_inst, d.email) email,\n");
                bufferChangedSQL.append("       calc.devolve_ds_depart(d.cd_depart) departamento\n");
                bufferChangedSQL.append("from   vwdocente d, adoc.teacher t\n");
                bufferChangedSQL.append("where  d.activo = 'S'\n");
                bufferChangedSQL.append("and    t.business_key = d.cd_docente\n");
                bufferChangedSQL.append("and   ((d.nm_completo <> t.name) or\n");
                bufferChangedSQL.append("        nvl(nvl(d.email_inst, d.email), '-') <> nvl(t.email, '-') or\n");
                bufferChangedSQL.append("        nvl(calc.devolve_ds_depart(d.cd_depart), '-') <> nvl(t.department, '-'))\n");
                SQLDataSet sigesChangedTeachers = new SQLDataSet(FCDnetFactory.getSession(), bufferChangedSQL.toString(), SQLDialect.ORACLE);
                final Integer totalToInsert = new Long(sigesMissingTeachers.query().count()).intValue();
                Integer totalToUpdate = new Long(sigesChangedTeachers.query().count()).intValue();
                final Integer total = totalToInsert + totalToUpdate;
                DIFLogger.getLogger().debug((Object)"CSDIntegrator: Insert missing teachers...");
                AbstractProcessorSingleAction insertMissingTeachersProcessor = new AbstractProcessorSingleAction(adocConnection.prepareStatement("insert into adoc.teacher(name, email, department, business_key) values(?,?,?,?)")){

                    @Override
                    public void executeForRecord(GenericBeanAttributes record) throws SQLException {
                        this.ps.setString(1, record.getAttributeAsString("nm_completo"));
                        this.ps.setString(2, record.getAttributeAsString("email"));
                        this.ps.setString(3, record.getAttributeAsString("departamento"));
                        this.ps.setString(4, record.getAttributeAsString("cd_docente"));
                        this.ps.addBatch();
                        if (worker != null) {
                            worker.notify(Integer.valueOf(new Long(this.getProcessed()).intValue()), total);
                        }
                    }
                };
                sigesMissingTeachers.query().processList((IListProcessor)insertMissingTeachersProcessor);
                insertMissingTeachersProcessor.flushBatchCache();
                adocSession.getTransaction().commit();
                DIFLogger.getLogger().debug((Object)("CSDIntegrator: " + insertMissingTeachersProcessor.getProcessed() + " teachers inserted."));
                DIFLogger.getLogger().debug((Object)"CSDIntegrator: Update changed teachers...");
                adocSession.beginTransaction();
                adocConnection = adocSession.connection();
                AbstractProcessorSingleAction changedTeachersProcessor = new AbstractProcessorSingleAction(adocConnection.prepareStatement("update adoc.teacher set name = ?, email = ?, department = ? where business_key = ?")){

                    @Override
                    public void executeForRecord(GenericBeanAttributes record) throws SQLException {
                        this.ps.setString(1, record.getAttributeAsString("nm_completo"));
                        this.ps.setString(2, record.getAttributeAsString("email"));
                        this.ps.setString(3, record.getAttributeAsString("departamento"));
                        this.ps.setString(4, record.getAttributeAsString("cd_docente"));
                        this.ps.addBatch();
                        if (worker != null) {
                            worker.notify(Integer.valueOf(totalToInsert + new Long(this.getProcessed()).intValue()), total);
                        }
                    }
                };
                sigesChangedTeachers.query().processList((IListProcessor)changedTeachersProcessor);
                changedTeachersProcessor.flushBatchCache();
                adocSession.getTransaction().commit();
                DIFLogger.getLogger().debug((Object)("CSDIntegrator: " + changedTeachersProcessor.getProcessed() + " teachers updated."));
            }
            catch (Exception e) {
                new BusinessException("Error syncing teachers from CSD to ADOC", e).log(LogLevel.ERROR);
            }
        } else {
            StatelessSession adocSession = HibernateUtil.getSessionFactory((String)ADOCFactory.SESSION_FACTORY_NAME).openStatelessSession();
            adocSession.beginTransaction();
            Connection adocConnection = adocSession.connection();
            SQLDataSet sigesTeachers = new SQLDataSet(FCDnetFactory.getSession(), "select cd_docente, nm_completo, nvl(email_inst, email) email, calc.devolve_ds_depart(cd_depart) departamento from vwdocente d where activo = 'S'", SQLDialect.ORACLE);
            DIFLogger.getLogger().debug((Object)"CSDIntegrator: Syncing teachers...");
            try {
                final Integer total = new Long(sigesTeachers.query().count()).intValue();
                AbstractProcessorInsertOrUpdate teachersProcessor = new AbstractProcessorInsertOrUpdate(CSDnetConfigurations.getInstance().isTeacherSyncRAMCacheModeEnabled(), adocConnection.prepareStatement("insert into adoc.teacher(name, email, department, business_key) values(?,?,?,?)"), adocConnection.prepareStatement("update adoc.teacher set name = ?, email = ?, department = ? where business_key = ?")){

                    @Override
                    public void executeForRecord(GenericBeanAttributes record) throws SQLException, DataSetException {
                        Teacher adocTeacher = this.getTeacherInADOC(record.getAttributeAsString("cd_docente"));
                        PreparedStatement ps = null;
                        if (adocTeacher == null) {
                            ps = this.psInsert;
                            this.incrementInserted();
                        } else if (!(StringUtils.nvl((String)adocTeacher.getName(), (String)"").equals(record.getAttributeAsString("nm_completo")) && StringUtils.nvl((String)adocTeacher.getEmail(), (String)"").equals(record.getAttributeAsString("email")) && StringUtils.nvl((String)adocTeacher.getDepartment(), (String)"").equals(record.getAttributeAsString("departamento")))) {
                            ps = this.psUpdate;
                            this.incrementUpdated();
                        }
                        if (ps != null) {
                            ps.setString(1, record.getAttributeAsString("nm_completo"));
                            ps.setString(2, record.getAttributeAsString("email"));
                            ps.setString(3, record.getAttributeAsString("departamento"));
                            ps.setString(4, record.getAttributeAsString("cd_docente"));
                            ps.addBatch();
                        }
                        if (worker != null) {
                            worker.notify(Integer.valueOf(new Long(this.getInserted() + this.getUpdated()).intValue()), total);
                        }
                    }
                };
                sigesTeachers.query().processList((IListProcessor)teachersProcessor);
                teachersProcessor.flushBatchCache();
                adocSession.getTransaction().commit();
                DIFLogger.getLogger().debug((Object)("CSDIntegrator: " + teachersProcessor.getInserted() + " teachers inserted."));
                DIFLogger.getLogger().debug((Object)("CSDIntegrator: " + teachersProcessor.getUpdated() + " teachers updated."));
            }
            catch (Exception e) {
                new BusinessException("Error syncing teachers from CSD to ADOC", e).log(LogLevel.ERROR);
            }
        }
    }

    private abstract class AbstractProcessorSingleAction
    implements IListProcessor<GenericBeanAttributes> {
        protected long insertedInCurrentBatchSet = 0L;
        protected long procssed = 0L;
        protected PreparedStatement ps;

        public AbstractProcessorSingleAction(PreparedStatement ps) {
            this.ps = ps;
        }

        public abstract void executeForRecord(GenericBeanAttributes var1) throws SQLException;

        public void flushBatchCache() throws SQLException {
            if (this.insertedInCurrentBatchSet > 0L) {
                this.ps.executeBatch();
            }
            this.ps.close();
        }

        public Integer getFetchPageSize() {
            return 100;
        }

        public long getProcessed() {
            return this.procssed;
        }

        public boolean needsToConvertBeansToObjectArray() {
            return false;
        }

        public void processAllRecords(List<?> records) throws Exception {
            for (Object record : records) {
                this.processRecord(record);
            }
        }

        public void processRecord(Object record) throws Exception {
            this.executeForRecord((GenericBeanAttributes)record);
            this.ps.clearParameters();
            ++this.procssed;
            ++this.insertedInCurrentBatchSet;
            if (this.insertedInCurrentBatchSet >= 100L) {
                this.ps.executeBatch();
                this.insertedInCurrentBatchSet = 0L;
            }
        }
    }

    private abstract class AbstractProcessorInsertOrUpdate
    implements IListProcessor<GenericBeanAttributes> {
        protected long inserted = 0L;
        protected long insertedInCurrentBatchSet = 0L;
        protected PreparedStatement psInsert;
        protected PreparedStatement psUpdate;
        protected long updated = 0L;
        protected long updatedInCurrentBatchSet = 0L;
        IADOCService adocService = (IADOCService)DIFIoCRegistry.getRegistry().getImplementation(IADOCService.class);
        private ListDataSet<Teacher> cacheList = null;
        private boolean ramCache;

        public AbstractProcessorInsertOrUpdate(boolean ramCache, PreparedStatement psInsert, PreparedStatement psUpdate) {
            this.ramCache = ramCache;
            this.psInsert = psInsert;
            this.psUpdate = psUpdate;
        }

        public abstract void executeForRecord(GenericBeanAttributes var1) throws SQLException, DataSetException;

        public void flushBatchCache() throws SQLException {
            if (this.insertedInCurrentBatchSet > 0L) {
                this.psInsert.executeBatch();
            }
            this.psInsert.close();
            if (this.updatedInCurrentBatchSet > 0L) {
                this.psUpdate.executeBatch();
            }
            this.psUpdate.close();
        }

        public Integer getFetchPageSize() {
            return 100;
        }

        public long getInserted() {
            return this.inserted;
        }

        protected Teacher getTeacherInADOC(String businessKey) throws DataSetException {
            if (this.ramCache) {
                if (this.cacheList == null) {
                    this.cacheList = new ListDataSet(Teacher.class, "businessKey", this.adocService.getTeacherDataSet().query().asList());
                }
                return (Teacher)this.cacheList.get(businessKey);
            }
            return (Teacher)this.adocService.getTeacherDataSet().query().equals("businessKey", businessKey).singleValue();
        }

        public long getUpdated() {
            return this.updated;
        }

        public void incrementInserted() {
            ++this.inserted;
            ++this.insertedInCurrentBatchSet;
        }

        public void incrementUpdated() {
            ++this.updated;
            ++this.updatedInCurrentBatchSet;
        }

        public boolean needsToConvertBeansToObjectArray() {
            return false;
        }

        public void processAllRecords(List<?> records) throws Exception {
            for (Object record : records) {
                this.processRecord(record);
            }
        }

        public void processRecord(Object record) throws Exception {
            this.executeForRecord((GenericBeanAttributes)record);
            this.psInsert.clearParameters();
            this.psUpdate.clearParameters();
            if (this.insertedInCurrentBatchSet >= 100L) {
                this.psInsert.executeBatch();
                this.insertedInCurrentBatchSet = 0L;
            }
            if (this.updatedInCurrentBatchSet >= 100L) {
                this.psUpdate.executeBatch();
                this.updatedInCurrentBatchSet = 0L;
            }
        }
    }
}

