/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.adoc.integration;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.adoc.integration.ITeacherInformationSystem;
import pt.digitalis.adoc.model.ADOCFactory;
import pt.digitalis.adoc.model.IADOCService;
import pt.digitalis.adoc.model.data.EvaluationProcessGroupCrit;
import pt.digitalis.adoc.model.data.TeacherProcess;
import pt.digitalis.adoc.model.data.TeacherProcessActivity;
import pt.digitalis.adoc.model.data.TeacherProcessCriterion;
import pt.digitalis.dif.dem.managers.IDEMManager;
import pt.digitalis.dif.dem.managers.IMessageManager;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.ConditionOperator;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.FilterSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.JoinType;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.dif.model.dataset.SortMode;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.presentation.views.jsp.objects.ajax.GenericServerProcessWorker;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.utils.templates.TemplateUtils;
import pt.digitalis.fcdnet.model.IFCDnetService;
import pt.digitalis.fcdnet.model.data.Producao;
import pt.digitalis.fcdnet.model.data.ProducaoArtistica;
import pt.digitalis.fcdnet.model.data.ProducaoCientifica;
import pt.digitalis.fcdnet.model.data.ProducaoTecnica;
import pt.digitalis.fcdnet.model.data.TableCategAtividade;
import pt.digitalis.fcdnet.model.data.TableItemAtividade;
import pt.digitalis.log.LogLevel;
import pt.digitalis.utils.common.CollectionUtils;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.common.StringUtils;

public class InexistantTeacherInformationSystemIntegration
implements ITeacherInformationSystem {
    @Override
    public boolean allowActivityEdit() {
        return true;
    }

    @Override
    public boolean allowActivityImport() {
        return true;
    }

    @Override
    public boolean allowTeacherSynchonization() {
        return false;
    }

    @Override
    public String getActivitiesEditStage() {
        return "producoesdocente";
    }

    private Map<String, Map<String, Long>> getActivityTable(TeacherProcess teacherProcess, Long categoryID, String language, boolean onlyExistingTeacherActivities) throws DataSetException {
        Map<String, Long> keyEntry;
        String secondaryKey;
        String primaryKey;
        Query query;
        LinkedHashMap<String, Map<String, Long>> map = new LinkedHashMap<String, Map<String, Long>>();
        IFCDnetService fcdService = (IFCDnetService)DIFIoCRegistry.getRegistry().getImplementation(IFCDnetService.class);
        IADOCService adocService = (IADOCService)DIFIoCRegistry.getRegistry().getImplementation(IADOCService.class);
        Map fcdNetMessages = ((IMessageManager)DIFIoCRegistry.getRegistry().getImplementation(IMessageManager.class)).getMessages(((IDEMManager)DIFIoCRegistry.getRegistry().getImplementation(IDEMManager.class)).getApplication("fcdnet"), language);
        String teacherID = teacherProcess.getTeacher().getBusinessKey();
        ArrayList<String> criterionCategories = new ArrayList<String>();
        if (categoryID == null) {
            Query queryCriterionCategories = adocService.getTeacherProcessCriterionDataSet().query().equals(TeacherProcessCriterion.FK().teacherProcess().ID(), teacherProcess.getId().toString());
            queryCriterionCategories.addField(TeacherProcessCriterion.FK().evaluationProcessGroupCrit().activityCategory().INTEGRATORID());
            queryCriterionCategories.setDistinct(true);
            for (Object result : queryCriterionCategories.asSelectedColumnsList()) {
                TeacherProcessCriterion criterion = (TeacherProcessCriterion)result;
                criterionCategories.add(StringUtils.toStringOrNull((Object)criterion.getEvaluationProcessGroupCrit().getActivityCategory().getIntegratorId()));
            }
        } else {
            criterionCategories.add(categoryID.toString());
        }
        if (criterionCategories.isEmpty()) {
            return map;
        }
        String criterionCategoriesAsString = CollectionUtils.listToCommaSeparatedString(criterionCategories);
        if (StringUtils.isBlank((String)criterionCategoriesAsString)) {
            return map;
        }
        if (!onlyExistingTeacherActivities) {
            query = fcdService.getTableItemAtividadeDataSet().query().addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TableItemAtividade.FK().tableGrupoAtividade(), JoinType.NORMAL).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TableItemAtividade.FK().tableCategAtividade(), JoinType.LEFT_OUTER_JOIN).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TableItemAtividade.FK().tableGrupoAtividade().tableCategAtividade(), JoinType.LEFT_OUTER_JOIN);
            ((FilterSet)query.filterSet(ConditionOperator.OR)).in(TableItemAtividade.FK().tableCategAtividade().ID(), criterionCategoriesAsString).in(TableItemAtividade.FK().tableGrupoAtividade().tableCategAtividade().ID(), criterionCategoriesAsString);
            for (TableItemAtividade atividade : query.asList()) {
                primaryKey = (String)fcdNetMessages.get(atividade.getTableGrupoAtividade().getTipo());
                secondaryKey = atividade.getTableGrupoAtividade().getDescricao();
                if (!atividade.getTableGrupoAtividade().getDescricao().equals(atividade.getDescricao())) {
                    secondaryKey = secondaryKey + " \u00bb " + atividade.getDescricao();
                }
                if ((keyEntry = (LinkedHashMap<String, Long>)map.get(primaryKey)) == null) {
                    keyEntry = new LinkedHashMap<String, Long>();
                    map.put(primaryKey, keyEntry);
                }
                keyEntry.put(secondaryKey, 0L);
            }
        }
        query = fcdService.getProducaoDataSet().query().addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Producao.FK().tableItemAtividade(), JoinType.NORMAL).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Producao.FK().tableItemAtividade().tableGrupoAtividade(), JoinType.NORMAL).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Producao.FK().tableItemAtividade().tableCategAtividade(), JoinType.LEFT_OUTER_JOIN).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)Producao.FK().tableItemAtividade().tableGrupoAtividade().tableCategAtividade(), JoinType.LEFT_OUTER_JOIN).equals(Producao.FK().IDDOCENTE(), teacherID).sortBy(Producao.FK().tableItemAtividade().tableGrupoAtividade().TIPO()).sortBy(Producao.FK().tableItemAtividade().tableGrupoAtividade().ID()).sortBy(Producao.FK().tableItemAtividade().ID());
        ((FilterSet)query.filterSet(ConditionOperator.OR)).in(Producao.FK().tableItemAtividade().tableCategAtividade().ID(), criterionCategoriesAsString).in(Producao.FK().tableItemAtividade().tableGrupoAtividade().tableCategAtividade().ID(), criterionCategoriesAsString);
        for (Producao producao : query.asList()) {
            Long total;
            primaryKey = (String)fcdNetMessages.get(producao.getTableItemAtividade().getTableGrupoAtividade().getTipo());
            secondaryKey = producao.getTableItemAtividade().getTableGrupoAtividade().getDescricao();
            if (!producao.getTableItemAtividade().getTableGrupoAtividade().getDescricao().equals(producao.getTableItemAtividade().getDescricao())) {
                secondaryKey = secondaryKey + " \u00bb " + producao.getTableItemAtividade().getDescricao();
            }
            if ((keyEntry = (Map)map.get(primaryKey)) == null) {
                keyEntry = new LinkedHashMap();
                keyEntry.put(secondaryKey, 0L);
                map.put(primaryKey, keyEntry);
            }
            if ((total = (Long)keyEntry.get(secondaryKey)) == null) {
                keyEntry.put(secondaryKey, 1L);
                continue;
            }
            keyEntry.put(secondaryKey, total + 1L);
        }
        return map;
    }

    @Override
    public Map<String, Map<String, Long>> getActivityTable(TeacherProcess teacherProcess, String language, boolean onlyExistingTeacherActivities) throws DataSetException {
        return this.getActivityTable(teacherProcess, null, language, onlyExistingTeacherActivities);
    }

    @Override
    public Map<String, Map<String, Long>> getActivityTable(TeacherProcessCriterion teacherProcessCriterion, String language, boolean onlyExistingTeacherActivities) throws DataSetException {
        Long categoryID = null;
        if (teacherProcessCriterion != null) {
            EvaluationProcessGroupCrit crit = teacherProcessCriterion.getEvaluationProcessGroupCrit();
            while (categoryID == null && crit != null) {
                if (crit.getActivityCategory() != null) {
                    categoryID = crit.getActivityCategory().getId();
                    continue;
                }
                crit = crit.getEvaluationProcessGroupCrit();
            }
        }
        return this.getActivityTable(teacherProcessCriterion.getTeacherProcess(), categoryID, language, onlyExistingTeacherActivities);
    }

    @Override
    public Map<String, String> getCategoryList() {
        HashMap<String, String> results = new HashMap<String, String>();
        IFCDnetService fcdService = (IFCDnetService)DIFIoCRegistry.getRegistry().getImplementation(IFCDnetService.class);
        try {
            for (TableCategAtividade category : fcdService.getTableCategAtividadeDataSet().query().asList()) {
                results.put(category.getId().toString(), category.getDescricao());
            }
        }
        catch (DataSetException e) {
            new BusinessException("Error reading categories from the FCD table", (Exception)((Object)e)).log(LogLevel.ERROR);
        }
        return results;
    }

    private EvaluationProcessGroupCrit getGroupCritForActivity(TeacherProcess teacherProcess, Producao producao) throws DataSetException {
        TableCategAtividade remoteCategory = producao.getTableItemAtividade().getTableCategAtividade();
        if (remoteCategory == null) {
            remoteCategory = producao.getTableItemAtividade().getTableGrupoAtividade().getTableCategAtividade();
        }
        if (remoteCategory != null) {
            return (EvaluationProcessGroupCrit)((IADOCService)DIFIoCRegistry.getRegistry().getImplementation(IADOCService.class)).getEvaluationProcessGroupCritDataSet().query().equals(EvaluationProcessGroupCrit.FK().activityCategory().INTEGRATORID(), remoteCategory.getId().toString()).equals(EvaluationProcessGroupCrit.FK().evaluationProcessGroup().ID(), teacherProcess.getEvaluationProcessGroup().getId().toString()).sortBy("id").singleValue();
        }
        return null;
    }

    @Override
    public boolean hasActivities(TeacherProcess teacherProcess) throws DataSetException {
        IFCDnetService fcdService = (IFCDnetService)DIFIoCRegistry.getRegistry().getImplementation(IFCDnetService.class);
        Query queryProducoes = fcdService.getProducaoDataSet().query().equals("idDocente", teacherProcess.getTeacher().getBusinessKey());
        return queryProducoes.count() > 0L;
    }

    @Override
    public boolean hasChangedActivities(TeacherProcess teacherProcess) throws DataSetException {
        return false;
    }

    @Override
    public Long importTeacherActivities(TeacherProcess teacherProcess, GenericServerProcessWorker worker) throws DataSetException {
        boolean wasOpened = ADOCFactory.openTransaction();
        ADOCFactory.getSession().createQuery("delete from " + TeacherProcessActivity.class.getSimpleName() + " where " + TeacherProcessActivity.FK().teacherProcess().ID() + "=" + teacherProcess.getId()).executeUpdate();
        IFCDnetService fcdService = (IFCDnetService)DIFIoCRegistry.getRegistry().getImplementation(IFCDnetService.class);
        IADOCService adocService = (IADOCService)DIFIoCRegistry.getRegistry().getImplementation(IADOCService.class);
        long insertedCount = 0L;
        Query queryCientifica = fcdService.getProducaoCientificaDataSet().query().addJoin((AbstractBeanRelationsAttributes.AbstractRelations)ProducaoCientifica.FK().producao().tableItemAtividade().tableCategAtividade(), JoinType.LEFT_OUTER_JOIN).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)ProducaoCientifica.FK().producao().tableItemAtividade().tableGrupoAtividade(), JoinType.NORMAL).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)ProducaoCientifica.FK().producao().tableItemAtividade().tableGrupoAtividade().tableCategAtividade(), JoinType.LEFT_OUTER_JOIN).equals(ProducaoCientifica.FK().producao().IDDOCENTE(), teacherProcess.getTeacher().getBusinessKey()).sortBy(ProducaoCientifica.FK().producao().ANO(), SortMode.DESCENDING).sortBy(ProducaoCientifica.FK().producao().ID(), SortMode.DESCENDING);
        ((FilterSet)queryCientifica.filterSet(ConditionOperator.OR)).isNotNull(ProducaoCientifica.FK().producao().tableItemAtividade().tableCategAtividade().ID()).isNotNull(ProducaoCientifica.FK().producao().tableItemAtividade().tableGrupoAtividade().tableCategAtividade().ID());
        insertedCount += this.importTeacherActivities(teacherProcess, queryCientifica.asList(), (IDataSet<TeacherProcessActivity>)adocService.getTeacherProcessActivityDataSet(), ProducaoCientifica.FK().producao().path());
        Query queryArtistica = fcdService.getProducaoArtisticaDataSet().query().addJoin((AbstractBeanRelationsAttributes.AbstractRelations)ProducaoArtistica.FK().producao().tableItemAtividade().tableCategAtividade(), JoinType.LEFT_OUTER_JOIN).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)ProducaoArtistica.FK().producao().tableItemAtividade().tableGrupoAtividade(), JoinType.NORMAL).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)ProducaoArtistica.FK().producao().tableItemAtividade().tableGrupoAtividade().tableCategAtividade(), JoinType.LEFT_OUTER_JOIN).equals(ProducaoArtistica.FK().producao().IDDOCENTE(), teacherProcess.getTeacher().getBusinessKey()).sortBy(ProducaoArtistica.FK().producao().ANO(), SortMode.DESCENDING).sortBy(ProducaoArtistica.FK().producao().ID(), SortMode.DESCENDING);
        ((FilterSet)queryArtistica.filterSet(ConditionOperator.OR)).isNotNull(ProducaoArtistica.FK().producao().tableItemAtividade().tableCategAtividade().ID()).isNotNull(ProducaoArtistica.FK().producao().tableItemAtividade().tableGrupoAtividade().tableCategAtividade().ID());
        insertedCount += this.importTeacherActivities(teacherProcess, queryArtistica.asList(), (IDataSet<TeacherProcessActivity>)adocService.getTeacherProcessActivityDataSet(), ProducaoArtistica.FK().producao().path());
        Query queryTecnica = fcdService.getProducaoTecnicaDataSet().query().addJoin((AbstractBeanRelationsAttributes.AbstractRelations)ProducaoTecnica.FK().producao().tableItemAtividade().tableCategAtividade(), JoinType.LEFT_OUTER_JOIN).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)ProducaoTecnica.FK().producao().tableItemAtividade().tableGrupoAtividade(), JoinType.NORMAL).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)ProducaoTecnica.FK().producao().tableItemAtividade().tableGrupoAtividade().tableCategAtividade(), JoinType.LEFT_OUTER_JOIN).equals(ProducaoTecnica.FK().producao().IDDOCENTE(), teacherProcess.getTeacher().getBusinessKey()).sortBy(ProducaoTecnica.FK().producao().ANO(), SortMode.DESCENDING).sortBy(ProducaoTecnica.FK().producao().ID(), SortMode.DESCENDING);
        ((FilterSet)queryTecnica.filterSet(ConditionOperator.OR)).isNotNull(ProducaoTecnica.FK().producao().tableItemAtividade().tableCategAtividade().ID()).isNotNull(ProducaoTecnica.FK().producao().tableItemAtividade().tableGrupoAtividade().tableCategAtividade().ID());
        insertedCount += this.importTeacherActivities(teacherProcess, queryTecnica.asList(), (IDataSet<TeacherProcessActivity>)adocService.getTeacherProcessActivityDataSet(), ProducaoTecnica.FK().producao().path());
        if (!wasOpened) {
            ADOCFactory.getSession().getTransaction().commit();
        }
        return insertedCount;
    }

    private long importTeacherActivities(TeacherProcess teacherProcess, List<? extends IBeanAttributes> producoes, IDataSet<TeacherProcessActivity> teacherProcessActivityDataSet, String producaoPath) throws DataSetException {
        long insertedCount = 0L;
        for (IBeanAttributes iBeanAttributes : producoes) {
            Producao producao = (Producao)iBeanAttributes.getAttribute(producaoPath);
            EvaluationProcessGroupCrit groupCrit = this.getGroupCritForActivity(teacherProcess, producao);
            if (groupCrit != null) {
                TeacherProcessActivity activity = new TeacherProcessActivity();
                activity.setTeacherProcess(teacherProcess);
                activity.setEvaluationProcessGroupCrit(groupCrit);
                String activityTypeTemplate = producao.getTableItemAtividade().getTemplate();
                if (StringUtils.isBlank((String)activityTypeTemplate)) {
                    activityTypeTemplate = "${producao.anoProducao} ${producao.titulo}";
                }
                activity.setDescription(TemplateUtils.parseTemplateLine((String)activityTypeTemplate, (IBeanAttributes)iBeanAttributes));
                teacherProcessActivityDataSet.insert((IBeanAttributes)activity);
                ++insertedCount;
                continue;
            }
            TableCategAtividade remoteCategory = producao.getTableItemAtividade().getTableCategAtividade();
            if (remoteCategory == null) {
                remoteCategory = producao.getTableItemAtividade().getTableGrupoAtividade().getTableCategAtividade();
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("Could not import activity \"[" + producao.getId().toString() + "]");
            if (remoteCategory != null) {
                buffer.append("] " + producao.getTitulo() + "\" since no Criterion was associated with the remote category \"[" + remoteCategory.getId() + "] " + remoteCategory.getDescricao() + "\"");
            }
            DIFLogger.getLogger().debug((Object)buffer.toString());
        }
        IADOCService adocService = (IADOCService)DIFIoCRegistry.getRegistry().getImplementation(IADOCService.class);
        teacherProcess.setLastActivityImportDate(new Timestamp(new Date().getTime()));
        adocService.getTeacherProcessDataSet().update((IBeanAttributes)teacherProcess);
        return insertedCount;
    }

    @Override
    public void syncRemoteTeachers(GenericServerProcessWorker worker) {
        DIFLogger.getLogger().error((Object)"A call to syncRemoteTeachers was made when this feature is not supported by this integrator");
    }
}

