/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.adoc.integration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import pt.digitalis.adoc.model.data.TeacherProcess;
import pt.digitalis.adoc.model.impl.ADOCServiceImpl;
import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportInstance;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplate;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplateArea;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplateAreaSql;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.dif.reporting.engine.AbstractFreeMarkerReportTemplateContext;
import pt.digitalis.dif.reporting.engine.AbstractReportSurveyHelper;
import pt.digitalis.dif.reporting.engine.types.AreaType;
import pt.digitalis.dif.reporting.engine.types.ReportTemplateContextID;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

@ReportTemplateContextID(value="SIGESTemplates")
public class SIGESReportTemplateContextImpl
extends AbstractFreeMarkerReportTemplateContext {
    public static final String REPORT_ID = "SIGESTemplates";
    private static String TEMPLATE_PATH = "templates/siges";
    private static Map<String, String> sqlTemplates = new HashMap<String, String>();

    public void addDefaultAreasToTemplate(ReportTemplate reportTemplate) throws DataSetException {
        Long areaPos;
        Long l = areaPos = Long.valueOf(1L);
        Long l2 = areaPos = Long.valueOf(areaPos + 1L);
        this.criarAreaDocentesLecionamUC(reportTemplate, l);
        l = areaPos;
        l2 = areaPos = Long.valueOf(areaPos + 1L);
        this.criarAreaAnaliseResultadosAlunosUC(reportTemplate, l);
        l = areaPos;
        l2 = areaPos = Long.valueOf(areaPos + 1L);
        this.criarAreaComentariosSugestoes(reportTemplate, l);
    }

    private void criarAreaAnaliseResultadosAlunosUC(ReportTemplate reportTemplate, Long areaPos) throws DataSetException {
        ReportTemplateArea area = new ReportTemplateArea();
        area.setReportTemplate(reportTemplate);
        area.setTitle("An\u00e1lise dos resultados dos Alunos da UC");
        area.setShowTitle(true);
        area.setType(AreaType.FREE_MARKER.getDBRepresentation());
        area.setContent(this.getTemplateContent("modeloRUCAnaliseResultadosAlunos.ftl"));
        area.setCustomizable(false);
        area.setMandatory(false);
        area.setPosition(areaPos);
        area.setPrivate_(false);
        area = (ReportTemplateArea)this.getDBService().getReportTemplateAreaDataSet().insert((IBeanAttributes)area);
        ReportTemplateAreaSql areaSql = new ReportTemplateAreaSql();
        areaSql.setName("AvaliacaoUC");
        areaSql.setSql(sqlTemplates.get("AvaliacaoUC"));
        areaSql.setSqlDataSource(null);
        areaSql.setReportTemplateArea(area);
        this.getDBService().getReportTemplateAreaSqlDataSet().insert((IBeanAttributes)areaSql);
        areaSql = new ReportTemplateAreaSql();
        areaSql.setName("StatusNaoAvaliadosUC");
        areaSql.setSql(sqlTemplates.get("StatusNaoAvaliadosUC"));
        areaSql.setSqlDataSource(null);
        areaSql.setReportTemplateArea(area);
        this.getDBService().getReportTemplateAreaSqlDataSet().insert((IBeanAttributes)areaSql);
    }

    private void criarAreaComentariosSugestoes(ReportTemplate reportTemplate, Long areaPos) throws DataSetException {
        ReportTemplateArea area = new ReportTemplateArea();
        area.setReportTemplate(reportTemplate);
        area.setTitle("Coment\u00e1rios / Sugest\u00f5es");
        area.setShowTitle(true);
        area.setType(AreaType.HTML.getDBRepresentation());
        area.setContent(null);
        area.setCustomizable(true);
        area.setMandatory(false);
        area.setPosition(areaPos);
        area.setPrivate_(false);
        area = (ReportTemplateArea)this.getDBService().getReportTemplateAreaDataSet().insert((IBeanAttributes)area);
    }

    private void criarAreaDocentesLecionamUC(ReportTemplate reportTemplate, Long areaPos) throws DataSetException {
        ReportTemplateArea area = new ReportTemplateArea();
        area.setReportTemplate(reportTemplate);
        area.setTitle("Docentes que Leccionam a UC");
        area.setShowTitle(true);
        area.setType(AreaType.FREE_MARKER.getDBRepresentation());
        area.setContent(this.getTemplateContent("modeloRUCDocentes.ftl"));
        area.setCustomizable(false);
        area.setMandatory(false);
        area.setPosition(areaPos);
        area.setPrivate_(false);
        area = (ReportTemplateArea)this.getDBService().getReportTemplateAreaDataSet().insert((IBeanAttributes)area);
        ReportTemplateAreaSql areaSql = new ReportTemplateAreaSql();
        areaSql.setName("DocentesLeccionamUC");
        areaSql.setSql(sqlTemplates.get("DocentesLeccionamUC"));
        areaSql.setSqlDataSource(null);
        areaSql.setReportTemplateArea(area);
        this.getDBService().getReportTemplateAreaSqlDataSet().insert((IBeanAttributes)areaSql);
    }

    public Map<String, Object> getContextVarsForBusinessObject(IBeanAttributes businessObject) {
        CaseInsensitiveHashMap map = new CaseInsensitiveHashMap();
        TeacherProcess teacherProcess = (TeacherProcess)businessObject;
        map.put("businessKey", teacherProcess.getId().toString());
        return map;
    }

    public IBeanAttributes getReportInstanceAssociatedBusinessObjectByID(String businessKey) {
        IBeanAttributes result = null;
        try {
            Query query = new ADOCServiceImpl().getTeacherProcessDataSet().query();
            query.equals("id", businessKey);
            result = query.singleValue();
        }
        catch (DataSetException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<String, String> getSQLTemplates() {
        return sqlTemplates;
    }

    public AbstractReportSurveyHelper getSurveyHelperInstance(IDIFContext context, ReportInstance reportInstance) {
        return null;
    }

    private String getTemplateContent(String templateName) {
        File file = new File(Thread.currentThread().getContextClassLoader().getResource(TEMPLATE_PATH).getPath() + "/" + templateName);
        try {
            return FileUtils.readFileToString((File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getTemplateURL() {
        return null;
    }

    static {
        StringBuffer areaSQL = new StringBuffer();
        areaSQL.append("SELECT COUNT(DECODE(I.CD_STATUS, 5, null,1)) INSCRITOS,\n");
        areaSQL.append("       COUNT(DECODE(I.CD_STATUS, 5, 1,null)) ANULADOS,\n");
        areaSQL.append("       COUNT(DECODE(I.CD_STATUS, 2, 1, 3, DECODE(I.NR_NOT_FIN,NULL,NULL,0,NULL,1), NULL)) AVALIADOS,\n");
        areaSQL.append("       COUNT(DECODE(I.CD_STATUS, 2, NULL, 3, DECODE(I.NR_NOT_FIN,NULL,1,0,1,NULL),5, NULL, 1)) NAOAVALIADOS,\n");
        areaSQL.append("       COUNT(DECODE(I.CD_STATUS, 2, 1)) APROVADOS,\n");
        areaSQL.append("       COUNT(DECODE(I.CD_STATUS, 3,DECODE(I.NR_NOT_FIN,NULL,NULL,0,NULL,1))) REPROVADOS,\n");
        areaSQL.append("       COUNT(DECODE(I.CD_STATUS, 1, 1)) STATUS_INSCRITOS,\n");
        areaSQL.append("       COUNT(DECODE(TRUNC(I.NR_NOT_FIN) / 10, 1, 1, NULL)) CLASSIFICACAO10,\n");
        areaSQL.append("       COUNT(DECODE(TRUNC(I.NR_NOT_FIN) / 11, 1, 1, NULL)) CLASSIFICACAO11,\n");
        areaSQL.append("       COUNT(DECODE(TRUNC(I.NR_NOT_FIN) / 12, 1, 1, NULL)) CLASSIFICACAO12,\n");
        areaSQL.append("       COUNT(DECODE(TRUNC(I.NR_NOT_FIN) / 13, 1, 1, NULL)) CLASSIFICACAO13,\n");
        areaSQL.append("       COUNT(DECODE(TRUNC(I.NR_NOT_FIN) / 14, 1, 1, NULL)) CLASSIFICACAO14,\n");
        areaSQL.append("       COUNT(DECODE(TRUNC(I.NR_NOT_FIN) / 15, 1, 1, NULL)) CLASSIFICACAO15,\n");
        areaSQL.append("       COUNT(DECODE(TRUNC(I.NR_NOT_FIN) / 16, 1, 1, NULL)) CLASSIFICACAO16,\n");
        areaSQL.append("       COUNT(DECODE(TRUNC(I.NR_NOT_FIN) / 17, 1, 1, NULL)) CLASSIFICACAO17,\n");
        areaSQL.append("       COUNT(DECODE(TRUNC(I.NR_NOT_FIN) / 18, 1, 1, NULL)) CLASSIFICACAO18,\n");
        areaSQL.append("       COUNT(DECODE(TRUNC(I.NR_NOT_FIN) / 19, 1, 1, NULL)) CLASSIFICACAO19,\n");
        areaSQL.append("       COUNT(DECODE(TRUNC(I.NR_NOT_FIN) / 20, 1, 1, NULL)) CLASSIFICACAO20\n");
        areaSQL.append("  FROM RUC.T_RUC R, INSCRI I\n");
        areaSQL.append(" WHERE R.CD_LECTIVO = I.CD_LECTIVO\n");
        areaSQL.append("   AND R.CD_PERIODO = I.CD_DURACAO\n");
        areaSQL.append("   AND R.CD_DISCIP = I.CD_DISCIP\n");
        areaSQL.append("   AND NVL(R.CD_CURSO,I.CD_CUR_DIS) = I.CD_CUR_DIS \n");
        areaSQL.append("   AND I.CD_TIPDIS IN ( 1,2,3) /* Normal, N\u00e3o conta para M\u00e9dia, Qualitativa */ \n");
        areaSQL.append("   AND I.CD_TIP_INS = 1 /* Normal */ \n");
        areaSQL.append("   AND R.ID = :businessKey\n");
        sqlTemplates.put("AvaliacaoUC", areaSQL.toString());
        areaSQL = new StringBuffer();
        areaSQL.append("SELECT I.CD_STATUS codigoStatus, S.DS_STATUS descricaoStatus, COUNT(*) total\n");
        areaSQL.append("  FROM RUC.T_RUC R, INSCRI I, TBSTATUS S\n");
        areaSQL.append(" WHERE R.CD_LECTIVO = I.CD_LECTIVO \n");
        areaSQL.append("   AND R.CD_PERIODO = I.CD_DURACAO\n");
        areaSQL.append("   AND R.CD_DISCIP = I.CD_DISCIP\n");
        areaSQL.append("   AND NVL(R.CD_CURSO,I.CD_CUR_DIS) = I.CD_CUR_DIS \n");
        areaSQL.append("   AND I.CD_STATUS = S.CD_STATUS \n");
        areaSQL.append("   AND I.CD_STATUS NOT IN (2, 3, 5) \n");
        areaSQL.append("   AND R.ID = :businessKey\n");
        areaSQL.append(" GROUP BY I.CD_STATUS, S.DS_STATUS \n");
        sqlTemplates.put("StatusNaoAvaliadosUC", areaSQL.toString());
        areaSQL = new StringBuffer();
        areaSQL.append("SELECT DISTINCT C.CD_CURSO AS codigoCurso ,\n");
        areaSQL.append("       C.NM_CURSO ||\n");
        areaSQL.append("       DECODE(C.Nm_Cur_Abr,\n              NULL,\n");
        areaSQL.append("              '',\n");
        areaSQL.append("              DECODE(C.Nm_Cur_Abr,\n");
        areaSQL.append("                     TO_CHAR(C.CD_CURSO),\n");
        areaSQL.append("                     '',\n");
        areaSQL.append("                     ' (' || C.Nm_Cur_Abr || ')')) AS nomeCurso \n");
        areaSQL.append(" FROM RUC.T_RUC R, PLANDISC PD, DISOPCAO OPC, CURSOS C , PLANOS P \n");
        areaSQL.append(" WHERE PD.CD_GRUPO = OPC.CD_GRUPO(+)\n");
        areaSQL.append("   AND PD.Cd_Curso = C.Cd_Curso \n");
        areaSQL.append("   AND PD.CD_CURSO = P.CD_CURSO\n");
        areaSQL.append("   AND PD.Cd_Plano = P.CD_PLANO ");
        areaSQL.append("   AND NVL(OPC.CD_DISCIP, PD.CD_DISCIP) = R.CD_DISCIP \n");
        areaSQL.append("   AND NVL(R.CD_CURSO,C.CD_CURSO) = C.CD_CURSO \n");
        areaSQL.append("   AND PD.Cd_Activa = 'S' \n ");
        areaSQL.append("   AND C.CD_PUBLICO = 'S'\n");
        areaSQL.append("   AND C.CD_ACTIVO = 'S'\n");
        areaSQL.append("   AND P.CD_PUBLICO = 'S'\n");
        areaSQL.append("   AND P.CD_ACTIVO = 'S' ");
        areaSQL.append("   AND R.ID = :businessKey ");
        areaSQL.append("  order by c.cd_curso asc");
        sqlTemplates.put("CursosUC", areaSQL.toString());
        areaSQL = new StringBuffer();
        areaSQL.append("SELECT CD_DOCENTE AS codigoDocente,\n");
        areaSQL.append("       MANU_CSP.DEVOLVE_NM_FUNC_INT(CD_DOCENTE) AS nomeDocente\n");
        areaSQL.append("  FROM RUC.T_RUC R, CSD.T_REG_DOCENTE T, CSD.T_TBTIPO_REGENCIA TR\n");
        areaSQL.append(" WHERE T.CD_LECTIVO = R.CD_LECTIVO\n");
        areaSQL.append("   AND T.CD_DISCIP = R.CD_DISCIP\n");
        areaSQL.append("   AND T.ID_TIPO_REG = TR.ID\n");
        areaSQL.append("   AND TR.TIPO = 'D'\n");
        areaSQL.append("   AND NVL(R.CD_CURSO,-1) = NVL(T.FILTRO_CURSO,R.CD_CURSO)\n");
        areaSQL.append("   AND NVL(R.CD_PERIODO,-1) = NVL(T.FILTRO_PERIODO,R.CD_PERIODO)\n");
        areaSQL.append("   AND R.ID = :businessKey\n");
        sqlTemplates.put("ResponsaveisUC", areaSQL.toString());
        areaSQL = new StringBuffer();
        areaSQL.append("SELECT DISTINCT CALC.DEVOLVE_SIGLA_TIPO_TURMA(T.ID_TIPOLOGIA) codigoTipologia,\n");
        areaSQL.append("                CALC.DEVOLVE_DESC_TIPO_TURMA(T.ID_TIPOLOGIA) nomeTipologia\n");
        areaSQL.append("  FROM RUC.T_RUC R, TURMA T\n");
        areaSQL.append(" WHERE R.CD_LECTIVO = T.CD_LECTIVO\n");
        areaSQL.append("   AND R.CD_PERIODO = T.CD_DURACAO\n");
        areaSQL.append("   AND R.CD_DISCIP = T.CD_DISCIP\n");
        areaSQL.append("   AND R.ID = :businessKey\n");
        sqlTemplates.put("TipologiasUC", areaSQL.toString());
        areaSQL = new StringBuffer();
        areaSQL.append("SELECT CD_LECTIVO,\n");
        areaSQL.append("       CD_DISCIP,\n");
        areaSQL.append("       CD_DOCENTE CODIGODOCENTE,\n");
        areaSQL.append("       MANU_CSP.DEVOLVE_NM_FUNC_INT(CD_DOCENTE) NOMEDOCENTE,\n");
        areaSQL.append("       TIPOTURMA,\n");
        areaSQL.append("       MANU_CSH.DEVOLVE_TIPO_AULA(TIPOTURMA) DESCRICAOTIPOTURMA,\n");
        areaSQL.append("       SUM(HORASPREVISTAS) AS HORASPREVISTAS,\n");
        areaSQL.append("       SUM(HORASLECIONADAS) AS HORASLECIONADAS\n");
        areaSQL.append("  FROM (SELECT DT.CD_LECTIVO, DT.CD_DURACAO, DT.CD_DISCIP, DT.CD_DOCENTE, DT.CD_TURMA,\n");
        areaSQL.append("               CALC.DEVOLVE_TIPO_TURMA(DT.CD_TURMA, ''N'', DT.CD_LECTIVO,\n");
        areaSQL.append("                                       DT.CD_DURACAO, DT.CD_DISCIP) TIPOTURMA,\n");
        areaSQL.append("               DT.NR_HORA_ANUAL HORASPREVISTAS,\n");
        areaSQL.append("               (SELECT NVL(SUM(HORA_FINAL - HORA_INICIAL), 0) / 60\n");
        areaSQL.append("                  FROM DETALHE_AULA DA, SUMARIOS_AULAS SA\n");
        areaSQL.append("                 WHERE DA.CD_SUMARIO = SA.CD_SUMARIO\n");
        areaSQL.append("                   AND SA.CD_ESTADO = 1\n");
        areaSQL.append("                   AND DA.CD_LECTIVO = DT.CD_LECTIVO\n");
        areaSQL.append("                   AND DA.CD_PERIODO = DT.CD_DURACAO\n");
        areaSQL.append("                   AND DA.CD_DISCIP = DT.CD_DISCIP\n");
        areaSQL.append("                   AND DA.CD_TURMA = DT.CD_TURMA\n");
        areaSQL.append("                   AND DA.CD_DOCENTE = DT.CD_DOCENTE) HORASLECIONADAS\n");
        areaSQL.append("          FROM RUC.T_RUC R, DOC_TURMA DT\n");
        areaSQL.append("         WHERE R.CD_LECTIVO = DT.CD_LECTIVO\n");
        areaSQL.append("           AND R.CD_PERIODO = DT.CD_DURACAO\n");
        areaSQL.append("           AND R.CD_DISCIP = DT.CD_DISCIP\n");
        areaSQL.append("           AND NVL(R.CD_CURSO,-1) = DECODE(R.CD_CURSO,NULL,-1,MANU_CSD.DEVOLVE_CURSO_TURMA(DT.CD_LECTIVO, DT.CD_DURACAO, DT.CD_DISCIP, DT.CD_TURMA))\n");
        areaSQL.append("           AND R.ID = :businessKey) DT\n");
        areaSQL.append(" GROUP BY CD_LECTIVO, CD_DISCIP, CD_DOCENTE, TIPOTURMA\n");
        areaSQL.append(" ORDER BY CD_DOCENTE\n");
        sqlTemplates.put("DocentesLeccionamUC", areaSQL.toString());
    }
}

