/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.adoc.rules;

import pt.digitalis.adoc.rules.objects.TeacherUser;
import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.fcdnet.business.AbstractFCDTeacherUser;
import pt.digitalis.log.LogLevel;

public class ADOCFCDTeacherUser
extends AbstractFCDTeacherUser {
    private IDIFContext context;
    private TeacherUser teacherUser;

    public ADOCFCDTeacherUser() {
    }

    public ADOCFCDTeacherUser(IDIFContext context) {
        this.context = context;
        this.teacherUser = new TeacherUser(context);
    }

    public Long getTeacherCode() {
        try {
            return new Long(this.teacherUser.getTeacher().getBusinessKey());
        }
        catch (Exception e) {
            new BusinessException("Could not read the keyBusiness from the TeacherUser", e).addToExceptionContext(this.context).log(LogLevel.ERROR);
            return null;
        }
    }

    public String getTeacherName() {
        try {
            return this.teacherUser.getTeacher().getName();
        }
        catch (Exception e) {
            new BusinessException("Could not read the name from the TeacherUser", e).addToExceptionContext(this.context).log(LogLevel.ERROR);
            return null;
        }
    }

    public Boolean isTeacher() {
        try {
            return this.teacherUser.getTeacher() != null;
        }
        catch (Exception e) {
            new BusinessException("Could not read the Teacher from the TeacherUser", e).addToExceptionContext(this.context).log(LogLevel.ERROR);
            return null;
        }
    }

    public Object newUser(IDIFContext context) {
        return new ADOCFCDTeacherUser(context);
    }
}

