/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.adoc.rules;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.Date;
import org.hibernate.Session;
import pt.digitalis.adoc.model.IADOCService;
import pt.digitalis.adoc.model.data.EvaluationProcess;
import pt.digitalis.adoc.model.data.ProcessSignalling;
import pt.digitalis.adoc.model.data.ProcessState;
import pt.digitalis.adoc.model.data.Profile;
import pt.digitalis.adoc.model.data.Teacher;
import pt.digitalis.adoc.model.data.TeacherProcess;
import pt.digitalis.adoc.model.data.TeacherProcessHistory;
import pt.digitalis.adoc.rules.ADOCRules;
import pt.digitalis.adoc.rules.ADOCUserInfo;
import pt.digitalis.adoc.rules.ADOCUtils;
import pt.digitalis.adoc.rules.ProcessStateChangeNotifier;
import pt.digitalis.adoc.rules.exception.ADOCException;
import pt.digitalis.adoc.rules.objects.ProcessCommentType;
import pt.digitalis.adoc.rules.objects.ProcessStates;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplate;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.rules.IFlowManager;
import pt.digitalis.dif.rules.annotations.Flow;
import pt.digitalis.dif.rules.annotations.FlowAction;
import pt.digitalis.dif.rules.exceptions.MissingContextException;
import pt.digitalis.dif.rules.exceptions.flow.FlowException;
import pt.digitalis.dif.rules.objects.flow.AbstractFlow;
import pt.digitalis.dif.rules.objects.flow.FlowActionResult;
import pt.digitalis.dif.rules.objects.flow.FlowActionResults;
import pt.digitalis.dif.rules.objects.rules.RuleResult;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.config.ConfigurationException;
import pt.digitalis.utils.inspection.Named;

@Flow(name="ADOCFlows")
public abstract class ADOCFlow
extends AbstractFlow {
    private static IFlowManager flowManager = (IFlowManager)DIFIoCRegistry.getRegistry().getImplementation(IFlowManager.class);
    private ADOCRules adocRules;
    private IADOCService adocService;

    public static ADOCFlow getInstance() throws ADOCException {
        try {
            return (ADOCFlow)flowManager.getFlowInstance(ADOCFlow.class);
        }
        catch (MissingContextException e) {
            throw new ADOCException((Exception)((Object)e));
        }
        catch (FlowException e) {
            throw new ADOCException((Exception)((Object)e));
        }
    }

    @FlowAction(name="alterProfile", description="Alter the profile of the teacher process", conditionRule="ADOCRules.canAlterProfileTeacherProcess")
    public FlowActionResult<TeacherProcess> alterProfile(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo, @Named(value="profileID") Long profileID) throws DataSetException, ADOCException {
        FlowActionResult result = new FlowActionResult(FlowActionResults.SUCCESS);
        Profile profile = (Profile)this.getADOCService().getProfileDataSet().get(profileID.toString());
        teacherProcess.setProfile(profile);
        this.getADOCService().getTeacherProcessDataSet().update((IBeanAttributes)teacherProcess);
        ADOCRules.getInstance().addMissingCriterionsToTeacherProcess(teacherProcess.getId());
        teacherProcess = this.getADOCRules().getTeacherProcess(teacherProcess.getId());
        result.setValue((Object)teacherProcess);
        return result;
    }

    @FlowAction(name="commissionSubmitFinalReviewData", description="Commission submit final review of the evaluation of the teacher process", conditionRule="ADOCRules.canCommissionReviewProcess")
    public FlowActionResult<TeacherProcess> commissionSubmitFinalReviewData(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="finalReviewDate") Date finalReviewDate, @Named(value="finalReviewMinute") String finalReviewMinute) throws ADOCException, DataSetException {
        FlowActionResult result = new FlowActionResult(FlowActionResults.SUCCESS);
        teacherProcess.setFinalReviewDate(finalReviewDate);
        teacherProcess.setFinalReviewMinute(finalReviewMinute);
        this.getADOCService().getTeacherProcessDataSet().update((IBeanAttributes)teacherProcess);
        teacherProcess = this.getADOCRules().getTeacherProcess(teacherProcess.getId());
        result.setValue((Object)teacherProcess);
        return result;
    }

    @FlowAction(name="commissionSubmitReviewTeacherProcess", description="End the commission review of the evaluation of the teacher process", conditionRule="ADOCRules.canCommissionReviewProcess")
    public FlowActionResult<TeacherProcess> commissionSubmitReviewTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws ADOCException, DataSetException, ConfigurationException {
        FlowActionResult result = new FlowActionResult(FlowActionResults.SUCCESS);
        this.registerTeacherProcessStateChange(teacherProcess, userInfo, ProcessStates.REVIEWED);
        teacherProcess.setProcessState(ProcessStates.REVIEWED);
        this.getADOCService().getTeacherProcessDataSet().update((IBeanAttributes)teacherProcess);
        ProcessStateChangeNotifier.notifyStageChange(teacherProcess);
        teacherProcess = this.getADOCRules().getTeacherProcess(teacherProcess.getId());
        result.setValue((Object)teacherProcess);
        return result;
    }

    @FlowAction(name="evaluationSubmitRevisionRequestReply", description="Submit the revision request reply on the teacher process evaluation", conditionRule="ADOCRules.canEvaluatorReviewTeacherReviewRequest")
    public FlowActionResult<TeacherProcess> evaluationSubmitRevisionRequestReply(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="revisionRequestTitle") String revisionReplyTitle, @Named(value="revisionRequestDescription") String revisionReplyDescription, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo, @Named(value="comment") Teacher author, @Named(value="changeStage") Boolean changeState) throws ADOCException, DataSetException, ConfigurationException {
        FlowActionResult result = new FlowActionResult(FlowActionResults.SUCCESS);
        if (!userInfo.isEvaluator()) {
            result.setResult(FlowActionResults.FAILED);
            result.setException((Exception)new BusinessException("Only the Evaluator can review revision requests!"));
        } else {
            this.getADOCRules().updateTeacherProcessComment(teacherProcess, ProcessCommentType.REVIEW_COMMENT, revisionReplyTitle, revisionReplyDescription, author, changeState == false, false);
            if (changeState.booleanValue()) {
                this.registerTeacherProcessStateChange(teacherProcess, userInfo, ProcessStates.EVALUATED);
                teacherProcess.setProcessState(ProcessStates.EVALUATED);
                this.getADOCService().getTeacherProcessDataSet().update((IBeanAttributes)teacherProcess);
                ProcessStateChangeNotifier.notifyStageChange(teacherProcess);
            }
            teacherProcess = this.getADOCRules().getTeacherProcess(teacherProcess.getId());
            result.setValue((Object)teacherProcess);
        }
        return result;
    }

    @FlowAction(name="invalidateTeacherProcess", description="Invalidate a teacher process", conditionRule="ADOCRules.canEvaluatorReviewTeacherProcess")
    public FlowActionResult<TeacherProcess> evaluatorInvalidateTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws ADOCException, DataSetException, ConfigurationException {
        FlowActionResult result = new FlowActionResult(FlowActionResults.SUCCESS);
        this.registerTeacherProcessStateChange(teacherProcess, userInfo, ProcessStates.INVALID);
        teacherProcess.setProcessState(ProcessStates.INVALID);
        this.getADOCService().getTeacherProcessDataSet().update((IBeanAttributes)teacherProcess);
        ProcessStateChangeNotifier.notifyStageChange(teacherProcess);
        teacherProcess = this.getADOCRules().getTeacherProcess(teacherProcess.getId());
        result.setValue((Object)teacherProcess);
        return result;
    }

    @FlowAction(name="evaluatorReopenFillTeacherProcess", description="Reopens a teacher process for him to edit", conditionRule="ADOCRules.canEvaluatorReopenFillTeacherProcess")
    public FlowActionResult<TeacherProcess> evaluatorReopenFillTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws DataSetException, ConfigurationException, ADOCException {
        FlowActionResult result = new FlowActionResult(FlowActionResults.SUCCESS);
        this.registerTeacherProcessStateChange(teacherProcess, userInfo, ProcessStates.INVALID);
        teacherProcess.setProcessState(ProcessStates.INVALID);
        this.getADOCService().getTeacherProcessDataSet().update((IBeanAttributes)teacherProcess);
        ProcessStateChangeNotifier.notifyStageChange(teacherProcess);
        teacherProcess = this.getADOCRules().getTeacherProcess(teacherProcess.getId());
        result.setValue((Object)teacherProcess);
        return result;
    }

    @FlowAction(name="evaluatorReopenGradesTeacherProcess", description="Reopens the teacher process grade matrix for review", conditionRule="ADOCRules.canEvaluatorReopenGradesTeacherProcess")
    public FlowActionResult<TeacherProcess> evaluatorReopenGradesTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws DataSetException, ADOCException, ConfigurationException {
        FlowActionResult result = new FlowActionResult(FlowActionResults.SUCCESS);
        this.registerTeacherProcessStateChange(teacherProcess, userInfo, ProcessStates.VALIDATED);
        teacherProcess.setProcessState(ProcessStates.VALIDATED);
        this.getADOCService().getTeacherProcessDataSet().update((IBeanAttributes)teacherProcess);
        ProcessStateChangeNotifier.notifyStageChange(teacherProcess);
        teacherProcess = this.getADOCRules().getTeacherProcess(teacherProcess.getId());
        result.setValue((Object)teacherProcess);
        return result;
    }

    @FlowAction(name="evaluatorSubmitEvaluationTeacherProcess", description="Evaluate a teacher process (first phase evaluation, can still be challenged by the teacher)", conditionRule="ADOCRules.canEvaluatorGradeTeacherProcess")
    public FlowActionResult<TeacherProcess> evaluatorSubmitEvaluationTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws ADOCException, DataSetException, ConfigurationException {
        FlowActionResult result = new FlowActionResult(FlowActionResults.SUCCESS);
        this.registerTeacherProcessStateChange(teacherProcess, userInfo, ProcessStates.EVALUATED);
        teacherProcess.setProcessState(ProcessStates.EVALUATED);
        this.getADOCService().getTeacherProcessDataSet().update((IBeanAttributes)teacherProcess);
        ProcessStateChangeNotifier.notifyStageChange(teacherProcess);
        teacherProcess = this.getADOCRules().getTeacherProcess(teacherProcess.getId());
        result.setValue((Object)teacherProcess);
        return result;
    }

    @FlowAction(name="evaluatorSubmitFinalEvaluationTeacherProcess", description="Evaluate a teacher process (final evaluation)", conditionRule="ADOCRules.canEvaluatorFinalReviewTeacherProcess")
    public FlowActionResult<TeacherProcess> evaluatorSubmitFinalEvaluationTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws ADOCException, DataSetException, ConfigurationException {
        FlowActionResult result = new FlowActionResult(FlowActionResults.SUCCESS);
        this.registerTeacherProcessStateChange(teacherProcess, userInfo, ProcessStates.EVALUATED);
        teacherProcess.setProcessState(ProcessStates.EVALUATED);
        this.getADOCService().getTeacherProcessDataSet().update((IBeanAttributes)teacherProcess);
        ProcessStateChangeNotifier.notifyStageChange(teacherProcess);
        teacherProcess = this.getADOCRules().getTeacherProcess(teacherProcess.getId());
        result.setValue((Object)teacherProcess);
        return result;
    }

    @FlowAction(name="validateTeacherProcess", description="Validate a teacher process", conditionRule="ADOCRules.canEvaluatorReviewTeacherProcess")
    public FlowActionResult<TeacherProcess> evaluatorValidateTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws ADOCException, DataSetException, ConfigurationException {
        FlowActionResult result = new FlowActionResult(FlowActionResults.SUCCESS);
        this.registerTeacherProcessStateChange(teacherProcess, userInfo, ProcessStates.VALIDATED);
        teacherProcess.setProcessState(ProcessStates.VALIDATED);
        this.getADOCService().getTeacherProcessDataSet().update((IBeanAttributes)teacherProcess);
        ProcessStateChangeNotifier.notifyStageChange(teacherProcess);
        teacherProcess = this.getADOCRules().getTeacherProcess(teacherProcess.getId());
        result.setValue((Object)teacherProcess);
        return result;
    }

    protected ADOCRules getADOCRules() throws ADOCException {
        if (this.adocRules == null) {
            this.adocRules = ADOCRules.getInstance();
        }
        return this.adocRules;
    }

    protected IADOCService getADOCService() {
        if (this.adocService == null) {
            this.adocService = (IADOCService)DIFIoCRegistry.getRegistry().getImplementation(IADOCService.class);
        }
        return this.adocService;
    }

    @FlowAction(name="homologatorFinalizeTeacherProcess", description="Finalize a teacher process", conditionRule="ADOCRules.canHomologatorCompleteProcess")
    public FlowActionResult<TeacherProcess> homologatorFinalizeTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws ADOCException, DataSetException, ConfigurationException {
        FlowActionResult result = new FlowActionResult(FlowActionResults.SUCCESS);
        this.registerTeacherProcessStateChange(teacherProcess, userInfo, ProcessStates.COMPLETED);
        teacherProcess.setProcessState(ProcessStates.COMPLETED);
        this.getADOCService().getTeacherProcessDataSet().update((IBeanAttributes)teacherProcess);
        ProcessStateChangeNotifier.notifyStageChange(teacherProcess);
        teacherProcess = this.getADOCRules().getTeacherProcess(teacherProcess.getId());
        result.setValue((Object)teacherProcess);
        return result;
    }

    @FlowAction(name="homologatorSubmitComplaintReply", description="Submit the complaint reply on the teacher process evaluation", conditionRule="ADOCRules.canHomologatorSubmitComplaintReply")
    public FlowActionResult<TeacherProcess> homologatorSubmitComplaintReply(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="complaintReplyTitle") String complaintReplyTitle, @Named(value="complaintReply") String complaintReply, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo, @Named(value="comment") Teacher author, @Named(value="changeStage") Boolean changeState) throws DataSetException, ADOCException, IdentityManagerException, ConfigurationException {
        FlowActionResult result = new FlowActionResult(FlowActionResults.SUCCESS);
        if (!userInfo.isHomologator() && !userInfo.isBOUser()) {
            result.setResult(FlowActionResults.FAILED);
            result.setException((Exception)new BusinessException("Only the Homologator can review revision requests!"));
        } else {
            this.getADOCRules().updateTeacherProcessComment(teacherProcess, ProcessCommentType.COMPLAINT_COMMENT, complaintReplyTitle, complaintReply, author, changeState == false, false);
            if (changeState.booleanValue()) {
                this.registerTeacherProcessStateChange(teacherProcess, userInfo, ProcessStates.REVIEWED);
                teacherProcess.setProcessState(ProcessStates.REVIEWED);
                this.getADOCService().getTeacherProcessDataSet().update((IBeanAttributes)teacherProcess);
                ProcessStateChangeNotifier.notifyStageChange(teacherProcess);
            }
            teacherProcess = this.getADOCRules().getTeacherProcess(teacherProcess.getId());
            result.setValue((Object)teacherProcess);
        }
        return result;
    }

    @FlowAction(name="homologatorSubmitHomologationData", description="Homologator submit homologation data of the evaluation of the teacher process", conditionRule="ADOCRules.canHomologatorCompleteProcess")
    public FlowActionResult<TeacherProcess> homologatorSubmitHomologationData(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="homologationDate") Date homologationDate) throws ADOCException, DataSetException, ConfigurationException {
        FlowActionResult result = new FlowActionResult(FlowActionResults.SUCCESS);
        teacherProcess.setHomologationDate(homologationDate);
        this.getADOCService().getTeacherProcessDataSet().update((IBeanAttributes)teacherProcess);
        teacherProcess = this.getADOCRules().getTeacherProcess(teacherProcess.getId());
        result.setValue((Object)teacherProcess);
        return result;
    }

    protected void registerTeacherProcessStateChange(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="userInfo") ADOCUserInfo userInfo, @Named(value="newProcessState") ProcessState newProcessState) throws DataSetException {
        TeacherProcessHistory processHistory = new TeacherProcessHistory();
        processHistory.setTeacherProcess(teacherProcess);
        if (userInfo.getTeacherUser() != null) {
            processHistory.setTeacher(userInfo.getTeacherUser().getTeacher());
        }
        processHistory.setProcessStateByOldStateId(teacherProcess.getProcessState());
        processHistory.setProcessStateByNewStateId(newProcessState);
        processHistory.setSaveDate(new Date());
        processHistory.setEvaluationMonths(teacherProcess.getEvaluationMonths());
        processHistory.setComments(teacherProcess.getComments());
        processHistory.setGrade(teacherProcess.getGrade());
        if (teacherProcess.getQualitativeGrade() != null) {
            processHistory.setQualitativeGradeId(teacherProcess.getQualitativeGrade().getId());
        }
        processHistory.setTeacherGrade(teacherProcess.getTeacherGrade());
        this.getADOCService().getTeacherProcessHistoryDataSet().insert((IBeanAttributes)processHistory);
    }

    @FlowAction(name="replicateEvaluationProcess", description="Replicate the given evaluation process", conditionRule="ADOCRules.canReplicateEvaluationProcess")
    public FlowActionResult<EvaluationProcess> replicateEvaluationProcess(@Named(value="idProcessToReplicate") Long idProcessToReplicate, @Named(value="title") String title, @Named(value="startDate") Date startDate, @Named(value="endDate") Date endDate, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws Exception {
        ADOCRules rules;
        RuleResult<ReportTemplate> resultCopiar;
        FlowActionResult result = new FlowActionResult(FlowActionResults.SUCCESS);
        EvaluationProcess processToReplicate = (EvaluationProcess)this.getADOCService().getEvaluationProcessDataSet().get((Serializable)idProcessToReplicate);
        EvaluationProcess newProcess = new EvaluationProcess();
        newProcess.setTitle(title);
        newProcess.setStartDate(startDate);
        newProcess.setEndDate(endDate);
        newProcess.setFinalGradeCalcType(processToReplicate.getFinalGradeCalcType());
        newProcess.setCalcQualGradeByFormula(processToReplicate.isCalcQualGradeByFormula());
        newProcess.setBusinessUid(processToReplicate.getBusinessUid());
        newProcess.setProfile(processToReplicate.getProfile());
        newProcess.setEndDateToAlterProfile(processToReplicate.getEndDateToAlterProfile());
        newProcess.setCanHomologatorEditGrades(true);
        newProcess = (EvaluationProcess)this.getADOCService().getEvaluationProcessDataSet().insert((IBeanAttributes)newProcess);
        if (processToReplicate.getReportTemplateId() != null && !(resultCopiar = (rules = ADOCRules.getInstance()).copiarReportTemplate(processToReplicate.getReportTemplateId(), newProcess)).isSuccess()) {
            throw resultCopiar.getException();
        }
        result.setValue((Object)newProcess);
        StringBuffer query = new StringBuffer();
        query.append("begin\n");
        query.append("  replicate_evaluation_process(?,?);\n");
        query.append("end;");
        Session session = this.getADOCService().getEvaluationProcessDataSet().getSession();
        boolean wasActive = session.getTransaction().isActive();
        if (!wasActive) {
            session.beginTransaction();
        }
        Connection hibConnection = this.getADOCService().getEvaluationProcessDataSet().getSession().connection();
        CallableStatement storedProc = hibConnection.prepareCall(query.toString());
        int pos = 1;
        storedProc.setString(pos++, idProcessToReplicate.toString());
        storedProc.setString(pos++, newProcess.getId().toString());
        storedProc.execute();
        storedProc.close();
        hibConnection.close();
        if (!wasActive) {
            session.getTransaction().commit();
        }
        return result;
    }

    @FlowAction(name="signalProcess", description="Submit the signalling of the teacher process", conditionRule="ADOCRules.canEvaluatorSignalTeacherProcess")
    public FlowActionResult<TeacherProcess> signalProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="signallingID") Long signallingID, @Named(value="signallingJustification") String signallingJustification, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo, @Named(value="comment") Teacher author) throws DataSetException, ADOCException, IdentityManagerException, ConfigurationException {
        FlowActionResult result = new FlowActionResult(FlowActionResults.SUCCESS);
        if (userInfo.isMyProcess(teacherProcess)) {
            result.setResult(FlowActionResults.FAILED);
            result.setException((Exception)new BusinessException("The teacher can't signal is own process!"));
        } else {
            ProcessSignalling processSignalling = (ProcessSignalling)this.getADOCService().getProcessSignallingDataSet().get(signallingID.toString());
            this.getADOCRules().updateTeacherProcessComment(teacherProcess, ProcessCommentType.SIGNAL_COMMENT, ADOCUtils.getADOCAppMessages(language).get("signalProcessTitle") + " " + processSignalling.getDescription(), signallingJustification, author, false, true);
            teacherProcess.setProcessSignalling(processSignalling);
            this.getADOCService().getTeacherProcessDataSet().update((IBeanAttributes)teacherProcess);
            teacherProcess = this.getADOCRules().getTeacherProcess(teacherProcess.getId());
            result.setValue((Object)teacherProcess);
        }
        return result;
    }

    @FlowAction(name="teacherSubmitComplaint", description="Submit a complaint on the teacher process evaluation", conditionRule="ADOCRules.canTeacherFileComplaint")
    public FlowActionResult<TeacherProcess> teacherSubmitComplaint(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="complaintTitle") String complaintTitle, @Named(value="complaintDescription") String complaintDescription, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo, @Named(value="changeStage") Boolean changeState) throws ADOCException, DataSetException, ConfigurationException {
        FlowActionResult result = new FlowActionResult(FlowActionResults.SUCCESS);
        if (!userInfo.isMyProcess(teacherProcess)) {
            result.setResult(FlowActionResults.FAILED);
            result.setException((Exception)new BusinessException("Only the teacher can submit revision requests!"));
        } else {
            this.getADOCRules().updateTeacherProcessComment(teacherProcess, ProcessCommentType.COMPLAINT_REQUEST, complaintTitle, complaintDescription, teacherProcess.getTeacher(), changeState == false, false);
            if (changeState.booleanValue()) {
                this.registerTeacherProcessStateChange(teacherProcess, userInfo, ProcessStates.EVALUATED_PENDING_COMPLAINT);
                teacherProcess.setProcessState(ProcessStates.EVALUATED_PENDING_COMPLAINT);
                this.getADOCService().getTeacherProcessDataSet().update((IBeanAttributes)teacherProcess);
                ProcessStateChangeNotifier.notifyStageChange(teacherProcess);
            }
            teacherProcess = this.getADOCRules().getTeacherProcess(teacherProcess.getId());
            result.setValue((Object)teacherProcess);
        }
        return result;
    }

    @FlowAction(name="teacherSubmitRevisionRequest", description="Submit a revision request on the teacher process evaluation", conditionRule="ADOCRules.canTeacherRequestRevision")
    public FlowActionResult<TeacherProcess> teacherSubmitRevisionRequest(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="revisionRequestTitle") String revisionRequestTitle, @Named(value="revisionRequestDescription") String revisionRequestDescription, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo, @Named(value="changeStage") Boolean changeState) throws ADOCException, DataSetException, ConfigurationException {
        FlowActionResult result = new FlowActionResult(FlowActionResults.SUCCESS);
        if (!userInfo.isMyProcess(teacherProcess)) {
            result.setResult(FlowActionResults.FAILED);
            result.setException((Exception)new BusinessException("Only the teacher can submit revision requests!"));
        } else {
            this.getADOCRules().updateTeacherProcessComment(teacherProcess, ProcessCommentType.REVIEW_REQUEST, revisionRequestTitle, revisionRequestDescription, teacherProcess.getTeacher(), changeState == false, false);
            if (changeState.booleanValue()) {
                this.registerTeacherProcessStateChange(teacherProcess, userInfo, ProcessStates.EVALUATED_PENDING_REVISION);
                teacherProcess.setProcessState(ProcessStates.EVALUATED_PENDING_REVISION);
                this.getADOCService().getTeacherProcessDataSet().update((IBeanAttributes)teacherProcess);
                ProcessStateChangeNotifier.notifyStageChange(teacherProcess);
            }
            teacherProcess = this.getADOCRules().getTeacherProcess(teacherProcess.getId());
            result.setValue((Object)teacherProcess);
        }
        return result;
    }

    @FlowAction(name="submitTeacherProcess", description="Submit a teacher process", conditionRule="ADOCRules.canTeacherSubmitProcess")
    public FlowActionResult<TeacherProcess> teacherSubmitTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws ADOCException, DataSetException, ConfigurationException {
        FlowActionResult result = new FlowActionResult(FlowActionResults.SUCCESS);
        this.registerTeacherProcessStateChange(teacherProcess, userInfo, ProcessStates.FILLED);
        teacherProcess.setProcessState(ProcessStates.FILLED);
        this.getADOCService().getTeacherProcessDataSet().update((IBeanAttributes)teacherProcess);
        ProcessStateChangeNotifier.notifyStageChange(teacherProcess);
        teacherProcess = this.getADOCRules().getTeacherProcess(teacherProcess.getId());
        result.setValue((Object)teacherProcess);
        return result;
    }
}

