/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.adoc.rules;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import pt.digitalis.adoc.ADOCConfigurations;
import pt.digitalis.adoc.integration.ITeacherInformationSystem;
import pt.digitalis.adoc.model.ADOCFactory;
import pt.digitalis.adoc.model.IADOCService;
import pt.digitalis.adoc.model.data.EvaluationProcess;
import pt.digitalis.adoc.model.data.EvaluationProcessComission;
import pt.digitalis.adoc.model.data.EvaluationProcessEvaluator;
import pt.digitalis.adoc.model.data.EvaluationProcessGroupCrit;
import pt.digitalis.adoc.model.data.EvaluationProcessGroupFile;
import pt.digitalis.adoc.model.data.EvaluationProcessGroupProf;
import pt.digitalis.adoc.model.data.EvaluationProcessStep;
import pt.digitalis.adoc.model.data.EvaluationProcessSurvey;
import pt.digitalis.adoc.model.data.QualitativeGrade;
import pt.digitalis.adoc.model.data.Teacher;
import pt.digitalis.adoc.model.data.TeacherEvaluatorStep;
import pt.digitalis.adoc.model.data.TeacherProcess;
import pt.digitalis.adoc.model.data.TeacherProcessComment;
import pt.digitalis.adoc.model.data.TeacherProcessCriterion;
import pt.digitalis.adoc.model.data.TeacherProcessEvaluator;
import pt.digitalis.adoc.model.data.TeacherProcessFile;
import pt.digitalis.adoc.rules.ADOCUserInfo;
import pt.digitalis.adoc.rules.ADOCUtils;
import pt.digitalis.adoc.rules.exception.ADOCException;
import pt.digitalis.adoc.rules.objects.ProcessCommentType;
import pt.digitalis.adoc.rules.objects.ProcessStates;
import pt.digitalis.adoc.rules.objects.ProcessSteps;
import pt.digitalis.comquest.business.api.annotations.ProfileDefinition;
import pt.digitalis.comquest.business.implementations.siges.profiles.ProfileDocente;
import pt.digitalis.comquest.model.data.AccountProfile;
import pt.digitalis.comquest.model.data.Survey;
import pt.digitalis.comquest.model.data.SurveyAddon;
import pt.digitalis.comquest.model.data.SurveyRevisor;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplate;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.Filter;
import pt.digitalis.dif.model.dataset.FilterType;
import pt.digitalis.dif.model.dataset.JoinType;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.dif.model.dataset.SortMode;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.reporting.engine.IReportTemplateContext;
import pt.digitalis.dif.reporting.engine.ReportTemplateManager;
import pt.digitalis.dif.rules.IRulesManager;
import pt.digitalis.dif.rules.annotations.RuleEvaluation;
import pt.digitalis.dif.rules.annotations.RuleExecution;
import pt.digitalis.dif.rules.annotations.RuleGroup;
import pt.digitalis.dif.rules.exceptions.MissingContextException;
import pt.digitalis.dif.rules.exceptions.rules.RuleGroupException;
import pt.digitalis.dif.rules.objects.rules.AbstractRuleGroup;
import pt.digitalis.dif.rules.objects.rules.RuleResult;
import pt.digitalis.siges.model.SIGESFactory;
import pt.digitalis.utils.common.CollectionUtils;
import pt.digitalis.utils.common.DateUtils;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.inspection.Named;

@RuleGroup(name="ADOCRules")
public abstract class ADOCRules
extends AbstractRuleGroup {
    private static IRulesManager ruleManager = (IRulesManager)DIFIoCRegistry.getRegistry().getImplementation(IRulesManager.class);
    private IADOCService dbService = (IADOCService)DIFIoCRegistry.getRegistry().getImplementation(IADOCService.class);

    public static ADOCRules getInstance() throws ADOCException {
        try {
            return (ADOCRules)ruleManager.getRuleGroupInstance(ADOCRules.class);
        }
        catch (MissingContextException e) {
            throw new ADOCException((Exception)((Object)e));
        }
        catch (RuleGroupException e) {
            throw new ADOCException((Exception)((Object)e));
        }
    }

    private static String getReportName(EvaluationProcess evaluationProcess) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(evaluationProcess.getStartDate());
        return "ADOC-" + cal.get(1) + "-" + evaluationProcess.getTitle();
    }

    private static IReportTemplateContext getReportCtx() {
        return ReportTemplateManager.getReportTemplateContext((String)"ADOCReport");
    }

    @RuleExecution(name="addMissingCriterionsToTeacherProcess", description="Determines the missing criterion for a teacher process according to the evaluation process criterion and adds them")
    public void addMissingCriterionsToTeacherProcess(@Named(value="teacherProcessID") Long teacherProcessID) throws DataSetException {
        List missingCriterions;
        TeacherProcess teacherProcess = this.getTeacherProcess(teacherProcessID);
        Query queryTeacherCriterions = this.dbService.getTeacherProcessCriterionDataSet().query();
        queryTeacherCriterions.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcessCriterion.FK().evaluationProcessGroupCrit(), JoinType.NORMAL);
        queryTeacherCriterions.equals(TeacherProcessCriterion.FK().teacherProcess().ID(), teacherProcessID.toString());
        ArrayList<String> existingCriterionIDs = new ArrayList<String>();
        for (TeacherProcessCriterion criterion : queryTeacherCriterions.asList()) {
            existingCriterionIDs.add(criterion.getEvaluationProcessGroupCrit().getId().toString());
        }
        Query queryProcessCriterion = this.dbService.getEvaluationProcessGroupCritDataSet().query();
        queryProcessCriterion.equals(EvaluationProcessGroupCrit.FK().evaluationProcessGroup().ID(), teacherProcess.getEvaluationProcessGroup().getId().toString());
        if (!existingCriterionIDs.isEmpty()) {
            queryProcessCriterion.notIn("id", existingCriterionIDs);
        }
        if (!(missingCriterions = queryProcessCriterion.asList()).isEmpty()) {
            for (EvaluationProcessGroupCrit missingCriterion : missingCriterions) {
                TeacherProcessCriterion teacherCriterion = new TeacherProcessCriterion();
                teacherCriterion.setEvaluationProcessGroupCrit(missingCriterion);
                teacherCriterion.setTeacherProcess(teacherProcess);
                this.dbService.getTeacherProcessCriterionDataSet().insert((IBeanAttributes)teacherCriterion);
            }
        }
    }

    @RuleExecution(name="addMissingFilesToTeacherProcess", description="Determines the missing files for a teacher process according to the evaluation process files and adds them")
    public void addMissingFilesToTeacherProcess(@Named(value="teacherProcessID") Long teacherProcessID) throws DataSetException {
        List missingFiles;
        Query queryTeacherFiles = this.dbService.getTeacherProcessFileDataSet().query();
        queryTeacherFiles.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcessFile.FK().evaluationProcessGroupFile(), JoinType.NORMAL);
        queryTeacherFiles.equals(TeacherProcessFile.FK().teacherProcess().ID(), teacherProcessID.toString());
        ArrayList<String> existingFileIDs = new ArrayList<String>();
        for (TeacherProcessFile file : queryTeacherFiles.asList()) {
            existingFileIDs.add(file.getEvaluationProcessGroupFile().getId().toString());
        }
        Query queryProcessFiles = this.dbService.getEvaluationProcessGroupFileDataSet().query();
        queryProcessFiles.equals(EvaluationProcessGroupFile.FK().evaluationProcessGroup().teacherProcesses().ID(), teacherProcessID.toString());
        if (!existingFileIDs.isEmpty()) {
            queryProcessFiles.notIn("id", existingFileIDs);
        }
        if (!(missingFiles = queryProcessFiles.asList()).isEmpty()) {
            TeacherProcess teacherProcess = (TeacherProcess)this.dbService.getTeacherProcessDataSet().get(teacherProcessID.toString());
            for (EvaluationProcessGroupFile missingFile : missingFiles) {
                TeacherProcessFile teacherFile = new TeacherProcessFile();
                teacherFile.setEvaluationProcessGroupFile(missingFile);
                teacherFile.setTeacherProcess(teacherProcess);
                this.dbService.getTeacherProcessFileDataSet().insert((IBeanAttributes)teacherFile);
            }
        }
    }

    public void addRevisoresSurvey(Long evaluationProcessID, Long surveyID) throws DataSetException {
        String profileDocentesID = ProfileDocente.class.getAnnotation(ProfileDefinition.class).id();
        if (SurveyRevisor.getDataSetInstance().query().equals(SurveyRevisor.FK().survey().ID(), surveyID.toString()).equals(SurveyRevisor.FK().accountProfile().PROFILECLASSID(), profileDocentesID).count() == 0L) {
            Survey survey = Survey.getInstance((Long)surveyID);
            AccountProfile accountProfile = (AccountProfile)AccountProfile.getDataSetInstance().query().equals(AccountProfile.FK().account().ID(), survey.getAccountId().toString()).equals("profileClassId", profileDocentesID).singleValue();
            SurveyRevisor surveyRevisor = new SurveyRevisor();
            surveyRevisor.setSurvey(survey);
            surveyRevisor.setAccountProfile(accountProfile);
            surveyRevisor.setCanSeeSurveyAnswers(Character.valueOf('N'));
            SurveyRevisor.getDataSetInstance().insert((IBeanAttributes)surveyRevisor);
        }
        if (SurveyAddon.getDataSetInstance().query().equals(SurveyAddon.FK().survey().ID(), surveyID.toString()).equals("addonClassId", "SurveyAddOnADOCAddValidatorsForRevisors").count() == 0L) {
            SurveyAddon surveyAddon = new SurveyAddon();
            surveyAddon.setSurveyProxyFromId(surveyID);
            surveyAddon.setAddonClassId("SurveyAddOnADOCAddValidatorsForRevisors");
            surveyAddon.setParameterList("periodoAvaliacao=" + evaluationProcessID);
            SurveyAddon.getDataSetInstance().insert((IBeanAttributes)surveyAddon);
        }
    }

    public void autoAddComQuestSurveyByBusinessUID(Long processID) throws DataSetException {
        if (processID != null && StringUtils.isNotBlank((String)ADOCConfigurations.getInstance().getComQuestTeachersEvaluationSurveyAutoBindBusinessUID())) {
            boolean wasActive = ADOCFactory.openTransaction();
            String existingIDs = CollectionUtils.listToCommaSeparatedString((List)EvaluationProcessSurvey.getDataSetInstance().query().equals(EvaluationProcessSurvey.FK().evaluationProcess().ID(), processID.toString()).asList(), (String)EvaluationProcessSurvey.FK().comQuestSurvey().ID());
            Query surveyQuery = Survey.getDataSetInstance().query().equals("businessUid", ADOCConfigurations.getInstance().getComQuestTeachersEvaluationSurveyAutoBindBusinessUID()).equals("isActive", "Y").equals("isArchived", "N");
            if (StringUtils.isNotBlank((String)existingIDs)) {
                surveyQuery.notIn("id", existingIDs);
            }
            if (ADOCConfigurations.getInstance().getComQuestSurveysAccountID() != null) {
                surveyQuery.equals(Survey.FK().account().ID(), ADOCConfigurations.getInstance().getComQuestSurveysAccountID().toString());
            }
            for (Survey survey : surveyQuery.asList()) {
                EvaluationProcessSurvey processSurvey = new EvaluationProcessSurvey();
                processSurvey.setEvaluationProcessProxyFromId(processID);
                processSurvey.setComQuestSurveyProxyFromId(survey.getId());
                processSurvey = (EvaluationProcessSurvey)EvaluationProcessSurvey.getDataSetInstance().insert((IBeanAttributes)processSurvey);
            }
            if (!wasActive) {
                ADOCFactory.getSession().getTransaction().commit();
            }
        }
    }

    @RuleExecution(name="canAlterProfileTeacherProcess", description="Determines if the profile of the teacher process can be changed")
    public RuleResult<String> canAlterProfileTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) {
        RuleResult result = new RuleResult(true);
        try {
            if (teacherProcess != null) {
                if (this.canTeacherFillProcess(teacherProcess, language, userInfo).isSuccess() || this.canEvaluatorGradeTeacherProcess(teacherProcess, language, userInfo).isSuccess()) {
                    if (!userInfo.isBOUser()) {
                        Date data = teacherProcess.getEvaluationProcessGroup().getEvaluationProcess().getEndDateToAlterProfile();
                        if (data != null && DateUtils.IsAfter((Date)data, (Long)0L)) {
                            result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("alterProfileUnavailable"));
                        }
                        Query p = this.dbService.getEvaluationProcessGroupProfDataSet().query();
                        p.addFilter(new Filter(EvaluationProcessGroupProf.FK().evaluationProcessGroup().ID(), FilterType.EQUALS, teacherProcess.getEvaluationProcessGroupId().toString()));
                        if (p.count() <= 1L) {
                            result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("alterProfileUnavailable"));
                        }
                    }
                } else {
                    result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("wrongPhaseStateForAction"));
                }
            }
        }
        catch (Exception e) {
            result = new RuleResult(false, (Object)e.getMessage(), e);
        }
        return result;
    }

    @RuleExecution(name="canBOGradeTeacherProcess", description="Determines if the BO user can grade the teacher process")
    public RuleResult<String> canBOGradeTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws DataSetException {
        RuleResult result = new RuleResult(true);
        try {
            if (teacherProcess != null) {
                result = this.canTeacherFillProcess(teacherProcess, language, userInfo);
            }
        }
        catch (Exception e) {
            result = new RuleResult(false, (Object)e.getMessage(), e);
        }
        return result;
    }

    @RuleExecution(name="canCommissionGradeTeacherProcess", description="Determines if the commission can grade the teacher process")
    public RuleResult<String> canCommissionGradeTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws DataSetException {
        RuleResult result = new RuleResult(true);
        try {
            if (teacherProcess != null) {
                if (ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.EVALUATED)) {
                    if (!this.isEvaluatorReviewOrFinalReviewActive(teacherProcess, userInfo)) {
                        result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("wrongPhaseStateForAction"));
                    }
                } else {
                    result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("invalidStateForAction"));
                }
            }
        }
        catch (Exception e) {
            result = new RuleResult(false, (Object)e.getMessage(), e);
        }
        return result;
    }

    @RuleExecution(name="canCommissionReviewProcess", description="Determines if the commission can review the teacher process")
    public RuleResult<String> canCommissionReviewProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws DataSetException {
        RuleResult result = new RuleResult(true);
        try {
            if (teacherProcess != null) {
                if (ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.EVALUATED)) {
                    Long evaluationProcessID = teacherProcess.getEvaluationProcessGroup().getEvaluationProcess().getId();
                    EvaluationProcessStep processStep = this.getEvaluationProcessStep(evaluationProcessID, ProcessSteps.COMMISSION_REVIEW.toString(), true);
                    if (processStep == null) {
                        result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("wrongPhaseStateForAction"));
                    }
                } else {
                    result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("invalidStateForAction"));
                }
            }
        }
        catch (Exception e) {
            result = new RuleResult(false, (Object)e.getMessage(), e);
        }
        return result;
    }

    @RuleExecution(name="canEvaluatorFinalReviewTeacherProcess", description="Determines if the evaluator can do the final review the teacher process")
    public RuleResult<String> canEvaluatorFinalReviewTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws DataSetException {
        RuleResult result = new RuleResult(true);
        try {
            if (teacherProcess != null) {
                if (ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.EVALUATED_PENDING_REVISION)) {
                    Long evaluationProcessID = teacherProcess.getEvaluationProcessGroup().getEvaluationProcess().getId();
                    EvaluationProcessStep processStep = this.getEvaluationProcessStep(evaluationProcessID, ProcessSteps.EVALUATOR_FINAL_REVIEW.toString(), true);
                    if (processStep == null) {
                        result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("wrongPhaseStateForAction"));
                    } else if (!this.isEvaluatorForTeacherOnTheProcessStep(evaluationProcessID, userInfo.getTeacherUser().getTeacher().getId(), teacherProcess.getTeacher().getId(), ProcessSteps.EVALUATOR_FINAL_REVIEW.toString())) {
                        result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("wrongPhaseStateForAction"));
                    }
                } else {
                    result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("invalidStateForAction"));
                }
            }
        }
        catch (Exception e) {
            result = new RuleResult(false, (Object)e.getMessage(), e);
        }
        return result;
    }

    @RuleExecution(name="canEvaluatorGradeTeacherProcess", description="Determines if the evaluator can grade the teacher process")
    public RuleResult<String> canEvaluatorGradeTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws DataSetException {
        RuleResult result = new RuleResult(true);
        try {
            if (teacherProcess != null) {
                if (ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.FILLED) || ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.EVALUATED_PENDING_REVISION) || ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.VALIDATED)) {
                    if (!this.isEvaluatorReviewOrFinalReviewActive(teacherProcess, userInfo)) {
                        result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("wrongPhaseStateForAction"));
                    }
                } else {
                    result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("invalidStateForAction"));
                }
            }
        }
        catch (Exception e) {
            result = new RuleResult(false, (Object)e.getMessage(), e);
        }
        return result;
    }

    @RuleExecution(name="canEvaluatorReopenFillTeacherProcess", description="Determines if the evaluator can reopen the process for the teacher to edit")
    public RuleResult<String> canEvaluatorReopenFillTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) {
        RuleResult result = new RuleResult(true);
        try {
            if (teacherProcess != null) {
                if (ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.FILLED) || ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.VALIDATED) || ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.EVALUATED) || ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.EVALUATED_PENDING_REVISION)) {
                    if (!this.isEvaluatorReviewOrFinalReviewActive(teacherProcess, userInfo)) {
                        result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("wrongPhaseStateForAction"));
                    }
                } else {
                    result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("invalidStateForAction"));
                }
            }
        }
        catch (Exception e) {
            result = new RuleResult(false, (Object)e.getMessage(), e);
        }
        return result;
    }

    @RuleExecution(name="canEvaluatorReopenGradesTeacherProcess", description="Determines if the evaluator can reopen the grade matrix for editing")
    public RuleResult<String> canEvaluatorReopenGradesTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) {
        RuleResult result = new RuleResult(true);
        try {
            if (teacherProcess != null) {
                if (ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.EVALUATED) || ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.EVALUATED_PENDING_REVISION)) {
                    if (!this.isEvaluatorReviewOrFinalReviewActive(teacherProcess, userInfo)) {
                        result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("wrongPhaseStateForAction"));
                    }
                } else {
                    result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("invalidStateForAction"));
                }
            }
        }
        catch (Exception e) {
            result = new RuleResult(false, (Object)e.getMessage(), e);
        }
        return result;
    }

    @RuleExecution(name="canEvaluatorReviewTeacherProcess", description="Determines if the evaluator can review the teacher process")
    public RuleResult<String> canEvaluatorReviewTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws DataSetException {
        RuleResult result = new RuleResult(true);
        try {
            if (teacherProcess != null) {
                if (ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.FILLED) || ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.INVALID)) {
                    Long evaluationProcessID = teacherProcess.getEvaluationProcessGroup().getEvaluationProcess().getId();
                    EvaluationProcessStep processStep = this.getEvaluationProcessStep(evaluationProcessID, ProcessSteps.EVALUATOR_REVIEW.toString(), true);
                    if (processStep == null) {
                        result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("wrongPhaseStateForAction"));
                    } else if (!this.isEvaluatorForTeacherOnTheProcessStep(evaluationProcessID, userInfo.getTeacherUser().getTeacher().getId(), teacherProcess.getTeacher().getId(), ProcessSteps.EVALUATOR_REVIEW.toString())) {
                        result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("wrongPhaseStateForAction"));
                    }
                } else {
                    result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("invalidStateForAction"));
                }
            }
        }
        catch (Exception e) {
            result = new RuleResult(false, (Object)e.getMessage(), e);
        }
        return result;
    }

    @RuleExecution(name="canEvaluatorReviewTeacherReviewRequest", description="Determines if the evaluator can review the teacher review request of his process")
    public RuleResult<String> canEvaluatorReviewTeacherReviewRequest(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws DataSetException {
        RuleResult result = new RuleResult(true);
        try {
            if (teacherProcess != null) {
                if (ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.EVALUATED_PENDING_REVISION)) {
                    Long evaluationProcessID = teacherProcess.getEvaluationProcessGroup().getEvaluationProcess().getId();
                    EvaluationProcessStep processStep = this.getEvaluationProcessStep(evaluationProcessID, ProcessSteps.EVALUATOR_FINAL_REVIEW.toString(), true);
                    if (processStep == null) {
                        result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("wrongPhaseStateForAction"));
                    } else if (!this.isEvaluatorForTeacherOnTheProcessStep(evaluationProcessID, userInfo.getTeacherUser().getTeacher().getId(), teacherProcess.getTeacher().getId(), ProcessSteps.EVALUATOR_FINAL_REVIEW.toString())) {
                        result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("wrongPhaseStateForAction"));
                    }
                } else {
                    result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("invalidStateForAction"));
                }
            }
        }
        catch (Exception e) {
            result = new RuleResult(false, (Object)e.getMessage(), e);
        }
        return result;
    }

    @RuleExecution(name="canEvaluatorSignalTeacherProcess", description="Determines if the evaluator can signal the teacher process")
    public RuleResult<String> canEvaluatorSignalTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws DataSetException {
        RuleResult result = new RuleResult(true);
        try {
            if (teacherProcess != null) {
                if (ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.CREATED) || ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.FILLED) || ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.COMPLETED)) {
                    result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("invalidStateForAction"));
                } else if (userInfo.isMyProcess(teacherProcess) || userInfo.isBOUser()) {
                    result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("invalidStateForAction"));
                }
            }
        }
        catch (Exception e) {
            result = new RuleResult(false, (Object)e.getMessage(), e);
        }
        return result;
    }

    @RuleExecution(name="canHomologatorCompleteProcess", description="Determines if the teacher process can be completed")
    public RuleResult<String> canHomologatorCompleteProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws DataSetException {
        RuleResult result = new RuleResult(true);
        try {
            if (teacherProcess != null) {
                if (ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.EVALUATED) || ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.REVIEWED) || ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.EVALUATED_PENDING_COMPLAINT)) {
                    Long evaluationProcessID = teacherProcess.getEvaluationProcessGroup().getEvaluationProcess().getId();
                    EvaluationProcessStep processStep = this.getEvaluationProcessStep(evaluationProcessID, ProcessSteps.FINAL_REVIEW.toString(), true);
                    if (processStep == null) {
                        result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("wrongPhaseStateForAction"));
                    }
                } else {
                    result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("invalidStateForAction"));
                }
            }
        }
        catch (Exception e) {
            result = new RuleResult(false, (Object)e.getMessage(), e);
        }
        return result;
    }

    @RuleExecution(name="canHomologatorGradeTeacherProcess", description="Determines if the homologator can grade the teacher process")
    public RuleResult<String> canHomologatorGradeTeacherProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws DataSetException {
        RuleResult result = new RuleResult(true);
        try {
            if (teacherProcess != null) {
                if (ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.EVALUATED) || ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.REVIEWED) || ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.EVALUATED_PENDING_COMPLAINT)) {
                    if (!this.isEvaluatorReviewOrFinalReviewActive(teacherProcess, userInfo)) {
                        result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("wrongPhaseStateForAction"));
                    }
                } else {
                    result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("invalidStateForAction"));
                }
            }
        }
        catch (Exception e) {
            result = new RuleResult(false, (Object)e.getMessage(), e);
        }
        return result;
    }

    @RuleExecution(name="canHomologatorSubmitComplaintReply", description="Determines if the homologator submit teacher complaint reply")
    public RuleResult<String> canHomologatorSubmitComplaintReply(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws DataSetException {
        RuleResult result = new RuleResult(true);
        try {
            if (teacherProcess != null) {
                if (ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.EVALUATED_PENDING_COMPLAINT)) {
                    Long evaluationProcessID = teacherProcess.getEvaluationProcessGroup().getEvaluationProcess().getId();
                    EvaluationProcessStep processStep = this.getEvaluationProcessStep(evaluationProcessID, ProcessSteps.FINAL_REVIEW.toString(), true);
                    if (processStep == null) {
                        result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("wrongPhaseStateForAction"));
                    }
                } else {
                    result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("invalidStateForAction"));
                }
            }
        }
        catch (Exception e) {
            result = new RuleResult(false, (Object)e.getMessage(), e);
        }
        return result;
    }

    @RuleExecution(name="canReplicateEvaluationProcess", description="Determines if the user can replicate evaluation process")
    public RuleResult<String> canReplicateEvaluationProcess(@Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws IdentityManagerException {
        RuleResult result = new RuleResult(true);
        if (!userInfo.isBOUser()) {
            result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("replicateProcessUnavailable"));
        }
        return result;
    }

    @RuleExecution(name="canTeacherFileComplaint", description="Determines if the teacher can file a complaint")
    public RuleResult<String> canTeacherFileComplaint(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws DataSetException {
        RuleResult result = new RuleResult(true);
        try {
            if (teacherProcess != null) {
                if (ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.EVALUATED) || ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.REVIEWED)) {
                    Long evaluationProcessID = teacherProcess.getEvaluationProcessGroup().getEvaluationProcess().getId();
                    EvaluationProcessStep processStep = this.getEvaluationProcessStep(evaluationProcessID, ProcessSteps.TEACHER_COMPLAINT.toString(), true);
                    if (processStep == null) {
                        result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("wrongPhaseStateForAction"));
                    }
                } else {
                    result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("invalidStateForAction"));
                }
            }
        }
        catch (Exception e) {
            result = new RuleResult(false, (Object)e.getMessage(), e);
        }
        return result;
    }

    @RuleExecution(name="canTeacherFillProcess", description="Determines if the teacher can fill his process")
    public RuleResult<String> canTeacherFillProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws DataSetException {
        RuleResult result = new RuleResult(true);
        try {
            if (teacherProcess != null) {
                if (ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.CREATED) || ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.INVALID)) {
                    Long evaluationProcessID = teacherProcess.getEvaluationProcessGroup().getEvaluationProcess().getId();
                    EvaluationProcessStep processStepFill = this.getEvaluationProcessStep(evaluationProcessID, ProcessSteps.TEACHER_FILL_PROCESS.toString(), true);
                    boolean fillPhaseAndCreated = processStepFill != null && ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.CREATED);
                    boolean invalid = ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.INVALID);
                    if (!fillPhaseAndCreated && !invalid) {
                        result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("wrongPhaseStateForAction"));
                    }
                } else {
                    result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("invalidStateForAction"));
                }
            }
        }
        catch (Exception e) {
            result = new RuleResult(false, (Object)e.getMessage(), e);
        }
        return result;
    }

    @RuleExecution(name="canTeacherRequestRevision", description="Determines if the teacher can request the revision of his process")
    public RuleResult<String> canTeacherRequestRevision(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws DataSetException {
        RuleResult result = new RuleResult(true);
        try {
            if (teacherProcess != null) {
                if (ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.EVALUATED)) {
                    Long evaluationProcessID = teacherProcess.getEvaluationProcessGroup().getEvaluationProcess().getId();
                    EvaluationProcessStep processStep = this.getEvaluationProcessStep(evaluationProcessID, ProcessSteps.TEACHER_REVISION_REQUEST.toString(), true);
                    if (processStep == null) {
                        result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("wrongPhaseStateForAction"));
                    }
                } else {
                    result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("invalidStateForAction"));
                }
            }
        }
        catch (Exception e) {
            result = new RuleResult(false, (Object)e.getMessage(), e);
        }
        return result;
    }

    @RuleExecution(name="canTeacherSeeGrades", description="Determines if the teacher can see evaluation grades of his process")
    public RuleResult<String> canTeacherSeeGrades(@Named(value="teacherProcess") TeacherProcess teacherProcess) throws DataSetException {
        RuleResult result = new RuleResult(false);
        if (teacherProcess != null && (ProcessStates.CREATED.getId().equals(teacherProcess.getProcessState().getId()) || ProcessStates.INVALID.getId().equals(teacherProcess.getProcessState().getId()) || teacherProcess.getEvaluationProcessGroup().isCanTeacherSeeGrades() || this.isTeacherProcessEvaluated(teacherProcess))) {
            result = new RuleResult(true);
        }
        return result;
    }

    @RuleExecution(name="canTeacherSubmitProcess", description="Determines if the teacher can submit his process")
    public RuleResult<String> canTeacherSubmitProcess(@Named(value="teacherProcess") TeacherProcess teacherProcess, @Named(value="language") String language, @Named(value="userInfo") ADOCUserInfo userInfo) throws DataSetException {
        Query query;
        RuleResult result = this.canTeacherFillProcess(teacherProcess, language, userInfo);
        if (result.isSuccess() && (query = this.dbService.getTeacherProcessFileDataSet().query().equals(TeacherProcessFile.FK().teacherProcess().ID(), teacherProcess.getId().toString()).isNull("documentId").equals(TeacherProcessFile.FK().evaluationProcessGroupFile().MANDATORY(), "true")).count() > 0L) {
            result = new RuleResult(false, (Object)ADOCUtils.getADOCAppMessages(language).get("mandatoryFilesMissing"));
        }
        return result;
    }

    @RuleExecution(name="copiarReportTemplate", description="Copiar um report template do ADOC para um novo periodo de avalia\u00e7\u00e3o.")
    public RuleResult<ReportTemplate> copiarReportTemplate(@Named(value="reportId") Long reportId, @Named(value="configuracao") EvaluationProcess evalProcess) {
        RuleResult result;
        block5: {
            result = new RuleResult(false);
            Session session = SIGESFactory.getSession(null);
            boolean wasActive = session.getTransaction().isActive();
            try {
                ReportTemplate reportTemplate;
                if (!wasActive) {
                    session.beginTransaction();
                }
                if (CollectionUtils.isNotEmpty((Collection)(reportTemplate = ReportTemplateManager.getInstance().copyReportTemplate(ADOCRules.getReportCtx(), ADOCRules.getReportName(evalProcess), reportId)).getReportTemplateAreas())) {
                    System.out.println("\u00c9 preciso aplicar aos crit\u00e9rios j\u00e1 criados");
                }
                evalProcess.setReportTemplateId(reportTemplate.getId());
                EvaluationProcess.getDataSetInstance().update((IBeanAttributes)evalProcess);
                if (!wasActive) {
                    session.getTransaction().commit();
                }
                result.setResult((Object)reportTemplate);
                result.setSuccess(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                result.setException(e);
                if (wasActive) break block5;
                session.getTransaction().rollback();
            }
        }
        return result;
    }

    @RuleExecution(name="criarNovaReportTemplate", description="Criar novo report template do ADOC que vai ser associado a um per\u00edodo.")
    public RuleResult<ReportTemplate> criarNovoReportTemplate(@Named(value="evalProcess") EvaluationProcess evalProcess) {
        RuleResult result;
        block4: {
            result = new RuleResult(false);
            Session session = SIGESFactory.getSession(null);
            boolean wasActive = session.getTransaction().isActive();
            try {
                if (!wasActive) {
                    session.beginTransaction();
                }
                ReportTemplate reportTemplate = ReportTemplateManager.getInstance().newReportTemplate(ADOCRules.getReportCtx(), ADOCRules.getReportName(evalProcess));
                evalProcess.setReportTemplateId(reportTemplate.getId());
                EvaluationProcess.getDataSetInstance().update((IBeanAttributes)evalProcess);
                if (!wasActive) {
                    session.getTransaction().commit();
                }
                result.setResult((Object)reportTemplate);
                result.setSuccess(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                result.setException(e);
                if (wasActive) break block4;
                session.getTransaction().rollback();
            }
        }
        return result;
    }

    @RuleExecution(name="getCurrentTeacherProcess", description="Gets the current process for the given teacher")
    public TeacherProcess getCurrentTeacherProcess(@Named(value="teacherID") Long teacherID) throws DataSetException {
        if (teacherID == null) {
            return null;
        }
        Query query = this.dbService.getTeacherProcessDataSet().query().addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcess.FK().evaluationProcessGroup(), JoinType.NORMAL).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcess.FK().evaluationProcessGroup().evaluationProcess(), JoinType.NORMAL).equals(TeacherProcess.FK().teacher().ID(), teacherID.toString()).sortBy("id", SortMode.DESCENDING);
        return (TeacherProcess)query.singleValue();
    }

    @RuleExecution(name="getEvaluationProcess", description="Loads an evaluation process with eager loading of all it's properties")
    public EvaluationProcess getEvaluationProcess(@Named(value="processID") Long processID, @Named(value="eagerLoadFullData") boolean eagerLoadFullData) throws DataSetException {
        if (processID == null) {
            return null;
        }
        Query query = this.dbService.getEvaluationProcessDataSet().query().equals("id", processID.toString());
        if (eagerLoadFullData) {
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)EvaluationProcess.FK().evaluationProcessGroups(), JoinType.LEFT_OUTER_JOIN);
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)EvaluationProcess.FK().evaluationProcessSteps(), JoinType.LEFT_OUTER_JOIN);
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)EvaluationProcess.FK().evaluationProcessComissions(), JoinType.LEFT_OUTER_JOIN);
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)EvaluationProcess.FK().evaluationProcessEvaluators(), JoinType.LEFT_OUTER_JOIN);
            query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)EvaluationProcess.FK().evaluationProcessSurveys(), JoinType.LEFT_OUTER_JOIN);
        }
        query.setDistinctEntities(true);
        return (EvaluationProcess)query.singleValue();
    }

    @RuleExecution(name="getEvaluationProcessStep", description="Get the indicated evaluation process step")
    public EvaluationProcessStep getEvaluationProcessStep(@Named(value="evaluationProcessID") Long evaluationProcessID, @Named(value="stepID") String stepID, @Named(value="validateDate") boolean validateDate) throws DataSetException {
        if (evaluationProcessID == null) {
            return null;
        }
        List activeSteps = this.dbService.getEvaluationProcessStepDataSet().query().equals(EvaluationProcessStep.FK().evaluationProcess().ID(), evaluationProcessID.toString()).equals("stepId", stepID).equals("active", "true").asList();
        if (activeSteps.isEmpty()) {
            return null;
        }
        Collections.sort(activeSteps, new Comparator<EvaluationProcessStep>(){

            @Override
            public int compare(EvaluationProcessStep a, EvaluationProcessStep b) {
                int r = a.getStartDate().compareTo(b.getStartDate());
                if (r == 0) {
                    r = a.getDescription().compareTo(b.getDescription());
                }
                return r;
            }
        });
        if (!validateDate) {
            return (EvaluationProcessStep)activeSteps.get(0);
        }
        EvaluationProcessStep result = null;
        for (EvaluationProcessStep processStep : activeSteps) {
            if (!this.isEvaluationProcessStepAtiveToday(processStep.getStartDate(), processStep.getEndDate())) continue;
            result = processStep;
            break;
        }
        return result;
    }

    @RuleExecution(name="getMissingMandatoryFiles", description="Determines the missing mandatory files for a teacher process according to the evaluation processo files definition")
    public Long getMissingMandatoryFiles(@Named(value="teacherProcessID") Long teacherProcessID) throws DataSetException {
        Long evaluationProcessGroupID = this.getTeacherProcess(teacherProcessID).getEvaluationProcessGroup().getId();
        Query queryMandatory = this.dbService.getEvaluationProcessGroupFileDataSet().query();
        queryMandatory.equals(EvaluationProcessGroupFile.FK().evaluationProcessGroup().ID(), evaluationProcessGroupID.toString());
        queryMandatory.equals("mandatory", "true");
        Long totalMandatory = queryMandatory.count();
        Query queryTeacherMandatoryUploaded = this.dbService.getTeacherProcessFileDataSet().query();
        queryTeacherMandatoryUploaded.equals(TeacherProcessFile.FK().teacherProcess().ID(), teacherProcessID.toString());
        queryTeacherMandatoryUploaded.equals(TeacherProcessFile.FK().evaluationProcessGroupFile().MANDATORY(), "true");
        queryTeacherMandatoryUploaded.isNotNull("documentId");
        Long totalMandatoryUploaded = queryTeacherMandatoryUploaded.count();
        return totalMandatory - totalMandatoryUploaded;
    }

    @RuleExecution(name="getProcessState", description="Loads the qualitative grade based of the quantitative grade")
    public QualitativeGrade getQualitativeGrade(@Named(value="quantitativeGrade") Long quantitativeGrade) throws DataSetException {
        if (quantitativeGrade == null) {
            return null;
        }
        String grade = Long.toString(quantitativeGrade);
        return (QualitativeGrade)this.dbService.getQualitativeGradeDataSet().query().graterOrEqualsThan("minQuantGrade", grade).lesserOrEqualsThan("maxQuantGrade", grade).singleValue();
    }

    public ITeacherInformationSystem getRemoteTeacherSystem() {
        return (ITeacherInformationSystem)DIFIoCRegistry.getRegistry().getImplementation(ITeacherInformationSystem.class, ADOCConfigurations.getInstance().getRemoteTeacherSystemIntegrator());
    }

    @RuleExecution(name="getTeacherProcess", description="Loads a teacher process with eager loading of all it's properties")
    public TeacherProcess getTeacherProcess(@Named(value="processID") Long processID) throws DataSetException {
        if (processID == null) {
            return null;
        }
        Query query = this.dbService.getTeacherProcessDataSet().query().equals("id", processID.toString());
        query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcess.FK().teacher(), JoinType.NORMAL);
        query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcess.FK().evaluationProcessGroup(), JoinType.NORMAL);
        query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcess.FK().evaluationProcessGroup().evaluationProcess(), JoinType.NORMAL);
        query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcess.FK().qualitativeGrade(), JoinType.LEFT_OUTER_JOIN);
        query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcess.FK().processState(), JoinType.NORMAL);
        query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcess.FK().processSignalling(), JoinType.LEFT_OUTER_JOIN);
        query.addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcess.FK().profile(), JoinType.NORMAL);
        query.setDistinctEntities(true);
        return (TeacherProcess)query.singleValue();
    }

    @RuleExecution(name="getTeacherProcessCommentsForComplaint", description="Loads the teacher process comments for complaint requests (both request and responses)")
    public List<TeacherProcessComment> getTeacherProcessCommentsForComplaint(@Named(value="processID") Long processID) throws DataSetException {
        if (processID == null) {
            return null;
        }
        List comment = this.dbService.getTeacherProcessCommentDataSet().query().equals(TeacherProcessComment.FK().teacherProcess().ID(), processID.toString()).in("cmntType", ProcessCommentType.COMPLAINT_REQUEST.getDBRepresentation() + "," + ProcessCommentType.COMPLAINT_COMMENT.getDBRepresentation()).equals("inProgress", "false").sortBy("cmntDate", SortMode.DESCENDING).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcessComment.FK().teacher(), JoinType.NORMAL).asList();
        return comment;
    }

    @RuleExecution(name="getTeacherProcessCommentsForReview", description="Loads the teacher process comments for review requests (both request and responses)")
    public List<TeacherProcessComment> getTeacherProcessCommentsForReview(@Named(value="processID") Long processID) throws DataSetException {
        if (processID == null) {
            return null;
        }
        List comment = this.dbService.getTeacherProcessCommentDataSet().query().equals(TeacherProcessComment.FK().teacherProcess().ID(), processID.toString()).in("cmntType", ProcessCommentType.REVIEW_REQUEST.getDBRepresentation() + "," + ProcessCommentType.REVIEW_COMMENT.getDBRepresentation()).equals("inProgress", "false").sortBy("cmntDate", SortMode.DESCENDING).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcessComment.FK().teacher(), JoinType.NORMAL).asList();
        return comment;
    }

    @RuleExecution(name="getTeacherProcessComment", description="Loads a teacher process comment")
    public TeacherProcessComment getTeacherProcessPendingComment(@Named(value="processID") Long processID, @Named(value="commentType") ProcessCommentType commentType) throws DataSetException {
        if (processID == null || commentType == null) {
            return null;
        }
        TeacherProcessComment comment = (TeacherProcessComment)this.dbService.getTeacherProcessCommentDataSet().query().equals(TeacherProcessComment.FK().teacherProcess().ID(), processID.toString()).equals("cmntType", commentType.getDBRepresentation()).equals("inProgress", "true").addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcessComment.FK().teacher(), JoinType.LEFT_OUTER_JOIN).singleValue();
        return comment;
    }

    public boolean hasPendingComplaint(TeacherProcess teacherProcess) {
        return ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.EVALUATED_PENDING_COMPLAINT);
    }

    public boolean hasPendingRevisionRequest(TeacherProcess teacherProcess) {
        return ProcessStates.equals(teacherProcess.getProcessState(), ProcessStates.EVALUATED_PENDING_REVISION);
    }

    @RuleEvaluation(name="isCanCommissionEditGrades", description="Determines if the teacher on a commission can edit grades")
    public boolean isCanCommissionEditGrades(@Named(value="evaluationProcessID") Long evaluationProcessID, @Named(value="teacherID") Long teacherID) throws DataSetException {
        if (teacherID == null) {
            return false;
        }
        return ((EvaluationProcessComission)this.dbService.getEvaluationProcessComissionDataSet().query().equals(EvaluationProcessComission.FK().evaluationProcess().ID(), evaluationProcessID.toString()).equals(EvaluationProcessComission.FK().teacher().ID(), teacherID.toString()).singleValue()).isCanComissionEditGrades();
    }

    private boolean isEvaluationProcessStepAtiveToday(Date startDate, Date endDate) {
        boolean isAtiveToday = false;
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date currentDate = cal.getTime();
        if (DateUtils.isDateBetween((Date)currentDate, (Date)startDate, (Date)endDate)) {
            isAtiveToday = true;
        }
        return isAtiveToday;
    }

    @RuleEvaluation(name="isEvaluator", description="Determines if the teacher is an evaluator")
    public boolean isEvaluator(@Named(value="teacherEvaluatorID") Long teacherEvaluatorID) throws DataSetException {
        if (teacherEvaluatorID == null) {
            return false;
        }
        return this.dbService.getEvaluationProcessEvaluatorDataSet().query().equals(EvaluationProcessEvaluator.FK().teacher().ID(), teacherEvaluatorID.toString()).count() > 0L;
    }

    @RuleEvaluation(name="isEvaluatorForProcess", description="Determines if the teacher is an evaluator of the process")
    public boolean isEvaluatorForProcess(@Named(value="evaluationProcessID") Long evaluationProcessID, @Named(value="teacherEvaluatorID") Long teacherEvaluatorID) throws DataSetException {
        if (teacherEvaluatorID == null) {
            return false;
        }
        return this.dbService.getTeacherProcessEvaluatorDataSet().query().equals(TeacherProcessEvaluator.FK().evaluationProcessEvaluator().teacher().ID(), teacherEvaluatorID.toString()).equals(TeacherProcessEvaluator.FK().teacherProcess().evaluationProcessGroup().evaluationProcess().ID(), evaluationProcessID.toString()).count() > 0L;
    }

    @RuleEvaluation(name="isEvaluatorForTeacher", description="Determines if the teacher is an evaluator of a given teacher")
    public boolean isEvaluatorForTeacher(@Named(value="teacherEvaluatorID") Long teacherEvaluatorID, @Named(value="teacherID") Long teacherID) throws DataSetException {
        if (teacherID == null) {
            return false;
        }
        return this.dbService.getTeacherProcessEvaluatorDataSet().query().equals(TeacherProcessEvaluator.FK().evaluationProcessEvaluator().teacher().ID(), teacherEvaluatorID.toString()).equals(TeacherProcessEvaluator.FK().teacherProcess().teacher().ID(), teacherID.toString()).count() > 0L;
    }

    @RuleEvaluation(name="isEvaluatorForTeacherOnTheProcessStep", description="Determines if the teacher is an evaluator of a given teacher on the process step indicated")
    public boolean isEvaluatorForTeacherOnTheProcessStep(@Named(value="evaluationProcessID") Long evaluationProcessID, @Named(value="teacherEvaluatorID") Long teacherEvaluatorID, @Named(value="teacherID") Long teacherID, @Named(value="processStepID") String stepID) throws DataSetException {
        if (teacherID == null) {
            return false;
        }
        boolean isGlobalEvaluator = ((EvaluationProcessEvaluator)this.dbService.getEvaluationProcessEvaluatorDataSet().query().addFilter(new Filter(EvaluationProcessEvaluator.FK().evaluationProcess().ID(), FilterType.EQUALS, evaluationProcessID.toString())).addFilter(new Filter(EvaluationProcessEvaluator.FK().teacher().ID(), FilterType.EQUALS, teacherEvaluatorID.toString())).singleValue()).isIsGlobal();
        Boolean result = isGlobalEvaluator || this.isEvaluatorForTeacher(teacherEvaluatorID, teacherID);
        boolean hasNoAssociations = false;
        boolean hasAssociationToStep = false;
        if (result.booleanValue() && stepID != null) {
            TeacherProcessEvaluator teacherProcessEvaluator = (TeacherProcessEvaluator)this.dbService.getTeacherProcessEvaluatorDataSet().query().equals(TeacherProcessEvaluator.FK().evaluationProcessEvaluator().teacher().ID(), teacherEvaluatorID.toString()).equals(TeacherProcessEvaluator.FK().teacherProcess().teacher().ID(), teacherID.toString()).equals(TeacherProcessEvaluator.FK().evaluationProcessEvaluator().evaluationProcess().ID(), evaluationProcessID.toString()).singleValue();
            if (teacherProcessEvaluator == null) {
                hasNoAssociations = true;
            } else {
                List associations = this.dbService.getTeacherEvaluatorStepDataSet().query().equals(TeacherEvaluatorStep.FK().teacherProcessEvaluator().ID(), teacherProcessEvaluator.getId().toString()).asList();
                hasNoAssociations = associations.isEmpty();
                associations = this.dbService.getTeacherEvaluatorStepDataSet().query().equals(TeacherEvaluatorStep.FK().teacherProcessEvaluator().ID(), teacherProcessEvaluator.getId().toString()).equals(TeacherEvaluatorStep.FK().evaluationProcessStep().STEPID(), stepID).asList();
                hasAssociationToStep = false;
                for (TeacherEvaluatorStep association : associations) {
                    if (!this.isEvaluationProcessStepAtiveToday(association.getEvaluationProcessStep().getStartDate(), association.getEvaluationProcessStep().getEndDate())) continue;
                    hasAssociationToStep = true;
                    break;
                }
            }
        }
        return result != false && (hasNoAssociations || hasAssociationToStep);
    }

    private boolean isEvaluatorReviewOrFinalReviewActive(TeacherProcess teacherProcess, ADOCUserInfo userInfo) throws DataSetException {
        Long evaluationProcessID = teacherProcess.getEvaluationProcessGroup().getEvaluationProcess().getId();
        EvaluationProcessStep processStepEvaluate = this.getEvaluationProcessStep(evaluationProcessID, ProcessSteps.EVALUATOR_REVIEW.toString(), true);
        EvaluationProcessStep processStepReview = this.getEvaluationProcessStep(evaluationProcessID, ProcessSteps.EVALUATOR_FINAL_REVIEW.toString(), true);
        Boolean isProcessStepEvaluateAtive = processStepEvaluate != null;
        Boolean isProcessStepReviewAtive = processStepReview != null;
        if (isProcessStepEvaluateAtive.booleanValue() && !this.isEvaluatorForTeacherOnTheProcessStep(evaluationProcessID, userInfo.getTeacherUser().getTeacher().getId(), teacherProcess.getTeacher().getId(), ProcessSteps.EVALUATOR_REVIEW.toString())) {
            isProcessStepEvaluateAtive = false;
        }
        if (isProcessStepReviewAtive.booleanValue() && !this.isEvaluatorForTeacherOnTheProcessStep(evaluationProcessID, userInfo.getTeacherUser().getTeacher().getId(), teacherProcess.getTeacher().getId(), ProcessSteps.EVALUATOR_FINAL_REVIEW.toString())) {
            isProcessStepReviewAtive = false;
        }
        return isProcessStepEvaluateAtive != false || isProcessStepReviewAtive != false;
    }

    @RuleEvaluation(name="isGlobalEvaluator", description="Determines if the teacher is an evaluator")
    public boolean isGlobalEvaluator(@Named(value="teacherEvaluatorID") Long teacherEvaluatorID) throws DataSetException {
        if (teacherEvaluatorID == null) {
            return false;
        }
        return this.dbService.getEvaluationProcessEvaluatorDataSet().query().equals(EvaluationProcessEvaluator.FK().teacher().ID(), teacherEvaluatorID.toString()).equals("isGlobal", "true").count() > 0L;
    }

    @RuleEvaluation(name="isGlobalEvaluatorForProcess", description="Determines if the teacher is an evaluator for the process")
    public boolean isGlobalEvaluatorForProcess(@Named(value="evaluationProcessID") Long evaluationProcessID, @Named(value="teacherEvaluatorID") Long teacherEvaluatorID) throws DataSetException {
        if (teacherEvaluatorID == null) {
            return false;
        }
        return this.dbService.getEvaluationProcessEvaluatorDataSet().query().equals(EvaluationProcessEvaluator.FK().teacher().ID(), teacherEvaluatorID.toString()).equals(EvaluationProcessEvaluator.FK().evaluationProcess().ID(), evaluationProcessID.toString()).equals("isGlobal", "true").count() > 0L;
    }

    @RuleEvaluation(name="isOnCommission", description="Determines if the teacher is on a commission")
    public boolean isOnCommission(@Named(value="teacherID") Long teacherID) throws DataSetException {
        if (teacherID == null) {
            return false;
        }
        return this.dbService.getEvaluationProcessComissionDataSet().query().equals(EvaluationProcessComission.FK().teacher().ID(), teacherID.toString()).count() > 0L;
    }

    @RuleEvaluation(name="isOnCommissionForProcess", description="Determines if the teacher is on a commission")
    public boolean isOnCommissionForProcess(@Named(value="evaluationProcessID") Long evaluationProcessID, @Named(value="teacherID") Long teacherID) throws DataSetException {
        if (teacherID == null) {
            return false;
        }
        return this.dbService.getEvaluationProcessComissionDataSet().query().equals(EvaluationProcessComission.FK().evaluationProcess().ID(), evaluationProcessID.toString()).equals(EvaluationProcessComission.FK().teacher().ID(), teacherID.toString()).count() > 0L;
    }

    public boolean isRevisoresAddedToSurvey(Long evaluationProcessID, Long surveyID) throws DataSetException {
        String profileDocentesID = ProfileDocente.class.getAnnotation(ProfileDefinition.class).id();
        return SurveyRevisor.getDataSetInstance().query().equals(SurveyRevisor.FK().survey().ID(), surveyID.toString()).equals(SurveyRevisor.FK().accountProfile().PROFILECLASSID(), profileDocentesID).count() > 0L && SurveyAddon.getDataSetInstance().query().equals(SurveyAddon.FK().survey().ID(), surveyID.toString()).equals("addonClassId", "SurveyAddOnADOCAddValidatorsForRevisors").count() > 0L;
    }

    @RuleExecution(name="isTeacherProcessEvaluated", description="Determines if the teacher process is evaluated")
    public boolean isTeacherProcessEvaluated(@Named(value="teacherProcess") TeacherProcess teacherProcess) throws DataSetException {
        boolean result = false;
        if (!(teacherProcess == null || ProcessStates.CREATED.getId().equals(teacherProcess.getProcessState().getId()) || ProcessStates.INVALID.getId().equals(teacherProcess.getProcessState().getId()) || ProcessStates.FILLED.getId().equals(teacherProcess.getProcessState().getId()) || ProcessStates.VALIDATED.getId().equals(teacherProcess.getProcessState().getId()))) {
            result = true;
        }
        return result;
    }

    @RuleExecution(name="updateTeacherProcessComment", description="Updates (or creates) a teacher process comment")
    public TeacherProcessComment updateTeacherProcessComment(@Named(value="process") TeacherProcess process, @Named(value="commentType") ProcessCommentType commentType, @Named(value="title") String title, @Named(value="comment") String comment, @Named(value="comment") Teacher author, @Named(value="inProgress") Boolean inProgress, @Named(value="isPrivate") Boolean isPrivate) throws DataSetException {
        if (process == null || commentType == null || StringUtils.isBlank((String)comment)) {
            return null;
        }
        TeacherProcessComment commentRecord = (TeacherProcessComment)this.dbService.getTeacherProcessCommentDataSet().query().equals(TeacherProcessComment.FK().teacherProcess().ID(), process.getId().toString()).equals("inProgress", "true").equals("cmntType", commentType.getDBRepresentation()).singleValue();
        if (commentRecord == null) {
            commentRecord = new TeacherProcessComment();
            commentRecord.setTeacherProcess(process);
            commentRecord.setCmntTitle(title);
            commentRecord.setCmntType(commentType.getDBRepresentation());
            commentRecord.setCmntBody(comment);
            commentRecord.setTeacher(author);
            commentRecord.setInProgress(inProgress.booleanValue());
            commentRecord.setIsPrivate(isPrivate.booleanValue());
            commentRecord.setCmntDate(new Timestamp(new Date().getTime()));
            commentRecord = (TeacherProcessComment)this.dbService.getTeacherProcessCommentDataSet().insert((IBeanAttributes)commentRecord);
            return commentRecord;
        }
        commentRecord.setTeacher(author);
        commentRecord.setCmntTitle(title);
        commentRecord.setCmntBody(comment);
        commentRecord.setInProgress(inProgress.booleanValue());
        commentRecord.setIsPrivate(isPrivate.booleanValue());
        commentRecord.setCmntDate(new Timestamp(new Date().getTime()));
        commentRecord = (TeacherProcessComment)this.dbService.getTeacherProcessCommentDataSet().update((IBeanAttributes)commentRecord);
        return commentRecord;
    }
}

