/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.adoc.rules;

import pt.digitalis.adoc.model.data.TeacherProcess;
import pt.digitalis.adoc.rules.ADOCRules;
import pt.digitalis.adoc.rules.exception.ADOCException;
import pt.digitalis.adoc.rules.objects.TeacherUser;
import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.model.dataset.DataSetException;

public class ADOCUserInfo {
    private static final String IS_EVALUATOR = "IsEvaluator";
    private static final String IS_GLOBAL_EVALUATOR = "IsglobalEvaluator";
    private static final String IS_ON_EVALUATION_COMMISSION = "OnEvaluationCommission";
    Boolean evaluator = null;
    Boolean globalEvaluator = null;
    Boolean onCommission = null;
    private IDIFContext context;
    private TeacherUser teacherUser;

    public ADOCUserInfo(IDIFContext context) throws IdentityManagerException {
        this.context = context;
        this.teacherUser = new TeacherUser(context);
        if (this.teacherUser != null && this.teacherUser.getTeacher() == null) {
            this.teacherUser = null;
        }
    }

    public IDIFContext getContext() {
        return this.context;
    }

    public TeacherUser getTeacherUser() {
        return this.teacherUser;
    }

    public boolean isAdministrator() throws IdentityManagerException {
        return this.context.getSession().isLogged() && this.context.getSession().getUser().getGroupIDs().contains("Administrators");
    }

    public boolean isBOUser() throws IdentityManagerException {
        return this.context.getSession().isLogged() && this.context.getSession().getUser().getGroupIDs().contains("BackOffice");
    }

    public boolean isEvaluator() throws ADOCException, DataSetException {
        if (this.evaluator == null) {
            if (!this.context.getSession().isLogged()) {
                return false;
            }
            this.evaluator = (Boolean)this.context.getSession().getAttribute(IS_EVALUATOR);
            if (this.evaluator == null) {
                this.evaluator = this.teacherUser != null && this.teacherUser.getTeacher() != null ? Boolean.valueOf(ADOCRules.getInstance().isEvaluator(this.teacherUser.getTeacher().getId())) : Boolean.valueOf(false);
                this.context.getSession().addAttribute(IS_EVALUATOR, (Object)this.evaluator);
            }
        }
        return this.evaluator;
    }

    public boolean isGlobalEvaluator() throws ADOCException, DataSetException {
        if (this.globalEvaluator == null) {
            if (!this.context.getSession().isLogged()) {
                return false;
            }
            this.globalEvaluator = (Boolean)this.context.getSession().getAttribute(IS_GLOBAL_EVALUATOR);
            if (this.globalEvaluator == null) {
                this.globalEvaluator = this.teacherUser != null && this.teacherUser.getTeacher() != null ? Boolean.valueOf(ADOCRules.getInstance().isGlobalEvaluator(this.teacherUser.getTeacher().getId())) : Boolean.valueOf(false);
                this.context.getSession().addAttribute(IS_GLOBAL_EVALUATOR, (Object)this.globalEvaluator);
            }
        }
        return this.globalEvaluator;
    }

    public boolean isHomologator() throws IdentityManagerException {
        return this.context.getSession().isLogged() && this.context.getSession().getUser().getGroupIDs().contains("homologate");
    }

    public boolean isMyProcess(TeacherProcess teacherProcess) {
        if (this.getTeacherUser() == null || this.getTeacherUser().getTeacher() == null) {
            return false;
        }
        return this.getTeacherUser().getTeacher().getId().equals(teacherProcess.getTeacher().getId());
    }

    public boolean isOnCommission() throws ADOCException, DataSetException {
        if (this.onCommission == null) {
            if (!this.context.getSession().isLogged()) {
                return false;
            }
            this.onCommission = (Boolean)this.context.getSession().getAttribute(IS_ON_EVALUATION_COMMISSION);
            if (this.onCommission == null) {
                this.onCommission = this.teacherUser != null && this.teacherUser.getTeacher() != null ? Boolean.valueOf(ADOCRules.getInstance().isOnCommission(this.teacherUser.getTeacher().getId())) : Boolean.valueOf(false);
                this.context.getSession().addAttribute(IS_ON_EVALUATION_COMMISSION, (Object)this.onCommission);
            }
        }
        return this.onCommission;
    }

    public boolean isTeacher() throws IdentityManagerException {
        return this.teacherUser != null && this.teacherUser.getTeacher() != null;
    }
}

