/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.adoc.rules;

import pt.digitalis.adoc.model.IADOCService;
import pt.digitalis.adoc.model.data.EvaluationProcessComission;
import pt.digitalis.adoc.model.data.EvaluationProcessEvaluator;
import pt.digitalis.adoc.model.data.ProcessState;
import pt.digitalis.adoc.model.data.Teacher;
import pt.digitalis.adoc.model.data.TeacherProcess;
import pt.digitalis.adoc.model.data.TeacherProcessEvaluator;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.JoinType;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.persistentactions.pool.mail.MailPersistentPool;
import pt.digitalis.dif.pools.AbstractAction;
import pt.digitalis.dif.utils.mail.MailAction;
import pt.digitalis.dif.utils.mail.MailType;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.ConfigurationException;

public class ProcessStateChangeNotifier {
    private static IADOCService dbService = (IADOCService)DIFIoCRegistry.getRegistry().getImplementation(IADOCService.class);

    public static void notifyStageChange(TeacherProcess teacherProcess) throws DataSetException, ConfigurationException {
        ProcessState stateDef = (ProcessState)dbService.getProcessStateDataSet().get(teacherProcess.getProcessState().getId().toString());
        if (stateDef != null) {
            ProcessStateChangeNotifier.sendMail(teacherProcess.getTeacher(), stateDef.getTeacherNotification());
            if (StringUtils.isNotBlank((String)stateDef.getEvaluatorNotification())) {
                Query queryGlobalEvaluators = dbService.getEvaluationProcessEvaluatorDataSet().query().addJoin((AbstractBeanRelationsAttributes.AbstractRelations)EvaluationProcessEvaluator.FK().teacher(), JoinType.NORMAL).equals(EvaluationProcessEvaluator.FK().evaluationProcess().ID(), teacherProcess.getEvaluationProcessGroup().getEvaluationProcess().getId().toString()).equals("isGlobal", "true");
                for (Object evaluator : queryGlobalEvaluators.asList()) {
                    ProcessStateChangeNotifier.sendMail(evaluator.getTeacher(), stateDef.getEvaluatorNotification());
                }
                Query queryTeacherEvaluators = dbService.getTeacherProcessEvaluatorDataSet().query().addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcessEvaluator.FK().evaluationProcessEvaluator().teacher(), JoinType.NORMAL).equals(TeacherProcessEvaluator.FK().teacherProcess().ID(), teacherProcess.getId().toString());
                for (TeacherProcessEvaluator teacherProcessEvaluator : queryTeacherEvaluators.asList()) {
                    ProcessStateChangeNotifier.sendMail(teacherProcessEvaluator.getEvaluationProcessEvaluator().getTeacher(), stateDef.getEvaluatorNotification());
                }
            }
            if (StringUtils.isNotBlank((String)stateDef.getComissionNotification())) {
                Query queryCommission = dbService.getEvaluationProcessComissionDataSet().query().addJoin((AbstractBeanRelationsAttributes.AbstractRelations)EvaluationProcessComission.FK().teacher(), JoinType.NORMAL).equals(EvaluationProcessComission.FK().evaluationProcess().ID(), teacherProcess.getEvaluationProcessGroup().getEvaluationProcess().getId().toString());
                for (EvaluationProcessComission commissionTeacher : queryCommission.asList()) {
                    ProcessStateChangeNotifier.sendMail(commissionTeacher.getTeacher().getId(), stateDef.getComissionNotification());
                }
            }
        }
    }

    private static void sendMail(Long destinationTeacherID, String mailBody) throws DataSetException, ConfigurationException {
        if (destinationTeacherID != null && StringUtils.isNotBlank((String)mailBody)) {
            Teacher destinationTeacher = (Teacher)dbService.getTeacherDataSet().get(destinationTeacherID.toString());
            ProcessStateChangeNotifier.sendMail(destinationTeacher, mailBody);
        }
    }

    private static void sendMail(Teacher destinationTeacher, String mailBody) throws DataSetException, ConfigurationException {
        if (destinationTeacher != null && StringUtils.isNotBlank((String)mailBody)) {
            MailAction action = new MailAction();
            action.setType(MailType.HTML);
            action.setAddressTo(destinationTeacher.getEmail());
            action.setSubject("Situa\u00e7\u00e3o de processo alterada");
            action.setBody(mailBody);
            MailPersistentPool.getPool().addAction((AbstractAction)action);
        }
    }
}

