/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.adoc.rules.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.adoc.model.ADOCFactory;
import pt.digitalis.adoc.model.data.EvaluationProcess;
import pt.digitalis.adoc.model.data.EvaluationProcessStep;
import pt.digitalis.adoc.rules.ADOCRules;
import pt.digitalis.adoc.rules.exception.ADOCException;
import pt.digitalis.adoc.rules.objects.ProcessStates;
import pt.digitalis.adoc.rules.objects.ProcessSteps;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.sql.GenericBeanAttributes;
import pt.digitalis.dif.model.sql.SQLDataSet;
import pt.digitalis.dif.model.sql.SQLDialect;
import pt.digitalis.utils.common.DateUtils;
import pt.digitalis.utils.common.StringUtils;

public class EvaluationProcessInfo {
    private static final String GRADED = "graded";
    private static final String HOMOLUGATED = "homolugated";
    private static final String SUBMITED = "submited";
    private static final String TOTAL = "total";
    private EvaluationProcess evaluationProcess;
    private Map<String, Long> teacherTotals = null;

    public EvaluationProcessInfo(EvaluationProcess evaluationProcess) {
        this.evaluationProcess = evaluationProcess;
    }

    public EvaluationProcessInfo(Long evaluationProcessID, String language) throws ADOCException, DataSetException {
        this(ADOCRules.getInstance().getEvaluationProcess(evaluationProcessID, true));
    }

    public EvaluationProcessStep getActiveStep() {
        EvaluationProcessStep activeStep = null;
        Date now = new Date();
        for (EvaluationProcessStep step : this.evaluationProcess.getEvaluationProcessSteps()) {
            if (!step.isActive() || !DateUtils.isDateBetween((Date)now, (Date)step.getStartDate(), (Date)step.getEndDate())) continue;
            activeStep = step;
            break;
        }
        return activeStep;
    }

    public ProcessSteps getActiveStepProcess() {
        EvaluationProcessStep activeStep = this.getActiveStep();
        if (activeStep == null || StringUtils.isBlank((String)activeStep.getStepId())) {
            return null;
        }
        return ProcessSteps.valueOf(activeStep.getStepId());
    }

    public List<EvaluationProcessStep> getActiveSteps() {
        ArrayList<EvaluationProcessStep> activeSteps = new ArrayList<EvaluationProcessStep>();
        Date now = new Date();
        for (EvaluationProcessStep step : this.evaluationProcess.getEvaluationProcessSteps()) {
            if (!step.isActive() || step.getStartDate() == null || step.getEndDate() == null || !DateUtils.isDateBetween((Date)now, (Date)step.getStartDate(), (Date)step.getEndDate())) continue;
            activeSteps.add(step);
        }
        Collections.sort(activeSteps, new Comparator<EvaluationProcessStep>(){

            @Override
            public int compare(EvaluationProcessStep a, EvaluationProcessStep b) {
                int r = a.getStartDate().compareTo(b.getStartDate());
                if (r == 0) {
                    r = a.getDescription().compareTo(b.getDescription());
                }
                return r;
            }
        });
        return activeSteps;
    }

    public EvaluationProcess getProcess() {
        return this.evaluationProcess;
    }

    protected Map<String, Long> getTeacherTotals() throws NumberFormatException, DataSetException {
        if (this.teacherTotals == null) {
            HashMap<String, Long> temp = new HashMap<String, Long>();
            StringBuffer sql = new StringBuffer();
            sql.append("select state_id state, count(*) total\n");
            sql.append("  from adoc.teacher_process p\n");
            sql.append(" where p.evaluation_process_group_id in\n");
            sql.append("      (select id\n");
            sql.append("         from adoc.evaluation_process_group g\n");
            sql.append("        where g.evaluation_process_id = " + this.getProcess().getId() + ")\n");
            sql.append(" group by state_id\n");
            Long total = 0L;
            Long created = 0L;
            Long invalid = 0L;
            Long filled = 0L;
            Long validated = 0L;
            Long evaluated = 0L;
            Long completed = 0L;
            boolean wasActive = ADOCFactory.openTransaction();
            SQLDataSet ds = new SQLDataSet(ADOCFactory.getSession().connection(), sql.toString(), SQLDialect.ORACLE);
            List totals = ds.query().asList();
            if (!wasActive) {
                ADOCFactory.getSession().getTransaction().commit();
            }
            for (GenericBeanAttributes record : totals) {
                long value = Long.parseLong(record.getAttributeAsString(TOTAL));
                String state = record.getAttributeAsString("state");
                total = total + value;
                if (ProcessStates.CREATED.getId().toString().equals(state)) {
                    created = created + value;
                    continue;
                }
                if (ProcessStates.INVALID.getId().toString().equals(state)) {
                    invalid = value;
                    continue;
                }
                if (ProcessStates.COMPLETED.getId().toString().equals(state)) {
                    completed = value;
                    continue;
                }
                if (ProcessStates.FILLED.getId().toString().equals(state)) {
                    filled = value;
                    continue;
                }
                if (ProcessStates.EVALUATED.getId().toString().equals(state)) {
                    evaluated = value;
                    continue;
                }
                if (!ProcessStates.VALIDATED.getId().toString().equals(state)) continue;
                validated = value;
            }
            temp.put(HOMOLUGATED, completed);
            temp.put(SUBMITED, total - created);
            temp.put(GRADED, evaluated + completed);
            temp.put(TOTAL, total);
            this.teacherTotals = temp;
        }
        return this.teacherTotals;
    }

    public Long getTeachersGraded() throws NumberFormatException, DataSetException {
        return this.getTeacherTotals().get(GRADED);
    }

    public Long getTeachersHomolugated() throws NumberFormatException, DataSetException {
        return this.getTeacherTotals().get(HOMOLUGATED);
    }

    public Long getTeachersSubmited() throws NumberFormatException, DataSetException {
        return this.getTeacherTotals().get(SUBMITED);
    }

    public Long getTeachersTotal() throws NumberFormatException, DataSetException {
        return this.getTeacherTotals().get(TOTAL);
    }

    public long getTimePeriodCompletionPercentage() {
        Date now = new Date();
        if (now.before(this.evaluationProcess.getStartDate())) {
            return 0L;
        }
        if (now.after(this.evaluationProcess.getEndDate())) {
            return 100L;
        }
        double totalTime = this.evaluationProcess.getEndDate().getTime() - this.evaluationProcess.getStartDate().getTime();
        double passedTime = now.getTime() - this.evaluationProcess.getStartDate().getTime();
        return (long)(passedTime * 100.0 / totalTime);
    }
}

