/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.adoc.rules.objects;

import java.util.HashMap;
import java.util.Map;
import pt.digitalis.adoc.model.IADOCService;
import pt.digitalis.adoc.model.data.ProcessState;
import pt.digitalis.adoc.rules.ADOCUtils;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;

public class ProcessStates {
    public static ProcessState COMPLETED;
    public static ProcessState CREATED;
    public static ProcessState EVALUATED;
    public static ProcessState EVALUATED_PENDING_COMPLAINT;
    public static ProcessState EVALUATED_PENDING_REVISION;
    public static ProcessState FILLED;
    public static ProcessState INVALID;
    public static ProcessState REVIEWED;
    public static ProcessState VALIDATED;
    private static Map<Long, ProcessState> processStateMap;

    public static boolean equals(ProcessState state1, ProcessState state2) {
        return state1.getId().equals(state2.getId());
    }

    public static Map<Long, ProcessState> getAllProcessStates() throws DataSetException {
        if (processStateMap == null) {
            processStateMap = new HashMap<Long, ProcessState>();
            for (ProcessState processState : ((IADOCService)DIFIoCRegistry.getRegistry().getImplementation(IADOCService.class)).getProcessStateDataSet().query().asList()) {
                processStateMap.put(processState.getId(), processState);
            }
        }
        return processStateMap;
    }

    public static ProcessState getProcessState(Long processStateID) throws DataSetException {
        return ProcessStates.getAllProcessStates().get(processStateID);
    }

    public static ProcessState getProcessState(String keyword) throws DataSetException {
        for (ProcessState state : ProcessStates.getAllProcessStates().values()) {
            if (!state.getKeyword().equalsIgnoreCase(keyword)) continue;
            return state;
        }
        return null;
    }

    public static Map<Long, String> getProcessTranslations(String language) throws DataSetException {
        HashMap<Long, String> translations = new HashMap<Long, String>();
        for (ProcessState state : ProcessStates.getAllProcessStates().values()) {
            translations.put(state.getId(), ADOCUtils.getADOCAppMessages(language).get("state." + state.getKeyword() + ".desc"));
        }
        return translations;
    }

    static {
        processStateMap = null;
        try {
            CREATED = ProcessStates.getProcessState(1L);
            INVALID = ProcessStates.getProcessState(2L);
            FILLED = ProcessStates.getProcessState(3L);
            VALIDATED = ProcessStates.getProcessState(4L);
            EVALUATED = ProcessStates.getProcessState(5L);
            EVALUATED_PENDING_REVISION = ProcessStates.getProcessState(8L);
            REVIEWED = ProcessStates.getProcessState(6L);
            EVALUATED_PENDING_COMPLAINT = ProcessStates.getProcessState(9L);
            COMPLETED = ProcessStates.getProcessState(7L);
        }
        catch (DataSetException e) {
            e.printStackTrace();
        }
    }
}

