/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.adoc.rules.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import pt.digitalis.adoc.model.IADOCService;
import pt.digitalis.adoc.model.data.EvaluationProcessStep;
import pt.digitalis.adoc.model.data.TeacherProcess;
import pt.digitalis.adoc.model.data.TeacherProcessActivity;
import pt.digitalis.adoc.model.data.TeacherProcessComment;
import pt.digitalis.adoc.model.data.TeacherProcessCriterion;
import pt.digitalis.adoc.model.data.TeacherProcessEvaluator;
import pt.digitalis.adoc.model.data.TeacherProcessFile;
import pt.digitalis.adoc.rules.ADOCRules;
import pt.digitalis.adoc.rules.ADOCUtils;
import pt.digitalis.adoc.rules.exception.ADOCException;
import pt.digitalis.adoc.rules.objects.EvaluationProcessInfo;
import pt.digitalis.adoc.rules.objects.ProcessCommentType;
import pt.digitalis.adoc.rules.objects.ProcessStates;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.JoinType;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.dif.model.dataset.SortMode;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.utils.common.CollectionUtils;
import pt.digitalis.utils.common.StringUtils;

public class TeacherProcessInfo {
    protected List<TeacherProcessActivity> teacherProcessActivities = null;
    protected List<TeacherProcessComment> teacherProcessComments = null;
    protected List<TeacherProcessComment> teacherProcessMessages = null;
    protected List<TeacherProcessCriterion> teacherProcessCriterion = null;
    protected List<TeacherProcessEvaluator> teacherProcessEvaluators = null;
    protected List<TeacherProcessFile> teacherProcessFiles = null;
    private IADOCService dbService = (IADOCService)DIFIoCRegistry.getRegistry().getImplementation(IADOCService.class);
    private String fileTotalStatus = null;
    private String language;
    private TeacherProcess process = null;
    private EvaluationProcessInfo processInfo = null;

    public TeacherProcessInfo(Long processID, String language) throws ADOCException, DataSetException {
        this(ADOCRules.getInstance().getTeacherProcess(processID), language);
    }

    public TeacherProcessInfo(TeacherProcess process, String language) {
        this.process = process;
        this.language = language;
    }

    public String getActivityTotalStatus() throws DataSetException {
        return StringUtils.fillStringLeft((String)Integer.toString(this.getTeacherProcessActivities().size()), (int)2, (String)"0") + "  <span class=\"font85\">" + ADOCUtils.getADOCAppMessages(this.language).get("activities") + "</span>";
    }

    public String getFileTotalStatus() throws ADOCException, DataSetException {
        if (this.fileTotalStatus == null) {
            Long missingMandatory = ADOCRules.getInstance().getMissingMandatoryFiles(this.process.getId());
            Integer totalFiles = 0;
            for (TeacherProcessFile file : this.getTeacherProcessFiles()) {
                if (file.getDocumentId() == null) continue;
                Integer n = totalFiles;
                Integer n2 = totalFiles = Integer.valueOf(totalFiles + 1);
            }
            this.fileTotalStatus = StringUtils.fillStringLeft((String)totalFiles.toString(), (int)2, (String)"0");
            if (missingMandatory > 0L) {
                this.fileTotalStatus = this.fileTotalStatus + " (" + StringUtils.fillStringLeft((String)Long.toString(missingMandatory), (int)2, (String)"0") + " <span class=\"font85\">" + ADOCUtils.getADOCAppMessages(this.language).get("mandatoryMising") + "</span>)";
            }
        }
        return this.fileTotalStatus;
    }

    public String getMessagesTotalStatus() throws DataSetException {
        return StringUtils.fillStringLeft((String)Integer.toString(this.getTeacherProcessMessages().size()), (int)2, (String)"0");
    }

    public String getPhase() throws ADOCException, DataSetException {
        EvaluationProcessStep step = this.getProcessInfo().getActiveStep();
        if (step != null) {
            return step.getDescription();
        }
        return null;
    }

    public String getPhases(String separador) throws ADOCException, DataSetException {
        ArrayList<String> phases = new ArrayList<String>();
        for (EvaluationProcessStep step : this.getProcessInfo().getActiveSteps()) {
            phases.add(step.getDescription());
        }
        return CollectionUtils.listToSeparatedString(phases, (String)separador);
    }

    public String getPhases() throws ADOCException, DataSetException {
        ArrayList<String> phases = new ArrayList<String>();
        for (EvaluationProcessStep step : this.getProcessInfo().getActiveSteps()) {
            phases.add(step.getDescription());
        }
        return CollectionUtils.listToSeparatedString(phases, (String)", ");
    }

    public TeacherProcess getProcess() {
        return this.process;
    }

    public EvaluationProcessInfo getProcessInfo() throws ADOCException, DataSetException {
        if (this.processInfo == null) {
            this.processInfo = new EvaluationProcessInfo(this.process.getEvaluationProcessGroup().getEvaluationProcess().getId(), this.language);
        }
        return this.processInfo;
    }

    public String getState() throws DataSetException {
        return ProcessStates.getProcessTranslations(this.language).get(this.process.getProcessState().getId());
    }

    public List<TeacherProcessActivity> getTeacherProcessActivities() throws DataSetException {
        if (this.teacherProcessActivities == null) {
            this.teacherProcessActivities = this.dbService.getTeacherProcessActivityDataSet().query().addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcessActivity.FK().evaluationProcessGroupCrit(), JoinType.LEFT_OUTER_JOIN).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcessActivity.FK().evaluationProcessGroupCrit().activityCategory(), JoinType.LEFT_OUTER_JOIN).equals(TeacherProcessActivity.FK().teacherProcess().ID(), this.getProcess().getId().toString()).asList();
        }
        return this.teacherProcessActivities;
    }

    public List<TeacherProcessComment> getTeacherProcessComments() throws DataSetException {
        if (this.teacherProcessComments == null) {
            this.teacherProcessComments = this.dbService.getTeacherProcessCommentDataSet().query().equals(TeacherProcessComment.FK().teacherProcess().ID(), this.getProcess().getId().toString()).sortBy("cmntDate", SortMode.DESCENDING).asList();
        }
        return this.teacherProcessComments;
    }

    public List<TeacherProcessCriterion> getTeacherProcessCriterion() throws DataSetException {
        if (this.teacherProcessCriterion == null) {
            this.teacherProcessCriterion = this.dbService.getTeacherProcessCriterionDataSet().query().addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcessCriterion.FK().evaluationProcessGroupCrit(), JoinType.NORMAL).equals(TeacherProcessCriterion.FK().teacherProcess().ID(), this.getProcess().getId().toString()).asList();
        }
        return this.teacherProcessCriterion;
    }

    public List<TeacherProcessEvaluator> getTeacherProcessEvaluators() throws DataSetException {
        if (this.teacherProcessEvaluators == null) {
            this.teacherProcessEvaluators = this.dbService.getTeacherProcessEvaluatorDataSet().query().addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcessEvaluator.FK().evaluationProcessEvaluator(), JoinType.NORMAL).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcessEvaluator.FK().evaluationProcessEvaluator().teacher(), JoinType.NORMAL).equals(TeacherProcessEvaluator.FK().teacherProcess().ID(), this.getProcess().getId().toString()).asList();
        }
        return this.teacherProcessEvaluators;
    }

    public List<TeacherProcessFile> getTeacherProcessFiles() throws DataSetException {
        if (this.teacherProcessFiles == null) {
            this.teacherProcessFiles = this.dbService.getTeacherProcessFileDataSet().query().addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcessFile.FK().evaluationProcessGroupFile(), JoinType.LEFT_OUTER_JOIN).equals(TeacherProcessFile.FK().teacherProcess().ID(), this.getProcess().getId().toString()).asList();
        }
        return this.teacherProcessFiles;
    }

    public List<TeacherProcessComment> getTeacherProcessMessages() throws DataSetException {
        if (this.teacherProcessMessages == null) {
            String[] typesToFilterOut = new String[]{ProcessCommentType.REVIEW_REQUEST.getDBRepresentation(), ProcessCommentType.REVIEW_COMMENT.getDBRepresentation(), ProcessCommentType.COMPLAINT_COMMENT.getDBRepresentation(), ProcessCommentType.COMPLAINT_REQUEST.getDBRepresentation()};
            List<String> listToFilterOut = Arrays.asList(typesToFilterOut);
            String inClauseValue = CollectionUtils.listToSeparatedString(Arrays.asList(typesToFilterOut), (String)",");
            this.teacherProcessMessages = this.dbService.getTeacherProcessCommentDataSet().query().equals(TeacherProcessComment.FK().teacherProcess().ID(), this.getProcess().getId().toString()).notIn("cmntType", inClauseValue).sortBy("cmntDate", SortMode.DESCENDING).asList();
        }
        return this.teacherProcessMessages;
    }

    public boolean isHasChangesInActivitiesPending() throws ADOCException, DataSetException {
        return ADOCRules.getInstance().getRemoteTeacherSystem().hasChangedActivities(this.getProcess());
    }

    public boolean isHasCriterionsWithNoActivities() throws DataSetException {
        boolean hasCriterionsWithNoActivities = false;
        Query query = this.dbService.getTeacherProcessCriterionDataSet().query().equals(TeacherProcessCriterion.FK().teacherProcess().ID(), this.getProcess().getId().toString());
        for (TeacherProcessCriterion criterion : query.asList()) {
            if (!(hasCriterionsWithNoActivities = hasCriterionsWithNoActivities || this.isHasCriterionsWithNoActivities(criterion.getId()))) continue;
            break;
        }
        return hasCriterionsWithNoActivities;
    }

    public boolean isHasCriterionsWithNoActivities(Long criterionID) throws DataSetException {
        if (criterionID == null) {
            return false;
        }
        TeacherProcessCriterion processGroupCriterion = (TeacherProcessCriterion)this.dbService.getTeacherProcessCriterionDataSet().query().equals("id", criterionID.toString()).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcessCriterion.FK().evaluationProcessGroupCrit(), JoinType.NORMAL).addJoin((AbstractBeanRelationsAttributes.AbstractRelations)TeacherProcessCriterion.FK().evaluationProcessGroupCrit().activityCategory(), JoinType.LEFT_OUTER_JOIN).singleValue();
        if (processGroupCriterion.getEvaluationProcessGroupCrit().getActivityCategory() == null) {
            return false;
        }
        return this.dbService.getTeacherProcessActivityDataSet().query().equals(TeacherProcessActivity.FK().evaluationProcessGroupCrit().ID(), processGroupCriterion.getEvaluationProcessGroupCrit().getId().toString()).count() == 0L;
    }

    public boolean isHasImportedActivities() {
        return this.getProcess().getLastActivityImportDate() != null;
    }
}

