/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.adoc.rules.objects;

import pt.digitalis.adoc.ADOCConfigurations;
import pt.digitalis.adoc.model.IADOCService;
import pt.digitalis.adoc.model.data.Teacher;
import pt.digitalis.adoc.model.data.TeacherProcess;
import pt.digitalis.adoc.rules.ADOCRules;
import pt.digitalis.adoc.rules.exception.ADOCException;
import pt.digitalis.dif.codegen.templates.IInjectUserCreator;
import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.exception.BusinessException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.log.LogLevel;
import pt.digitalis.utils.common.StringUtils;

public class TeacherUser
implements IInjectUserCreator {
    protected IDIFContext context;
    protected Long currentTeacherProcessID = null;
    protected IADOCService dbService = (IADOCService)DIFIoCRegistry.getRegistry().getImplementation(IADOCService.class);
    private Teacher teacherData = null;

    public TeacherUser() {
    }

    public TeacherUser(IDIFContext context) {
        this.context = context;
        String businessKey = this.getTeacherBusinessKeyFromUser();
        if (StringUtils.isNotBlank((String)businessKey)) {
            try {
                this.teacherData = (Teacher)this.dbService.getTeacherDataSet().query().equals("businessKey", businessKey).sortBy("id").singleValue();
            }
            catch (DataSetException e) {
                new BusinessException("Error getting the Teacher for the user's business key", (Exception)((Object)e)).addToExceptionContext(context).addToExceptionContext("BusinessKey", (Object)businessKey).log(LogLevel.ERROR);
            }
        } else if (context.getSession().isLogged()) {
            String email = this.context.getSession().getUser().getEmail();
            String name = this.context.getSession().getUser().getName();
            try {
                this.teacherData = (Teacher)this.dbService.getTeacherDataSet().query().equals("name", name).equals("email", email).sortBy("id").singleValue();
                if (this.teacherData == null) {
                    this.teacherData = (Teacher)this.dbService.getTeacherDataSet().query().equals("name", name).sortBy("id").singleValue();
                }
                if (this.teacherData == null) {
                    this.teacherData = (Teacher)this.dbService.getTeacherDataSet().query().equals("email", email).sortBy("id").singleValue();
                }
            }
            catch (DataSetException e) {
                new BusinessException("Error getting the Teacher for the user's business key", (Exception)((Object)e)).addToExceptionContext(context).addToExceptionContext("BusinessKey", (Object)businessKey).log(LogLevel.ERROR);
            }
        } else {
            this.teacherData = null;
        }
    }

    public Long getCurrentTeacherProcessID() throws DataSetException, ADOCException {
        TeacherProcess currentTeacherProcess;
        if (this.currentTeacherProcessID == null && this.getTeacher() != null && (currentTeacherProcess = ADOCRules.getInstance().getCurrentTeacherProcess(this.getTeacher().getId())) != null) {
            this.currentTeacherProcessID = currentTeacherProcess.getId();
        }
        return this.currentTeacherProcessID;
    }

    public void setCurrentTeacherProcessID(Long currentTeacherProcessID) {
        this.currentTeacherProcessID = currentTeacherProcessID;
    }

    public Teacher getTeacher() {
        return this.teacherData;
    }

    protected String getTeacherBusinessKeyFromUser() {
        if (this.context.getSession().isLogged()) {
            return StringUtils.toStringOrNull((Object)this.context.getSession().getUser().getAttribute(ADOCConfigurations.getInstance().getTeacherBusinessKeyAttributeFromIdentityManager()));
        }
        return null;
    }

    public TeacherUser newUser(IDIFContext context) {
        return new TeacherUser(context);
    }
}

