/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.codegen;

import java.util.List;
import java.util.Map;

import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.controller.objects.DIFContext;
import pt.digitalis.dif.dem.interfaces.IStage;
import pt.digitalis.dif.dem.objects.ViewObject;
import pt.digitalis.dif.dem.objects.parameters.IParameters;

/**
 * Place holder for some DIF CG-related constants and operations that are used on the code generation process.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2007/10/29
 */
public class CGAncillaries {

    /** The name of the method that calls the user-defined application's initialization method. */
    final static public String APP_INIT_METHOD = "__CG__initialize";

    /** The IApplication 'getProvider' method name. */
    final static public String APPLICATION_GET_PROVIDER_METHOD = "getProvider";

    /** The boolean return as a String. */
    final static public String BOOLEAN_RETURN = "Z";

    /** The name of the method that calls the event handler method. */
    final static public String CALL_EVENT_METHOD = "callEventMethod";

    /** The name of the method that calls the user-defined execution method. */
    final static public String CALL_EXEC_METHOD = "callExecuteMethod";

    /** The name of the method that calls the user-defined execution method for a specified event. */
    final static public String CALL_EXEC_ONEVENT_METHOD = "callExecuteOnEventMethod";

    /** The name of the method that calls the user-defined execution method. */
    final static public String CALL_FINALIZE_METHOD = "callFinalizeMethod";

    /** The name of the method that calls the user-defined parameter definition method. */
    final static public String CALL_INIT_CUSTOM_PARAMETERS_METHOD = "callInitCustomParametersMethod";

    /** The name of the method that calls the user-defined initialization method. */
    final static public String CALL_INIT_METHOD = "callInitMethod";

    /** The ICallback 'getCallbackType' method name. */
    final static public String CALLBACK_GET_CALLBACK_TYPE_METHOD = "getCallbackType";

    /** The ICallback 'hasCallbackEnabled' method name. */
    final static public String CALLBACK_HAS_CALLBACK_ENABLED_METHOD = "hasCallbackEnabled";

    /** This message is used as return for Boolean-returning methods whose bodies will be implemented by the CodeGen. */
    final static public boolean CG_TO_BE_IMPLEMENTED_BOOLEAN = true;

    /** This message is used as return for String-returning methods whose bodies will be implemented by the CodeGen. */
    final static public String CG_TO_BE_IMPLEMENTED_MESSAGE = "This will be replaced with generated code".toLowerCase();

    /** This message is used as return for Object-returning methods whose bodies will be implemented by the CodeGen. */
    final static public Object CG_TO_BE_IMPLEMENTED_OBJECT = null;

    /** This message is used as return for Stage-returning methods whose bodies will be implemented by the CodeGen. */
    final static public IStage CG_TO_BE_IMPLEMENTED_STAGE = null;

    /** This message is used as return for ViewObject-returning methods whose bodies will be implemented by the CodeGen. */
    final static public ViewObject CG_TO_BE_IMPLEMENTED_VIEW = null;

    /** The comma character as a String. */
    final static public String COMMA = ",";

    /** Java's end block char as a String constant. */
    final static public String END_BLOCK = "}";

    /** The IEntity 'getID' method name. */
    final static public String ENTITY_GET_ID_METHOD = "getID";

    /** The IEntity 'getName' method name. */
    final static public String ENTITY_GET_NAME_METHOD = "getName";

    /** The IEntity 'getOriginalClassName' method name. */
    final static public String ENTITY_GET_ORIGINALCLASSNAME_METHOD = "getOriginalClassName";

    /** The IEntity 'getID' method name. */
    final static public String ENTITY_GET_OVERRIDE_METHOD = "getOverridesStageID";

    /** The IEntity 'getOriginalClassName' method name. */
    final static public String ENTITY_GET_STAGEINSTANCECLASSNAME_METHOD = "getStageInstanceClassName";

    /** The DIFContext argument as a String. */
    final static public String IDIF_CONTEXT_ARGS = "(L" + IDIFContext.class.getCanonicalName().replace(".", "/") + ";)";

    /** The IParameters argument as a String. */
    final static public String IPARAMETERS_ARGS = "(L" + IParameters.class.getCanonicalName().replace(".", "/") + ";)";

    /** The List return as a String. */
    final static public String LIST_RETURN = "L" + List.class.getCanonicalName().replace(".", "/") + ";";

    /** The Map return as a String. */
    final static public String MAP_RETURN = "L" + Map.class.getCanonicalName().replace(".", "/") + ";";

    /** The method body tag as String constant. */
    final static public String METHOD_BODY_TAG = "${body}";

    /** The new line character as a String. */
    final static public String NEW_LINE = "\n";

    /** The id tag for the non-stage enriched class. */
    final static public String NON_STAGE_ENRICHED_CLASS_ID = "EnrichedClass";

    /** The IService 'getApplication' method name. */
    final static public String SERVICE_GET_APPLICATION_METHOD = "getApplication";

    /** The error stages builder method name */
    final static public String STAGE_EVENT_HANDLERS_BUILDER = "eventHandlersBuilder";

    /** The IStage 'getDefaultErrorStage' method name. */
    final static public String STAGE_GET_DEFAULT_ERROR_STAGE = "getDefaultErrorStage";

    /** The IStage 'getDefaultErrorView' method name. */
    final static public String STAGE_GET_DEFAULT_ERROR_VIEW = "getDefaultErrorView";

    /** The IStage 'getDefaultView' method name. */
    final static public String STAGE_GET_DEFAULT_VIEW = "getDefaultView";

    /** The IStage 'getService' method name. */
    final static public String STAGE_GET_SERVICE_METHOD = "getService";

    /** The IStage 'hasAuthentication' method name. */
    final static public String STAGE_HAS_AUTHENTICATION = "hasAuthentication";

    /** The IStage 'hasAuthenticationErrorInjection' method name. */
    final static public String STAGE_HAS_AUTHENTICATION_ERROR_INJECTION = "hasAuthenticationErrorInjection";

    /** The IStage 'hasAuthorization' method name. */
    final static public String STAGE_HAS_AUTHORIZATION = "hasAuthorization";

    /** The IStage 'hasInjectedContributions' method name. */
    final static public String STAGE_HAS_INJECTED_CONTRIBUTIONS = "hasInjectedContributions";

    /** The IStage 'hasParameterErrorInjection' method name. */
    final static public String STAGE_HAS_PARAMETER_ERROR_INJECTION = "hasParameterErrorInjection";

    /** Defines the name of the entity internal init method */
    final static public String STAGE_INJECTED_ATTRIBUTES_INIT_METHOD_NAME = "__Stage__InjectedAttributesInitMethod__";

    /** Defines the source of the entity internal init method. The ${body} enables later substitution of method body. */
    final static public String STAGE_INJECTED_ATTRIBUTES_INIT_METHOD_NAME_SOURCE = "public void "
            + STAGE_INJECTED_ATTRIBUTES_INIT_METHOD_NAME + "(" + DIFContext.class.getCanonicalName()
            + " difContext) { ${body}  }";

    /** The error stages builder method name */
    final static public String STAGE_INJECTED_ERRORSTAGES_BUILDER = "injectedErrorStagesBuilder";

    /** The error views builder method name */
    final static public String STAGE_INJECTED_ERRORVIEWS_BUILDER = "injectedErrorViewsBuilder";

    /** The stages builder method name */
    final static public String STAGE_INJECTED_STAGES_BUILDER = "injectedStagesBuilder";

    /** The views builder method name */
    final static public String STAGE_INJECTED_VIEWS_BUILDER = "injectedViewsBuilder";

    /** The id tag for the stage instance. */
    final static public String STAGE_INSTANCE_ID = "CGStageInstance";

    /** Defines the name of the entity internal finalize method */
    final static public String STAGE_POSTPROCESSING_METHOD_NAME = "__Stage__PostProcessingMethod__";

    /** Defines the source of the entity internal init method. The ${body} enables later substitution of method body. */
    final static public String STAGE_POSTPROCESSING_METHOD_NAME_SOURCE = "public void "
            + STAGE_POSTPROCESSING_METHOD_NAME + "(" + DIFContext.class.getCanonicalName()
            + " difContext) { ${body}  }";

    /** The id tag for the stage proxy. */
    final static public String STAGE_PROXY_ID = "CGStageProxy";

    /** Java's start block char as a String constant. */
    final static public String START_BLOCK = "{";

    /** The String return as a String. */
    final static public String STRING_RETURN = "L" + String.class.getCanonicalName().replace(".", "/") + ";";

    /** The IValidator 'getBoundParameterIDs' method name. */
    final static public String VALIDATOR_GET_BOUND_PARAMETER_IDS_METHOD = "getBoundParameterIDs";

    /** The ViewObject return as a String. */
    final static public String VIEW_OBJECT_RETURN = "L" + ViewObject.class.getCanonicalName().replace(".", "/") + ";";

    /** The void argument as a String. */
    final static public String VOID_ARGS = "()";

    /** The void return as a String. */
    final static public String VOID_RETURN = "V";

    /**
     * @param clazz
     *            the class
     * @return the method signature
     */
    static public String getReturnSignatureForClass(Class<?> clazz)
    {

        /** The String return as a String. */
        return "L" + clazz.getCanonicalName().replace(".", "/") + ";";

    }

    /**
     * Separates a string into multiple strings by splitting the original string around matches of a given pattern.
     * Trims the destination strings to remove leading and trailing white spaces.
     * 
     * @param stringToSplit
     *            the string to split
     * @param regex
     *            the pattern used to separate the string
     * @return an array of strings with the original string split and trimmed.
     */
    final static public String[] parse(String stringToSplit, String regex)
    {

        if (stringToSplit == null || "".equals(stringToSplit))
            return new String[0];

        String[] result = stringToSplit.split(regex);

        for (int i = 0; i < result.length; i++)
        {
            result[i] = result[i].trim();
        }

        return result;
    }
}
