/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.codegen.templates;

import java.util.Map;

import pt.digitalis.dif.codegen.CGAncillaries;
import pt.digitalis.dif.dem.interfaces.IApplication;
import pt.digitalis.dif.dem.interfaces.IService;
import pt.digitalis.dif.dem.interfaces.IStage;
import pt.digitalis.dif.dem.objects.LicenseEditionType;
import pt.digitalis.dif.exception.manager.RegistrationManagerException;
import pt.digitalis.dif.startup.DIFGeneralConfigurationParameters;
import pt.digitalis.dif.utils.logging.DIFLogger;

/**
 * This class is a template for the IService interface method implementations. The CodeGen will copy these methods to
 * the class implementing the interface IService. Some methods will be copied "as is", other will be tweaked.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/06/01
 */
public class ServiceCGTemplate implements IService {

    /**
     * @see pt.digitalis.dif.dem.interfaces.IService#getApplication()
     */
    public IApplication getApplication()
    {
        // The applicationID will be supplied by the CodeGen.
        return TemplateResources.getDEMManager().getApplication(CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE);
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#getLicenseEdition()
     */
    public LicenseEditionType getLicenseEdition()
    {
        return TemplateResources.getRegistrationManager().getServiceEdition(this.getID());
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getID()
     */
    public String getID()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IMessage#getMessage(java.lang.String)
     */
    public String getMessage(String messageID)
    {
        return getMessages().get(messageID);
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IMessage#getMessages()
     */
    public Map<String, String> getMessages()
    {
        return TemplateResources.getMessageManager().getMessages(this,
                DIFGeneralConfigurationParameters.getInstance().getDefaultLanguage());
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getName()
     */
    public String getName()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getOriginalClassName()
     */
    public String getOriginalClassName()
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_MESSAGE;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IService#getStages()
     */
    public Map<String, IStage> getStages()
    {
        return TemplateResources.getDEMManager().getStages(this);
    }

    /**
     * @return an instance of template resources
     */
    protected TemplateResources getTemplateResources()
    {
        return TemplateResources.getInstance();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getUID()
     */
    public String getUID()
    {
        return "SERVICE:" + this.getID();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistered()
     */
    public boolean isRegistered()
    {
        boolean result = this.getApplication().isRegistered();

        if (this.isRegistrable())
            result = TemplateResources.getRegistrationManager().isServiceRegistered(this.getID());

        return result;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistrable()
     */
    public boolean isRegistrable()
    {
        return TemplateResources.getRegistrationManager().isServiceRegistrable(getID());
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#register(java.lang.String, java.lang.String)
     */
    public boolean register(String name, String key)
    {
        try
        {
            return TemplateResources.getRegistrationManager().registerService(getID(), name, key);
        }
        catch (RegistrationManagerException e)
        {
            DIFLogger.getLogger().debug(e);
            return false;
        }
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#unregister()
     */
    public void unregister()
    {
        TemplateResources.getRegistrationManager().unregisterService(getID());
    }
}
